/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.api.UsageSessionService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.EventStat;
import org.sakaiproject.sitestats.api.JobRun;
import org.sakaiproject.sitestats.api.LessonBuilderStat;
import org.sakaiproject.sitestats.api.ResourceStat;
import org.sakaiproject.sitestats.api.ServerStat;
import org.sakaiproject.sitestats.api.SiteActivity;
import org.sakaiproject.sitestats.api.SitePresence;
import org.sakaiproject.sitestats.api.SitePresenceTotal;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.StatsUpdateManager;
import org.sakaiproject.sitestats.api.StatsUpdateManagerMXBean;
import org.sakaiproject.sitestats.api.UserStat;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.parser.EventParserTip;
import org.sakaiproject.sitestats.impl.CustomEventImpl;
import org.sakaiproject.sitestats.impl.EventStatImpl;
import org.sakaiproject.sitestats.impl.JobRunImpl;
import org.sakaiproject.sitestats.impl.LessonBuilderStatImpl;
import org.sakaiproject.sitestats.impl.ResourceStatImpl;
import org.sakaiproject.sitestats.impl.ServerStatImpl;
import org.sakaiproject.sitestats.impl.SiteActivityImpl;
import org.sakaiproject.sitestats.impl.SitePresenceImpl;
import org.sakaiproject.sitestats.impl.SitePresenceTotalImpl;
import org.sakaiproject.sitestats.impl.SiteVisitsImpl;
import org.sakaiproject.sitestats.impl.StatsAggregateJobImpl;
import org.sakaiproject.sitestats.impl.UserStatImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class StatsUpdateManagerImpl
extends HibernateDaoSupport
implements Runnable,
StatsUpdateManager,
Observer,
StatsUpdateManagerMXBean {
    private Logger LOG = LoggerFactory.getLogger(StatsUpdateManagerImpl.class);
    private static final String PRESENCE_SUFFIX = "-presence";
    private static final int PRESENCE_SUFFIX_LENGTH = "-presence".length();
    private boolean collectThreadEnabled = true;
    public long collectThreadUpdateInterval = 4000L;
    private boolean collectAdminEvents = false;
    private boolean collectEventsForSiteWithToolOnly = true;
    private StatsManager M_sm;
    private EventRegistryService M_ers;
    private SiteService M_ss;
    private AliasService M_as;
    private EntityManager M_em;
    private UsageSessionService M_uss;
    private EventTrackingService M_ets;
    private Thread collectThread;
    private List<Event> collectThreadQueue = new ArrayList<Event>();
    private Object collectThreadSemaphore = new Object();
    private boolean collectThreadRunning = false;
    private Map<String, EventStat> eventStatMap = Collections.synchronizedMap(new HashMap());
    private Map<String, ResourceStat> resourceStatMap = Collections.synchronizedMap(new HashMap());
    private Map<String, LessonBuilderStat> lessonBuilderStatMap = Collections.synchronizedMap(new HashMap());
    private Map<String, SiteActivity> activityMap = Collections.synchronizedMap(new HashMap());
    private Map<String, SiteVisits> visitsMap = Collections.synchronizedMap(new HashMap());
    private Map<String, SitePresenceConsolidation> presencesMap = Collections.synchronizedMap(new HashMap());
    private Map<UniqueVisitsKey, Integer> uniqueVisitsMap = Collections.synchronizedMap(new HashMap());
    private Map<String, ServerStat> serverStatMap = Collections.synchronizedMap(new HashMap());
    private Map<String, UserStat> userStatMap = Collections.synchronizedMap(new HashMap());
    private Map<String, String> lessonPageCreateEventMap = new HashMap<String, String>();
    private boolean initialized = false;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean isIdle = true;
    private long totalEventsProcessed = 0L;
    private long totalTimeInEventProcessing = 0L;
    private long resetTime = System.currentTimeMillis();

    public void setCollectThreadEnabled(boolean enabled) {
        this.collectThreadEnabled = enabled;
        if (this.initialized) {
            if (enabled && !this.collectThreadRunning) {
                this.startUpdateThread();
                this.M_ets.addLocalObserver((Observer)this);
            } else if (!enabled && this.collectThreadRunning) {
                this.M_ets.deleteObserver((Observer)this);
                this.stopUpdateThread();
            }
        }
    }

    public boolean isCollectThreadEnabled() {
        return this.collectThreadEnabled;
    }

    public void setCollectThreadUpdateInterval(long dbUpdateInterval) {
        this.collectThreadUpdateInterval = dbUpdateInterval;
    }

    public long getCollectThreadUpdateInterval() {
        return this.collectThreadUpdateInterval;
    }

    public void setCollectAdminEvents(boolean value) {
        this.collectAdminEvents = value;
    }

    public boolean isCollectAdminEvents() {
        return this.collectAdminEvents;
    }

    public void setCollectEventsForSiteWithToolOnly(boolean value) {
        this.collectEventsForSiteWithToolOnly = value;
    }

    public boolean isCollectEventsForSiteWithToolOnly() {
        return this.collectEventsForSiteWithToolOnly;
    }

    public void setStatsManager(StatsManager mng) {
        this.M_sm = mng;
    }

    public void setEventRegistryService(EventRegistryService eventRegistryService) {
        this.M_ers = eventRegistryService;
    }

    public void setSiteService(SiteService ss) {
        this.M_ss = ss;
    }

    public void setAliasService(AliasService as) {
        this.M_as = as;
    }

    public void setEntityManager(EntityManager em) {
        this.M_em = em;
    }

    public void setEventTrackingService(EventTrackingService ets) {
        this.M_ets = ets;
    }

    public void setUsageSessionService(UsageSessionService uss) {
        this.M_uss = uss;
    }

    public void init() {
        StringBuilder buff = new StringBuilder();
        buff.append("init(): collect thread enabled: ");
        buff.append(this.collectThreadEnabled);
        if (this.collectThreadEnabled) {
            buff.append(", db update interval: ");
            buff.append(this.collectThreadUpdateInterval);
            buff.append(" ms");
        }
        buff.append(", collect administrator events: " + this.collectAdminEvents);
        buff.append(", collect events only for sites with SiteStats: " + this.collectEventsForSiteWithToolOnly);
        this.logger.info((Object)buff.toString());
        this.initialized = true;
        this.setCollectThreadEnabled(this.collectThreadEnabled);
    }

    public void destroy() {
        if (this.collectThreadEnabled) {
            this.M_ets.deleteObserver((Observer)this);
            this.stopUpdateThread();
        }
    }

    public Event buildEvent(Date date, String event, String ref, String sessionUser, String sessionId) {
        return new CustomEventImpl(date, event, ref, sessionUser, sessionId);
    }

    public Event buildEvent(Date date, String event, String ref, String context, String sessionUser, String sessionId) {
        return new CustomEventImpl(date, event, ref, context, sessionUser, sessionId);
    }

    public boolean collectEvent(Event e) {
        if (e != null) {
            long startTime = System.currentTimeMillis();
            this.isIdle = false;
            this.preProcessEvent(e);
            boolean success = this.doUpdateConsolidatedEvents();
            this.isIdle = true;
            this.totalTimeInEventProcessing += System.currentTimeMillis() - startTime;
            return success;
        }
        return true;
    }

    public boolean collectEvents(List<Event> events) {
        int eventCount;
        if (events != null && (eventCount = events.size()) > 0) {
            return this.collectEvents(events.toArray(new Event[eventCount]));
        }
        return true;
    }

    public boolean collectEvents(Event[] events) {
        int eventCount;
        if (events != null && (eventCount = events.length) > 0) {
            long startTime = System.currentTimeMillis();
            this.isIdle = false;
            for (int i = 0; i < events.length; ++i) {
                if (events[i] == null) continue;
                this.preProcessEvent(events[i]);
            }
            boolean success = this.doUpdateConsolidatedEvents();
            this.isIdle = true;
            this.totalTimeInEventProcessing += System.currentTimeMillis() - startTime;
            return success;
        }
        return true;
    }

    public long collectPastSiteEvents(String siteId, Date initialDate, Date finalDate) {
        StatsAggregateJobImpl statsAggregateJob = (StatsAggregateJobImpl)ComponentManager.get((String)"org.sakaiproject.sitestats.api.StatsAggregateJob");
        return statsAggregateJob.collectPastSiteEvents(siteId, initialDate, finalDate);
    }

    public boolean saveJobRun(final JobRun jobRun) {
        if (jobRun == null) {
            return false;
        }
        Object r = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Transaction tx = null;
                try {
                    tx = session.beginTransaction();
                    session.saveOrUpdate((Object)jobRun);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    StatsUpdateManagerImpl.this.LOG.warn("Unable to commit transaction: ", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return (Boolean)r;
    }

    public JobRun getLatestJobRun() throws Exception {
        Object r = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                JobRun jobRun = null;
                Criteria c = session.createCriteria(JobRunImpl.class);
                c.setMaxResults(1);
                c.addOrder(Order.desc((String)"id"));
                List jobs = c.list();
                if (jobs != null && jobs.size() > 0) {
                    jobRun = (JobRun)jobs.get(0);
                }
                return jobRun;
            }
        });
        return (JobRun)r;
    }

    public Date getEventDateFromLatestJobRun() throws Exception {
        Object r = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(JobRunImpl.class);
                c.add(Expression.isNotNull((String)"lastEventDate"));
                c.setMaxResults(1);
                c.addOrder(Order.desc((String)"id"));
                List jobs = c.list();
                if (jobs != null && jobs.size() > 0) {
                    JobRun jobRun = (JobRun)jobs.get(0);
                    return jobRun.getLastEventDate();
                }
                return null;
            }
        });
        return (Date)r;
    }

    public int getQueueSize() {
        return this.collectThreadQueue.size();
    }

    public boolean isIdle() {
        return this.isIdle && this.getQueueSize() == 0;
    }

    public void resetMetrics() {
        this.totalEventsProcessed = 0L;
        this.totalTimeInEventProcessing = 0L;
        this.resetTime = System.currentTimeMillis();
    }

    public long getNumberOfEventsProcessed() {
        return this.totalEventsProcessed;
    }

    public long getTotalTimeInEventProcessing() {
        return this.totalTimeInEventProcessing;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public long getTotalTimeElapsedSinceReset() {
        return System.currentTimeMillis() - this.resetTime;
    }

    public double getNumberOfEventsProcessedPerSec() {
        if (this.totalTimeInEventProcessing > 0L) {
            return Util.round((double)((double)this.totalEventsProcessed / ((double)this.totalTimeInEventProcessing / 1000.0)), (int)3);
        }
        return Util.round((double)((double)this.totalEventsProcessed / 0.001), (int)3);
    }

    public double getNumberOfEventsGeneratedPerSec() {
        double ellapsed = this.getTotalTimeElapsedSinceReset();
        if (ellapsed > 0.0) {
            return Util.round((double)((double)this.totalEventsProcessed / (ellapsed / 1000.0)), (int)3);
        }
        return Util.round((double)((double)this.totalEventsProcessed / 0.001), (int)3);
    }

    public long getAverageTimeInEventProcessingPerEvent() {
        if (this.totalEventsProcessed > 0L) {
            return this.totalTimeInEventProcessing / this.totalEventsProcessed;
        }
        return 0L;
    }

    public String getMetricsSummary(boolean compact) {
        StringBuilder sb = new StringBuilder();
        if (!compact) {
            sb.append("SiteStats Event aggregation metrics summary:\n");
            sb.append("\t\tNumber of total events processed: ").append(this.getNumberOfEventsProcessed()).append("\n");
            sb.append("\t\tReset/init time: ").append(new Date(this.getResetTime())).append("\n");
            sb.append("\t\tTotal time ellapsed since reset: ").append(this.getTotalTimeElapsedSinceReset()).append(" ms\n");
            sb.append("\t\tTotal time spent processing events: ").append(this.getTotalTimeInEventProcessing()).append(" ms\n");
            sb.append("\t\tNumber of events processed per sec: ").append(this.getNumberOfEventsProcessedPerSec()).append("\n");
            sb.append("\t\tNumber of events genereated in Sakai per sec: ").append(this.getNumberOfEventsGeneratedPerSec()).append("\n");
            sb.append("\t\tAverage time spent in event processing per event: ").append(this.getAverageTimeInEventProcessingPerEvent()).append(" ms\n");
            sb.append("\t\tEvent queue size: ").append(this.getQueueSize()).append("\n");
            sb.append("\t\tIdle: ").append(this.isIdle());
        } else {
            sb.append("#Events processed: ").append(this.getNumberOfEventsProcessed()).append(", ");
            sb.append("Time ellapsed since reset: ").append(this.getTotalTimeElapsedSinceReset()).append(" ms, ");
            sb.append("Time spent processing events: ").append(this.getTotalTimeInEventProcessing()).append(" ms, ");
            sb.append("#Events processed/sec: ").append(this.getNumberOfEventsProcessedPerSec()).append(", ");
            sb.append("Avg. Time/event: ").append(this.getAverageTimeInEventProcessingPerEvent()).append(" ms, ");
            sb.append("Event queue size: ").append(this.getQueueSize()).append(", ");
            sb.append("Idle: ").append(this.isIdle());
        }
        return sb.toString();
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o instanceof Event) {
            Event e = (Event)o;
            Event eventWithPreciseDate = this.buildEvent(this.getToday(), e.getEvent(), e.getResource(), e.getContext(), e.getUserId(), e.getSessionId());
            this.collectThreadQueue.add(eventWithPreciseDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.LOG.debug("Started statistics update thread");
            while (this.collectThreadRunning) {
                this.isIdle = false;
                long startTime = System.currentTimeMillis();
                int eventCount = this.collectThreadQueue.size();
                if (eventCount > 0) {
                    while (this.collectThreadQueue.size() > 0) {
                        this.preProcessEvent(this.collectThreadQueue.remove(0));
                    }
                }
                this.doUpdateConsolidatedEvents();
                this.isIdle = true;
                this.totalTimeInEventProcessing += System.currentTimeMillis() - startTime;
                if (!this.collectThreadRunning) {
                    break;
                }
                try {
                    Object object = this.collectThreadSemaphore;
                    synchronized (object) {
                        this.collectThreadSemaphore.wait(this.collectThreadUpdateInterval);
                    }
                }
                catch (InterruptedException e) {
                    this.LOG.warn("Failed to sleep statistics update thread", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            this.LOG.debug("Failed to execute statistics update thread", t);
        }
        finally {
            if (this.collectThreadRunning) {
                this.LOG.debug("Statistics update thread was stoped by an unknown error: restarting...");
                this.startUpdateThread();
            } else {
                this.LOG.debug("Finished statistics update thread");
            }
        }
    }

    private void startUpdateThread() {
        this.collectThreadRunning = true;
        this.collectThread = null;
        this.collectThread = new Thread((Runnable)this, "org.sakaiproject.sitestats.impl.StatsUpdateManagerImpl");
        this.collectThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUpdateThread() {
        this.collectThreadRunning = false;
        Object object = this.collectThreadSemaphore;
        synchronized (object) {
            this.collectThreadSemaphore.notifyAll();
        }
    }

    private void preProcessEvent(Event event) {
        ++this.totalEventsProcessed;
        String userId = event.getUserId();
        Event e = this.fixMalFormedEvents(event);
        if (e == null) {
            return;
        }
        if (this.isRegisteredEvent(e.getEvent()) && this.isValidEvent(e)) {
            UsageSession session;
            String siteId = this.parseSiteId(e);
            if (siteId == null || this.M_ss.isUserSite(siteId) || this.M_ss.isSpecialSite(siteId)) {
                return;
            }
            Site site = this.getSite(siteId);
            if (site == null) {
                return;
            }
            if (this.isCollectEventsForSiteWithToolOnly() && site.getToolForCommonId("sakai.sitestats") == null) {
                return;
            }
            if (userId == null && (session = this.M_uss.getSession(e.getSessionId())) != null) {
                userId = session.getUserId();
            }
            if (!this.isCollectAdminEvents() && "admin".equals(userId)) {
                return;
            }
            if (!this.M_sm.isShowAnonymousAccessEvents() && "?".equals(userId)) {
                return;
            }
            Date date = null;
            date = e instanceof CustomEventImpl ? ((CustomEventImpl)e).getDate() : this.getToday();
            String eventId = e.getEvent();
            String resourceRef = e.getResource();
            if (userId == null || eventId == null || resourceRef == null) {
                return;
            }
            this.consolidateEvent(date, eventId, resourceRef, userId, siteId);
        } else if (this.getServerEvents().contains(e.getEvent()) && !this.isMyWorkspaceEvent(e)) {
            String eventId;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Server event: " + e.toString());
            }
            if ((eventId = e.getEvent()) == null) {
                return;
            }
            Date date = new Date();
            this.consolidateServerEvent(date, eventId);
        }
        if (this.isUserLoginEvent(e)) {
            UsageSession session;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("User event: " + e.toString());
            }
            if (userId == null && (session = this.M_uss.getSession(e.getSessionId())) != null) {
                userId = session.getUserId();
            }
            if (userId == null) {
                return;
            }
            Date date = new Date();
            this.consolidateUserEvent(date, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void consolidateEvent(Date dateTime, String eventId, String resourceRef, String userId, final String siteId) {
        String key;
        if (eventId == null) {
            return;
        }
        Date date = this.getTruncatedDate(dateTime);
        if (this.isRegisteredEvent(eventId) && !"pres.end".equals(eventId)) {
            key = userId + siteId + eventId + date;
            Map<String, EventStat> map = this.eventStatMap;
            synchronized (map) {
                void var9_13;
                EventStat eventStat = this.eventStatMap.get(key);
                if (eventStat == null) {
                    EventStatImpl eventStatImpl = new EventStatImpl();
                    eventStatImpl.setUserId(userId);
                    eventStatImpl.setSiteId(siteId);
                    eventStatImpl.setEventId(eventId);
                    eventStatImpl.setDate(date);
                }
                var9_13.setCount(var9_13.getCount() + 1L);
                this.eventStatMap.put(key, (EventStat)var9_13);
            }
            if (!"pres.begin".equals(eventId)) {
                String key2 = siteId + date + eventId;
                Map<String, SiteActivity> map2 = this.activityMap;
                synchronized (map2) {
                    SiteActivity e2 = this.activityMap.get(key2);
                    if (e2 == null) {
                        e2 = new SiteActivityImpl();
                        e2.setSiteId(siteId);
                        e2.setDate(date);
                        e2.setEventId(eventId);
                    }
                    e2.setCount(e2.getCount() + 1L);
                    this.activityMap.put(key2, e2);
                }
            }
        }
        if (eventId.startsWith("content.")) {
            String resourceAction = null;
            try {
                resourceAction = eventId.split("\\.")[1];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                resourceAction = eventId;
            }
            String key2 = userId + siteId + resourceRef + resourceAction + date;
            Map<String, ResourceStat> map = this.resourceStatMap;
            synchronized (map) {
                ResourceStat e1 = this.resourceStatMap.get(key2);
                if (e1 == null) {
                    e1 = new ResourceStatImpl();
                    e1.setUserId(userId);
                    e1.setSiteId(siteId);
                    e1.setResourceRef(resourceRef);
                    e1.setResourceAction(resourceAction);
                    e1.setDate(date);
                }
                e1.setCount(e1.getCount() + 1L);
                this.resourceStatMap.put(key2, e1);
                return;
            }
        }
        if (eventId.startsWith("lessonbuilder.")) {
            String[] resourceParts = resourceRef.split("/");
            if (resourceParts.length <= 3 || !"page".equals(resourceParts[2])) return;
            long pageId = Long.parseLong(resourceParts[3]);
            String lessonBuilderAction = null;
            try {
                lessonBuilderAction = eventId.split("\\.")[1];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                lessonBuilderAction = eventId;
            }
            String key3 = userId + siteId + lessonBuilderAction + pageId + date;
            if ("create".equals(lessonBuilderAction)) {
                this.lessonPageCreateEventMap.put(resourceRef, userId);
            }
            if ("read".equals(lessonBuilderAction)) {
                String creatorUserId = this.lessonPageCreateEventMap.get(resourceRef);
                if (creatorUserId == null) {
                    String hql = "select s.userId from LessonBuilderStatImpl as s where s.siteId = :siteid and s.pageAction = :pageAction and s.pageRef = :pageRef ";
                    final String finalPageRef = resourceRef;
                    HibernateCallback hcb1 = new HibernateCallback(){

                        public Object doInHibernate(Session session) throws HibernateException, SQLException {
                            Query q = session.createQuery("select s.userId from LessonBuilderStatImpl as s where s.siteId = :siteid and s.pageAction = :pageAction and s.pageRef = :pageRef ");
                            q.setString("siteid", siteId);
                            q.setString("pageAction", "create");
                            q.setString("pageRef", finalPageRef);
                            return q.list();
                        }
                    };
                    List creatorUserIds = (List)this.getHibernateTemplate().execute(hcb1);
                    if (creatorUserIds.size() > 0) {
                        creatorUserId = (String)creatorUserIds.get(0);
                        this.lessonPageCreateEventMap.put(resourceRef, creatorUserId);
                        if (creatorUserIds.size() > 1) {
                            this.LOG.warn("Multiple create events for page reference: " + resourceRef);
                        }
                    }
                }
                if (creatorUserId != null && creatorUserId.equals(userId)) return;
                this.addToLessonBuilderStatMap(key3, userId, siteId, resourceRef, pageId, lessonBuilderAction, date);
                return;
            } else {
                this.addToLessonBuilderStatMap(key3, userId, siteId, resourceRef, pageId, lessonBuilderAction, date);
            }
            return;
        }
        if ("pres.begin".equals(eventId)) {
            key = siteId + date;
            this.lock.lock();
            try {
                SiteVisits e1 = this.visitsMap.get(key);
                if (e1 == null) {
                    e1 = new SiteVisitsImpl();
                    e1.setSiteId(siteId);
                    e1.setDate(date);
                }
                e1.setTotalVisits(e1.getTotalVisits() + 1L);
                this.visitsMap.put(key, e1);
                UniqueVisitsKey uniqueVisitsKey = new UniqueVisitsKey(siteId, date);
                this.uniqueVisitsMap.put(uniqueVisitsKey, 1);
                if (!this.M_sm.isEnableSitePresences()) return;
                String pKey = siteId + userId + date;
                SitePresenceConsolidation spc = this.presencesMap.get(pKey);
                if (spc == null) {
                    SitePresenceImpl sp = new SitePresenceImpl();
                    sp.setSiteId(siteId);
                    sp.setUserId(userId);
                    sp.setDate(date);
                    spc = new SitePresenceConsolidation((SitePresence)sp);
                }
                spc.sitePresence.setLastVisitStartTime(dateTime);
                this.presencesMap.put(pKey, spc);
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!"pres.end".equals(eventId) || !this.M_sm.isEnableSitePresences()) return;
        String pKey = siteId + userId + date;
        this.lock.lock();
        try {
            SitePresenceConsolidation spc = this.presencesMap.get(pKey);
            if (spc == null) {
                SitePresenceImpl sitePresenceImpl = new SitePresenceImpl();
                sitePresenceImpl.setSiteId(siteId);
                sitePresenceImpl.setUserId(userId);
                sitePresenceImpl.setDate(date);
                sitePresenceImpl.setLastVisitStartTime(null);
                spc = new SitePresenceConsolidation((SitePresence)sitePresenceImpl, dateTime);
            }
            if (spc.sitePresence.getLastVisitStartTime() != null) {
                long l = spc.sitePresence.getDuration();
                long start = spc.sitePresence.getLastVisitStartTime().getTime();
                long thisEventTime = dateTime.getTime();
                long additionalDuration = thisEventTime - start;
                if (additionalDuration > 14400000L) {
                    this.LOG.warn("A site presence is longer than 4h!: duration=" + additionalDuration / 1000L / 60L + " min (SITE:" + siteId + ", USER:" + userId + ", DATE:" + date + ")");
                }
                spc.sitePresence.setDuration(l + additionalDuration);
                spc.sitePresence.setLastVisitStartTime(null);
            }
            this.presencesMap.put(pKey, spc);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLessonBuilderStatMap(String key, String userId, String siteId, String pageRef, long pageId, String action, Date date) {
        Map<String, LessonBuilderStat> map = this.lessonBuilderStatMap;
        synchronized (map) {
            LessonBuilderStat e1 = this.lessonBuilderStatMap.get(key);
            if (e1 == null) {
                e1 = new LessonBuilderStatImpl();
                e1.setUserId(userId);
                e1.setSiteId(siteId);
                e1.setPageRef(pageRef);
                e1.setPageId(pageId);
                e1.setPageAction(action);
                e1.setDate(date);
            }
            e1.setCount(e1.getCount() + 1L);
            this.lessonBuilderStatMap.put(key, e1);
        }
    }

    protected boolean isRegisteredEvent(String eventId) {
        return this.M_ers.isRegisteredEvent(eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consolidateServerEvent(Date dateTime, String eventId) {
        Date date = this.getTruncatedDate(dateTime);
        String key = eventId + date;
        Map<String, ServerStat> map = this.serverStatMap;
        synchronized (map) {
            ServerStat s = this.serverStatMap.get(key);
            if (s == null) {
                s = new ServerStatImpl();
                s.setEventId(eventId);
                s.setDate(date);
            }
            s.setCount(s.getCount() + 1L);
            this.serverStatMap.put(key, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consolidateUserEvent(Date dateTime, String userId) {
        Date date = this.getTruncatedDate(dateTime);
        String key = userId + date;
        Map<String, UserStat> map = this.userStatMap;
        synchronized (map) {
            UserStat s = this.userStatMap.get(key);
            if (s == null) {
                s = new UserStatImpl();
                s.setUserId(userId);
                s.setDate(date);
            }
            s.setCount(s.getCount() + 1L);
            this.userStatMap.put(key, s);
        }
    }

    private synchronized boolean doUpdateConsolidatedEvents() {
        long startTime = System.currentTimeMillis();
        if (this.eventStatMap.size() > 0 || this.resourceStatMap.size() > 0 || this.activityMap.size() > 0 || this.uniqueVisitsMap.size() > 0 || this.visitsMap.size() > 0 || this.presencesMap.size() > 0 || this.serverStatMap.size() > 0 || this.userStatMap.size() > 0) {
            Object r = this.getHibernateTemplate().execute(new HibernateCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Transaction tx = null;
                    try {
                        Collection tmp3;
                        Map map;
                        tx = session.beginTransaction();
                        if (StatsUpdateManagerImpl.this.eventStatMap.size() > 0) {
                            Collection tmp1 = null;
                            map = StatsUpdateManagerImpl.this.eventStatMap;
                            synchronized (map) {
                                tmp1 = StatsUpdateManagerImpl.this.eventStatMap.values();
                                StatsUpdateManagerImpl.this.eventStatMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateEventStatObjects(session, tmp1);
                        }
                        if (StatsUpdateManagerImpl.this.resourceStatMap.size() > 0) {
                            Collection tmp2 = null;
                            map = StatsUpdateManagerImpl.this.resourceStatMap;
                            synchronized (map) {
                                tmp2 = StatsUpdateManagerImpl.this.resourceStatMap.values();
                                StatsUpdateManagerImpl.this.resourceStatMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateResourceStatObjects(session, tmp2);
                        }
                        if (StatsUpdateManagerImpl.this.lessonBuilderStatMap.size() > 0) {
                            tmp3 = null;
                            map = StatsUpdateManagerImpl.this.lessonBuilderStatMap;
                            synchronized (map) {
                                tmp3 = StatsUpdateManagerImpl.this.lessonBuilderStatMap.values();
                                StatsUpdateManagerImpl.this.lessonBuilderStatMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateLessonBuilderStatObjects(session, tmp3);
                        }
                        if (StatsUpdateManagerImpl.this.activityMap.size() > 0) {
                            tmp3 = null;
                            map = StatsUpdateManagerImpl.this.activityMap;
                            synchronized (map) {
                                tmp3 = StatsUpdateManagerImpl.this.activityMap.values();
                                StatsUpdateManagerImpl.this.activityMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateSiteActivityObjects(session, tmp3);
                        }
                        if (StatsUpdateManagerImpl.this.uniqueVisitsMap.size() > 0 || StatsUpdateManagerImpl.this.visitsMap.size() > 0) {
                            Map tmp4;
                            map = StatsUpdateManagerImpl.this.uniqueVisitsMap;
                            synchronized (map) {
                                tmp4 = StatsUpdateManagerImpl.this.uniqueVisitsMap;
                                StatsUpdateManagerImpl.this.uniqueVisitsMap = Collections.synchronizedMap(new HashMap());
                            }
                            tmp4 = StatsUpdateManagerImpl.this.doGetSiteUniqueVisits(session, tmp4);
                            if (StatsUpdateManagerImpl.this.visitsMap.size() > 0) {
                                Collection tmp5 = null;
                                Map map2 = StatsUpdateManagerImpl.this.visitsMap;
                                synchronized (map2) {
                                    tmp5 = StatsUpdateManagerImpl.this.visitsMap.values();
                                    StatsUpdateManagerImpl.this.visitsMap = Collections.synchronizedMap(new HashMap());
                                }
                                StatsUpdateManagerImpl.this.doUpdateSiteVisitsObjects(session, tmp5, tmp4);
                            }
                        }
                        if (StatsUpdateManagerImpl.this.presencesMap.size() > 0) {
                            Collection tmp6 = null;
                            map = StatsUpdateManagerImpl.this.presencesMap;
                            synchronized (map) {
                                tmp6 = StatsUpdateManagerImpl.this.presencesMap.values();
                                StatsUpdateManagerImpl.this.presencesMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateSitePresencesObjects(session, tmp6);
                        }
                        if (StatsUpdateManagerImpl.this.serverStatMap.size() > 0) {
                            Collection tmp7 = null;
                            map = StatsUpdateManagerImpl.this.serverStatMap;
                            synchronized (map) {
                                tmp7 = StatsUpdateManagerImpl.this.serverStatMap.values();
                                StatsUpdateManagerImpl.this.serverStatMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateServerStatObjects(session, tmp7);
                        }
                        if (StatsUpdateManagerImpl.this.userStatMap.size() > 0) {
                            Collection tmp8 = null;
                            map = StatsUpdateManagerImpl.this.userStatMap;
                            synchronized (map) {
                                tmp8 = StatsUpdateManagerImpl.this.userStatMap.values();
                                StatsUpdateManagerImpl.this.userStatMap = Collections.synchronizedMap(new HashMap());
                            }
                            StatsUpdateManagerImpl.this.doUpdateUserStatObjects(session, tmp8);
                        }
                        tx.commit();
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        StatsUpdateManagerImpl.this.LOG.warn("Unable to commit transaction: ", (Throwable)e);
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            });
            long endTime = System.currentTimeMillis();
            this.LOG.debug("Time spent in doUpdateConsolidatedEvents(): " + (endTime - startTime) + " ms");
            return (Boolean)r;
        }
        return true;
    }

    private void doUpdateEventStatObjects(Session session, Collection<EventStat> o) {
        if (o == null) {
            return;
        }
        ArrayList<EventStat> objects = new ArrayList<EventStat>(o);
        Collections.sort(objects);
        for (EventStat eUpdate : objects) {
            String eExistingSiteId = null;
            EventStat eExisting = null;
            try {
                Criteria c = session.createCriteria(EventStatImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"eventId", (Object)eUpdate.getEventId()));
                c.add((Criterion)Expression.eq((String)"userId", (Object)eUpdate.getUserId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (EventStat)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (EventStat)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getEventId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateResourceStatObjects(Session session, Collection<ResourceStat> o) {
        if (o == null) {
            return;
        }
        ArrayList<ResourceStat> objects = new ArrayList<ResourceStat>(o);
        Collections.sort(objects);
        for (ResourceStat eUpdate : objects) {
            ResourceStat eExisting = null;
            String eExistingSiteId = null;
            try {
                Criteria c = session.createCriteria(ResourceStatImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"resourceRef", (Object)eUpdate.getResourceRef()));
                c.add((Criterion)Expression.eq((String)"resourceAction", (Object)eUpdate.getResourceAction()));
                c.add((Criterion)Expression.eq((String)"userId", (Object)eUpdate.getUserId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (ResourceStat)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (ResourceStat)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateLessonBuilderStatObjects(Session session, Collection<LessonBuilderStat> o) {
        if (o == null) {
            return;
        }
        ArrayList<LessonBuilderStat> objects = new ArrayList<LessonBuilderStat>(o);
        Collections.sort(objects);
        for (LessonBuilderStat eUpdate : objects) {
            LessonBuilderStat eExisting = null;
            String eExistingSiteId = null;
            try {
                Criteria c = session.createCriteria(LessonBuilderStatImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"pageRef", (Object)eUpdate.getPageRef()));
                c.add((Criterion)Expression.eq((String)"pageAction", (Object)eUpdate.getPageAction()));
                c.add((Criterion)Expression.eq((String)"userId", (Object)eUpdate.getUserId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (LessonBuilderStat)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (LessonBuilderStat)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateSiteActivityObjects(Session session, Collection<SiteActivity> o) {
        if (o == null) {
            return;
        }
        ArrayList<SiteActivity> objects = new ArrayList<SiteActivity>(o);
        Collections.sort(objects);
        for (SiteActivity eUpdate : objects) {
            SiteActivity eExisting = null;
            String eExistingSiteId = null;
            try {
                Criteria c = session.createCriteria(SiteActivityImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"eventId", (Object)eUpdate.getEventId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (SiteActivity)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (SiteActivity)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getEventId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateSiteVisitsObjects(Session session, Collection<SiteVisits> o, Map<UniqueVisitsKey, Integer> map) {
        if (o == null) {
            return;
        }
        ArrayList<SiteVisits> objects = new ArrayList<SiteVisits>(o);
        Collections.sort(objects);
        for (SiteVisits eUpdate : objects) {
            SiteVisits eExisting = null;
            String eExistingSiteId = null;
            try {
                Criteria c = session.createCriteria(SiteVisitsImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (SiteVisits)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (SiteVisits)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setTotalVisits(eExisting.getTotalVisits() + eUpdate.getTotalVisits());
                }
                Integer mapUV = map.get(new UniqueVisitsKey(eExisting.getSiteId(), eExisting.getDate()));
                eExisting.setTotalUnique(mapUV == null ? 1L : mapUV.longValue());
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate((Object)eExisting);
        }
    }

    private void doUpdateSiteVisitTimeObjects(Session session, Collection<SitePresence> o) {
        if (o == null) {
            return;
        }
        ArrayList<SitePresence> objects = new ArrayList<SitePresence>(o);
        Collections.sort(objects);
        for (SitePresence eUpdate : objects) {
            SitePresence eExisting = null;
            String eExistingSiteId = null;
            try {
                Criteria c = session.createCriteria(SitePresenceImpl.class);
                c.add((Criterion)Expression.eq((String)"siteId", (Object)eUpdate.getSiteId()));
                c.add((Criterion)Expression.eq((String)"userId", (Object)eUpdate.getUserId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (SitePresence)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (SitePresence)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setDuration(eExisting.getDuration() + eUpdate.getDuration());
                }
                eExistingSiteId = eExisting.getSiteId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getId(), (Throwable)ex);
            }
            if (eExistingSiteId == null || eExistingSiteId.trim().length() <= 0) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateServerStatObjects(Session session, Collection<ServerStat> o) {
        if (o == null) {
            return;
        }
        ArrayList<ServerStat> objects = new ArrayList<ServerStat>(o);
        Collections.sort(objects);
        for (ServerStat eUpdate : objects) {
            ServerStat eExisting = null;
            try {
                Criteria c = session.createCriteria(ServerStatImpl.class);
                c.add((Criterion)Expression.eq((String)"eventId", (Object)eUpdate.getEventId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (ServerStat)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (ServerStat)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getEventId(), (Throwable)ex);
            }
            session.saveOrUpdate(eExisting);
        }
    }

    private void doUpdateUserStatObjects(Session session, Collection<UserStat> o) {
        if (o == null) {
            return;
        }
        ArrayList<UserStat> objects = new ArrayList<UserStat>(o);
        Collections.sort(objects);
        for (UserStat eUpdate : objects) {
            UserStat eExisting = null;
            String eExistingUserId = null;
            try {
                Criteria c = session.createCriteria(UserStatImpl.class);
                c.add((Criterion)Expression.eq((String)"userId", (Object)eUpdate.getUserId()));
                c.add((Criterion)Expression.eq((String)"date", (Object)eUpdate.getDate()));
                try {
                    eExisting = (UserStat)c.uniqueResult();
                }
                catch (HibernateException ex) {
                    try {
                        List events = c.list();
                        if (events != null && events.size() > 0) {
                            this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                            eExisting = (UserStat)c.list().get(0);
                        }
                        this.LOG.debug("No result found", (Throwable)ex);
                        eExisting = null;
                    }
                    catch (Exception ex3) {
                        eExisting = null;
                    }
                }
                catch (Exception ex2) {
                    this.LOG.warn("Probably ddbb error when loading data at java object", (Throwable)ex2);
                }
                if (eExisting == null) {
                    eExisting = eUpdate;
                } else {
                    eExisting.setCount(eExisting.getCount() + eUpdate.getCount());
                }
                eExistingUserId = eExisting.getUserId();
            }
            catch (Exception ex) {
                this.LOG.warn("Failed to event:" + eUpdate.getId(), (Throwable)ex);
            }
            if (!StringUtils.isNotBlank(eExistingUserId)) continue;
            session.saveOrUpdate(eExisting);
        }
    }

    private Map<UniqueVisitsKey, Integer> doGetSiteUniqueVisits(Session session, Map<UniqueVisitsKey, Integer> map) {
        for (UniqueVisitsKey key : map.keySet()) {
            Query q = session.createQuery("select count(distinct s.userId) from EventStatImpl as s where s.siteId = :siteid and s.eventId = 'pres.begin' and s.date = :idate");
            q.setString("siteid", key.siteId);
            q.setDate("idate", key.date);
            Integer uv = 1;
            try {
                uv = (Integer)q.uniqueResult();
            }
            catch (ClassCastException ex) {
                uv = (int)((Long)q.uniqueResult()).longValue();
            }
            catch (HibernateException ex) {
                try {
                    List visits = q.list();
                    if (visits != null && visits.size() > 0) {
                        this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                        uv = (Integer)q.list().get(0);
                    }
                    this.LOG.debug("No result found", (Throwable)ex);
                    uv = 1;
                }
                catch (Exception e3) {
                    uv = 1;
                }
            }
            catch (Exception ex2) {
                this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)ex2);
            }
            int uniqueVisits = uv == null ? 1 : uv;
            map.put(key, uniqueVisits);
        }
        return map;
    }

    private void doUpdateSitePresencesObjects(Session session, Collection<SitePresenceConsolidation> o) {
        if (o == null) {
            return;
        }
        ArrayList<SitePresenceConsolidation> objects = new ArrayList<SitePresenceConsolidation>(o);
        Collections.sort(objects);
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            try {
                SitePresenceConsolidation spc = (SitePresenceConsolidation)i.next();
                SitePresence sp = spc.sitePresence;
                SitePresence spExisting = this.doGetSitePresence(session, sp.getSiteId(), sp.getUserId(), sp.getDate());
                if (spExisting == null) {
                    session.save((Object)sp);
                    if (spc.firstEventIsPresEnd) continue;
                    this.doUpdateSitePresenceTotal(session, sp);
                    continue;
                }
                long previousTotalPresence = spExisting.getDuration();
                long previousPresence = 0L;
                long newTotalPresence = 0L;
                if (spc.firstEventIsPresEnd) {
                    if (spExisting.getLastVisitStartTime() != null) {
                        previousPresence = spc.firstPresEndDate.getTime() - spExisting.getLastVisitStartTime().getTime();
                    } else {
                        throw new Exception("No initial visit start time found - skipping");
                    }
                }
                newTotalPresence = previousTotalPresence + previousPresence + sp.getDuration();
                spExisting.setDuration(newTotalPresence);
                spExisting.setLastVisitStartTime(sp.getLastVisitStartTime());
                session.update((Object)spExisting);
                if (spc.firstEventIsPresEnd) continue;
                this.doUpdateSitePresenceTotal(session, spExisting);
            }
            catch (HibernateException e) {
                this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)e);
            }
            catch (Exception e) {
                this.LOG.debug("Unknow error while consolidating presence events", (Throwable)e);
            }
        }
    }

    private void doUpdateSitePresenceTotal(Session session, SitePresence sp) throws Exception {
        SitePresenceTotalImpl spt = new SitePresenceTotalImpl(sp);
        SitePresenceTotal sptExisting = this.doGetSitePresenceTotal(session, sp.getSiteId(), sp.getUserId());
        if (sptExisting == null) {
            session.save((Object)spt);
        } else {
            sptExisting.incrementTotalVisits();
            sptExisting.setLastVisitTime(sp.getLastVisitStartTime());
            session.update((Object)sptExisting);
        }
    }

    private SitePresence doGetSitePresence(Session session, String siteId, String userId, Date date) {
        SitePresence eDb = null;
        Criteria c = session.createCriteria(SitePresenceImpl.class);
        c.add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
        c.add((Criterion)Expression.eq((String)"userId", (Object)userId));
        c.add((Criterion)Expression.eq((String)"date", (Object)date));
        try {
            eDb = (SitePresence)c.uniqueResult();
        }
        catch (HibernateException ex) {
            try {
                List es = c.list();
                if (es != null && es.size() > 0) {
                    this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                    eDb = (SitePresence)es.get(0);
                }
                eDb = null;
            }
            catch (Exception e3) {
                this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)e3);
                eDb = null;
            }
        }
        catch (Exception ex2) {
            this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)ex2);
        }
        return eDb;
    }

    private SitePresenceTotal doGetSitePresenceTotal(Session session, String siteId, String userId) {
        SitePresenceTotal eDb = null;
        Criteria c = session.createCriteria(SitePresenceTotalImpl.class);
        c.add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
        c.add((Criterion)Expression.eq((String)"userId", (Object)userId));
        try {
            eDb = (SitePresenceTotal)c.uniqueResult();
        }
        catch (HibernateException ex) {
            try {
                List es = c.list();
                if (es != null && es.size() > 0) {
                    this.LOG.debug("More than 1 result when unique result expected.", (Throwable)ex);
                    eDb = (SitePresenceTotal)es.get(0);
                }
                eDb = null;
            }
            catch (Exception e3) {
                this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)e3);
                eDb = null;
            }
        }
        catch (Exception ex2) {
            this.LOG.debug("Probably ddbb error when loading data at java object", (Throwable)ex2);
        }
        return eDb;
    }

    private synchronized boolean isValidEvent(Event e) {
        if (e.getEvent().startsWith("content.")) {
            String ref = e.getResource();
            if (ref.trim().equals("")) {
                return false;
            }
            try {
                String[] parts = ref.split("\\/");
                if (parts[2].equals("user")) {
                    return false;
                }
                if (parts[2].equals("attachment") && parts.length < 6) {
                    return false;
                }
                if (parts[2].equals("group")) {
                    if (parts.length <= 4) {
                        return false;
                    }
                } else if (parts[2].equals("group-user")) {
                    if (parts.length <= 5) {
                        return false;
                    }
                } else if (parts.length >= 3 && parts[2].equals("private")) {
                    this.LOG.debug("Discarding content event in private area.");
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private Event fixMalFormedEvents(Event e) {
        String event = e.getEvent();
        String resource = e.getResource();
        if (event != null) {
            if (event.startsWith("content.") && resource.startsWith("MessageCenter")) {
                resource = resource.replaceFirst("MessageCenter::", "/MessageCenter/site/");
                resource = resource.replaceAll("::", "/");
                return this.M_ets.newEvent(event.replaceFirst("content.", "msgcntr."), resource, false);
            }
            return e;
        }
        return this.M_ets.newEvent("garbage.", resource, false);
    }

    private String parseSiteId(Event e) {
        String eventRef;
        String eventId = e.getEvent();
        if (this.M_sm.isEventContextSupported()) {
            String contextId = null;
            try {
                contextId = (String)e.getClass().getMethod("getContext", null).invoke((Object)e, null);
                String sitePrefix = "/site/";
                if (contextId != null && contextId.startsWith(sitePrefix)) {
                    contextId = contextId.substring(sitePrefix.length());
                }
                this.LOG.debug("Context read from Event.getContext() for event: " + eventId + " - context: " + contextId);
            }
            catch (Exception ex) {
                this.LOG.warn("Unable to get Event.getContext() for event: " + eventId, (Throwable)ex);
            }
            if (contextId != null) {
                return contextId;
            }
        }
        if ((eventRef = e.getResource()) != null) {
            try {
                if ("pres.begin".equals(eventId) || "pres.end".equals(eventId)) {
                    String[] parts = eventRef.split("/");
                    if (parts.length > 2 && parts[2].endsWith(PRESENCE_SUFFIX)) {
                        return parts[2].substring(0, parts[2].length() - PRESENCE_SUFFIX_LENGTH);
                    }
                } else {
                    ToolInfo toolInfo = this.getEventIdToolMap().get(eventId);
                    EventParserTip parserTip = toolInfo.getEventParserTip();
                    if (parserTip != null && parserTip.getFor().equals("contextId")) {
                        int index = Integer.parseInt(parserTip.getIndex());
                        return eventRef.split(parserTip.getSeparator())[index];
                    }
                    if (this.M_sm.isEventContextSupported()) {
                        this.LOG.info("Context information unavailable for event: " + eventId + " (ignoring)");
                    } else {
                        this.LOG.info("<eventParserTip> is mandatory when Event.getContext() is unsupported! Ignoring event: " + eventId);
                    }
                }
            }
            catch (Exception ex) {
                this.LOG.warn("Unable to parse contextId from event: " + eventId + " | " + eventRef, (Throwable)ex);
            }
        }
        return null;
    }

    private Site getSite(String siteId) {
        Site site = null;
        try {
            site = this.M_ss.getSite(siteId);
        }
        catch (IdUnusedException e1) {
            try {
                String alias = siteId;
                String target = this.M_as.getTarget(alias);
                if (target == null) {
                    throw new IdUnusedException(siteId);
                }
                String newSiteId = this.M_em.newReference(target).getId();
                this.LOG.debug(alias + " is an alias targetting site id: " + newSiteId);
                site = this.M_ss.getSite(newSiteId);
            }
            catch (IdUnusedException e2) {
                this.LOG.debug(siteId + " is not a valid site.", (Throwable)e2);
            }
        }
        catch (Exception ex) {
            this.LOG.debug(siteId + " is not a valid site.", (Throwable)ex);
        }
        return site;
    }

    private Collection<String> getServerEvents() {
        return this.M_ers.getServerEventIds();
    }

    private Map<String, ToolInfo> getEventIdToolMap() {
        return this.M_ers.getEventIdToolMap();
    }

    private Date getToday() {
        return new Date();
    }

    private boolean isUserLoginEvent(Event e) {
        return StringUtils.equals((String)"user.login", (String)e.getEvent()) || StringUtils.equals((String)"user.login.container", (String)e.getEvent());
    }

    private boolean isMyWorkspaceEvent(Event e) {
        return e.getResource() != null && e.getResource().startsWith("/site/~");
    }

    private Date getTruncatedDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    private static class SitePresenceConsolidation
    implements Comparable<SitePresenceConsolidation> {
        public boolean firstEventIsPresEnd;
        public Date firstPresEndDate;
        public SitePresence sitePresence;

        public SitePresenceConsolidation(SitePresence sitePresence) {
            this(sitePresence, null);
        }

        public SitePresenceConsolidation(SitePresence sitePresence, Date firstPresEndDate) {
            this.sitePresence = sitePresence;
            if (firstPresEndDate == null) {
                this.firstEventIsPresEnd = false;
                this.firstPresEndDate = null;
            } else {
                this.firstEventIsPresEnd = true;
                this.firstPresEndDate = firstPresEndDate;
            }
        }

        @Override
        public int compareTo(SitePresenceConsolidation other) {
            int val = this.sitePresence.compareTo((Object)other.sitePresence);
            if (val != 0) {
                return val;
            }
            val = this.firstPresEndDate.compareTo(other.firstPresEndDate);
            if (val != 0) {
                return val;
            }
            return (this.firstEventIsPresEnd ? 1 : 0) - (other.firstEventIsPresEnd ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof SitePresenceConsolidation) {
                SitePresenceConsolidation u = (SitePresenceConsolidation)o;
                return this.firstEventIsPresEnd == u.firstEventIsPresEnd && (this.firstPresEndDate == null && u.firstPresEndDate == null || this.firstPresEndDate != null && this.firstPresEndDate.equals(u.firstPresEndDate)) && (this.sitePresence == null && u.sitePresence == null || this.sitePresence != null && this.sitePresence.equals(u.sitePresence));
            }
            return false;
        }

        public int hashCode() {
            return Boolean.valueOf(this.firstEventIsPresEnd).hashCode() + this.firstPresEndDate.hashCode() + this.sitePresence.hashCode();
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("firstPresEndDate: ");
            buff.append(this.firstPresEndDate);
            buff.append(" | sitePresence => ");
            if (this.sitePresence != null) {
                buff.append(this.sitePresence.toString());
            } else {
                buff.append("null");
            }
            return buff.toString();
        }
    }

    private static class UniqueVisitsKey {
        public String siteId;
        public Date date;

        public UniqueVisitsKey(String siteId, Date date) {
            this.siteId = siteId;
            this.date = this.resetToDay(date);
        }

        public boolean equals(Object o) {
            if (o instanceof UniqueVisitsKey) {
                UniqueVisitsKey u = (UniqueVisitsKey)o;
                return this.siteId.equals(u.siteId) && this.date.equals(u.date);
            }
            return false;
        }

        public int hashCode() {
            return this.siteId.hashCode() + this.date.hashCode();
        }

        private Date resetToDay(Date date) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
    }
}

