/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.sakaiproject.sitestats.api.SiteActivity;
import org.sakaiproject.sitestats.api.SiteActivityByTool;
import org.sakaiproject.sitestats.api.SummaryActivityChartData;

public class SummaryActivityChartDataImpl
implements SummaryActivityChartData {
    private String viewType = null;
    private String chartType = null;
    private Date firstDay = null;
    private long[] activity = null;
    private int activityByToolTotal = 0;
    private List<SiteActivity> siteActivity = null;
    private List<SiteActivityByTool> siteActivityByTool = null;

    public SummaryActivityChartDataImpl(String viewType, String chartType) {
        this.viewType = viewType;
        this.chartType = chartType;
    }

    public void setSiteActivity(List<SiteActivity> siteActivity) {
        this.siteActivity = siteActivity;
    }

    public void setSiteActivityByTool(List<SiteActivityByTool> siteActivityByTool) {
        this.siteActivityByTool = siteActivityByTool;
    }

    public long[] getActivity() {
        if (this.activity == null && this.siteActivity.size() > 0) {
            this.fillBarChartData();
        }
        return this.activity;
    }

    public List<SiteActivityByTool> getActivityByTool() {
        this.fillPieChartData();
        if (this.siteActivityByTool.size() > 0) {
            return this.siteActivityByTool;
        }
        return null;
    }

    public int getActivityByToolTotal() {
        this.fillPieChartData();
        return this.activityByToolTotal;
    }

    public Date getFirstDay() {
        if (this.firstDay == null && this.siteActivity.size() > 0) {
            this.fillBarChartData();
        }
        return this.firstDay;
    }

    private void fillPieChartData() {
        if (this.viewType == null || this.chartType == null || this.siteActivityByTool == null) {
            return;
        }
        Collections.sort(this.siteActivityByTool, new SiteActivityByToolComparator());
        this.activityByToolTotal = 0;
        for (int i = 0; i < this.siteActivityByTool.size(); ++i) {
            this.activityByToolTotal = (int)((long)this.activityByToolTotal + this.siteActivityByTool.get(i).getCount());
        }
    }

    private void fillBarChartData() {
        if (this.viewType == null || this.chartType == null || this.siteActivity == null) {
            return;
        }
        int timeSlots = 0;
        if ("week".equals(this.viewType)) {
            timeSlots = 7;
        } else if ("month".equals(this.viewType)) {
            timeSlots = 30;
        } else if ("year".equals(this.viewType)) {
            timeSlots = 12;
        }
        Calendar cal = Calendar.getInstance();
        this.activity = new long[timeSlots];
        for (int i = timeSlots - 1; i >= 0; --i) {
            SiteActivity sa = null;
            sa = "year".equals(this.viewType) ? this.getDataForMonth(cal) : this.getDataForDay(cal);
            this.activity[i] = sa == null ? 0L : sa.getCount();
            if (i <= 0) continue;
            if ("week".equals(this.viewType) || "month".equals(this.viewType)) {
                cal.add(5, -1);
                continue;
            }
            if (!"year".equals(this.viewType)) continue;
            cal.add(2, -1);
        }
        this.firstDay = cal.getTime();
    }

    private SiteActivity getDataForDay(Calendar cal_) {
        Calendar cal = (Calendar)cal_.clone();
        int desiredDay = cal.get(6);
        for (int i = this.siteActivity.size() - 1; i >= 0; --i) {
            SiteActivity sa = this.siteActivity.get(i);
            cal.setTime(sa.getDate());
            int thisDay = cal.get(6);
            if (desiredDay != thisDay) continue;
            return sa;
        }
        return null;
    }

    private SiteActivity getDataForMonth(Calendar cal_) {
        Calendar cal = (Calendar)cal_.clone();
        int desiredMonth = cal.get(2);
        for (int i = this.siteActivity.size() - 1; i >= 0; --i) {
            SiteActivity sa = this.siteActivity.get(i);
            cal.setTime(sa.getDate());
            int thisMonth = cal.get(2);
            if (desiredMonth != thisMonth) continue;
            return sa;
        }
        return null;
    }

    static class SiteActivityByToolComparator
    implements Comparator<SiteActivityByTool>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SiteActivityByToolComparator() {
        }

        @Override
        public int compare(SiteActivityByTool o1, SiteActivityByTool o2) {
            if (o1.getCount() < o2.getCount()) {
                return 1;
            }
            if (o1.getCount() == o2.getCount()) {
                return 0;
            }
            return -1;
        }
    }
}

