/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.report.fop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryURIResolver
implements URIResolver {
    private Logger LOG = LoggerFactory.getLogger(LibraryURIResolver.class);
    private static final String LIBRARY_HANDLER = "library://";
    private static final String SITESTATS_HANDLER = "sitestats://";
    private String libraryRoot = this.getLibraryRoot();
    private String sitestatsRoot = this.getSitestatsRoot();

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith(LIBRARY_HANDLER) && this.libraryRoot != null || href.startsWith(SITESTATS_HANDLER) && this.sitestatsRoot != null) {
            String resource = null;
            String fullResource = null;
            if (href.startsWith(LIBRARY_HANDLER)) {
                resource = href.substring(LIBRARY_HANDLER.length());
                fullResource = this.libraryRoot + resource;
            }
            if (href.startsWith(SITESTATS_HANDLER)) {
                String webappStartDir;
                resource = href.substring(SITESTATS_HANDLER.length());
                if (resource.startsWith(webappStartDir = "/sitestats-tool")) {
                    resource = resource.substring(webappStartDir.length());
                }
                fullResource = this.sitestatsRoot + resource;
            }
            FileInputStream fis = null;
            StreamSource ss = null;
            try {
                fis = new FileInputStream(fullResource);
                StreamSource streamSource = ss = new StreamSource(fis, resource);
                return streamSource;
            }
            catch (FileNotFoundException e) {
                throw new TransformerException(e);
            }
        }
        return null;
    }

    private String getLibraryRoot() {
        String path = null;
        try {
            String catalina = System.getProperty("catalina.base");
            if (catalina == null) {
                catalina = System.getProperty("catalina.home");
            }
            StringBuilder buff = new StringBuilder(catalina);
            buff.append(File.separatorChar);
            buff.append("webapps");
            buff.append(File.separatorChar);
            buff.append("library");
            buff.append(File.separatorChar);
            path = buff.toString();
        }
        catch (Exception e) {
            path = null;
        }
        return path;
    }

    private String getSitestatsRoot() {
        String path = null;
        try {
            String catalina = System.getProperty("catalina.base");
            if (catalina == null) {
                catalina = System.getProperty("catalina.home");
            }
            StringBuilder buff = new StringBuilder(catalina);
            buff.append(File.separatorChar);
            buff.append("webapps");
            buff.append("/sitestats-tool");
            buff.append(File.separatorChar);
            path = buff.toString();
        }
        catch (Exception e) {
            path = null;
        }
        return path;
    }
}

