/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.sitestats.api.StatsAuthz;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsAuthzImpl
implements StatsAuthz {
    private static Logger LOG = LoggerFactory.getLogger(StatsAuthzImpl.class);
    private UserDirectoryService M_uds;
    private SecurityService M_secs;
    private SessionManager M_sess;
    private ToolManager M_tm;

    public void setUserService(UserDirectoryService userService) {
        this.M_uds = userService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.M_secs = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.M_sess = sessionManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.M_tm = toolManager;
    }

    public void init() {
        LOG.info("init()");
        FunctionManager.registerFunction((String)"sitestats.view");
        FunctionManager.registerFunction((String)"sitestats.admin.view");
    }

    public boolean isUserAbleToViewSiteStats(String siteId) {
        return this.hasPermission(SiteService.siteReference((String)siteId), "sitestats.view");
    }

    public boolean isUserAbleToViewSiteStatsAdmin(String siteId) {
        return this.hasPermission(SiteService.siteReference((String)siteId), "sitestats.admin.view");
    }

    public boolean isSiteStatsPage() {
        return "sakai.sitestats".equals(this.M_tm.getCurrentTool().getId());
    }

    public boolean isSiteStatsAdminPage() {
        return "sakai.sitestats.admin".equals(this.M_tm.getCurrentTool().getId());
    }

    private boolean hasPermission(String reference, String permission) {
        return this.M_secs.unlock(permission, reference);
    }
}

