/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.EventStat;
import org.sakaiproject.sitestats.api.ResourceStat;
import org.sakaiproject.sitestats.api.SitePresence;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.Stat;
import org.sakaiproject.sitestats.api.StatsAuthz;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.report.Report;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportFormattedParams;
import org.sakaiproject.sitestats.api.report.ReportManager;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.impl.parser.DigesterUtil;
import org.sakaiproject.sitestats.impl.report.fop.LibraryURIResolver;
import org.sakaiproject.sitestats.impl.report.fop.ReportInputSource;
import org.sakaiproject.sitestats.impl.report.fop.ReportXMLReader;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ReportManagerImpl
extends HibernateDaoSupport
implements ReportManager,
Observer {
    private Logger LOG = LoggerFactory.getLogger(ReportManagerImpl.class);
    private static ResourceLoader msgs = new ResourceLoader("Messages");
    private ReportFormattedParams formattedParams = new ReportFormattedParamsImpl();
    private FopFactory fopFactory = FopFactory.newInstance();
    private Templates cachedXmlFoXSLT = null;
    private static final String XML_FO_XSL_FILE = "xmlReportToFo.xsl";
    private SimpleDateFormat dateMonthFrmt = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat dateYearFrmt = new SimpleDateFormat("yyyy");
    private StatsManager M_sm;
    private StatsAuthz M_sa;
    private EventRegistryService M_ers;
    private SiteService M_ss;
    private UserDirectoryService M_uds;
    private ContentHostingService M_chs;
    private ToolManager M_tm;
    private TimeService M_ts;
    private EventTrackingService M_ets;
    private MemoryService M_ms;
    private Cache cacheReportDef = null;

    public void setStatsManager(StatsManager statsManager) {
        this.M_sm = statsManager;
    }

    public void setStatsAuthz(StatsAuthz statsAuthz) {
        this.M_sa = statsAuthz;
    }

    public void setEventRegistryService(EventRegistryService eventRegistryService) {
        this.M_ers = eventRegistryService;
    }

    public void setSiteService(SiteService siteService) {
        this.M_ss = siteService;
    }

    public void setUserService(UserDirectoryService userService) {
        this.M_uds = userService;
    }

    public void setContentService(ContentHostingService contentService) {
        this.M_chs = contentService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.M_tm = toolManager;
    }

    public void setTimeService(TimeService timeService) {
        this.M_ts = timeService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.M_ets = eventTrackingService;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.M_ms = memoryService;
    }

    public void setResourceLoader(ResourceLoader msgs) {
        ReportManagerImpl.msgs = msgs;
    }

    public void init() {
        this.M_ets.addPriorityObserver((Observer)this);
        this.cacheReportDef = this.M_ms.newCache(ReportDef.class.getName());
    }

    public void destroy() {
        this.M_ets.deleteObserver((Observer)this);
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o instanceof Event) {
            Event e = (Event)o;
            String prefix = "sitestats.report";
            if (e.getEvent() != null && e.getEvent().startsWith(prefix) && (e.getEvent().endsWith("new") || e.getEvent().endsWith("edit") || e.getEvent().endsWith("delete"))) {
                String[] parts = e.getResource().split("/");
                String id = parts[4];
                String siteId = parts[2];
                this.LOG.debug("Expiring report for id: " + siteId);
                this.cacheReportDef.remove((Object)id);
                this.LOG.debug("Expiring report lists for site: " + siteId);
                this.cacheReportDef.remove((Object)new KeyReportDefList(siteId, true, true).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(siteId, true, false).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(siteId, false, true).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(siteId, false, false).toString());
                this.LOG.debug("Expiring predefined report lists");
                this.cacheReportDef.remove((Object)new KeyReportDefList(null, true, true).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(null, true, false).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(null, false, true).toString());
                this.cacheReportDef.remove((Object)new KeyReportDefList(null, false, false).toString());
            }
        }
    }

    public Report getReport(ReportDef reportDef, boolean restrictToToolsInSite) {
        return this.getReport(reportDef, restrictToToolsInSite, null, true);
    }

    public int getReportRowCount(ReportDef reportDef, boolean restrictToToolsInSite) {
        ReportProcessedParams rpp = this.processReportParams(reportDef.getReportParams(), restrictToToolsInSite, null);
        if (reportDef.getReportParams().getWhat().equals("what-resources")) {
            return this.M_sm.getResourceStatsRowCount(rpp.siteId, rpp.resourceAction, rpp.resourceIds, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, rpp.totalsBy);
        }
        return this.M_sm.getEventStatsRowCount(rpp.siteId, rpp.events, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, rpp.totalsBy);
    }

    public Report getReport(ReportDef reportDef, boolean restrictToToolsInSite, PagingPosition pagingPosition, boolean log) {
        ReportProcessedParams rpp = this.processReportParams(reportDef.getReportParams(), restrictToToolsInSite, pagingPosition);
        Report report = new Report();
        List data = null;
        if (reportDef.getReportParams().getWhat().equals("what-resources")) {
            data = this.M_sm.getResourceStats(rpp.siteId, rpp.resourceAction, rpp.resourceIds, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        } else if (reportDef.getReportParams().getWhat().equals("what-visits") || reportDef.getReportParams().getWhat().equals("what-events")) {
            data = this.M_sm.getEventStats(rpp.siteId, rpp.events, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        } else if (reportDef.getReportParams().getWhat().equals("what-presences")) {
            data = this.M_sm.getPresenceStats(rpp.siteId, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        } else if (reportDef.getReportParams().getWhat().equals("what-visits-totals")) {
            data = this.M_sm.getVisitsTotalsStats(rpp.siteId, rpp.iDate, rpp.fDate, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        } else if (reportDef.getReportParams().getWhat().equals("what-activity-totals")) {
            data = this.M_sm.getActivityTotalsStats(rpp.siteId, rpp.events, rpp.iDate, rpp.fDate, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        } else if (reportDef.getReportParams().getWhat().equals("what-lessonpages")) {
            data = this.M_sm.getLessonBuilderStats(rpp.siteId, rpp.resourceAction, rpp.resourceIds, rpp.iDate, rpp.fDate, rpp.userIds, rpp.inverseUserSelection, pagingPosition, rpp.totalsBy, rpp.sortBy, rpp.sortAscending, rpp.maxResults);
        }
        reportDef.getReportParams().setWhenFrom(rpp.iDate);
        reportDef.getReportParams().setWhenTo(rpp.fDate);
        reportDef.getReportParams().setWhoUserIds(rpp.userIds);
        reportDef.getReportParams().setHowTotalsBy(rpp.totalsBy);
        report.setReportData(data);
        report.setReportDefinition(reportDef);
        report.setReportGenerationDate(new Date());
        if (log && reportDef.getId() != 0L) {
            String siteId = reportDef.getSiteId();
            if (siteId == null) {
                siteId = reportDef.getReportParams().getSiteId();
            }
            this.M_sm.logEvent((Object)reportDef, "view", siteId, true);
        }
        return report;
    }

    private ReportProcessedParams processReportParams(ReportParams params, boolean restrictToToolsInSite, PagingPosition pagingPosition) {
        Calendar c;
        ReportProcessedParams rpp = new ReportProcessedParams();
        rpp.siteId = params.getSiteId();
        rpp.events = new ArrayList<String>();
        if (params.getWhat().equals("what-visits")) {
            rpp.events.add("pres.begin");
        } else if (params.getWhat().equals("what-events")) {
            if (params.getWhatEventSelType().equals("what-events-bytool")) {
                Iterator iT = null;
                iT = rpp.siteId != null ? this.M_ers.getEventRegistry(rpp.siteId, restrictToToolsInSite).iterator() : this.M_ers.getEventRegistry().iterator();
                while (iT.hasNext()) {
                    ToolInfo t = (ToolInfo)iT.next();
                    if (!params.getWhatToolIds().contains(t.getToolId()) && !params.getWhatToolIds().contains("all")) continue;
                    Iterator iE = t.getEvents().iterator();
                    while (iE.hasNext()) {
                        rpp.events.add(((EventInfo)iE.next()).getEventId());
                    }
                }
            } else {
                List eventIds = params.getWhatEventIds();
                if (eventIds != null) {
                    rpp.events.addAll(eventIds);
                }
            }
        } else if (params.getWhat().equals("what-resources")) {
            rpp.resourceIds = null;
            rpp.resourceAction = null;
            if (params.isWhatLimitedResourceIds() && params.getWhatResourceIds() != null) {
                rpp.resourceIds = new ArrayList<String>();
                for (String next : params.getWhatResourceIds()) {
                    rpp.resourceIds.add("/content" + next);
                }
            }
            if (params.isWhatLimitedAction() && params.getWhatResourceAction() != null) {
                rpp.resourceAction = params.getWhatResourceAction();
            }
        } else if (params.getWhat().equals("what-lessonpages")) {
            rpp.resourceIds = null;
            rpp.resourceAction = null;
            if (params.isWhatLimitedResourceIds() && params.getWhatResourceIds() != null) {
                rpp.resourceIds = new ArrayList<String>();
                for (String iR : params.getWhatResourceIds()) {
                    rpp.resourceIds.add("/lessonbuilder" + iR);
                }
            }
            if (params.isWhatLimitedAction() && params.getWhatResourceAction() != null) {
                rpp.resourceAction = params.getWhatResourceAction();
            }
        }
        rpp.fDate = null;
        rpp.iDate = null;
        if (params.getWhen().equals("when-custom")) {
            rpp.iDate = params.getWhenFrom();
            rpp.fDate = params.getWhenTo();
        } else {
            rpp.fDate = new Date();
        }
        if (params.getWhen().equals("when-all")) {
            rpp.iDate = rpp.siteId != null ? this.M_sm.getInitialActivityDate(rpp.siteId) : null;
        } else if (params.getWhen().equals("when-last7days")) {
            c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.add(5, -6);
            rpp.iDate = c.getTime();
        } else if (params.getWhen().equals("when-last30days")) {
            c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.add(5, -29);
            rpp.iDate = c.getTime();
        } else if (params.getWhen().equals("when-last365days")) {
            c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.add(5, -364);
            rpp.iDate = c.getTime();
        }
        params.setWhenFrom(rpp.iDate);
        params.setWhenTo(rpp.fDate);
        rpp.userIds = null;
        rpp.inverseUserSelection = false;
        if (!params.getWho().equals("who-all")) {
            Site site;
            if (params.getWho().equals("who-role") && rpp.siteId != null) {
                rpp.userIds = new ArrayList<String>();
                try {
                    site = this.M_ss.getSite(rpp.siteId);
                    rpp.userIds.addAll(site.getUsersHasRole(params.getWhoRoleId()));
                }
                catch (IdUnusedException e) {
                    this.LOG.error("No site with specified siteId.");
                }
            } else if (params.getWho().equals("who-groups") && rpp.siteId != null) {
                rpp.userIds = new ArrayList<String>();
                try {
                    site = this.M_ss.getSite(rpp.siteId);
                    rpp.userIds.addAll(site.getGroup(params.getWhoGroupId()).getUsers());
                }
                catch (IdUnusedException e) {
                    this.LOG.error("No site with specified siteId.");
                }
            } else if (params.getWho().equals("who-custom")) {
                rpp.userIds = params.getWhoUserIds();
            } else {
                rpp.inverseUserSelection = true;
            }
        }
        params.setWhoUserIds(rpp.userIds);
        rpp.totalsBy = params.getHowTotalsBy();
        rpp.sortBy = "default".equals(params.getHowSortBy()) ? null : params.getHowSortBy();
        rpp.sortAscending = params.getHowSortAscending();
        rpp.maxResults = params.isHowLimitedMaxResults() && params.getHowMaxResults() > 0 ? params.getHowMaxResults() : 0;
        return rpp;
    }

    public ReportFormattedParams getReportFormattedParams() {
        return this.formattedParams;
    }

    public boolean isReportColumnAvailable(ReportParams params, String column) {
        List totalsBy = params.getHowTotalsBy();
        if (column == null) {
            return false;
        }
        if (column.equals("site")) {
            return totalsBy.contains("site");
        }
        if (column.equals("user")) {
            return totalsBy.contains("user");
        }
        if (column.equals("event")) {
            return totalsBy.contains("event") && !"who-none".equals(params.getWho());
        }
        if (column.equals("tool")) {
            return totalsBy.contains("tool") && !"who-none".equals(params.getWho());
        }
        if (column.equals("resource")) {
            return totalsBy.contains("resource") && !"who-none".equals(params.getWho());
        }
        if (column.equals("resource-action")) {
            return totalsBy.contains("resource-action") && !"who-none".equals(params.getWho());
        }
        if (column.equals("page")) {
            return totalsBy.contains("page") && !"who-none".equals(params.getWho());
        }
        if (column.equals("page-action")) {
            return totalsBy.contains("page-action") && !"who-none".equals(params.getWho());
        }
        if (column.equals("date")) {
            return totalsBy.contains("date") && !"who-none".equals(params.getWho());
        }
        if (column.equals("month")) {
            return totalsBy.contains("month") && !"who-none".equals(params.getWho());
        }
        if (column.equals("year")) {
            return totalsBy.contains("year") && !"who-none".equals(params.getWho());
        }
        if (column.equals("last-date")) {
            return totalsBy.contains("last-date") && !"who-none".equals(params.getWho());
        }
        if (column.equals("total")) {
            return !"what-presences".equals(params.getWhat()) && !totalsBy.contains("duration") && !"who-none".equals(params.getWho()) && !"what-visits-totals".equals(params.getWhat()) && !totalsBy.contains("visits") && !totalsBy.contains("unique-visits");
        }
        if (column.equals("visits")) {
            return totalsBy.contains("visits");
        }
        if (column.equals("unique-visits")) {
            return totalsBy.contains("unique-visits");
        }
        if (column.equals("duration")) {
            return "what-presences".equals(params.getWhat());
        }
        this.LOG.warn("isReportColumnAvailable(): invalid column: " + column);
        return false;
    }

    public ReportDef getReportDefinition(final long id) {
        ReportDef reportDef = null;
        Object cached = this.cacheReportDef.get((Object)String.valueOf(id));
        if (cached != null) {
            reportDef = (ReportDef)cached;
        } else {
            Object o;
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.load(ReportDef.class, (Serializable)Long.valueOf(id));
                }
            };
            try {
                o = this.getHibernateTemplate().execute(hcb);
            }
            catch (DataAccessException e) {
                o = null;
            }
            if (o != null) {
                reportDef = (ReportDef)o;
                this.cacheReportDef.put((Object)String.valueOf(id), (Object)reportDef);
            }
        }
        try {
            if (reportDef != null) {
                reportDef.setReportParams(DigesterUtil.convertXmlToReportParams(reportDef.getReportDefinitionXml()));
            }
        }
        catch (Exception e) {
            this.LOG.warn("getReportDefinition(): unable to parse report parameters.");
        }
        return reportDef;
    }

    public boolean saveReportDefinition(final ReportDef reportDef) {
        if (reportDef.getSiteId() == null && !this.M_sa.isSiteStatsAdminPage()) {
            return false;
        }
        boolean isNew = reportDef.getId() == 0L;
        try {
            if (reportDef.getCreatedBy() == null) {
                reportDef.setCreatedBy(this.M_uds.getCurrentUser().getId());
            }
            if (reportDef.getCreatedOn() == null) {
                reportDef.setCreatedOn(new Date());
            }
            if (reportDef.getModifiedBy() == null) {
                reportDef.setModifiedBy(this.M_uds.getCurrentUser().getId());
            }
            if (reportDef.getModifiedOn() == null) {
                reportDef.setModifiedOn(new Date());
            }
            ReportParams params = reportDef.getReportParams();
            boolean isResourcesReport = params.getWhat().equals("what-resources");
            boolean isResourceEvent = false;
            for (String eventId : params.getWhatEventIds()) {
                if (!eventId.equals("new") && !eventId.equals("read") && !eventId.equals("revise") && !eventId.equals("delete")) continue;
                isResourceEvent = true;
            }
            if (!isResourcesReport && !isResourceEvent) {
                params.setWhatResourceAction(null);
            } else {
                params.setWhatToolIds(Arrays.asList("sakai.resources"));
            }
            reportDef.setReportDefinitionXml(DigesterUtil.convertReportParamsToXml(params));
        }
        catch (Exception e) {
            this.LOG.warn("saveReportDefinition(): unable to generate xml string from report parameters.", (Throwable)e);
            return false;
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Transaction tx = null;
                try {
                    tx = session.beginTransaction();
                    session.saveOrUpdate((Object)reportDef);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    ReportManagerImpl.this.LOG.warn("Unable to commit transaction: ", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        Boolean success = (Boolean)this.getHibernateTemplate().execute(hcb);
        if (success.booleanValue()) {
            String siteId = reportDef.getSiteId();
            if (siteId == null) {
                siteId = reportDef.getReportParams().getSiteId();
            }
            this.M_sm.logEvent((Object)reportDef, isNew ? "new" : "edit", siteId, false);
        }
        return success;
    }

    public boolean removeReportDefinition(final ReportDef reportDef) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Transaction tx = null;
                try {
                    tx = session.beginTransaction();
                    session.delete((Object)reportDef);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    ReportManagerImpl.this.LOG.warn("Unable to commit transaction: ", (Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        Boolean success = (Boolean)this.getHibernateTemplate().execute(hcb);
        if (success.booleanValue()) {
            String siteId = reportDef.getSiteId();
            if (siteId == null) {
                siteId = reportDef.getReportParams().getSiteId();
            }
            this.M_sm.logEvent((Object)reportDef, "delete", siteId, false);
        }
        return success;
    }

    public List<ReportDef> getReportDefinitions(final String siteId, final boolean includedPredefined, final boolean includeHidden) {
        List reportDefs = null;
        KeyReportDefList key = new KeyReportDefList(siteId, includedPredefined, includeHidden);
        Object cached = this.cacheReportDef.get((Object)key.toString());
        if (cached != null) {
            reportDefs = (List)cached;
            this.LOG.debug("Getting report list from cache for site " + siteId);
        } else {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Criteria c = session.createCriteria(ReportDef.class);
                    if (siteId != null) {
                        if (includedPredefined) {
                            c.add((Criterion)Expression.or((Criterion)Expression.eq((String)"siteId", (Object)siteId), (Criterion)Expression.isNull((String)"siteId")));
                        } else {
                            c.add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
                        }
                    } else {
                        c.add(Expression.isNull((String)"siteId"));
                    }
                    if (!includeHidden) {
                        c.add((Criterion)Expression.eq((String)"hidden", (Object)false));
                    }
                    return c.list();
                }
            };
            Object o = this.getHibernateTemplate().execute(hcb);
            if (o != null) {
                reportDefs = (List)o;
                for (ReportDef reportDef : reportDefs) {
                    try {
                        reportDef.setReportParams(DigesterUtil.convertXmlToReportParams(reportDef.getReportDefinitionXml()));
                    }
                    catch (Exception e) {
                        this.LOG.warn("getReportDefinition(): unable to parse report parameters.");
                        reportDef.setReportParams(null);
                    }
                }
                this.cacheReportDef.put((Object)key.toString(), (Object)reportDefs);
            }
        }
        return reportDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getReportAsExcel(Report report, String sheetName) {
        List statsObjects = report.getReportData();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(WorkbookUtil.createSafeSheetName((String)sheetName));
        HSSFRow headerRow = sheet.createRow(0);
        int ix = 0;
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "site")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_site"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "user")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_id"));
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_user"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "tool")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_tool"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "event")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_event"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_resource"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource-action")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_action"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "date") || this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "month") || this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "year")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_date"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "last-date")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_lastdate"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "total")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_total"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "visits")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_visits"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "unique-visits")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_uniquevisitors"));
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "duration")) {
            headerRow.createCell(ix++).setCellValue(msgs.getString("th_duration") + " (" + msgs.getString("minutes_abbr") + ")");
        }
        Iterator i = statsObjects.iterator();
        while (i.hasNext()) {
            SiteVisits sv;
            ResourceStat rs;
            EventStat es;
            HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
            Stat se = (Stat)i.next();
            ix = 0;
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "site")) {
                try {
                    Site site = this.M_ss.getSite(se.getSiteId());
                    row.createCell(ix++).setCellValue(site.getTitle());
                }
                catch (IdUnusedException e) {
                    this.logger.debug((Object)("can't find site with id: " + se.getSiteId()));
                    row.createCell(ix++).setCellValue(se.getSiteId().toString());
                }
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "user")) {
                String userId = se.getUserId();
                String userEid = null;
                String userName = null;
                if (userId != null) {
                    if ("-".equals(userId)) {
                        userEid = "-";
                        userName = msgs.getString("user_anonymous");
                    } else if ("?".equals(userId)) {
                        userEid = "-";
                        userName = msgs.getString("user_anonymous_access");
                    } else {
                        try {
                            User user = this.M_uds.getUser(userId);
                            userEid = user.getDisplayId();
                            userName = this.M_sm.getUserNameForDisplay(user);
                        }
                        catch (UserNotDefinedException e1) {
                            userEid = userId;
                            userName = msgs.getString("user_unknown");
                        }
                    }
                } else {
                    userName = msgs.getString("user_unknown");
                }
                row.createCell(ix++).setCellValue(userEid);
                row.createCell(ix++).setCellValue(userName);
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "tool")) {
                es = (EventStat)se;
                row.createCell(ix++).setCellValue(this.M_ers.getToolName(es.getToolId()));
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "event")) {
                es = (EventStat)se;
                row.createCell(ix++).setCellValue(this.M_ers.getEventName(es.getEventId()));
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource")) {
                rs = (ResourceStat)se;
                row.createCell(ix++).setCellValue(rs.getResourceRef());
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource-action")) {
                rs = (ResourceStat)se;
                row.createCell(ix++).setCellValue(rs.getResourceAction());
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "date")) {
                row.createCell(ix++).setCellValue(se.getDate().toString());
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "month")) {
                row.createCell(ix++).setCellValue(this.dateMonthFrmt.format(se.getDate()));
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "year")) {
                row.createCell(ix++).setCellValue(this.dateYearFrmt.format(se.getDate()));
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "last-date")) {
                row.createCell(ix++).setCellValue(se.getDate().toString());
            }
            if (report.getReportDefinition().getReportParams().getSiteId() == null || !"".equals(report.getReportDefinition().getReportParams().getSiteId())) {
                // empty if block
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "total")) {
                row.createCell(ix++).setCellValue((double)se.getCount());
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "visits")) {
                sv = (SiteVisits)se;
                row.createCell(ix++).setCellValue((double)sv.getTotalVisits());
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "unique-visits")) {
                sv = (SiteVisits)se;
                row.createCell(ix++).setCellValue((double)sv.getTotalUnique());
            }
            if (!this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "duration")) continue;
            SitePresence ss = (SitePresence)se;
            double durationInMin = ss.getDuration() == 0L ? 0.0 : Util.round((double)((double)ss.getDuration() / 1000.0 / 60.0), (int)1);
            row.createCell(ix++).setCellValue(durationInMin);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            wb.write((OutputStream)baos);
        }
        catch (IOException e) {
            this.LOG.error("Error writing Excel bytes from SiteStats report", (Throwable)e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (baos != null) {
            return baos.toByteArray();
        }
        return new byte[0];
    }

    public String getReportAsCsv(Report report) {
        List statsObjects = report.getReportData();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "site")) {
            this.appendQuoted(sb, msgs.getString("th_site"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "user")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_id"));
            sb.append(",");
            this.appendQuoted(sb, msgs.getString("th_user"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "tool")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_tool"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "event")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_event"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_resource"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource-action")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_action"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "date") || this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "month") || this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "year")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_date"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "last-date")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_lastdate"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "total")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_total"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "visits")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_visits"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "unique-visits")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_uniquevisitors"));
            isFirst = false;
        }
        if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "duration")) {
            if (!isFirst) {
                sb.append(",");
            }
            this.appendQuoted(sb, msgs.getString("th_duration") + " (" + msgs.getString("minutes_abbr") + ")");
            isFirst = false;
        }
        sb.append("\n");
        for (Stat se : statsObjects) {
            SiteVisits sv;
            ResourceStat rs;
            EventStat es;
            isFirst = true;
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "site")) {
                try {
                    Site site = this.M_ss.getSite(se.getSiteId());
                    this.appendQuoted(sb, site.getTitle());
                }
                catch (IdUnusedException e) {
                    this.logger.debug((Object)("can't find site with id: " + se.getSiteId()));
                    this.appendQuoted(sb, se.getSiteId());
                }
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "user")) {
                if (!isFirst) {
                    sb.append(",");
                }
                String userId = se.getUserId();
                String userEid = null;
                String userName = null;
                if (userId != null) {
                    if ("-".equals(userId)) {
                        userEid = "-";
                        userName = msgs.getString("user_anonymous");
                    } else if ("?".equals(userId)) {
                        userEid = "-";
                        userName = msgs.getString("user_anonymous_access");
                    } else {
                        try {
                            User user = this.M_uds.getUser(userId);
                            userEid = user.getDisplayId();
                            userName = this.M_sm.getUserNameForDisplay(user);
                        }
                        catch (UserNotDefinedException e1) {
                            userEid = userId;
                            userName = msgs.getString("user_unknown");
                        }
                    }
                } else {
                    userEid = "-";
                    userName = msgs.getString("user_unknown");
                }
                this.appendQuoted(sb, userEid);
                sb.append(",");
                this.appendQuoted(sb, userName);
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "tool")) {
                if (!isFirst) {
                    sb.append(",");
                }
                es = (EventStat)se;
                this.appendQuoted(sb, this.M_ers.getToolName(es.getToolId()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "event")) {
                if (!isFirst) {
                    sb.append(",");
                }
                es = (EventStat)se;
                this.appendQuoted(sb, this.M_ers.getEventName(es.getEventId()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource")) {
                if (!isFirst) {
                    sb.append(",");
                }
                rs = (ResourceStat)se;
                this.appendQuoted(sb, rs.getResourceRef());
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "resource-action")) {
                if (!isFirst) {
                    sb.append(",");
                }
                rs = (ResourceStat)se;
                this.appendQuoted(sb, rs.getResourceAction());
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "date")) {
                if (!isFirst) {
                    sb.append(",");
                }
                this.appendQuoted(sb, se.getDate().toString());
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "month")) {
                if (!isFirst) {
                    sb.append(",");
                }
                this.appendQuoted(sb, this.dateMonthFrmt.format(se.getDate()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "year")) {
                if (!isFirst) {
                    sb.append(",");
                }
                this.appendQuoted(sb, this.dateYearFrmt.format(se.getDate()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "last-date")) {
                if (!isFirst) {
                    sb.append(",");
                }
                this.appendQuoted(sb, se.getDate().toString());
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "total")) {
                if (!isFirst) {
                    sb.append(",");
                }
                this.appendQuoted(sb, Long.toString(se.getCount()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "visits")) {
                if (!isFirst) {
                    sb.append(",");
                }
                sv = (SiteVisits)se;
                this.appendQuoted(sb, Long.toString(sv.getTotalVisits()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "unique-visits")) {
                if (!isFirst) {
                    sb.append(",");
                }
                sv = (SiteVisits)se;
                this.appendQuoted(sb, Long.toString(sv.getTotalUnique()));
                isFirst = false;
            }
            if (this.isReportColumnAvailable(report.getReportDefinition().getReportParams(), "duration")) {
                SitePresence ss;
                if (!isFirst) {
                    sb.append(",");
                }
                double durationInMin = (ss = (SitePresence)se).getDuration() == 0L ? 0.0 : Util.round((double)((double)ss.getDuration() / 1000.0 / 60.0), (int)1);
                this.appendQuoted(sb, Double.toString(durationInMin));
                isFirst = false;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getReportAsPDF(Report report) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            this.fopFactory.setURIResolver((URIResolver)new LibraryURIResolver());
            FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
            Fop fop = this.fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            if (this.cachedXmlFoXSLT == null) {
                ClassPathResource xsltCPR = new ClassPathResource("org/sakaiproject/sitestats/config/fop/xmlReportToFo.xsl");
                InputStream xslt = xsltCPR.getInputStream();
                TransformerFactory factory = TransformerFactory.newInstance();
                this.cachedXmlFoXSLT = factory.newTemplates(new StreamSource(xslt));
            }
            Transformer transformer = this.cachedXmlFoXSLT.newTransformer();
            SAXSource src = new SAXSource(new ReportXMLReader(), new ReportInputSource(report));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (TransformerConfigurationException e) {
            this.LOG.error("TransformerConfigurationException while writing SiteStats PDF report", (Throwable)e);
        }
        catch (FOPException e) {
            this.LOG.error("FOPException while writing SiteStats PDF report", (Throwable)e);
        }
        catch (TransformerException e) {
            this.LOG.error("TransformerException while writing SiteStats PDF report", (Throwable)e);
        }
        catch (Exception e) {
            this.LOG.error("Exception while generating SiteStats PDF report", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    return out.toByteArray();
                }
            }
            catch (IOException e) {
                this.LOG.error("IOException while writing SiteStats PDF report", (Throwable)e);
            }
        }
        return null;
    }

    private Report consolidateAnonymousEvents(Report report) {
        ArrayList<Stat> consolidated = new ArrayList<Stat>();
        List list = report.getReportData();
        HashMap<String, Stat> anonMap = new HashMap<String, Stat>();
        for (Stat s : list) {
            if (!(s instanceof EventStat)) continue;
            EventStat es = (EventStat)s;
            String eventId = es.getEventId();
            if (!this.isAnonymousEvent(eventId)) {
                consolidated.add(s);
                continue;
            }
            Stat sMapped = (Stat)anonMap.get(eventId);
            if (sMapped != null) {
                sMapped.setCount(sMapped.getCount() + s.getCount());
                if (s.getDate().after(sMapped.getDate())) {
                    sMapped.setDate(s.getDate());
                }
                anonMap.put(eventId, sMapped);
                continue;
            }
            s.setUserId(null);
            anonMap.put(eventId, s);
        }
        for (Stat s : anonMap.values()) {
            consolidated.add(s);
        }
        report.setReportData(consolidated);
        return report;
    }

    private boolean isAnonymousEvent(String eventId) {
        for (ToolInfo ti : this.M_ers.getEventRegistry()) {
            for (EventInfo ei : ti.getEvents()) {
                if (!ei.getEventId().equals(eventId)) continue;
                return ei.isAnonymous();
            }
        }
        return false;
    }

    private StringBuilder appendQuoted(StringBuilder sb, String toQuote) {
        if (toQuote.indexOf(44) >= 0 || toQuote.indexOf(34) >= 0) {
            String out = toQuote.replaceAll("\"", "\"\"");
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Turning '" + toQuote + "' to '" + out + "'");
            }
            sb.append("\"").append(out).append("\"");
        } else {
            sb.append(toQuote);
        }
        return sb;
    }

    private String getUserDisplayId(String userId) {
        String userEid = null;
        if (userId != null) {
            if ("-".equals(userId) || "?".equals(userId)) {
                userEid = "-";
            } else {
                try {
                    userEid = this.M_uds.getUser(userId).getDisplayId();
                }
                catch (UserNotDefinedException e1) {
                    userEid = userId;
                }
            }
        } else {
            userEid = msgs.getString("user_unknown");
        }
        return userEid;
    }

    private String getUserDisplayName(String userId) {
        String userName = null;
        userName = userId != null ? ("-".equals(userId) ? msgs.getString("user_anonymous") : ("?".equals(userId) ? msgs.getString("user_anonymous_access") : this.M_sm.getUserNameForDisplay(userId))) : msgs.getString("user_unknown");
        return userName;
    }

    public String getSiteGroupTitle(String groupId) {
        try {
            Placement placement = this.M_tm.getCurrentPlacement();
            Site site = this.M_ss.getSite(placement.getContext());
            return site.getGroup(groupId).getTitle();
        }
        catch (IdUnusedException e) {
            this.LOG.warn("ReportManager: unable to get group title with id: " + groupId);
            return null;
        }
    }

    private static class KeyReportDefList {
        public String siteId;
        public boolean includedPredefined;
        public boolean includeHidden;

        public KeyReportDefList(String siteId, boolean includedPredefined, boolean includeHidden) {
            this.siteId = siteId;
            this.includedPredefined = includedPredefined;
            this.includeHidden = includeHidden;
        }

        public boolean equals(Object o) {
            if (o instanceof KeyReportDefList) {
                KeyReportDefList u = (KeyReportDefList)o;
                return (this.siteId == null && u.siteId == null || this.siteId != null && this.siteId.equals(u.siteId)) && this.includedPredefined == u.includedPredefined && this.includeHidden == u.includeHidden;
            }
            return false;
        }

        public int hashCode() {
            return (this.siteId != null ? this.siteId.hashCode() : 0) + (this.includedPredefined ? 1 : 0) + (this.includeHidden ? 1 : 0);
        }

        public String toString() {
            return this.siteId + ",p:" + this.includedPredefined + ",h:" + this.includeHidden;
        }
    }

    class ReportFormattedParamsImpl
    implements ReportFormattedParams {
        ReportFormattedParamsImpl() {
        }

        public String getReportSite(Report report) {
            String site = report.getReportDefinition().getReportParams().getSiteId();
            if (site != null) {
                return ReportManagerImpl.this.M_ss.getSiteDisplay(site);
            }
            return msgs.getString("report_reportsite_all");
        }

        public String getReportTitle(Report report) {
            String title = report.getReportDefinition().getTitle();
            if (title != null && title.length() != 0) {
                if (this.isStringLocalized(title)) {
                    return msgs.getString(report.getReportDefinition().getTitleBundleKey());
                }
                return title;
            }
            return null;
        }

        public String getReportDescription(Report report) {
            String description = report.getReportDefinition().getDescription();
            if (description != null && description.length() != 0) {
                if (this.isStringLocalized(description)) {
                    return msgs.getString(report.getReportDefinition().getDescriptionBundleKey());
                }
                return description;
            }
            return null;
        }

        public boolean isStringLocalized(String string) {
            return string.startsWith("${") && string.endsWith("}");
        }

        public String getReportGenerationDate(Report report) {
            if (report.getReportGenerationDate() == null) {
                report.setReportGenerationDate(new Date());
            }
            return report.getLocalizedReportGenerationDate();
        }

        public String getReportActivityBasedOn(Report report) {
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-visits") || report.getReportDefinition().getReportParams().getWhat().equals("what-visits-totals")) {
                return msgs.getString("report_what_visits");
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-presences")) {
                return msgs.getString("report_what_presences");
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-events") || report.getReportDefinition().getReportParams().getWhat().equals("what-activity-totals")) {
                StringBuilder buff = new StringBuilder();
                buff.append(msgs.getString("report_what_events"));
                String eventSelType = report.getReportDefinition().getReportParams().getWhatEventSelType();
                if (eventSelType != null) {
                    if (eventSelType.equals("what-events-bytool")) {
                        buff.append(" (");
                        buff.append(msgs.getString("report_what_events_bytool"));
                        buff.append(")");
                    } else {
                        buff.append(" (");
                        buff.append(msgs.getString("report_what_events_byevent"));
                        buff.append(")");
                    }
                }
                return buff.toString();
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-resources")) {
                return msgs.getString("report_what_resources");
            }
            return msgs.getString("report_what_events");
        }

        public String getReportActivitySelectionTitle(Report report) {
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-visits")) {
                return msgs.getString("report_what_visits");
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-presences")) {
                return msgs.getString("report_what_presences");
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-events")) {
                if (report.getReportDefinition().getReportParams().getWhatEventSelType().equals("what-events-bytool")) {
                    return msgs.getString("reportres_summ_act_tools_selected");
                }
                return msgs.getString("reportres_summ_act_events_selected");
            }
            return msgs.getString("reportres_summ_act_rsrc_selected");
        }

        public String getReportActivitySelection(Report report) {
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-visits") || report.getReportDefinition().getReportParams().getWhat().equals("what-presences")) {
                return null;
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-events")) {
                if (report.getReportDefinition().getReportParams().getWhatEventSelType().equals("what-events-bytool")) {
                    List list = report.getReportDefinition().getReportParams().getWhatToolIds();
                    int listSize = list.size();
                    StringBuilder buff = new StringBuilder();
                    if (listSize > 0) {
                        for (int i = 0; i < listSize - 1; ++i) {
                            String toolId = (String)list.get(i);
                            buff.append(ReportManagerImpl.this.M_ers.getToolName(toolId));
                            buff.append(", ");
                        }
                        String toolId = (String)list.get(listSize - 1);
                        buff.append(ReportManagerImpl.this.M_ers.getToolName(toolId));
                    }
                    return buff.toString();
                }
                List list = report.getReportDefinition().getReportParams().getWhatEventIds();
                int listSize = list.size();
                StringBuilder buff = new StringBuilder();
                if (listSize > 0) {
                    for (int i = 0; i < listSize - 1; ++i) {
                        String eventId = (String)list.get(i);
                        buff.append(ReportManagerImpl.this.M_ers.getEventName(eventId));
                        buff.append(", ");
                    }
                    String eventId = (String)list.get(listSize - 1);
                    buff.append(ReportManagerImpl.this.M_ers.getEventName(eventId));
                }
                return buff.toString();
            }
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-resources")) {
                List list = report.getReportDefinition().getReportParams().getWhatResourceIds();
                if (report.getReportDefinition().getReportParams().getWhatResourceIds() == null || report.getReportDefinition().getReportParams().getWhatResourceIds().size() == 0) {
                    return null;
                }
                if (list.contains("all")) {
                    return msgs.getString("report_what_all");
                }
                StringBuilder buff = new StringBuilder();
                String siteId = report.getReportDefinition().getReportParams().getSiteId();
                String resourcesCollectionId = ReportManagerImpl.this.M_chs.getSiteCollection(siteId);
                String dropboxCollectionId = ReportManagerImpl.this.M_chs.getDropboxCollection(siteId);
                String attachmentsCollectionId = resourcesCollectionId.replaceFirst("/group/", "/attachment/");
                for (int i = 0; i < list.size(); ++i) {
                    String resourceId = (String)list.get(i);
                    try {
                        if (resourceId.endsWith("/")) {
                            String ccName;
                            ContentCollection cc;
                            if ("/group/".equals(resourceId) || resourceId.equals(resourcesCollectionId)) {
                                buff.append(ReportManagerImpl.this.M_tm.getTool("sakai.resources").getTitle());
                            } else if ("/group-user/".equals(resourceId) || resourceId.equals(dropboxCollectionId)) {
                                buff.append(ReportManagerImpl.this.M_tm.getTool("sakai.dropbox").getTitle());
                            } else if (resourceId.startsWith(dropboxCollectionId)) {
                                buff.append(ReportManagerImpl.this.M_tm.getTool("sakai.dropbox").getTitle());
                                buff.append(": ");
                                cc = ReportManagerImpl.this.M_chs.getCollection(resourceId);
                                ccName = cc.getProperties().getProperty("DAV:displayname");
                                buff.append(ccName);
                            } else if ("/attachment/".equals(resourceId) || resourceId.equals(attachmentsCollectionId)) {
                                buff.append(msgs.getString("report_content_attachments"));
                            } else if (resourceId.startsWith(attachmentsCollectionId)) {
                                buff.append(msgs.getString("report_content_attachments"));
                                buff.append(": ");
                                cc = ReportManagerImpl.this.M_chs.getCollection(resourceId);
                                ccName = cc.getProperties().getProperty("DAV:displayname");
                                buff.append(ccName);
                            } else {
                                cc = ReportManagerImpl.this.M_chs.getCollection(resourceId);
                                ccName = cc.getProperties().getProperty("DAV:displayname");
                                buff.append(ccName);
                            }
                        } else {
                            ContentResource cr = ReportManagerImpl.this.M_chs.getResource(resourceId);
                            String crName = cr.getProperties().getProperty("DAV:displayname");
                            buff.append(crName);
                        }
                        if (list.size() <= 1 || i == list.size() - 1) continue;
                        buff.append(", ");
                        continue;
                    }
                    catch (PermissionException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IdUnusedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (TypeException e) {
                        e.printStackTrace();
                    }
                }
                return buff.toString();
            }
            return null;
        }

        public String getReportResourceActionTitle(Report report) {
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-resources") && report.getReportDefinition().getReportParams().getWhatResourceAction() != null) {
                return msgs.getString("reportres_summ_act_rsrc_action");
            }
            return null;
        }

        public String getReportResourceAction(Report report) {
            if (report.getReportDefinition().getReportParams().getWhat().equals("what-resources") && report.getReportDefinition().getReportParams().getWhatResourceAction() != null) {
                return msgs.getString("action_" + report.getReportDefinition().getReportParams().getWhatResourceAction());
            }
            return null;
        }

        public String getReportTimePeriod(Report report) {
            if (report.getReportDefinition().getReportParams().getWhen().equals("when-all")) {
                return msgs.getString("report_when_all");
            }
            Time from = ReportManagerImpl.this.M_ts.newTime(report.getReportDefinition().getReportParams().getWhenFrom().getTime());
            Time to = ReportManagerImpl.this.M_ts.newTime(report.getReportDefinition().getReportParams().getWhenTo().getTime());
            return from.toStringLocalFull() + " - " + to.toStringLocalFull();
        }

        public String getReportUserSelectionType(Report report) {
            if (report.getReportDefinition().getReportParams().getWho().equals("who-all")) {
                return msgs.getString("report_who_all");
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-groups")) {
                return msgs.getString("report_who_group");
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-role")) {
                return msgs.getString("report_who_role");
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-custom")) {
                return msgs.getString("report_who_custom");
            }
            return msgs.getString("report_who_not_match");
        }

        public String getReportUserSelectionTitle(Report report) {
            if (report.getReportDefinition().getReportParams().getWho().equals("who-all")) {
                return null;
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-groups")) {
                return msgs.getString("reportres_summ_usr_group_selected");
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-role")) {
                return msgs.getString("reportres_summ_usr_role_selected");
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-custom")) {
                return msgs.getString("reportres_summ_usr_users_selected");
            }
            return null;
        }

        public String getReportUserSelection(Report report) {
            if (report.getReportDefinition().getReportParams().getWho().equals("who-groups")) {
                return ReportManagerImpl.this.getSiteGroupTitle(report.getReportDefinition().getReportParams().getWhoGroupId());
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-role")) {
                return report.getReportDefinition().getReportParams().getWhoRoleId();
            }
            if (report.getReportDefinition().getReportParams().getWho().equals("who-custom")) {
                List list = report.getReportDefinition().getReportParams().getWhoUserIds();
                StringBuilder buff = new StringBuilder();
                for (int i = 0; i < list.size() - 1; ++i) {
                    String userId = (String)list.get(i);
                    buff.append(ReportManagerImpl.this.getUserDisplayId(userId));
                    buff.append(", ");
                }
                String userId = (String)list.get(list.size() - 1);
                buff.append(ReportManagerImpl.this.getUserDisplayId(userId));
                return buff.toString();
            }
            return null;
        }
    }

    private static class ReportProcessedParams {
        public String siteId;
        public List<String> events;
        public List<String> anonymousEvents;
        public List<String> resourceIds;
        public String resourceAction;
        public Date iDate;
        public Date fDate;
        public List<String> userIds;
        public List<String> totalsBy;
        public boolean inverseUserSelection;
        public PagingPosition page;
        public String sortBy;
        public boolean sortAscending;
        public int maxResults;

        private ReportProcessedParams() {
        }
    }
}

