/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBHelper
extends HibernateDaoSupport {
    private static Log LOG = LogFactory.getLog(DBHelper.class);
    private boolean autoDdl = false;
    private String dbVendor = null;
    private boolean notifiedIndexesUpdate = false;

    public void init() {
        this.dbVendor = this.getDbVendor();
        this.autoDdl = this.getAutoDdl();
        if (this.autoDdl) {
            // empty if block
        }
    }

    public void preloadDefaultReports() {
        HibernateCallback hcb = new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection c = null;
                InputStreamReader isr = null;
                BufferedReader br = null;
                try {
                    ClassPathResource defaultReports = new ClassPathResource(DBHelper.this.dbVendor + "/default_reports.sql");
                    LOG.info((Object)"init(): - preloading sitestats default reports");
                    isr = new InputStreamReader(defaultReports.getInputStream());
                    br = new BufferedReader(isr);
                    c = session.connection();
                    String sqlLine = null;
                    while ((sqlLine = br.readLine()) != null) {
                        if ((sqlLine = sqlLine.trim()).equals("") || sqlLine.startsWith("--")) continue;
                        if (sqlLine.endsWith(";")) {
                            sqlLine = sqlLine.substring(0, sqlLine.indexOf(";"));
                        }
                        Statement st = null;
                        try {
                            st = c.createStatement();
                            st.execute(sqlLine);
                        }
                        catch (SQLException e) {
                            if ("23000".equals(e.getSQLState())) continue;
                            LOG.warn((Object)("Failed to preload default report: " + sqlLine), (Throwable)e);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Failed to preload default report: " + sqlLine), (Throwable)e);
                        }
                        finally {
                            if (st == null) continue;
                            st.close();
                        }
                    }
                }
                catch (HibernateException e) {
                    LOG.error((Object)"Error while preloading default reports", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while preloading default reports", (Throwable)e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {}
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {}
                    }
                    if (c != null) {
                        c.close();
                    }
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    public void updateIndexes() {
        if (!this.dbVendor.equals("mysql") && !this.dbVendor.equals("oracle")) {
            return;
        }
        this.notifiedIndexesUpdate = false;
        HibernateCallback hcb = new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection c = null;
                try {
                    c = session.connection();
                    List sstEventsIxs = DBHelper.this.listIndexes(c, "SST_EVENTS");
                    List sstResourcesIxs = DBHelper.this.listIndexes(c, "SST_RESOURCES");
                    List sstSiteActivityIxs = DBHelper.this.listIndexes(c, "SST_SITEACTIVITY");
                    List sstSiteVisitsIxs = DBHelper.this.listIndexes(c, "SST_SITEVISITS");
                    List sstReportsIxs = DBHelper.this.listIndexes(c, "SST_REPORTS");
                    if (sstEventsIxs.contains("SITE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "SITE_ID_IX", "SST_EVENTS_SITE_ID_IX", "SITE_ID", "SST_EVENTS");
                    } else if (!sstEventsIxs.contains("SST_EVENTS_SITE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_EVENTS_SITE_ID_IX", "SITE_ID", "SST_EVENTS");
                    }
                    if (sstEventsIxs.contains("USER_ID_IX")) {
                        DBHelper.this.renameIndex(c, "USER_ID_IX", "SST_EVENTS_USER_ID_IX", "USER_ID", "SST_EVENTS");
                    } else if (!sstEventsIxs.contains("SST_EVENTS_USER_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_EVENTS_USER_ID_IX", "USER_ID", "SST_EVENTS");
                    }
                    if (sstEventsIxs.contains("EVENT_ID_IX")) {
                        DBHelper.this.renameIndex(c, "EVENT_ID_IX", "SST_EVENTS_EVENT_ID_IX", "EVENT_ID", "SST_EVENTS");
                    } else if (!sstEventsIxs.contains("SST_EVENTS_EVENT_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_EVENTS_EVENT_ID_IX", "EVENT_ID", "SST_EVENTS");
                    }
                    if (sstEventsIxs.contains("DATE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "DATE_ID_IX", "SST_EVENTS_DATE_ID_IX", "EVENT_DATE", "SST_EVENTS");
                    } else if (!sstEventsIxs.contains("SST_EVENTS_DATE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_EVENTS_DATE_ID_IX", "EVENT_DATE", "SST_EVENTS");
                    }
                    if (sstResourcesIxs.contains("SITE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "SITE_ID_IX", "SST_RESOURCES_SITE_ID_IX", "SITE_ID", "SST_RESOURCES");
                    } else if (!sstResourcesIxs.contains("SST_RESOURCES_SITE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_RESOURCES_SITE_ID_IX", "SITE_ID", "SST_RESOURCES");
                    }
                    if (sstResourcesIxs.contains("USER_ID_IX")) {
                        DBHelper.this.renameIndex(c, "USER_ID_IX", "SST_RESOURCES_USER_ID_IX", "USER_ID", "SST_RESOURCES");
                    } else if (!sstResourcesIxs.contains("SST_RESOURCES_USER_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_RESOURCES_USER_ID_IX", "USER_ID", "SST_RESOURCES");
                    }
                    if (sstResourcesIxs.contains("RES_ACT_IDX")) {
                        DBHelper.this.renameIndex(c, "RES_ACT_IDX", "SST_RESOURCES_RES_ACT_IDX", "RESOURCE_ACTION", "SST_RESOURCES");
                    } else if (!sstResourcesIxs.contains("SST_RESOURCES_RES_ACT_IDX")) {
                        DBHelper.this.createIndex(c, "SST_RESOURCES_RES_ACT_IDX", "RESOURCE_ACTION", "SST_RESOURCES");
                    }
                    if (sstResourcesIxs.contains("DATE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "DATE_ID_IX", "SST_RESOURCES_DATE_ID_IX", "RESOURCE_DATE", "SST_RESOURCES");
                    } else if (!sstResourcesIxs.contains("SST_RESOURCES_DATE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_RESOURCES_DATE_ID_IX", "RESOURCE_DATE", "SST_RESOURCES");
                    }
                    if (sstSiteActivityIxs.contains("SITE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "SITE_ID_IX", "SST_SITEACTIVITY_SITE_ID_IX", "SITE_ID", "SST_SITEACTIVITY");
                    } else if (!sstSiteActivityIxs.contains("SST_SITEACTIVITY_SITE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_SITEACTIVITY_SITE_ID_IX", "SITE_ID", "SST_SITEACTIVITY");
                    }
                    if (sstSiteActivityIxs.contains("EVENT_ID_IX")) {
                        DBHelper.this.renameIndex(c, "EVENT_ID_IX", "SST_SITEACTIVITY_EVENT_ID_IX", "EVENT_ID", "SST_SITEACTIVITY");
                    } else if (!sstSiteActivityIxs.contains("SST_SITEACTIVITY_EVENT_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_SITEACTIVITY_EVENT_ID_IX", "EVENT_ID", "SST_SITEACTIVITY");
                    }
                    if (sstSiteActivityIxs.contains("DATE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "DATE_ID_IX", "SST_SITEACTIVITY_DATE_ID_IX", "ACTIVITY_DATE", "SST_SITEACTIVITY");
                    } else if (!sstSiteActivityIxs.contains("SST_SITEACTIVITY_DATE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_SITEACTIVITY_DATE_ID_IX", "ACTIVITY_DATE", "SST_SITEACTIVITY");
                    }
                    if (sstSiteVisitsIxs.contains("SITE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "SITE_ID_IX", "SST_SITEVISITS_SITE_ID_IX", "SITE_ID", "SST_SITEVISITS");
                    } else if (!sstSiteVisitsIxs.contains("SST_SITEVISITS_SITE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_SITEVISITS_SITE_ID_IX", "SITE_ID", "SST_SITEVISITS");
                    }
                    if (sstSiteVisitsIxs.contains("DATE_ID_IX")) {
                        DBHelper.this.renameIndex(c, "DATE_ID_IX", "SST_SITEVISITS_DATE_ID_IX", "VISITS_DATE", "SST_SITEVISITS");
                    } else if (!sstSiteVisitsIxs.contains("SST_SITEVISITS_DATE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_SITEVISITS_DATE_ID_IX", "VISITS_DATE", "SST_SITEVISITS");
                    }
                    if (!sstReportsIxs.contains("SST_REPORTS_SITE_ID_IX")) {
                        DBHelper.this.createIndex(c, "SST_REPORTS_SITE_ID_IX", "SITE_ID", "SST_REPORTS");
                    }
                }
                catch (HibernateException e) {
                    LOG.error((Object)"Error while updating indexes", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while updating indexes", (Throwable)e);
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    private void notifyIndexesUpdate() {
        if (!this.notifiedIndexesUpdate) {
            LOG.info((Object)"init(): updating indexes on SiteStats tables...");
        }
        this.notifiedIndexesUpdate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listIndexes(Connection c, String table) throws SQLException {
        ArrayList<String> indexes = new ArrayList<String>();
        String sql = null;
        int pos = 1;
        if (this.dbVendor.equals("mysql")) {
            sql = "show indexes from " + table;
            pos = 3;
        } else if (this.dbVendor.equals("oracle")) {
            sql = "select * from all_indexes where table_name = '" + table + "'";
            pos = 2;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = c.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                String ixName = rs.getString(pos);
                indexes.add(ixName);
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to execute sql: " + sql), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(Connection c, String index, String field, String table) throws SQLException {
        this.notifyIndexesUpdate();
        String sql = "create index " + index + " on " + table + "(" + field + ")";
        Statement st = null;
        try {
            st = c.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to execute sql: " + sql), (Throwable)e);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameIndex(Connection c, String oldIndex, String newIndex, String field, String table) throws SQLException {
        String sql = null;
        this.notifyIndexesUpdate();
        if (this.dbVendor.equals("mysql")) {
            sql = "ALTER TABLE " + table + " DROP INDEX " + oldIndex + ", ADD INDEX " + newIndex + " USING BTREE(" + field + ")";
        } else if (this.dbVendor.equals("oracle")) {
            sql = "ALTER INDEX " + oldIndex + " RENAME TO " + newIndex;
        }
        Statement st = null;
        try {
            st = c.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to execute sql: " + sql), (Throwable)e);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private String getDbVendor() {
        String dialectStr = null;
        dialectStr = ServerConfigurationService.getString((String)"sitestats.db", (String)"internal").equals("internal") ? ServerConfigurationService.getString((String)"hibernate.dialect", (String)"org.hibernate.dialect.HSQLDialect") : ServerConfigurationService.getString((String)"sitestats.externalDb.hibernate.dialect", (String)"org.hibernate.dialect.HSQLDialect");
        if (dialectStr.toLowerCase().contains("mysql")) {
            return "mysql";
        }
        if (dialectStr.toLowerCase().contains("oracle")) {
            return "oracle";
        }
        return "hsql";
    }

    public boolean getAutoDdl() {
        boolean autoDdl = false;
        autoDdl = ServerConfigurationService.getString((String)"sitestats.db", (String)"internal").equals("internal") ? ServerConfigurationService.getBoolean((String)"auto.ddl", (boolean)true) : ServerConfigurationService.getBoolean((String)"sitestats.externalDb.auto.ddl", (boolean)true);
        return autoDdl;
    }
}

