/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.SortOrder;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.EventStat;
import org.sakaiproject.sitestats.api.ResourceStat;
import org.sakaiproject.sitestats.api.SiteActivityByTool;
import org.sakaiproject.sitestats.api.SitePresence;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.Stat;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.SummaryActivityChartData;
import org.sakaiproject.sitestats.api.SummaryVisitsChartData;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.api.chart.ChartService;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.report.Report;
import org.sakaiproject.sitestats.impl.event.EventRegistryServiceImpl;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartServiceImpl
implements ChartService {
    private static Log LOG = LogFactory.getLog(EventRegistryServiceImpl.class);
    private static ResourceLoader msgs = new ResourceLoader("Messages");
    private static final int MIN_CHART_WIDTH_TO_DRAW_ALL_DAYS = 640;
    private Map<Integer, String> weekDaysMap = null;
    private Map<Integer, String> monthNamesMap = null;
    private StatsManager M_sm;
    private SiteService M_ss;
    private UserDirectoryService M_uds;
    private PreferencesService M_ps;
    private EventRegistryService M_ers;

    public void setStatsManager(StatsManager statsManager) {
        this.M_sm = statsManager;
    }

    public void setSiteService(SiteService siteService) {
        this.M_ss = siteService;
    }

    public void setUserService(UserDirectoryService userDirectoryService) {
        this.M_uds = userDirectoryService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.M_ps = preferencesService;
    }

    public void setEventRegistryService(EventRegistryService eventRegistryService) {
        this.M_ers = eventRegistryService;
    }

    public byte[] generateVisitsChart(String siteId, String viewType, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible) {
        DefaultCategoryDataset dataset = null;
        boolean smallFontInDomainAxis = false;
        render3d = false;
        if ("week".equals(viewType)) {
            dataset = this.getVisitsWeekDataSet(siteId);
        } else if ("month".equals(viewType)) {
            dataset = this.getVisitsMonthDataSet(siteId, width);
            smallFontInDomainAxis = true;
        } else {
            dataset = this.getVisitsYearDataSet(siteId);
        }
        if (dataset != null) {
            return this.generateBarChart(siteId, (CategoryDataset)dataset, width, height, render3d, transparency, itemLabelsVisible, smallFontInDomainAxis);
        }
        return this.generateNoDataChart(width, height);
    }

    public byte[] generateActivityChart(String siteId, String viewType, String chartType, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible) {
        boolean smallFontInDomainAxis = false;
        render3d = false;
        if ("pie".equals(chartType)) {
            DefaultPieDataset dataset = null;
            dataset = "week".equals(viewType) ? this.getActivityWeekPieDataSet(siteId) : ("month".equals(viewType) ? this.getActivityMonthPieDataSet(siteId) : this.getActivityYearPieDataSet(siteId));
            if (dataset != null) {
                return this.generatePieChart(siteId, (PieDataset)dataset, width, height, render3d, transparency, smallFontInDomainAxis);
            }
            return this.generateNoDataChart(width, height);
        }
        DefaultCategoryDataset dataset = null;
        if ("week".equals(viewType)) {
            dataset = this.getActivityWeekBarDataSet(siteId);
        } else if ("month".equals(viewType)) {
            dataset = this.getActivityMonthBarDataSet(siteId, width);
            smallFontInDomainAxis = true;
        } else {
            dataset = this.getActivityYearBarDataSet(siteId);
        }
        if (dataset != null) {
            return this.generateBarChart(siteId, (CategoryDataset)dataset, width, height, render3d, transparency, itemLabelsVisible, smallFontInDomainAxis);
        }
        return this.generateNoDataChart(width, height);
    }

    public byte[] generateChart(String siteId, Object dataset, String chartType, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible, String timePeriod) {
        render3d = false;
        if ("bar".equals(chartType)) {
            if (dataset instanceof CategoryDataset) {
                CategoryDataset ds = (CategoryDataset)dataset;
                return this.generateBarChart(siteId, ds, width, height, render3d, transparency, itemLabelsVisible, false);
            }
            LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing CategoryDataset are supported."));
        } else if ("line".equals(chartType)) {
            if (dataset instanceof CategoryDataset) {
                CategoryDataset ds = (CategoryDataset)dataset;
                return this.generateLineChart(siteId, ds, width, height, render3d, transparency, itemLabelsVisible, false);
            }
            LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing CategoryDataset are supported."));
        } else if ("pie".equals(chartType)) {
            if (dataset instanceof PieDataset) {
                PieDataset ds = (PieDataset)dataset;
                return this.generatePieChart(siteId, ds, width, height, render3d, transparency, false);
            }
            LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing PieDataset are supported."));
        } else if ("timeseries".equals(chartType)) {
            if (dataset instanceof IntervalXYDataset) {
                IntervalXYDataset ds = (IntervalXYDataset)dataset;
                return this.generateTimeSeriesChart(siteId, ds, width, height, false, transparency, itemLabelsVisible, false, timePeriod);
            }
            LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing XYDataset are supported."));
        } else if ("timeseriesbar".equals(chartType)) {
            if (dataset instanceof IntervalXYDataset) {
                IntervalXYDataset ds = (IntervalXYDataset)dataset;
                return this.generateTimeSeriesChart(siteId, ds, width, height, true, transparency, itemLabelsVisible, false, timePeriod);
            }
            LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing XYDataset are supported."));
        }
        LOG.warn((Object)("Chart type " + chartType + " not supported: only line, bar, pie, timeseries are supported."));
        return null;
    }

    public byte[] generateChart(Report report, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible) {
        AbstractDataset dataset = null;
        String chartType = report.getReportDefinition().getReportParams().getHowChartType();
        render3d = false;
        if ("bar".equals(chartType) || "line".equals(chartType)) {
            dataset = this.getCategoryDataset(report);
        } else if ("timeseries".equals(chartType) || "timeseriesbar".equals(chartType)) {
            dataset = this.getTimeSeriesCollectionDataset(report);
        } else if ("pie".equals(chartType)) {
            dataset = this.getPieDataset(report);
        }
        if (dataset != null) {
            String siteId = report.getReportDefinition().getReportParams().getSiteId();
            String timePeriod = report.getReportDefinition().getReportParams().getHowChartSeriesPeriod();
            Date firstDate = report.getReportDefinition().getReportParams().getWhenFrom();
            Date lastDate = report.getReportDefinition().getReportParams().getWhenTo();
            if ("bar".equals(chartType)) {
                if (dataset instanceof CategoryDataset) {
                    CategoryDataset ds = (CategoryDataset)dataset;
                    return this.generateBarChart(siteId, ds, width, height, render3d, transparency, itemLabelsVisible, false);
                }
                LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing CategoryDataset are supported."));
            } else if ("line".equals(chartType)) {
                if (dataset instanceof CategoryDataset) {
                    CategoryDataset ds = (CategoryDataset)dataset;
                    return this.generateLineChart(siteId, ds, width, height, render3d, transparency, itemLabelsVisible, false);
                }
                LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing CategoryDataset are supported."));
            } else if ("pie".equals(chartType)) {
                if (dataset instanceof PieDataset) {
                    PieDataset ds = (PieDataset)dataset;
                    return this.generatePieChart(siteId, ds, width, height, render3d, transparency, false);
                }
                LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing PieDataset are supported."));
            } else if ("timeseries".equals(chartType)) {
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset ds = (IntervalXYDataset)dataset;
                    return this.generateTimeSeriesChart(siteId, ds, width, height, false, transparency, itemLabelsVisible, false, timePeriod, firstDate, lastDate);
                }
                LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing XYDataset are supported."));
            } else if ("timeseriesbar".equals(chartType)) {
                if (dataset instanceof IntervalXYDataset) {
                    IntervalXYDataset ds = (IntervalXYDataset)dataset;
                    return this.generateTimeSeriesChart(siteId, ds, width, height, true, transparency, itemLabelsVisible, false, timePeriod, firstDate, lastDate);
                }
                LOG.warn((Object)("Dataset not supported for " + chartType + " chart type: only classes implementing XYDataset are supported."));
            }
            LOG.warn((Object)("Chart type " + chartType + " not supported: only line, bar, pie, timeseries are supported."));
            return null;
        }
        LOG.warn((Object)("Chart type " + chartType + " not supported: only line, bar, pie, timeseries are supported."));
        return null;
    }

    private byte[] generateBarChart(String siteId, CategoryDataset dataset, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible, boolean smallFontInDomainAxis) {
        JFreeChart chart = null;
        chart = render3d ? ChartFactory.createBarChart3D(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(transparency);
        chart.setBackgroundPaint((Paint)ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ChartServiceImpl.parseColor("#cccccc"));
        plot.getDomainAxis().setMaximumCategoryLabelLines(50);
        plot.getDomainAxis().setMaximumCategoryLabelWidthRatio(1.0f);
        chart.setAntiAlias(true);
        if (smallFontInDomainAxis && !this.canUseNormalFontSize(width)) {
            plot.getDomainAxis().setTickLabelFont(new Font("SansSerif", 0, 8));
            plot.getDomainAxis().setCategoryMargin(0.05);
        }
        BarRenderer barrenderer = (BarRenderer)plot.getRenderer();
        barrenderer.setDrawBarOutline(true);
        if (smallFontInDomainAxis && !this.canUseNormalFontSize(width)) {
            barrenderer.setItemMargin(0.05);
        } else {
            barrenderer.setItemMargin(0.1);
        }
        if (itemLabelsVisible) {
            plot.getRangeAxis().setUpperMargin(0.2);
            barrenderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator(){
                private static final long serialVersionUID = 1L;

                public String generateLabel(CategoryDataset dataset, int row, int column) {
                    Number n = dataset.getValue(row, column);
                    if (n.doubleValue() != 0.0) {
                        if ((double)n.intValue() == n.doubleValue()) {
                            return Integer.toString(n.intValue());
                        }
                        return Double.toString(Util.round((double)n.doubleValue(), (int)1));
                    }
                    return "";
                }
            });
            barrenderer.setItemLabelFont(new Font("SansSerif", 0, 8));
            barrenderer.setItemLabelsVisible(true);
        }
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateLineChart(String siteId, CategoryDataset dataset, int width, int height, boolean render3d, float transparency, boolean itemLabelsVisible, boolean smallFontInDomainAxis) {
        JFreeChart chart = null;
        chart = render3d ? ChartFactory.createLineChart3D(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createLineChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(transparency);
        chart.setBackgroundPaint((Paint)ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ChartServiceImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        if (smallFontInDomainAxis && !this.canUseNormalFontSize(width)) {
            plot.getDomainAxis().setTickLabelFont(new Font("SansSerif", 0, 8));
            plot.getDomainAxis().setCategoryMargin(0.05);
        }
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setDrawOutlines(true);
        if (itemLabelsVisible) {
            plot.getRangeAxis().setUpperMargin(0.2);
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator(){
                private static final long serialVersionUID = 1L;

                public String generateLabel(CategoryDataset dataset, int row, int column) {
                    Number n = dataset.getValue(row, column);
                    if (n.intValue() != 0) {
                        return n.toString();
                    }
                    return "";
                }
            });
            renderer.setItemLabelFont(new Font("SansSerif", 0, 8));
            renderer.setItemLabelsVisible(true);
        }
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generatePieChart(String siteId, PieDataset dataset, int width, int height, boolean render3d, float transparency, boolean smallFontInDomainAxis) {
        JFreeChart chart = null;
        chart = render3d ? ChartFactory.createPieChart3D(null, (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false) : ChartFactory.createPieChart(null, (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setStartAngle(150.0);
        plot.setForegroundAlpha(transparency);
        chart.setBackgroundPaint((Paint)ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        plot.setBackgroundPaint((Paint)ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setInsets(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        plot.setOutlinePaint(null);
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ChartServiceImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateTimeSeriesChart(String siteId, IntervalXYDataset dataset, int width, int height, boolean renderBar, float transparency, boolean itemLabelsVisible, boolean smallFontInDomainAxis, String timePeriod) {
        return this.generateTimeSeriesChart(siteId, dataset, width, height, renderBar, transparency, itemLabelsVisible, smallFontInDomainAxis, timePeriod, null, null);
    }

    private byte[] generateTimeSeriesChart(String siteId, IntervalXYDataset dataset, int width, int height, boolean renderBar, float transparency, boolean itemLabelsVisible, boolean smallFontInDomainAxis, String timePeriod, Date firstDate, Date lastDate) {
        XYLineAndShapeRenderer r;
        JFreeChart chart = null;
        chart = !renderBar ? ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false) : ChartFactory.createXYBarChart(null, null, (boolean)true, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setForegroundAlpha(transparency);
        chart.setBackgroundPaint((Paint)ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        chart.setPadding(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)ChartServiceImpl.parseColor("#cccccc"));
        chart.setAntiAlias(true);
        if (smallFontInDomainAxis && !this.canUseNormalFontSize(width)) {
            plot.getDomainAxis().setTickLabelFont(new Font("SansSerif", 0, 8));
        }
        Locale locale = msgs.getLocale();
        PeriodAxis periodaxis = new PeriodAxis(null);
        Class timePeriodClass = null;
        if (dataset instanceof TimeSeriesCollection) {
            TimeSeriesCollection tsc = (TimeSeriesCollection)dataset;
            timePeriodClass = tsc.getSeriesCount() > 0 ? tsc.getSeries(0).getTimePeriodClass() : org.jfree.data.time.Day.class;
            periodaxis.setAutoRangeTimePeriodClass(timePeriodClass);
        }
        PeriodAxisLabelInfo[] aperiodaxislabelinfo = null;
        if ("byweekday".equals(timePeriod)) {
            aperiodaxislabelinfo = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(org.jfree.data.time.Day.class, (DateFormat)new SimpleDateFormat("E", locale)), new PeriodAxisLabelInfo(org.jfree.data.time.Day.class, (DateFormat)new SimpleDateFormat("d", locale))};
        } else if ("byday".equals(timePeriod)) {
            aperiodaxislabelinfo = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(org.jfree.data.time.Day.class, (DateFormat)new SimpleDateFormat("d", locale)), new PeriodAxisLabelInfo(Month.class, (DateFormat)new SimpleDateFormat("MMM", locale)), new PeriodAxisLabelInfo(Year.class, (DateFormat)new SimpleDateFormat("yyyy", locale))};
        } else if ("bymonth".equals(timePeriod)) {
            aperiodaxislabelinfo = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Month.class, (DateFormat)new SimpleDateFormat("MMM", locale)), new PeriodAxisLabelInfo(Year.class, (DateFormat)new SimpleDateFormat("yyyy", locale))};
        } else if ("byyear".equals(timePeriod)) {
            aperiodaxislabelinfo = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Year.class, (DateFormat)new SimpleDateFormat("yyyy", locale))};
        }
        periodaxis.setLabelInfo(aperiodaxislabelinfo);
        if (firstDate != null || lastDate != null) {
            periodaxis.setAutoRange(false);
            if (firstDate != null) {
                if ("bymonth".equals(timePeriod) || "byyear".equals(timePeriod)) {
                    periodaxis.setFirst((RegularTimePeriod)new Month(firstDate));
                } else {
                    periodaxis.setFirst((RegularTimePeriod)new org.jfree.data.time.Day(firstDate));
                }
            }
            if (lastDate != null) {
                if ("bymonth".equals(timePeriod) || "byyear".equals(timePeriod)) {
                    periodaxis.setLast((RegularTimePeriod)new Month(lastDate));
                } else {
                    periodaxis.setLast((RegularTimePeriod)new org.jfree.data.time.Day(lastDate));
                }
            }
        }
        periodaxis.setTickMarkOutsideLength(0.0f);
        plot.setDomainAxis((ValueAxis)periodaxis);
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
        if (renderer instanceof XYLineAndShapeRenderer) {
            r = (XYLineAndShapeRenderer)renderer;
            r.setDrawSeriesLineAsPath(true);
            r.setShapesVisible(true);
            r.setShapesFilled(true);
        } else if (renderer instanceof XYBarRenderer) {
            r = new ClusteredXYBarRenderer();
            r.setDrawBarOutline(true);
            if (smallFontInDomainAxis && !this.canUseNormalFontSize(width)) {
                r.setMargin(0.05);
            } else {
                r.setMargin(0.1);
            }
            plot.setRenderer((XYItemRenderer)r);
            renderer = r;
        }
        if (itemLabelsVisible) {
            plot.getRangeAxis().setUpperMargin(0.2);
            renderer.setItemLabelGenerator(new XYItemLabelGenerator(){
                private static final long serialVersionUID = 1L;

                public String generateLabel(XYDataset dataset, int series, int item) {
                    Number n = dataset.getY(series, item);
                    if (n.doubleValue() != 0.0) {
                        return n.toString();
                    }
                    return "";
                }
            });
            renderer.setItemLabelFont(new Font("SansSerif", 0, 8));
            renderer.setItemLabelsVisible(true);
        }
        BufferedImage img = chart.createBufferedImage(width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private byte[] generateNoDataChart(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2d = img.createGraphics();
        g2d.setBackground(ChartServiceImpl.parseColor(this.M_sm.getChartBackgroundColor()));
        g2d.clearRect(0, 0, width - 1, height - 1);
        g2d.setColor(ChartServiceImpl.parseColor("#cccccc"));
        g2d.drawRect(0, 0, width - 1, height - 1);
        Font f = new Font("SansSerif", 0, 12);
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics(f);
        String noData = msgs.getString("no_data");
        int noDataWidth = fm.stringWidth(noData);
        int noDataHeight = fm.getHeight();
        g2d.setColor(ChartServiceImpl.parseColor("#555555"));
        g2d.drawString(noData, width / 2 - noDataWidth / 2, height / 2 - noDataHeight / 2 + 2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error occurred while generating SiteStats chart image data", (Throwable)e);
        }
        return out.toByteArray();
    }

    private DefaultCategoryDataset getVisitsWeekDataSet(String siteId) {
        SummaryVisitsChartData svc = this.M_sm.getSummaryVisitsChartData(siteId, "week");
        if (svc == null) {
            return null;
        }
        DefaultCategoryDataset visitsWeekDataSet = new DefaultCategoryDataset();
        String visits = msgs.getString("legend_visits");
        String uniqueVisits = msgs.getString("legend_unique_visitors");
        Calendar cal = Calendar.getInstance();
        cal.setTime(svc.getFirstDay());
        Calendar currDay = (Calendar)cal.clone();
        long[] visitsData = svc.getVisits();
        long[] uniqueVisitsData = svc.getUniqueVisits();
        for (int i = 0; i < visitsData.length; ++i) {
            visitsWeekDataSet.addValue((double)visitsData[i], (Comparable)((Object)visits), (Comparable)((Object)this.getWeekDaysMap().get(currDay.get(7))));
            visitsWeekDataSet.addValue((double)uniqueVisitsData[i], (Comparable)((Object)uniqueVisits), (Comparable)((Object)this.getWeekDaysMap().get(currDay.get(7))));
            currDay.add(6, 1);
        }
        return visitsWeekDataSet;
    }

    private DefaultCategoryDataset getVisitsMonthDataSet(String siteId, int width) {
        SummaryVisitsChartData svc = this.M_sm.getSummaryVisitsChartData(siteId, "month");
        if (svc == null) {
            return null;
        }
        DefaultCategoryDataset visitsMonthDataSet = new DefaultCategoryDataset();
        String visits = msgs.getString("legend_visits");
        String uniqueVisits = msgs.getString("legend_unique_visitors");
        Calendar cal = Calendar.getInstance();
        cal.setTime(svc.getFirstDay());
        Calendar currDay = (Calendar)cal.clone();
        long[] visitsData = svc.getVisits();
        long[] uniqueVisitsData = svc.getUniqueVisits();
        for (int i = 0; i < visitsData.length; ++i) {
            int dayOfMonth = currDay.get(5);
            Day day = this.canUseNormalFontSize(width) || i == 0 || i == 29 || i % 2 == 0 ? new Day(dayOfMonth, Integer.toString(dayOfMonth)) : new Day(dayOfMonth, "");
            visitsMonthDataSet.addValue((double)visitsData[i], (Comparable)((Object)visits), (Comparable)day);
            visitsMonthDataSet.addValue((double)uniqueVisitsData[i], (Comparable)((Object)uniqueVisits), (Comparable)day);
            currDay.add(5, 1);
        }
        return visitsMonthDataSet;
    }

    private DefaultCategoryDataset getVisitsYearDataSet(String siteId) {
        SummaryVisitsChartData svc = this.M_sm.getSummaryVisitsChartData(siteId, "year");
        if (svc == null) {
            return null;
        }
        DefaultCategoryDataset visitsYearDataSet = new DefaultCategoryDataset();
        String visits = msgs.getString("legend_visits");
        String uniqueVisits = msgs.getString("legend_unique_visitors");
        Calendar cal = Calendar.getInstance();
        cal.setTime(svc.getFirstDay());
        Calendar currMonth = (Calendar)cal.clone();
        long[] visitsData = svc.getVisits();
        long[] uniqueVisitsData = svc.getUniqueVisits();
        for (int i = 0; i < visitsData.length; ++i) {
            visitsYearDataSet.addValue((double)visitsData[i], (Comparable)((Object)visits), (Comparable)((Object)this.getMonthNamesMap().get(currMonth.get(2))));
            visitsYearDataSet.addValue((double)uniqueVisitsData[i], (Comparable)((Object)uniqueVisits), (Comparable)((Object)this.getMonthNamesMap().get(currMonth.get(2))));
            currMonth.add(2, 1);
        }
        return visitsYearDataSet;
    }

    private DefaultPieDataset getActivityWeekPieDataSet(String siteId) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "week", "pie");
        if (sac == null) {
            return null;
        }
        DefaultPieDataset activityWeekPieDataSet = this.fillActivityPieDataSet(sac);
        return activityWeekPieDataSet;
    }

    private DefaultPieDataset getActivityMonthPieDataSet(String siteId) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "month", "pie");
        if (sac == null) {
            return null;
        }
        DefaultPieDataset activityMonthPieDataSet = this.fillActivityPieDataSet(sac);
        return activityMonthPieDataSet;
    }

    private DefaultPieDataset getActivityYearPieDataSet(String siteId) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "year", "pie");
        if (sac == null) {
            return null;
        }
        DefaultPieDataset activityYearPieDataSet = this.fillActivityPieDataSet(sac);
        return activityYearPieDataSet;
    }

    private DefaultPieDataset fillActivityPieDataSet(SummaryActivityChartData sac) {
        String label;
        int decimalPlaces;
        DefaultPieDataset pieDataSet = new DefaultPieDataset();
        List lsac = sac.getActivityByTool();
        int total = sac.getActivityByToolTotal();
        int showMax = 5;
        for (int i = 0; i < lsac.size() && i < showMax; ++i) {
            SiteActivityByTool s = (SiteActivityByTool)lsac.get(i);
            double percentage = (double)s.getCount() * 100.0 / (double)total;
            decimalPlaces = 1;
            if (percentage < 0.1) {
                decimalPlaces = 2;
            }
            label = this.M_ers.getToolName(s.getTool().getToolId()) + " " + Util.round((double)percentage, (int)decimalPlaces) + "%";
            pieDataSet.setValue((Comparable)((Object)label), percentage);
        }
        if (lsac.size() > showMax) {
            int acumulated = 0;
            String otherTools = msgs.getString("label_activity_other_tools");
            for (int i = showMax; i < lsac.size(); ++i) {
                SiteActivityByTool s = (SiteActivityByTool)lsac.get(i);
                acumulated = (int)((long)acumulated + s.getCount());
            }
            double percentage = (double)acumulated * 100.0 / (double)total;
            decimalPlaces = 1;
            if (percentage < 0.1) {
                decimalPlaces = 2;
            }
            label = otherTools + " " + Util.round((double)percentage, (int)decimalPlaces) + "%";
            pieDataSet.setValue((Comparable)((Object)label), percentage);
        }
        return pieDataSet;
    }

    private DefaultCategoryDataset getActivityWeekBarDataSet(String siteId) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "week", "bar");
        if (sac == null) {
            return null;
        }
        DefaultCategoryDataset activityWeekBarDataSet = new DefaultCategoryDataset();
        String activity = msgs.getString("legend_activity");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sac.getFirstDay());
        Calendar currDay = (Calendar)cal.clone();
        long[] activityData = sac.getActivity();
        for (int i = 0; i < activityData.length; ++i) {
            activityWeekBarDataSet.addValue((double)activityData[i], (Comparable)((Object)activity), (Comparable)((Object)this.getWeekDaysMap().get(currDay.get(7))));
            currDay.add(6, 1);
        }
        return activityWeekBarDataSet;
    }

    private DefaultCategoryDataset getActivityMonthBarDataSet(String siteId, int width) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "month", "bar");
        if (sac == null) {
            return null;
        }
        DefaultCategoryDataset activityMonthBarDataSet = new DefaultCategoryDataset();
        String activity = msgs.getString("legend_activity");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sac.getFirstDay());
        Calendar currDay = (Calendar)cal.clone();
        long[] activityData = sac.getActivity();
        for (int i = 0; i < activityData.length; ++i) {
            int dayOfMonth = currDay.get(5);
            Day day = this.canUseNormalFontSize(width) || i == 0 || i == 29 || i % 2 == 0 ? new Day(dayOfMonth, Integer.toString(dayOfMonth)) : new Day(dayOfMonth, "");
            activityMonthBarDataSet.addValue((double)activityData[i], (Comparable)((Object)activity), (Comparable)day);
            currDay.add(5, 1);
        }
        return activityMonthBarDataSet;
    }

    private DefaultCategoryDataset getActivityYearBarDataSet(String siteId) {
        SummaryActivityChartData sac = this.M_sm.getSummaryActivityChartData(siteId, "year", "bar");
        if (sac == null) {
            return null;
        }
        DefaultCategoryDataset activityYearBarDataSet = new DefaultCategoryDataset();
        String activity = msgs.getString("legend_activity");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sac.getFirstDay());
        Calendar currMonth = (Calendar)cal.clone();
        long[] activityData = sac.getActivity();
        for (int i = 0; i < activityData.length; ++i) {
            activityYearBarDataSet.addValue((double)activityData[i], (Comparable)((Object)activity), (Comparable)((Object)this.getMonthNamesMap().get(currMonth.get(2))));
            currMonth.add(2, 1);
        }
        return activityYearBarDataSet;
    }

    private AbstractDataset getCategoryDataset(Report report) {
        List reportData = report.getReportData();
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
        String dataSource = report.getReportDefinition().getReportParams().getHowChartSource();
        String categorySource = report.getReportDefinition().getReportParams().getHowChartCategorySource();
        if ("none".equals(categorySource)) {
            categorySource = null;
        }
        if (categorySource == null) {
            HashSet<Comparable> usedKeys = new HashSet<Comparable>();
            for (Stat s : reportData) {
                Comparable key = this.getStatValue(s, dataSource);
                if (key == null) continue;
                if (usedKeys.contains(key)) {
                    dataSet.incrementValue(this.getTotalValue(s, report).doubleValue(), key, key);
                    continue;
                }
                dataSet.addValue(this.getTotalValue(s, report), key, key);
                usedKeys.add(key);
            }
        } else {
            HashMap<Comparable, Comparable> usedKeys = new HashMap<Comparable, Comparable>();
            for (Stat s : reportData) {
                Comparable key = this.getStatValue(s, dataSource);
                Comparable cat = this.getStatValue(s, categorySource);
                if (key == null || cat == null) continue;
                if (usedKeys.containsKey(cat) && key.equals(usedKeys.get(cat))) {
                    dataSet.incrementValue(this.getTotalValue(s, report).doubleValue(), key, cat);
                    continue;
                }
                dataSet.addValue(this.getTotalValue(s, report), key, cat);
                usedKeys.put(cat, key);
            }
            for (Comparable c : usedKeys.keySet()) {
                for (Comparable k : usedKeys.values()) {
                    if (dataSet.getValue(k, c) != null) continue;
                    dataSet.addValue(0.0, k, c);
                }
            }
        }
        return dataSet;
    }

    private AbstractDataset getPieDataset(Report report) {
        List reportData = report.getReportData();
        DefaultPieDataset dataSet = new DefaultPieDataset();
        String dataSource = report.getReportDefinition().getReportParams().getHowChartSource();
        double total = 0.0;
        for (Stat s : reportData) {
            Comparable key = this.getStatValue(s, dataSource);
            if (key == null) continue;
            try {
                Number existingValue = dataSet.getValue(key);
                dataSet.setValue(key, this.getTotalValue(existingValue, s, report));
                total += this.getTotalValue(s, report).doubleValue();
            }
            catch (UnknownKeyException e) {
                dataSet.setValue(key, this.getTotalValue(s, report));
                total += this.getTotalValue(s, report).doubleValue();
            }
        }
        dataSet.sortByValues(SortOrder.DESCENDING);
        int maxDisplayedItems = 10;
        int currItem = 1;
        Integer othersValues = 0;
        List keys = dataSet.getKeys();
        for (Comparable key : keys) {
            Number existingValue = dataSet.getValue(key);
            if (currItem < maxDisplayedItems) {
                double percentage;
                double valuePercentage = Util.round((double)percentage, (int)((percentage = existingValue.doubleValue() * 100.0 / total) > 0.1 ? 1 : 2));
                StringBuilder keyStr = new StringBuilder(key.toString());
                keyStr.append(' ');
                keyStr.append(valuePercentage);
                keyStr.append("% (");
                if ((double)existingValue.intValue() == existingValue.doubleValue()) {
                    keyStr.append(existingValue.intValue());
                } else {
                    keyStr.append(existingValue.doubleValue());
                }
                keyStr.append(")");
                dataSet.remove(key);
                dataSet.setValue((Comparable)((Object)keyStr.toString()), existingValue);
            } else {
                othersValues = othersValues + existingValue.intValue();
                dataSet.remove(key);
            }
            ++currItem;
        }
        if (othersValues > 0) {
            double percentage;
            double valuePercentage = Util.round((double)percentage, (int)((percentage = ((Number)othersValues).doubleValue() * 100.0 / total) > 0.1 ? 1 : 2));
            StringBuilder keyStr = new StringBuilder(msgs.getString("pie_chart_others"));
            keyStr.append(' ');
            keyStr.append(valuePercentage);
            keyStr.append("% (");
            if ((double)((Number)othersValues).intValue() == ((Number)othersValues).doubleValue()) {
                keyStr.append(othersValues);
            } else {
                keyStr.append(((Number)othersValues).doubleValue());
            }
            keyStr.append(")");
            dataSet.setValue((Comparable)((Object)keyStr.toString()), (Number)othersValues);
        }
        return dataSet;
    }

    private AbstractDataset getTimeSeriesCollectionDataset(Report report) {
        List reportData = report.getReportData();
        TimeSeriesCollection dataSet = new TimeSeriesCollection();
        String dataSource = report.getReportDefinition().getReportParams().getHowChartSource();
        String seriesFrom = report.getReportDefinition().getReportParams().getHowChartSeriesSource();
        if ("total".equals(seriesFrom) || "none".equals(seriesFrom)) {
            seriesFrom = null;
        }
        Class<org.jfree.data.time.Day> periodGrouping = null;
        if ("byday".equals(report.getReportDefinition().getReportParams().getHowChartSeriesPeriod()) || "byweekday".equals(report.getReportDefinition().getReportParams().getHowChartSeriesPeriod())) {
            periodGrouping = org.jfree.data.time.Day.class;
        } else if ("bymonth".equals(report.getReportDefinition().getReportParams().getHowChartSeriesPeriod())) {
            periodGrouping = Month.class;
        } else if ("byyear".equals(report.getReportDefinition().getReportParams().getHowChartSeriesPeriod())) {
            periodGrouping = Year.class;
        }
        boolean visitsTotalsChart = "what-visits-totals".equals(report.getReportDefinition().getReportParams().getWhat()) || report.getReportDefinition().getReportParams().getHowTotalsBy().contains("visits") || report.getReportDefinition().getReportParams().getHowTotalsBy().contains("unique-visits");
        HashSet<RegularTimePeriod> keys = new HashSet<RegularTimePeriod>();
        if (!visitsTotalsChart && seriesFrom == null) {
            String name = msgs.getString("th_total");
            TimeSeries ts = new TimeSeries(name, periodGrouping);
            for (Stat s : reportData) {
                RegularTimePeriod key = (RegularTimePeriod)this.getStatValue(s, dataSource, periodGrouping);
                if (key == null) continue;
                Number existing = null;
                existing = ts.getValue(key);
                if (existing == null) {
                    ts.add(key, this.getTotalValue(s, report));
                } else {
                    ts.addOrUpdate(key, this.getTotalValue(existing, s, report));
                }
                keys.add(key);
            }
            dataSet.addSeries(ts);
        } else if (!visitsTotalsChart && seriesFrom != null) {
            HashMap<Comparable, TimeSeries> series = new HashMap<Comparable, TimeSeries>();
            for (Stat s : reportData) {
                RegularTimePeriod key = (RegularTimePeriod)this.getStatValue(s, dataSource, periodGrouping);
                Comparable serie = this.getStatValue(s, seriesFrom);
                if (key == null || serie == null) continue;
                TimeSeries ts = null;
                if (!series.containsKey(serie)) {
                    ts = new TimeSeries(serie.toString(), periodGrouping);
                    series.put(serie, ts);
                } else {
                    ts = (TimeSeries)series.get(serie);
                }
                Number existing = null;
                existing = ts.getValue(key);
                if (existing == null) {
                    ts.add(key, this.getTotalValue(s, report));
                } else {
                    ts.addOrUpdate(key, this.getTotalValue(existing, s, report));
                }
                keys.add(key);
            }
            for (TimeSeries ts : series.values()) {
                dataSet.addSeries(ts);
            }
        } else if (visitsTotalsChart) {
            TimeSeries tsV = new TimeSeries(msgs.getString("th_visits"), periodGrouping);
            TimeSeries tsUV = new TimeSeries(msgs.getString("th_uniquevisitors"), periodGrouping);
            for (Stat _s : reportData) {
                SiteVisits s = (SiteVisits)_s;
                RegularTimePeriod key = (RegularTimePeriod)this.getStatValue((Stat)s, dataSource, periodGrouping);
                if (key == null) continue;
                Number existing = null;
                existing = tsV.getValue(key);
                if (existing == null) {
                    tsV.add(key, (double)s.getTotalVisits());
                    tsUV.add(key, (double)s.getTotalUnique());
                } else {
                    tsV.addOrUpdate(key, (double)(s.getTotalVisits() + existing.longValue()));
                    tsUV.addOrUpdate(key, (double)(s.getTotalVisits() + existing.longValue()));
                }
                keys.add(key);
            }
            dataSet.addSeries(tsV);
            dataSet.addSeries(tsUV);
        }
        dataSet.setXPosition(TimePeriodAnchor.MIDDLE);
        return dataSet;
    }

    private Map<Integer, String> getWeekDaysMap() {
        this.weekDaysMap = new HashMap<Integer, String>();
        this.weekDaysMap.put(1, msgs.getString("day_sun"));
        this.weekDaysMap.put(2, msgs.getString("day_mon"));
        this.weekDaysMap.put(3, msgs.getString("day_tue"));
        this.weekDaysMap.put(4, msgs.getString("day_wed"));
        this.weekDaysMap.put(5, msgs.getString("day_thu"));
        this.weekDaysMap.put(6, msgs.getString("day_fri"));
        this.weekDaysMap.put(7, msgs.getString("day_sat"));
        return this.weekDaysMap;
    }

    private Map<Integer, String> getMonthNamesMap() {
        this.monthNamesMap = new HashMap<Integer, String>();
        this.monthNamesMap.put(0, msgs.getString("mo_jan"));
        this.monthNamesMap.put(1, msgs.getString("mo_feb"));
        this.monthNamesMap.put(2, msgs.getString("mo_mar"));
        this.monthNamesMap.put(3, msgs.getString("mo_apr"));
        this.monthNamesMap.put(4, msgs.getString("mo_may"));
        this.monthNamesMap.put(5, msgs.getString("mo_jun"));
        this.monthNamesMap.put(6, msgs.getString("mo_jul"));
        this.monthNamesMap.put(7, msgs.getString("mo_ago"));
        this.monthNamesMap.put(8, msgs.getString("mo_sep"));
        this.monthNamesMap.put(9, msgs.getString("mo_oct"));
        this.monthNamesMap.put(10, msgs.getString("mo_nov"));
        this.monthNamesMap.put(11, msgs.getString("mo_dec"));
        return this.monthNamesMap;
    }

    private boolean canUseNormalFontSize(int chartWidth) {
        return chartWidth >= 640;
    }

    private static Color parseColor(String color) {
        if (color != null) {
            if (color.trim().startsWith("#")) {
                return new Color(Integer.parseInt(color.substring(1), 16));
            }
            if (color.trim().startsWith("rgb")) {
                String values = color.substring(color.indexOf("(") + 1, color.indexOf(")"));
                String[] rgb = values.split(",");
                return new Color(Integer.parseInt(rgb[0].trim()), Integer.parseInt(rgb[1].trim()), Integer.parseInt(rgb[2].trim()));
            }
            if (color.equalsIgnoreCase("black")) {
                return Color.black;
            }
            if (color.equalsIgnoreCase("grey")) {
                return Color.gray;
            }
            if (color.equalsIgnoreCase("yellow")) {
                return Color.yellow;
            }
            if (color.equalsIgnoreCase("green")) {
                return Color.green;
            }
            if (color.equalsIgnoreCase("blue")) {
                return Color.blue;
            }
            if (color.equalsIgnoreCase("red")) {
                return Color.red;
            }
            if (color.equalsIgnoreCase("orange")) {
                return Color.orange;
            }
            if (color.equalsIgnoreCase("cyan")) {
                return Color.cyan;
            }
            if (color.equalsIgnoreCase("magenta")) {
                return Color.magenta;
            }
            if (color.equalsIgnoreCase("darkgray")) {
                return Color.darkGray;
            }
            if (color.equalsIgnoreCase("lightgray")) {
                return Color.lightGray;
            }
            if (color.equalsIgnoreCase("pink")) {
                return Color.pink;
            }
            if (color.equalsIgnoreCase("white")) {
                return Color.white;
            }
        }
        LOG.info((Object)("Unable to parse body background-color (color:" + color + "). Assuming white."));
        return Color.white;
    }

    private Comparable getStatValue(Stat s, String fieldCode) {
        return this.getStatValue(s, fieldCode, org.jfree.data.time.Day.class);
    }

    private Comparable getStatValue(Stat s, String fieldCode, Class periodGrouping) {
        if (fieldCode == null) {
            return null;
        }
        try {
            if (fieldCode.equals("site")) {
                String siteId = s.getSiteId();
                String title = null;
                try {
                    title = this.M_ss.getSite(siteId).getTitle();
                }
                catch (IdUnusedException e) {
                    title = siteId;
                }
                return title;
            }
            if (fieldCode.equals("user")) {
                String userId = s.getUserId();
                String name = null;
                name = userId != null ? ("-".equals(userId) ? msgs.getString("user_anonymous") : ("?".equals(userId) ? msgs.getString("user_anonymous_access") : this.M_sm.getUserNameForDisplay(userId))) : msgs.getString("user_unknown");
                return name;
            }
            if (fieldCode.equals("event")) {
                String eventId;
                String eventName = "";
                if (s instanceof EventStat && !"".equals(eventId = ((EventStat)s).getEventId())) {
                    eventName = this.M_ers.getEventName(eventId);
                }
                return eventName;
            }
            if (fieldCode.equals("tool")) {
                String toolId;
                String toolName = "";
                if (s instanceof EventStat && !"".equals(toolId = ((EventStat)s).getToolId())) {
                    toolName = this.M_ers.getToolName(toolId);
                }
                return toolName;
            }
            if (fieldCode.equals("resource")) {
                if (s instanceof ResourceStat) {
                    String ref = ((ResourceStat)s).getResourceRef();
                    String resName = this.M_sm.getResourceName(ref);
                    return resName != null ? resName : msgs.getString("resource_unknown");
                }
                return "";
            }
            if (fieldCode.equals("resource-action")) {
                String action = "";
                if (s instanceof ResourceStat) {
                    String refAction = ((ResourceStat)s).getResourceAction();
                    if (refAction == null) {
                        action = "";
                    } else if (!"".equals(refAction.trim())) {
                        action = msgs.getString("action_" + refAction);
                    }
                }
                return action;
            }
            if (fieldCode.equals("date") || fieldCode.equals("last-date") || fieldCode.equals("month") || fieldCode.equals("year")) {
                Date d = s.getDate();
                if (d != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    if (Year.class.equals((Object)periodGrouping)) {
                        return new Year(c.getTime());
                    }
                    if (Month.class.equals((Object)periodGrouping)) {
                        return new Month(c.getTime());
                    }
                    if (Week.class.equals((Object)periodGrouping)) {
                        return new Week(c.getTime());
                    }
                    return new org.jfree.data.time.Day(c.getTime());
                }
                return null;
            }
            if (fieldCode.equals("total")) {
                return Long.valueOf(s.getCount());
            }
            if (fieldCode.equals("visits")) {
                if (s instanceof SiteVisits) {
                    return Long.valueOf(((SiteVisits)s).getTotalVisits());
                }
                return Long.valueOf(s.getCount());
            }
            if (fieldCode.equals("unique-visits")) {
                if (s instanceof SiteVisits) {
                    return Long.valueOf(((SiteVisits)s).getTotalUnique());
                }
                return Long.valueOf(s.getCount());
            }
            if (fieldCode.equals("duration") && s instanceof SitePresence) {
                double duration = ((SitePresence)s).getDuration();
                return Double.valueOf(Util.round((double)(duration / 1000.0 / 60.0), (int)1));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error occurred while getting value for chart", (Throwable)e);
        }
        return null;
    }

    private Number getTotalValue(Stat s, Report r) {
        return this.getTotalValue(null, s, r);
    }

    private Number getTotalValue(Number existingValue, Stat s, Report r) {
        try {
            String what = r.getReportDefinition().getReportParams().getWhat();
            if ("what-visits-totals".equals(what)) {
                if (s instanceof SiteVisits) {
                    long totalVisits = ((SiteVisits)s).getTotalVisits();
                    if (existingValue != null) {
                        totalVisits += existingValue.longValue();
                    }
                    return totalVisits;
                }
            } else if ("what-presences".equals(what) && s instanceof SitePresence) {
                double duration = ((SitePresence)s).getDuration();
                duration = Util.round((double)(duration / 1000.0 / 60.0), (int)1);
                if (existingValue != null) {
                    duration += existingValue.doubleValue();
                }
                return duration;
            }
            long count = s.getCount();
            if (existingValue != null) {
                count += existingValue.longValue();
            }
            return count;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error occurred while getting total value for chart", (Throwable)e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Day
    implements Comparable<Object> {
        private String dayLabel;
        private int day;

        public Day(int day, String dayLabel) {
            this.day = day;
            this.dayLabel = dayLabel;
        }

        public int getDay() {
            return this.day;
        }

        public String toString() {
            return this.dayLabel;
        }

        @Override
        public int compareTo(Object o) {
            if (!(o instanceof Day)) {
                return -1;
            }
            int otherDay = ((Day)o).getDay();
            if (this.day < otherDay) {
                return -1;
            }
            if (this.day > otherDay) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Day)) {
                return false;
            }
            int otherDay = ((Day)o).getDay();
            return this.day == otherDay;
        }

        public int hashCode() {
            return this.getDay();
        }
    }
}

