/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.report.fop;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.EventStat;
import org.sakaiproject.sitestats.api.ResourceStat;
import org.sakaiproject.sitestats.api.SitePresence;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.Stat;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.api.chart.ChartService;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.report.Report;
import org.sakaiproject.sitestats.api.report.ReportManager;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.impl.report.fop.AbstractObjectReader;
import org.sakaiproject.sitestats.impl.report.fop.ReportInputSource;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportXMLReader
extends AbstractObjectReader {
    private ResourceLoader msgs = new ResourceLoader("Messages");
    private SimpleDateFormat dateMonthFrmt = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat dateYearFrmt = new SimpleDateFormat("yyyy");
    private TimeService M_ts = (TimeService)ComponentManager.get((String)TimeService.class.getName());
    private SiteService M_ss = (SiteService)ComponentManager.get((String)SiteService.class.getName());
    private UserDirectoryService M_uds = (UserDirectoryService)ComponentManager.get((String)UserDirectoryService.class.getName());
    private StatsManager M_sm = (StatsManager)ComponentManager.get((String)StatsManager.class.getName());
    private EventRegistryService M_ers = (EventRegistryService)ComponentManager.get((String)EventRegistryService.class.getName());
    private ReportManager M_rm = (ReportManager)ComponentManager.get((String)ReportManager.class.getName());
    private ChartService M_cs = (ChartService)ComponentManager.get((String)ChartService.class.getName());

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (!(input instanceof ReportInputSource)) {
            throw new SAXException("Unsupported InputSource specified. Must be a ReportInputSource");
        }
        this.parse(((ReportInputSource)input).getReport());
    }

    public void parse(Report report) throws SAXException {
        if (report == null) {
            throw new NullPointerException("Parameter report must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startDocument();
        this.generateReport(report);
        this.handler.endDocument();
    }

    protected void generateReport(Report report) throws SAXException {
        String reportActivitySelection;
        String reportSite;
        if (report == null) {
            throw new NullPointerException("Parameter report must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startElement("report");
        String reportTitle = this.M_rm.getReportFormattedParams().getReportTitle(report);
        reportTitle = reportTitle != null && reportTitle.trim().length() != 0 ? this.msgs.getString("reportres_title_detailed").replaceAll("\\$\\{title\\}", reportTitle) : this.msgs.getString("reportres_title");
        this.handler.element("title", reportTitle);
        String reportDescription = this.M_rm.getReportFormattedParams().getReportDescription(report);
        if (reportDescription != null) {
            this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_description"), reportDescription);
        }
        if ((reportSite = this.M_rm.getReportFormattedParams().getReportSite(report)) != null) {
            this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_site"), reportSite);
        }
        this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_act_basedon"), this.M_rm.getReportFormattedParams().getReportActivityBasedOn(report));
        String reportResourceAction = this.M_rm.getReportFormattedParams().getReportResourceAction(report);
        if (reportResourceAction != null) {
            this.generateReportSummaryHeaderRow(this.M_rm.getReportFormattedParams().getReportResourceActionTitle(report), reportResourceAction);
        }
        if ((reportActivitySelection = this.M_rm.getReportFormattedParams().getReportActivitySelection(report)) != null) {
            this.generateReportSummaryHeaderRow(this.M_rm.getReportFormattedParams().getReportActivitySelectionTitle(report), reportActivitySelection);
        }
        this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_timeperiod"), this.M_rm.getReportFormattedParams().getReportTimePeriod(report));
        this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_usr_selectiontype"), this.M_rm.getReportFormattedParams().getReportUserSelectionType(report));
        String reportUserSelection = this.M_rm.getReportFormattedParams().getReportUserSelection(report);
        if (reportUserSelection != null) {
            this.generateReportSummaryHeaderRow(this.M_rm.getReportFormattedParams().getReportUserSelectionTitle(report), reportUserSelection);
        }
        this.generateReportSummaryHeaderRow(this.msgs.getString("reportres_summ_generatedon"), this.M_rm.getReportFormattedParams().getReportGenerationDate(report));
        this.setColumnDisplayInfo(report.getReportDefinition().getReportParams());
        boolean showChart = false;
        boolean showTable = true;
        this.handler.element("showChart", String.valueOf(showChart));
        this.handler.element("showTable", String.valueOf(showTable));
        if (showChart) {
            this.generateReportChart(report);
        }
        if (showTable) {
            this.generateReportDataHeader(report.getReportDefinition().getReportParams());
            this.generateReportTable(report.getReportData(), report.getReportDefinition().getReportParams());
        }
        this.handler.endElement("report");
    }

    protected void generateReportSummaryHeaderRow(String label, String value) throws SAXException {
        if (label == null || value == null) {
            throw new NullPointerException("Parameter label and value must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startElement("summaryheader");
        this.handler.element("label", label);
        this.handler.element("value", value);
        this.handler.endElement("summaryheader");
    }

    private void generateReportDataHeader(ReportParams params) throws SAXException {
        if (params == null) {
            throw new NullPointerException("Parameter 'params' must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.startElement("datarowheader");
        this.setColumnDisplayInfo(params);
        this.handler.element("th_site", this.msgs.getString("th_site"));
        this.handler.element("th_id", this.msgs.getString("th_id"));
        this.handler.element("th_user", this.msgs.getString("th_user"));
        this.handler.element("th_resource", this.msgs.getString("th_resource"));
        this.handler.element("th_action", this.msgs.getString("th_action"));
        this.handler.element("th_tool", this.msgs.getString("th_tool"));
        this.handler.element("th_event", this.msgs.getString("th_event"));
        this.handler.element("th_date", this.msgs.getString("th_date"));
        this.handler.element("th_lastdate", this.msgs.getString("th_date"));
        this.handler.element("th_total", this.msgs.getString("th_total"));
        this.handler.element("th_visits", this.msgs.getString("th_visits"));
        this.handler.element("th_uniquevisitors", this.msgs.getString("th_uniquevisitors"));
        this.handler.element("th_duration", this.msgs.getString("th_duration") + " (" + this.msgs.getString("minutes_abbr") + ")");
        this.handler.endElement("datarowheader");
    }

    private void setColumnDisplayInfo(ReportParams params) throws SAXException {
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        this.handler.element("what", params.getWhat());
        this.handler.element("who", params.getWho());
        this.handler.element("showSite", String.valueOf(this.M_rm.isReportColumnAvailable(params, "site")));
        this.handler.element("showUser", String.valueOf(this.M_rm.isReportColumnAvailable(params, "user")));
        this.handler.element("showTool", String.valueOf(this.M_rm.isReportColumnAvailable(params, "tool")));
        this.handler.element("showEvent", String.valueOf(this.M_rm.isReportColumnAvailable(params, "event")));
        this.handler.element("showResource", String.valueOf(this.M_rm.isReportColumnAvailable(params, "resource")));
        this.handler.element("showResourceAction", String.valueOf(this.M_rm.isReportColumnAvailable(params, "resource-action")));
        this.handler.element("showDate", String.valueOf(this.M_rm.isReportColumnAvailable(params, "date") || this.M_rm.isReportColumnAvailable(params, "month") || this.M_rm.isReportColumnAvailable(params, "year")));
        this.handler.element("showLastDate", String.valueOf(this.M_rm.isReportColumnAvailable(params, "last-date")));
        this.handler.element("showTotal", String.valueOf(this.M_rm.isReportColumnAvailable(params, "total")));
        this.handler.element("showTotalVisits", String.valueOf(this.M_rm.isReportColumnAvailable(params, "visits")));
        this.handler.element("showTotalUnique", String.valueOf(this.M_rm.isReportColumnAvailable(params, "unique-visits")));
        this.handler.element("showDuration", String.valueOf(this.M_rm.isReportColumnAvailable(params, "duration")));
    }

    private void generateReportChart(Report report) throws SAXException {
        if (report == null) {
            throw new NullPointerException("Parameter 'report'must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
    }

    private void generateReportTable(List<Stat> data, ReportParams params) throws SAXException {
        if (data == null || params == null) {
            throw new NullPointerException("Parameter 'data', 'params' must not be null");
        }
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandler not set");
        }
        Map eventIdToolMap = this.M_ers.getEventIdToolMap();
        boolean showSite = this.M_rm.isReportColumnAvailable(params, "site");
        boolean showUser = this.M_rm.isReportColumnAvailable(params, "user");
        boolean showTool = this.M_rm.isReportColumnAvailable(params, "tool");
        boolean showEvent = this.M_rm.isReportColumnAvailable(params, "event");
        boolean showResource = this.M_rm.isReportColumnAvailable(params, "resource");
        boolean showResourceAction = this.M_rm.isReportColumnAvailable(params, "resource-action");
        boolean showDate = this.M_rm.isReportColumnAvailable(params, "date") || this.M_rm.isReportColumnAvailable(params, "month") || this.M_rm.isReportColumnAvailable(params, "year");
        boolean showLastDate = this.M_rm.isReportColumnAvailable(params, "last-date");
        boolean showTotal = this.M_rm.isReportColumnAvailable(params, "total");
        boolean showTotalVisits = this.M_rm.isReportColumnAvailable(params, "visits");
        boolean showTotalUnique = this.M_rm.isReportColumnAvailable(params, "unique-visits");
        boolean showDuration = this.M_rm.isReportColumnAvailable(params, "duration");
        for (Stat cs : data) {
            SiteVisits ss;
            Date date;
            ResourceStat rs;
            EventStat es;
            this.handler.startElement("datarow");
            this.setColumnDisplayInfo(params);
            if (showSite) {
                String siteId = cs.getSiteId();
                String site = null;
                try {
                    site = this.M_ss.getSite(siteId).getTitle();
                }
                catch (IdUnusedException e) {
                    site = this.msgs.getString("site_unknown");
                }
                this.handler.element("site", site);
            }
            if (showUser) {
                String userId = null;
                String userName = null;
                String id = cs.getUserId();
                if (id != null) {
                    if ("-".equals(id)) {
                        userId = "-";
                        userName = this.msgs.getString("user_anonymous");
                    } else if ("?".equals(id)) {
                        userId = "-";
                        userName = this.msgs.getString("user_anonymous_access");
                    } else {
                        try {
                            User user = this.M_uds.getUser(id);
                            userId = user.getDisplayId();
                            userName = this.M_sm.getUserNameForDisplay(user);
                        }
                        catch (UserNotDefinedException e1) {
                            userId = id;
                            userName = this.msgs.getString("user_unknown");
                        }
                    }
                } else {
                    userName = this.msgs.getString("user_unknown");
                }
                this.handler.element("userid", userId);
                this.handler.element("username", userName);
            }
            if (showTool) {
                es = (EventStat)cs;
                String toolId = es.getToolId();
                this.handler.element("tool", this.M_ers.getToolName(toolId == null ? "" : toolId));
                this.handler.element("showToolIcon", "true");
                this.handler.element("toolicon", "sitestats://" + this.M_ers.getToolIcon(toolId));
            }
            if (showEvent) {
                es = (EventStat)cs;
                String eventRef = es.getEventId();
                this.handler.element("event", this.M_ers.getEventName(eventRef == null ? "" : eventRef));
                ToolInfo toolInfo = (ToolInfo)eventIdToolMap.get(eventRef);
                if (toolInfo != null && !showTool) {
                    this.handler.element("showToolEventIcon", "true");
                    String toolId = toolInfo.getToolId();
                    this.handler.element("tooleventicon", "sitestats://" + this.M_ers.getToolIcon(toolId));
                } else {
                    this.handler.element("showToolEventIcon", "false");
                }
            }
            if (showResource) {
                rs = (ResourceStat)cs;
                String resName = this.M_sm.getResourceName(rs.getResourceRef());
                this.handler.element("resource", resName == null ? "" : resName);
                this.handler.element("resourceimg", "library://" + this.M_sm.getResourceImageLibraryRelativePath(rs.getResourceRef()));
            }
            if (showResourceAction) {
                rs = (ResourceStat)cs;
                String resAction = rs.getResourceAction();
                this.handler.element("action", resAction == null ? "" : this.msgs.getString("action_" + resAction));
            }
            if (showDate) {
                date = cs.getDate();
                if (this.M_rm.isReportColumnAvailable(params, "date")) {
                    this.handler.element("date", date == null ? "" : this.M_ts.newTime(date.getTime()).toStringLocalDate());
                } else if (this.M_rm.isReportColumnAvailable(params, "month")) {
                    this.handler.element("date", date == null ? "" : this.dateMonthFrmt.format(date));
                } else if (this.M_rm.isReportColumnAvailable(params, "year")) {
                    this.handler.element("date", date == null ? "" : this.dateYearFrmt.format(date));
                }
            }
            if (showLastDate) {
                date = cs.getDate();
                this.handler.element("lastdate", date == null ? "" : this.M_ts.newTime(date.getTime()).toStringLocalDate());
            }
            if (showTotal) {
                this.handler.element("total", String.valueOf(cs.getCount()));
            }
            if (showTotalVisits) {
                ss = (SiteVisits)cs;
                this.handler.element("totalVisits", String.valueOf(ss.getTotalVisits()));
            }
            if (showTotalUnique) {
                ss = (SiteVisits)cs;
                this.handler.element("totalUnique", String.valueOf(ss.getTotalUnique()));
            }
            if (showDuration) {
                ss = (SitePresence)cs;
                double durationInMin = ss.getDuration() == 0L ? 0.0 : Util.round((double)((double)ss.getDuration() / 1000.0 / 60.0), (int)1);
                this.handler.element("duration", String.valueOf(durationInMin));
            }
            this.handler.endElement("datarow");
        }
        if (data.size() == 0) {
            String messageNoData = this.msgs.getString("no_data");
            this.handler.startElement("datarow");
            this.setColumnDisplayInfo(params);
            if (showSite) {
                this.handler.element("site", messageNoData);
                messageNoData = "";
            }
            if (showUser) {
                this.handler.element("userid", messageNoData);
                messageNoData = "";
                this.handler.element("username", messageNoData);
            }
            if (showTool) {
                this.handler.element("tool", messageNoData);
                messageNoData = "";
                this.handler.element("showToolIcon", "");
                this.handler.element("toolicon", "");
            }
            if (showEvent) {
                this.handler.element("event", messageNoData);
                messageNoData = "";
                this.handler.element("showToolEventIcon", "false");
            }
            if (showResource) {
                this.handler.element("resource", messageNoData);
                messageNoData = "";
                this.handler.element("resourceimg", "");
            }
            if (showResourceAction) {
                this.handler.element("action", messageNoData);
                messageNoData = "";
            }
            if (showDate) {
                this.handler.element("date", messageNoData);
                messageNoData = "";
            }
            if (showLastDate) {
                this.handler.element("lastdate", messageNoData);
                messageNoData = "";
            }
            if (showTotal) {
                this.handler.element("total", messageNoData);
                messageNoData = "";
            }
            if (showTotalVisits) {
                this.handler.element("totalVisits", messageNoData);
                messageNoData = "";
            }
            if (showTotalUnique) {
                this.handler.element("totalUnique", messageNoData);
                messageNoData = "";
            }
            if (showDuration) {
                this.handler.element("duration", messageNoData);
                messageNoData = "";
            }
            this.handler.endElement("datarow");
        }
    }
}

