/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.parser;

import java.beans.IntrospectionException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.strategy.DefaultObjectStringConverter;
import org.apache.commons.betwixt.strategy.ObjectStringConverter;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.impl.parser.EventFactoryImpl;
import org.sakaiproject.sitestats.impl.parser.EventParserTipFactoryImpl;
import org.sakaiproject.sitestats.impl.parser.ToolFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterUtil {
    public static Digester configureToolEventsDefDigester(String prefix, Digester digester) {
        digester.addObjectCreate(prefix + "toolEventsDef", ArrayList.class);
        ToolFactoryImpl toolFactory = new ToolFactoryImpl();
        digester.addFactoryCreate(prefix + "toolEventsDef/tool", (ObjectCreationFactory)toolFactory);
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/toolId", "toolId");
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/additionalToolIds", "additionalToolIdsStr");
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/selected", "selected");
        digester.addSetNext(prefix + "toolEventsDef/tool", "add");
        EventFactoryImpl eventFactoryImpl = new EventFactoryImpl();
        digester.addFactoryCreate(prefix + "toolEventsDef/tool/event", (ObjectCreationFactory)eventFactoryImpl);
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/event/eventId", "eventId");
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/event/selected", "selected");
        digester.addBeanPropertySetter(prefix + "toolEventsDef/tool/event/anonymous", "anonymous");
        digester.addSetNext(prefix + "toolEventsDef/tool/event", "addEvent");
        return digester;
    }

    public static Digester configurePrefsDigester(Digester digester) {
        digester.addObjectCreate("prefs", PrefsData.class);
        digester.addSetProperties("prefs");
        digester.addBeanPropertySetter("prefs/listToolEventsOnlyAvailableInSite", "setListToolEventsOnlyAvailableInSite");
        digester.addBeanPropertySetter("prefs/chartIn3D", "setChartIn3D");
        digester.addBeanPropertySetter("prefs/chartTransparency", "setChartTransparency");
        digester.addBeanPropertySetter("prefs/itemLabelsVisible", "setItemLabelsVisible");
        digester.addBeanPropertySetter("prefs/useAllTools", "setUseAllTools");
        digester = DigesterUtil.configureToolEventsDefDigester("prefs/", digester);
        digester.addSetNext("prefs/toolEventsDef", "setToolEventsDef");
        return digester;
    }

    public static List<ToolInfo> parseToolEventsDefinition(InputStream input) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester = DigesterUtil.configureToolEventsDefDigester("", digester);
        EventParserTipFactoryImpl eventParserTipFactoryImpl = new EventParserTipFactoryImpl();
        digester.addFactoryCreate("toolEventsDef/tool/eventParserTip", (ObjectCreationFactory)eventParserTipFactoryImpl);
        digester.addSetNestedProperties("toolEventsDef/tool/eventParserTip");
        digester.addSetNext("toolEventsDef/tool/eventParserTip", "setEventParserTip");
        return (List)digester.parse(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportParams convertXmlToReportParams(String inputString) throws Exception {
        BeanReader beanReader = DigesterUtil.getBeanReader();
        StringReader reader = null;
        ReportParams reportParams = null;
        try {
            reader = new StringReader(inputString);
            reportParams = (ReportParams)beanReader.parse((Reader)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return reportParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertReportParamsToXml(ReportParams reportParams) throws Exception {
        String xml = null;
        StringWriter outputWriter = null;
        try {
            outputWriter = new StringWriter();
            outputWriter.write("<?xml version='1.0' ?>");
            BeanWriter beanWriter = DigesterUtil.getBeanWriter(outputWriter);
            beanWriter.write("ReportParams", (Object)reportParams);
            xml = outputWriter.toString();
        }
        finally {
            outputWriter.close();
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ReportDef> convertXmlToReportDefs(String inputString) throws Exception {
        BeanReader beanReader = DigesterUtil.getBeanReader();
        StringReader reader = null;
        List reportDefs = null;
        try {
            reader = new StringReader(inputString);
            reportDefs = (List)beanReader.parse((Reader)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return reportDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertReportDefsToXml(List<ReportDef> reportDef) throws Exception {
        String xml = null;
        StringWriter outputWriter = null;
        try {
            outputWriter = new StringWriter();
            outputWriter.write("<?xml version='1.0' ?>");
            BeanWriter beanWriter = DigesterUtil.getBeanWriter(outputWriter);
            beanWriter.write("List", reportDef);
            xml = outputWriter.toString();
        }
        finally {
            outputWriter.close();
        }
        return xml;
    }

    private static BeanWriter getBeanWriter(StringWriter outputWriter) {
        BeanWriter beanWriter = new BeanWriter((Writer)outputWriter);
        beanWriter.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.getBindingConfiguration().setValueSuppressionStrategy((ValueSuppressionStrategy)new NullEmptyValueSuppressionStrategy());
        beanWriter.getBindingConfiguration().setObjectStringConverter((ObjectStringConverter)new SitestatsObjectStringConverter());
        beanWriter.setEndOfLine("");
        return beanWriter;
    }

    private static BeanReader getBeanReader() throws IntrospectionException {
        BeanReader beanReader = new BeanReader();
        beanReader.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        beanReader.getBindingConfiguration().setMapIDs(false);
        beanReader.getBindingConfiguration().setValueSuppressionStrategy((ValueSuppressionStrategy)new NullEmptyValueSuppressionStrategy());
        beanReader.getBindingConfiguration().setObjectStringConverter((ObjectStringConverter)new SitestatsObjectStringConverter());
        beanReader.registerBeanClass("List", ArrayList.class);
        beanReader.registerBeanClass("ReportDef", ReportDef.class);
        beanReader.registerBeanClass("ReportParams", ReportParams.class);
        return beanReader;
    }

    private static class SitestatsObjectStringConverter
    extends DefaultObjectStringConverter {
        private SitestatsObjectStringConverter() {
        }

        public Object stringToObject(String value, Class type, String flavour, Context context) {
            if (value != null && !"".equals(value.trim())) {
                return super.stringToObject(value, type, flavour, context);
            }
            return null;
        }
    }

    private static class NullEmptyValueSuppressionStrategy
    extends ValueSuppressionStrategy {
        private NullEmptyValueSuppressionStrategy() {
        }

        public boolean suppressAttribute(AttributeDescriptor attributeDescriptor, String value) {
            return value == null || "".equals(value.trim());
        }
    }
}

