/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentTypeImageService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.api.CommonStatGrpByDate;
import org.sakaiproject.sitestats.api.EventStat;
import org.sakaiproject.sitestats.api.Prefs;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.ResourceStat;
import org.sakaiproject.sitestats.api.SiteActivity;
import org.sakaiproject.sitestats.api.SiteActivityByTool;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.Stat;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.SummaryActivityChartData;
import org.sakaiproject.sitestats.api.SummaryActivityTotals;
import org.sakaiproject.sitestats.api.SummaryVisitsChartData;
import org.sakaiproject.sitestats.api.SummaryVisitsTotals;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.impl.CommonStatGrpByDateImpl;
import org.sakaiproject.sitestats.impl.EventStatImpl;
import org.sakaiproject.sitestats.impl.PrefsImpl;
import org.sakaiproject.sitestats.impl.ResourceStatImpl;
import org.sakaiproject.sitestats.impl.SiteActivityByToolImpl;
import org.sakaiproject.sitestats.impl.SiteActivityImpl;
import org.sakaiproject.sitestats.impl.SitePresenceImpl;
import org.sakaiproject.sitestats.impl.SiteVisitsImpl;
import org.sakaiproject.sitestats.impl.SummaryActivityChartDataImpl;
import org.sakaiproject.sitestats.impl.SummaryActivityTotalsImpl;
import org.sakaiproject.sitestats.impl.SummaryVisitsChartDataImpl;
import org.sakaiproject.sitestats.impl.SummaryVisitsTotalsImpl;
import org.sakaiproject.sitestats.impl.event.EventUtil;
import org.sakaiproject.sitestats.impl.parser.DigesterUtil;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsManagerImpl
extends HibernateDaoSupport
implements StatsManager,
Observer {
    private Log LOG = LogFactory.getLog(StatsManagerImpl.class);
    private Boolean enableSiteVisits = null;
    private Boolean enableSiteActivity = null;
    private Boolean enableResourceStats = null;
    private Boolean enableSitePresences = null;
    private Boolean visitsInfoAvailable = null;
    private boolean enableServerWideStats = false;
    private boolean countFilesUsingCHS = true;
    private String chartBackgroundColor = "white";
    private boolean chartIn3D = true;
    private float chartTransparency = 0.8f;
    private boolean itemLabelsVisible = false;
    private boolean lastJobRunDateVisible = true;
    private boolean isEventContextSupported = false;
    private boolean enableReportExport = true;
    private boolean sortUsersByDisplayName = false;
    private boolean showAnonymousAccessEvents = true;
    private static ResourceLoader msgs = new ResourceLoader("Messages");
    private EventRegistryService M_ers;
    private UserDirectoryService M_uds;
    private SiteService M_ss;
    private ServerConfigurationService M_scs;
    private ToolManager M_tm;
    private MemoryService M_ms;
    private SessionManager M_sm;
    private EventTrackingService M_ets;
    private EntityManager M_em;
    private ContentHostingService M_chs;
    private ContentTypeImageService M_ctis;
    private Cache cachePrefsData = null;

    public void setEnableSiteVisits(Boolean enableSiteVisits) {
        this.enableSiteVisits = enableSiteVisits;
    }

    public void setEnableSiteVisits(boolean enableSiteVisits) {
        this.enableSiteVisits = enableSiteVisits;
    }

    public boolean isEnableSiteVisits() {
        return this.enableSiteVisits;
    }

    public void setEnableSiteActivity(Boolean enableSiteActivity) {
        this.enableSiteActivity = enableSiteActivity;
    }

    public void setEnableSiteActivity(boolean enableSiteActivity) {
        this.enableSiteActivity = enableSiteActivity;
    }

    public void setServerWideStatsEnabled(boolean enableServerWideStats) {
        this.enableServerWideStats = enableServerWideStats;
    }

    public boolean isServerWideStatsEnabled() {
        return this.enableServerWideStats;
    }

    public boolean isEnableSiteActivity() {
        return this.enableSiteActivity;
    }

    public void setVisitsInfoAvailable(Boolean available) {
        this.visitsInfoAvailable = available;
    }

    public boolean isVisitsInfoAvailable() {
        return this.visitsInfoAvailable;
    }

    public void setEnableResourceStats(Boolean enableResourceStats) {
        this.enableResourceStats = enableResourceStats;
    }

    public void setEnableResourceStats(boolean enableResourceStats) {
        this.enableResourceStats = enableResourceStats;
    }

    public boolean isEnableResourceStats() {
        return this.enableResourceStats;
    }

    public void setEnableSitePresences(Boolean enableSitePresences) {
        this.enableSitePresences = enableSitePresences;
    }

    public void setEnableSitePresences(boolean enableSitePresences) {
        this.enableSitePresences = enableSitePresences;
    }

    public boolean isEnableSitePresences() {
        return this.enableSitePresences;
    }

    public void setCountFilesUsingCHS(boolean countFilesUsingCHS) {
        this.countFilesUsingCHS = countFilesUsingCHS;
    }

    public void setChartBackgroundColor(String color) {
        this.chartBackgroundColor = color;
    }

    public String getChartBackgroundColor() {
        return this.chartBackgroundColor;
    }

    public void setChartIn3D(boolean value) {
        this.chartIn3D = value;
    }

    public boolean isChartIn3D() {
        return this.chartIn3D;
    }

    public void setChartTransparency(float value) {
        this.chartTransparency = value;
    }

    public float getChartTransparency() {
        return this.chartTransparency;
    }

    public void setItemLabelsVisible(boolean itemLabelsVisible) {
        this.itemLabelsVisible = itemLabelsVisible;
    }

    public boolean isItemLabelsVisible() {
        return this.itemLabelsVisible;
    }

    public void setShowAnonymousAccessEvents(boolean value) {
        this.showAnonymousAccessEvents = value;
    }

    public boolean isShowAnonymousAccessEvents() {
        return this.showAnonymousAccessEvents;
    }

    public void setLastJobRunDateVisible(boolean value) {
        this.lastJobRunDateVisible = value;
    }

    public boolean isLastJobRunDateVisible() {
        return this.lastJobRunDateVisible;
    }

    public void setSortUsersByDisplayName(boolean sortUsersByDisplayName) {
        this.sortUsersByDisplayName = sortUsersByDisplayName;
    }

    public boolean isSortUsersByDisplayName() {
        return this.sortUsersByDisplayName;
    }

    public void setEventRegistryService(EventRegistryService eventRegistryService) {
        this.M_ers = eventRegistryService;
    }

    public void setUserService(UserDirectoryService userService) {
        this.M_uds = userService;
    }

    public void setSiteService(SiteService siteService) {
        this.M_ss = siteService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.M_scs = serverConfigurationService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.M_tm = toolManager;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.M_ms = memoryService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.M_sm = sessionManager;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.M_ets = eventTrackingService;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.M_em = entityManager;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.M_chs = contentHostingService;
    }

    public void setContentTypeImageService(ContentTypeImageService contentTypeImageService) {
        this.M_ctis = contentTypeImageService;
    }

    public void setResourceLoader(ResourceLoader msgs) {
        StatsManagerImpl.msgs = msgs;
    }

    public void setEnableReportExport(boolean enableReportExport) {
        this.enableReportExport = enableReportExport;
    }

    public boolean isEnableReportExport() {
        return this.enableReportExport;
    }

    public void init() {
        this.checkAndSetDefaultPropertiesIfNotSet();
        this.checkForEventContextSupport();
        this.M_ets.addPriorityObserver((Observer)this);
        this.cachePrefsData = this.M_ms.newCache(PrefsData.class.getName());
        this.logger.info((Object)("init(): - (Event.getContext()?, site visits enabled, charts background color, charts in 3D, charts transparency, item labels visible on bar charts) : " + this.isEventContextSupported + ',' + this.enableSiteVisits + ',' + this.chartBackgroundColor + ',' + this.chartIn3D + ',' + this.chartTransparency + ',' + this.itemLabelsVisible));
    }

    public void checkAndSetDefaultPropertiesIfNotSet() {
        if (this.enableSiteVisits == null) {
            this.enableSiteVisits = this.M_scs.getBoolean("display.users.present", false) || this.M_scs.getBoolean("presence.events.log", false);
        }
        if (this.visitsInfoAvailable == null) {
            this.visitsInfoAvailable = this.enableSiteVisits;
        }
        if (this.enableSiteActivity == null) {
            this.enableSiteActivity = true;
        }
        if (this.enableResourceStats == null) {
            this.enableResourceStats = true;
        }
        if (this.enableSitePresences == null) {
            this.enableSitePresences = false;
        } else if (this.enableSitePresences.booleanValue()) {
            if (this.M_scs.getBoolean("display.users.present", false)) {
                this.enableSitePresences = this.M_scs.getBoolean("display.users.present", false);
            } else if (this.M_scs.getBoolean("presence.events.log", false)) {
                this.enableSitePresences = false;
                this.LOG.warn((Object)"Disabled SiteStats presence tracking: doesn't work properly with 'presence.events.log' => only plays nicely with 'display.users.present'");
            }
        }
    }

    public void destroy() {
        this.M_ets.deleteObserver((Observer)this);
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o instanceof Event) {
            Event e = (Event)o;
            String event = "sitestats.prefs.edit";
            if (e.getEvent() != null && e.getEvent().equals(event)) {
                String siteId = e.getResource().split("/")[2];
                this.cachePrefsData.expire((Object)siteId);
                this.LOG.debug((Object)("Expiring preferences cache for site: " + siteId));
            }
        }
    }

    private PrefsData parseSitePrefs(InputStream input) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester = DigesterUtil.configurePrefsDigester(digester);
        return (PrefsData)digester.parse(input);
    }

    public PrefsData getPreferences(final String siteId, boolean includeUnselected) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        PrefsData prefsdata = null;
        Object cached = this.cachePrefsData.get((Object)siteId);
        if (cached != null) {
            prefsdata = (PrefsData)cached;
            this.LOG.debug((Object)("Getting preferences for site " + siteId + " from cache"));
        } else {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Criteria c = session.createCriteria(PrefsImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
                    try {
                        Prefs prefs = (Prefs)c.uniqueResult();
                        return prefs;
                    }
                    catch (Exception e) {
                        StatsManagerImpl.this.LOG.warn((Object)"Exception in getPreferences() ", (Throwable)e);
                        return null;
                    }
                }
            };
            Prefs prefs = (Prefs)this.getHibernateTemplate().execute(hcb);
            if (prefs == null) {
                prefsdata = new PrefsData();
                prefsdata.setChartIn3D(this.isChartIn3D());
                prefsdata.setChartTransparency(this.getChartTransparency());
                prefsdata.setItemLabelsVisible(this.isItemLabelsVisible());
                prefsdata.setToolEventsDef(this.M_ers.getEventRegistry());
            } else {
                try {
                    prefsdata = this.parseSitePrefs(new ByteArrayInputStream(prefs.getPrefs().getBytes()));
                }
                catch (Exception e) {
                    this.LOG.warn((Object)"Exception in parseSitePrefs() ", (Throwable)e);
                    prefsdata = new PrefsData();
                    prefsdata.setToolEventsDef(this.M_ers.getEventRegistry());
                }
            }
            this.cachePrefsData.put((Object)siteId, (Object)prefsdata);
        }
        if (prefsdata.isUseAllTools()) {
            List allTools = this.M_ers.getEventRegistry();
            for (ToolInfo ti : allTools) {
                ti.setSelected(true);
                for (EventInfo ei : ti.getEvents()) {
                    ei.setSelected(true);
                }
            }
            prefsdata.setToolEventsDef(allTools);
        }
        if (includeUnselected) {
            prefsdata.setToolEventsDef(EventUtil.getUnionWithAllDefaultToolEvents(prefsdata.getToolEventsDef(), this.M_ers.getEventRegistry()));
        }
        if (prefsdata.isListToolEventsOnlyAvailableInSite()) {
            prefsdata.setToolEventsDef(EventUtil.getIntersectionWithAvailableToolsInSite(this.M_ss, prefsdata.getToolEventsDef(), siteId));
        } else {
            prefsdata.setToolEventsDef(EventUtil.getIntersectionWithAvailableToolsInSakaiInstallation(this.M_tm, prefsdata.getToolEventsDef()));
        }
        prefsdata.setToolEventsDef(EventUtil.addMissingAdditionalToolIds(prefsdata.getToolEventsDef(), this.M_ers.getEventRegistry()));
        return prefsdata;
    }

    public boolean setPreferences(final String siteId, final PrefsData prefsdata) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        if (prefsdata == null) {
            throw new IllegalArgumentException("Null preferences");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Transaction tx = null;
                try {
                    tx = session.beginTransaction();
                    Criteria c = session.createCriteria(PrefsImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
                    Prefs prefs = (Prefs)c.uniqueResult();
                    if (prefs == null) {
                        prefs = new PrefsImpl();
                        prefs.setSiteId(siteId);
                    }
                    prefs.setPrefs(prefsdata.toXmlPrefs());
                    session.saveOrUpdate((Object)prefs);
                    tx.commit();
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    StatsManagerImpl.this.LOG.warn((Object)"Unable to commit transaction: ", (Throwable)e);
                    return Boolean.FALSE;
                }
            }
        };
        Boolean success = (boolean)((Boolean)this.getHibernateTemplate().execute(hcb));
        if (success.booleanValue()) {
            this.logEvent(prefsdata, "edit", siteId, false);
        }
        return success;
    }

    public Set<String> getSiteUsers(String siteId) {
        try {
            if (siteId == null) {
                siteId = this.M_tm.getCurrentPlacement().getContext();
            }
            return this.M_ss.getSite(siteId).getUsers();
        }
        catch (IdUnusedException e) {
            this.LOG.warn((Object)("Inexistent site for site id: " + siteId));
            return null;
        }
    }

    public String getUserNameForDisplay(String userId) {
        String name = null;
        try {
            User user = this.M_uds.getUser(userId);
            name = this.getUserNameForDisplay(user);
        }
        catch (UserNotDefinedException e) {
            name = msgs.getString("user_unknown");
        }
        return name;
    }

    public String getUserNameForDisplay(User user) {
        if (this.isSortUsersByDisplayName()) {
            return user.getDisplayName();
        }
        return user.getSortName();
    }

    public Set<String> getUsersWithVisits(final String siteId) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "select distinct s.userId from EventStatImpl as s where s.siteId = :siteid and s.eventId = :eventId";
                Query q = session.createQuery("select distinct s.userId from EventStatImpl as s where s.siteId = :siteid and s.eventId = :eventId");
                q.setString("siteid", siteId);
                q.setString("eventId", "pres.begin");
                return new HashSet(q.list());
            }
        };
        return (Set)this.getHibernateTemplate().execute(hcb);
    }

    public String getResourceName(String ref) {
        return this.getResourceName(ref, true);
    }

    public String getResourceName(String ref, boolean includeLocationPrefix) {
        if (ref == null) {
            return null;
        }
        String[] parts = ref.split("\\/");
        Reference r = this.M_em.newReference(ref);
        ResourceProperties rp = null;
        String name = null;
        if (r != null) {
            rp = r.getProperties();
            if (rp != null) {
                name = rp.getProperty("DAV:displayname");
            } else {
                if (parts.length >= 2) {
                    name = parts[parts.length - 1];
                }
                if ("".equals(name) && parts.length >= 3) {
                    name = parts[parts.length - 2];
                }
            }
        }
        StringBuffer _fileName = new StringBuffer("");
        if (includeLocationPrefix) {
            if (parts.length >= 4 && parts[2].equals("user")) {
                _fileName.append("[");
                try {
                    _fileName.append(this.M_ss.getSite(this.M_ss.getSiteUserId(parts[3])).getTitle());
                }
                catch (IdUnusedException e) {
                    _fileName.append("My Workspace");
                }
                _fileName.append("] ");
            } else if (parts[2].equals("attachment")) {
                if (parts.length >= 5) {
                    _fileName.append("[");
                    _fileName.append(msgs.getString("report_content_attachments"));
                    _fileName.append(": ");
                    _fileName.append(parts[4]);
                    _fileName.append("] ");
                } else {
                    _fileName.append("[");
                    _fileName.append(msgs.getString("report_content_attachments"));
                    _fileName.append("] ");
                }
            } else if ((parts.length <= 4 || !parts[2].equals("group")) && parts.length > 4 && parts[2].equals("group-user")) {
                _fileName.append("[");
                _fileName.append(this.M_tm.getTool("sakai.dropbox").getTitle());
                if (parts.length > 5) {
                    _fileName.append(": ");
                    String user = null;
                    try {
                        StringBuilder refU = new StringBuilder();
                        for (int i = 0; i < 5; ++i) {
                            refU.append(parts[i]);
                            refU.append('/');
                        }
                        Reference rU = this.M_em.newReference(refU.toString());
                        ResourceProperties rpU = rU.getProperties();
                        user = rpU.getProperty("DAV:displayname");
                    }
                    catch (Exception e1) {
                        try {
                            user = this.M_uds.getUserEid(parts[4]);
                        }
                        catch (UserNotDefinedException e2) {
                            user = parts[4];
                        }
                    }
                    _fileName.append(user);
                    _fileName.append("] ");
                } else {
                    _fileName.append("] ");
                }
            }
        }
        _fileName.append(name);
        return _fileName.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    private String getResourceName_ManualParse(String ref) {
        if (ref == null) {
            return null;
        }
        String[] parts = ref.split("\\/");
        StringBuffer _fileName = new StringBuffer("");
        if (parts == null || parts.length < 3 || parts[2].equals("user")) {
            return null;
        }
        if (parts[2].equals("attachment")) {
            if (parts.length <= 4) {
                return null;
            }
            if (!parts[4].equals("Choose File")) return null;
            if (parts.length <= 6) {
                return null;
            }
            _fileName.append("attachment");
            _fileName.append("/");
            for (int i = 6; i < parts.length - 1; ++i) {
                _fileName.append(parts[i] + "/");
            }
            _fileName.append(parts[parts.length - 1]);
        } else if (parts[2].equals("group")) {
            if (parts.length <= 4) {
                return null;
            }
            for (int i = 4; i < parts.length - 1; ++i) {
                _fileName.append(parts[i] + "/");
            }
            _fileName.append(parts[parts.length - 1]);
        } else if (parts[2].equals("group-user")) {
            if (parts.length <= 5) {
                return null;
            }
            String userEid = null;
            try {
                userEid = this.M_uds.getUserEid(parts[4]);
            }
            catch (UserNotDefinedException e) {
                userEid = parts[4];
            }
            _fileName.append(userEid);
            _fileName.append("/");
            for (int i = 5; i < parts.length - 1; ++i) {
                _fileName.append(parts[i] + "/");
            }
            _fileName.append(parts[parts.length - 1]);
        }
        String fileName = _fileName.toString();
        if (!fileName.trim().equals("")) return fileName;
        return null;
    }

    public String getResourceImageLibraryRelativePath(String ref) {
        boolean isCollection;
        Reference r = this.M_em.newReference(ref);
        ResourceProperties rp = null;
        if (r != null) {
            rp = r.getProperties();
        }
        if (rp != null) {
            try {
                isCollection = rp.getBooleanProperty(rp.getNamePropIsCollection());
            }
            catch (EntityPropertyNotDefinedException e) {
                isCollection = false;
            }
            catch (EntityPropertyTypeException e) {
                isCollection = false;
            }
        } else {
            isCollection = false;
        }
        String imgLink = "";
        try {
            String contentType;
            imgLink = isCollection ? this.M_ctis.getContentTypeImage("folder") : (rp != null ? ((contentType = rp.getProperty(rp.getNamePropContentType())) != null ? this.M_ctis.getContentTypeImage(contentType) : "sakai/generic.gif") : "sakai/generic.gif");
        }
        catch (Exception e) {
            imgLink = "sakai/generic.gif";
        }
        return "image/" + imgLink;
    }

    public String getResourceImage(String ref) {
        return this.M_scs.getServerUrl() + "/library/" + this.getResourceImageLibraryRelativePath(ref);
    }

    public String getResourceURL(String ref) {
        try {
            String tmp = ref.replaceFirst("/content", "");
            if (tmp.endsWith("/")) {
                this.M_chs.checkCollection(tmp);
            } else {
                this.M_chs.checkResource(tmp);
            }
        }
        catch (IdUnusedException e) {
            return null;
        }
        catch (Exception e) {
            // empty catch block
        }
        Reference r = this.M_em.newReference(ref);
        if (r != null) {
            return Validator.escapeHtml((String)r.getUrl());
        }
        return null;
    }

    public int getTotalResources(final String siteId, final boolean excludeFolders) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        if (this.countFilesUsingCHS) {
            String siteCollectionId = this.M_chs.getSiteCollection(siteId);
            return this.M_chs.getAllResources(siteCollectionId).size();
        }
        String hql_ = "select s.siteId, sum(s.count) from ResourceStatImpl as s where s.siteId = :siteid and s.resourceAction = :resourceAction and s.resourceRef like :resourceRefLike ";
        if (excludeFolders) {
            hql_ = hql_ + "and s.resourceRef not like :resourceRefNotLike ";
        }
        final String hql = hql_ = hql_ + "group by s.siteId";
        final String resourceRefLike = "/content/group/" + siteId + "/%";
        String resourceRefNotLike = "%/";
        HibernateCallback hcb1 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                q.setString("resourceAction", "new");
                q.setString("resourceRefLike", resourceRefLike);
                if (excludeFolders) {
                    q.setString("resourceRefNotLike", "%/");
                }
                List list = q.list();
                Long total = 0L;
                if (list != null && list.size() > 0) {
                    try {
                        total = (Long)((Object[])list.get(0))[1];
                    }
                    catch (ClassCastException e) {
                        total = ((Integer)((Object[])list.get(0))[1]).longValue();
                    }
                }
                return total;
            }
        };
        Long totalNew = (Long)this.getHibernateTemplate().execute(hcb1);
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                q.setString("resourceAction", "delete");
                q.setString("resourceRefLike", resourceRefLike);
                if (excludeFolders) {
                    q.setString("resourceRefNotLike", "%/");
                }
                List list = q.list();
                Long total = 0L;
                if (list != null && list.size() > 0) {
                    try {
                        total = (Long)((Object[])list.get(0))[1];
                    }
                    catch (ClassCastException e) {
                        total = ((Integer)((Object[])list.get(0))[1]).longValue();
                    }
                }
                return total;
            }
        };
        Long totalDel = (Long)this.getHibernateTemplate().execute(hcb2);
        return (int)(totalNew - totalDel);
    }

    public SummaryVisitsTotals getSummaryVisitsTotals(String siteId) {
        SummaryVisitsTotalsImpl svt = new SummaryVisitsTotalsImpl();
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        Calendar cl = null;
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        cl = (Calendar)c.clone();
        cl.add(5, -6);
        Date lastWeek = cl.getTime();
        cl = (Calendar)c.clone();
        cl.add(5, -29);
        Date lastMonth = cl.getTime();
        cl = (Calendar)c.clone();
        c.add(2, -11);
        Date lastYear = cl.getTime();
        double last7DaysVisitsAverage = Util.round((double)((double)this.getTotalSiteVisits(siteId, lastWeek, now) / 7.0), (int)1);
        double last30DaysVisitsAverage = Util.round((double)((double)this.getTotalSiteVisits(siteId, lastMonth, now) / 30.0), (int)1);
        double last365DaysVisitsAverage = Util.round((double)((double)this.getTotalSiteVisits(siteId, lastYear, now) / 365.0), (int)1);
        svt.setLast7DaysVisitsAverage(last7DaysVisitsAverage);
        svt.setLast30DaysVisitsAverage(last30DaysVisitsAverage);
        svt.setLast365DaysVisitsAverage(last365DaysVisitsAverage);
        long totalSiteUniqueVisits = this.getTotalSiteUniqueVisits(siteId);
        long totalSiteVisits = this.getTotalSiteVisits(siteId);
        int totalSiteUsers = this.getTotalSiteUsers(siteId);
        double percentageOfUsersThatVisitedSite = totalSiteUsers == 0 ? 0.0 : (double)(100L * totalSiteUniqueVisits) / (double)totalSiteUsers;
        svt.setTotalUniqueVisits(totalSiteUniqueVisits);
        svt.setTotalVisits(totalSiteVisits);
        svt.setTotalUsers(totalSiteUsers);
        svt.setPercentageOfUsersThatVisitedSite(Util.round((double)percentageOfUsersThatVisitedSite, (int)1));
        return svt;
    }

    public SummaryActivityTotals getSummaryActivityTotals(String siteId) {
        PrefsData prefsdata = this.getPreferences(siteId, false);
        return this.getSummaryActivityTotals(siteId, prefsdata);
    }

    public SummaryActivityTotals getSummaryActivityTotals(String siteId, PrefsData prefsdata) {
        SummaryActivityTotalsImpl sat = new SummaryActivityTotalsImpl();
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        Calendar cl = null;
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        cl = (Calendar)c.clone();
        cl.add(5, -6);
        Date lastWeek = cl.getTime();
        cl = (Calendar)c.clone();
        cl.add(5, -29);
        Date lastMonth = cl.getTime();
        cl = (Calendar)c.clone();
        c.add(2, -11);
        Date lastYear = cl.getTime();
        double last7DaysActivityAverage = Util.round((double)((double)this.getTotalSiteActivity(siteId, prefsdata.getToolEventsStringList(), lastWeek, now) / 7.0), (int)1);
        double last30DaysActivityAverage = Util.round((double)((double)this.getTotalSiteActivity(siteId, prefsdata.getToolEventsStringList(), lastMonth, now) / 30.0), (int)1);
        double last365DaysActivityAverage = Util.round((double)((double)this.getTotalSiteActivity(siteId, prefsdata.getToolEventsStringList(), lastYear, now) / 365.0), (int)1);
        sat.setLast7DaysActivityAverage(last7DaysActivityAverage);
        sat.setLast30DaysActivityAverage(last30DaysActivityAverage);
        sat.setLast365DaysActivityAverage(last365DaysActivityAverage);
        long totalActivity = this.getTotalSiteActivity(siteId, prefsdata.getToolEventsStringList());
        sat.setTotalActivity(totalActivity);
        return sat;
    }

    public SummaryVisitsChartData getSummaryVisitsChartData(String siteId, String viewType) {
        SummaryVisitsChartDataImpl svc = new SummaryVisitsChartDataImpl(viewType);
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        Date finalDate = c.getTime();
        Date initialDate = null;
        List<SiteVisits> siteVisits = null;
        if ("week".equals(viewType)) {
            c.add(5, -6);
            initialDate = c.getTime();
            siteVisits = this.getSiteVisits(siteId, initialDate, finalDate);
        } else if ("month".equals(viewType)) {
            c.add(5, -29);
            initialDate = c.getTime();
            siteVisits = this.getSiteVisits(siteId, initialDate, finalDate);
        } else if ("year".equals(viewType)) {
            c.add(2, -11);
            initialDate = c.getTime();
            siteVisits = this.getSiteVisitsByMonth(siteId, initialDate, finalDate);
        }
        svc.setSiteVisits(siteVisits);
        return siteVisits != null && siteVisits.size() > 0 ? svc : null;
    }

    public SummaryActivityChartData getSummaryActivityChartData(String siteId, String viewType, String chartType) {
        PrefsData prefsdata = this.getPreferences(siteId, false);
        return this.getSummaryActivityChartData(siteId, prefsdata, viewType, chartType);
    }

    public SummaryActivityChartData getSummaryActivityChartData(String siteId, PrefsData prefsdata, String viewType, String chartType) {
        SummaryActivityChartDataImpl sac = new SummaryActivityChartDataImpl(viewType, chartType);
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        Date finalDate = c.getTime();
        Date initialDate = null;
        if ("bar".equals(chartType)) {
            List<SiteActivity> siteActivity = null;
            if ("week".equals(viewType)) {
                c.add(5, -6);
                initialDate = c.getTime();
                siteActivity = this.getSiteActivityByDay(siteId, prefsdata.getToolEventsStringList(), initialDate, finalDate);
            } else if ("month".equals(viewType)) {
                c.add(5, -29);
                initialDate = c.getTime();
                siteActivity = this.getSiteActivityByDay(siteId, prefsdata.getToolEventsStringList(), initialDate, finalDate);
            } else if ("year".equals(viewType)) {
                c.add(2, -11);
                initialDate = c.getTime();
                siteActivity = this.getSiteActivityByMonth(siteId, prefsdata.getToolEventsStringList(), initialDate, finalDate);
            }
            sac.setSiteActivity(siteActivity);
            return siteActivity != null && siteActivity.size() > 0 ? sac : null;
        }
        List<SiteActivityByTool> siteActivityByTool = null;
        if ("week".equals(viewType)) {
            c.add(5, -6);
            initialDate = c.getTime();
        } else if ("month".equals(viewType)) {
            c.add(5, -29);
            initialDate = c.getTime();
        } else if ("year".equals(viewType)) {
            c.add(2, -11);
            initialDate = c.getTime();
        }
        siteActivityByTool = this.getSiteActivityByTool(siteId, prefsdata.getToolEventsStringList(), initialDate, finalDate);
        sac.setSiteActivityByTool(siteActivityByTool);
        return siteActivityByTool.size() > 0 ? sac : null;
    }

    public List<Stat> getEventStats(String siteId, List<String> events) {
        return this.getEventStats(siteId, events, this.getInitialActivityDate(siteId), null, null, false, null, null, null, true, 0);
    }

    @Deprecated
    public List<EventStat> getEventStats(final String siteId, final List<String> events, String searchKey, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        final List<String> userIdList = this.searchUsers(searchKey, siteId);
        if (userIdList != null && userIdList.size() == 0) {
            return new ArrayList<EventStat>();
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(EventStatImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId)).add(Expression.in((String)"eventId", (Collection)events));
                if (!StatsManagerImpl.this.showAnonymousAccessEvents) {
                    c.add((Criterion)Expression.ne((String)"userId", (Object)"?"));
                }
                if (userIdList != null && userIdList.size() > 0) {
                    c.add(Expression.in((String)"userId", (Collection)userIdList));
                }
                if (iDate != null) {
                    c.add((Criterion)Expression.ge((String)"date", (Object)iDate));
                }
                if (fDate != null) {
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(fDate);
                    ca.add(6, 1);
                    Date fDate2 = ca.getTime();
                    c.add((Criterion)Expression.lt((String)"date", (Object)fDate2));
                }
                return c.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Deprecated
    public List<CommonStatGrpByDate> getEventStatsGrpByDate(final String siteId, final List<String> events, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, final PagingPosition page) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String usersStr = "";
        String iDateStr = "";
        String fDateStr = "";
        if (userIds != null && !userIds.isEmpty()) {
            usersStr = "and s.userId in (:users) ";
        }
        if (iDate != null) {
            iDateStr = "and s.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and s.date < :fdate ";
        }
        if (!this.showAnonymousAccessEvents) {
            usersStr = usersStr + " and s.userId != '?' ";
        }
        final String hql = "select s.siteId, s.userId, s.eventId, sum(s.count), max(s.date) from EventStatImpl as s where s.siteId = :siteid and s.eventId in (:events) " + usersStr + iDateStr + fDateStr + "group by s.siteId, s.userId, s.eventId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                q.setParameterList("events", (Collection)events);
                if (userIds != null && !userIds.isEmpty()) {
                    q.setParameterList("users", (Collection)userIds);
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                List records = q.list();
                ArrayList<CommonStatGrpByDateImpl> results = new ArrayList<CommonStatGrpByDateImpl>();
                Set<String> siteUserIds = null;
                if (inverseUserSelection) {
                    siteUserIds = StatsManagerImpl.this.getSiteUsers(siteId);
                }
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        if (!inverseUserSelection) {
                            CommonStatGrpByDateImpl c = new CommonStatGrpByDateImpl();
                            c.setSiteId((String)s[0]);
                            c.setUserId((String)s[1]);
                            c.setRef((String)s[2]);
                            c.setCount(((Long)s[3]).longValue());
                            c.setDate((Date)s[4]);
                            results.add(c);
                            continue;
                        }
                        siteUserIds.remove((String)s[1]);
                    }
                }
                if (inverseUserSelection) {
                    long id = 0L;
                    for (String userId : siteUserIds) {
                        CommonStatGrpByDateImpl c = new CommonStatGrpByDateImpl();
                        c.setId(id++);
                        c.setUserId(userId);
                        c.setSiteId(siteId);
                        c.setCount(0L);
                        results.add(c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getEventStats(final String siteId, final List<String> events, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, final PagingPosition page, final List<String> totalsBy, String sortBy, boolean sortAscending, final int maxResults) {
        final List anonymousEvents = this.M_ers.getAnonymousEventIds();
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 0, totalsBy, siteId, events, anonymousEvents, this.showAnonymousAccessEvents, null, null, iDate, fDate, userIds, inverseUserSelection, sortBy, sortAscending);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            /*
             * Could not resolve type clashes
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (events != null) {
                    if (events.isEmpty()) {
                        events.add("");
                    }
                    q.setParameterList("events", (Collection)events);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (columnMap.containsKey(StatsSqlBuilder.C_USER) && anonymousEvents != null && anonymousEvents.size() > 0) {
                    q.setParameterList("anonymousEvents", (Collection)anonymousEvents);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                if (maxResults > 0) {
                    q.setMaxResults(maxResults);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getEventStats(): " + q.getQueryString()));
                List records = q.list();
                ArrayList<EventStatImpl> results = new ArrayList<EventStatImpl>();
                Set<String> siteUserIds = null;
                if (inverseUserSelection) {
                    siteUserIds = StatsManagerImpl.this.getSiteUsers(siteId);
                }
                if (records.size() > 0) {
                    Calendar cal = Calendar.getInstance();
                    Map eventIdToolMap = StatsManagerImpl.this.M_ers.getEventIdToolMap();
                    boolean groupByTool = columnMap.containsKey(StatsSqlBuilder.C_TOOL) && !columnMap.containsKey(StatsSqlBuilder.C_EVENT);
                    boolean hasVisitsData = columnMap.containsKey(StatsSqlBuilder.C_VISITS);
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        if (!inverseUserSelection) {
                            ToolInfo ti;
                            int ix;
                            Object[] s = (Object[])iter.next();
                            Object c = null;
                            String toolId = null;
                            c = !hasVisitsData ? new EventStatImpl() : new SiteVisitsImpl();
                            if (columnMap.containsKey(StatsSqlBuilder.C_SITE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_SITE);
                                c.setSiteId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_USER)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_USER);
                                c.setUserId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_EVENT) && !hasVisitsData) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_EVENT);
                                ((EventStat)c).setEventId((String)s[ix]);
                                ti = (ToolInfo)eventIdToolMap.get((String)s[ix]);
                                toolId = ti != null ? ti.getToolId() : (String)s[ix];
                                ((EventStat)c).setToolId(toolId);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_TOOL) && !hasVisitsData) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_TOOL);
                                ti = (ToolInfo)eventIdToolMap.get((String)s[ix]);
                                toolId = ti != null ? ti.getToolId() : (String)s[ix];
                                ((EventStat)c).setToolId(toolId);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATE);
                                c.setDate((Date)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATEMONTH) && columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                int ixY = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int ixM = (Integer)columnMap.get(StatsSqlBuilder.C_DATEMONTH);
                                int yr = 0;
                                int mo = 0;
                                if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                                    yr = Integer.parseInt((String)s[ixY]);
                                    mo = Integer.parseInt((String)s[ixM]) - 1;
                                } else {
                                    yr = (Integer)s[ixY];
                                    mo = (Integer)s[ixM] - 1;
                                }
                                cal.set(1, yr);
                                cal.set(2, mo);
                                c.setDate(cal.getTime());
                            } else if (columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int yr = 0;
                                yr = StatsManagerImpl.this.getDbVendor().equals("oracle") ? Integer.parseInt((String)s[ix]) : (Integer)s[ix];
                                cal.set(1, yr);
                                c.setDate(cal.getTime());
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_TOTAL)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_TOTAL);
                                c.setCount(c.getCount() + (Long)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_VISITS)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_VISITS);
                                try {
                                    ((SiteVisits)c).setTotalVisits(((Long)s[ix]).longValue());
                                }
                                catch (ClassCastException cce) {
                                    ((SiteVisits)c).setTotalVisits((long)((Integer)s[ix]).intValue());
                                }
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_UNIQUEVISITS)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_UNIQUEVISITS);
                                try {
                                    ((SiteVisits)c).setTotalUnique(((Long)s[ix]).longValue());
                                }
                                catch (ClassCastException cce) {
                                    ((SiteVisits)c).setTotalUnique((long)((Integer)s[ix]).intValue());
                                }
                            }
                            if (!groupByTool) {
                                results.add((EventStatImpl)c);
                                continue;
                            }
                            boolean toolAggregated = false;
                            for (Stat s_ : results) {
                                EventStat es_ = (EventStat)s_;
                                if (!es_.equalExceptForCount(c)) continue;
                                es_.setCount(es_.getCount() + c.getCount());
                                toolAggregated = true;
                                break;
                            }
                            if (toolAggregated) continue;
                            results.add((EventStatImpl)c);
                            continue;
                        }
                        if (siteUserIds == null) continue;
                        siteUserIds.remove(iter.next());
                    }
                }
                if (inverseUserSelection) {
                    long id = 0L;
                    for (String userId : siteUserIds) {
                        EventStatImpl c = new EventStatImpl();
                        c.setId(id++);
                        c.setUserId(userId);
                        c.setSiteId(siteId);
                        c.setCount(0L);
                        results.add(c);
                    }
                } else if (StatsManagerImpl.this.getDbVendor().equals("oracle") && totalsBy.contains("user") && anonymousEvents != null && anonymousEvents.size() > 0) {
                    ArrayList<EventStat> consolidated = new ArrayList<EventStat>();
                    for (Stat s : results) {
                        EventStat es = (EventStat)s;
                        boolean found = false;
                        for (Object c : consolidated) {
                            EventStat esc = (EventStat)c;
                            if (!esc.equalExceptForCount((Object)es)) continue;
                            esc.setCount(esc.getCount() + es.getCount());
                            found = true;
                            break;
                        }
                        if (found) continue;
                        consolidated.add(es);
                    }
                    results = consolidated;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int getEventStatsRowCount(final String siteId, final List<String> events, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, List<String> totalsBy) {
        final List anonymousEvents = this.M_ers.getAnonymousEventIds();
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 0, totalsBy, siteId, events, anonymousEvents, this.showAnonymousAccessEvents, null, null, iDate, fDate, userIds, inverseUserSelection, null, true);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (events != null && !events.isEmpty()) {
                    q.setParameterList("events", (Collection)events);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (columnMap.containsKey(StatsSqlBuilder.C_USER) && anonymousEvents != null && anonymousEvents.size() > 0) {
                    q.setParameterList("anonymousEvents", (Collection)anonymousEvents);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getEventStatsRowCount(): " + q.getQueryString()));
                Integer rowCount = q.list().size();
                if (!inverseUserSelection) {
                    return rowCount;
                }
                return StatsManagerImpl.this.getSiteUsers(siteId).size() - rowCount;
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getPresenceStats(final String siteId, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, final PagingPosition page, List<String> totalsBy, String sortBy, boolean sortAscending, final int maxResults) {
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 4, totalsBy, siteId, null, null, this.showAnonymousAccessEvents, null, null, iDate, fDate, userIds, inverseUserSelection, sortBy, sortAscending);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                if (maxResults > 0) {
                    q.setMaxResults(maxResults);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getPresenceStats(): " + q.getQueryString()));
                List records = q.list();
                ArrayList<SitePresenceImpl> results = new ArrayList<SitePresenceImpl>();
                Set<String> siteUserIds = null;
                if (inverseUserSelection) {
                    siteUserIds = StatsManagerImpl.this.getSiteUsers(siteId);
                }
                if (records.size() > 0) {
                    Calendar cal = Calendar.getInstance();
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        if (!inverseUserSelection) {
                            int ix;
                            Object[] s = (Object[])iter.next();
                            SitePresenceImpl c = new SitePresenceImpl();
                            if (columnMap.containsKey(StatsSqlBuilder.C_SITE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_SITE);
                                c.setSiteId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_USER)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_USER);
                                c.setUserId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATE);
                                c.setDate((Date)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATEMONTH) && columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                int ixY = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int ixM = (Integer)columnMap.get(StatsSqlBuilder.C_DATEMONTH);
                                int yr = 0;
                                int mo = 0;
                                if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                                    yr = Integer.parseInt((String)s[ixY]);
                                    mo = Integer.parseInt((String)s[ixM]) - 1;
                                } else {
                                    yr = (Integer)s[ixY];
                                    mo = (Integer)s[ixM] - 1;
                                }
                                cal.set(1, yr);
                                cal.set(2, mo);
                                c.setDate(cal.getTime());
                            } else if (columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int yr = 0;
                                yr = StatsManagerImpl.this.getDbVendor().equals("oracle") ? Integer.parseInt((String)s[ix]) : (Integer)s[ix];
                                cal.set(1, yr);
                                c.setDate(cal.getTime());
                            }
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_DURATION);
                            c.setDuration(c.getDuration() + (Long)s[ix]);
                            results.add(c);
                            continue;
                        }
                        if (siteUserIds == null) continue;
                        siteUserIds.remove(iter.next());
                    }
                }
                if (inverseUserSelection) {
                    long id = 0L;
                    for (String userId : siteUserIds) {
                        SitePresenceImpl c = new SitePresenceImpl();
                        c.setId(id++);
                        c.setUserId(userId);
                        c.setSiteId(siteId);
                        c.setDuration(0L);
                        c.setCount(0L);
                        results.add(c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int getPresenceStatsRowCount(final String siteId, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, List<String> totalsBy) {
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 4, totalsBy, null, null, null, this.showAnonymousAccessEvents, null, null, iDate, fDate, userIds, inverseUserSelection, null, true);
        final String hql = sqlBuilder.getHQL();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getPresenceStatsRowCount(): " + q.getQueryString()));
                Integer rowCount = q.list().size();
                if (!inverseUserSelection) {
                    return rowCount;
                }
                return StatsManagerImpl.this.getSiteUsers(siteId).size() - rowCount;
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getResourceStats(String siteId) {
        return this.getResourceStats(siteId, null, null, this.getInitialActivityDate(siteId), null, null, false, null, null, null, true, 0);
    }

    @Deprecated
    public List<ResourceStat> getResourceStats(final String siteId, String searchKey, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        final List<String> userIdList = this.searchUsers(searchKey, siteId);
        if (userIdList != null && userIdList.size() == 0) {
            return new ArrayList<ResourceStat>();
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(ResourceStatImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
                if (!StatsManagerImpl.this.showAnonymousAccessEvents) {
                    c.add((Criterion)Expression.ne((String)"userId", (Object)"?"));
                }
                if (userIdList != null && userIdList.size() > 0) {
                    c.add(Expression.in((String)"userId", (Collection)userIdList));
                }
                if (iDate != null) {
                    c.add((Criterion)Expression.ge((String)"date", (Object)iDate));
                }
                if (fDate != null) {
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(fDate);
                    ca.add(6, 1);
                    Date fDate2 = ca.getTime();
                    c.add((Criterion)Expression.lt((String)"date", (Object)fDate2));
                }
                return c.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Deprecated
    public List<CommonStatGrpByDate> getResourceStatsGrpByDateAndAction(final String siteId, final String resourceAction, final List<String> resourceIds, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, final PagingPosition page) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String usersStr = "";
        String resourcesActionStr = "";
        String resourcesStr = "";
        String iDateStr = "";
        String fDateStr = "";
        if (userIds != null && !userIds.isEmpty()) {
            usersStr = "and s.userId in (:users) ";
        }
        if (resourceAction != null) {
            resourcesActionStr = "and s.resourceAction = :action ";
        }
        if (resourceIds != null && !resourceIds.isEmpty()) {
            resourcesStr = "and s.resourceRef in (:resources) ";
        }
        if (iDate != null) {
            iDateStr = "and s.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and s.date < :fdate ";
        }
        if (!this.showAnonymousAccessEvents) {
            usersStr = usersStr + " and s.userId != '?' ";
        }
        final String hql = "select s.siteId, s.userId, s.resourceRef, s.resourceAction, sum(s.count), max(s.date) from ResourceStatImpl as s where s.siteId = :siteid " + usersStr + resourcesActionStr + resourcesStr + iDateStr + fDateStr + "group by s.siteId, s.userId, s.resourceRef, s.resourceAction";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                if (userIds != null && !userIds.isEmpty()) {
                    q.setParameterList("users", (Collection)userIds);
                }
                if (resourceAction != null) {
                    q.setString("action", resourceAction);
                }
                if (resourceIds != null && !resourceIds.isEmpty()) {
                    q.setParameterList("resources", (Collection)resourceIds);
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                List records = q.list();
                ArrayList<CommonStatGrpByDateImpl> results = new ArrayList<CommonStatGrpByDateImpl>();
                Set<String> siteUserIds = null;
                if (inverseUserSelection) {
                    siteUserIds = StatsManagerImpl.this.getSiteUsers(siteId);
                }
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        if (!inverseUserSelection) {
                            CommonStatGrpByDateImpl c = new CommonStatGrpByDateImpl();
                            c.setSiteId((String)s[0]);
                            c.setUserId((String)s[1]);
                            c.setRef((String)s[2]);
                            c.setRefImg(StatsManagerImpl.this.getResourceImage((String)s[2]));
                            c.setRefUrl(StatsManagerImpl.this.getResourceURL((String)s[2]));
                            c.setRefAction((String)s[3]);
                            c.setCount(((Long)s[4]).longValue());
                            c.setDate((Date)s[5]);
                            results.add(c);
                            continue;
                        }
                        siteUserIds.remove((String)s[1]);
                    }
                }
                if (inverseUserSelection) {
                    long id = 0L;
                    for (String userId : siteUserIds) {
                        CommonStatGrpByDateImpl c = new CommonStatGrpByDateImpl();
                        c.setId(id++);
                        c.setUserId(userId);
                        c.setSiteId(siteId);
                        c.setCount(0L);
                        results.add(c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getResourceStats(final String siteId, final String resourceAction, final List<String> resourceIds, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, final PagingPosition page, List<String> totalsBy, String sortBy, boolean sortAscending, final int maxResults) {
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 1, totalsBy, siteId, null, null, this.showAnonymousAccessEvents, resourceAction, resourceIds, iDate, fDate, userIds, inverseUserSelection, sortBy, sortAscending);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (resourceAction != null) {
                    q.setString("action", resourceAction);
                }
                if (resourceIds != null && !resourceIds.isEmpty()) {
                    ArrayList<String> simpleResourceIds = new ArrayList<String>();
                    ArrayList<String> wildcardResourceIds = new ArrayList<String>();
                    for (String rId : resourceIds) {
                        if (rId.endsWith("/")) {
                            wildcardResourceIds.add(rId + "%");
                            continue;
                        }
                        simpleResourceIds.add(rId);
                    }
                    if (simpleResourceIds.size() > 0) {
                        q.setParameterList("resources", (Collection)resourceIds);
                    }
                    for (int i = 0; i < wildcardResourceIds.size(); ++i) {
                        q.setString("resource" + i, (String)wildcardResourceIds.get(i));
                    }
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                if (maxResults > 0) {
                    q.setMaxResults(maxResults);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getResourceStats(): " + q.getQueryString()));
                List records = q.list();
                ArrayList<ResourceStatImpl> results = new ArrayList<ResourceStatImpl>();
                Set<String> siteUserIds = null;
                if (inverseUserSelection) {
                    siteUserIds = StatsManagerImpl.this.getSiteUsers(siteId);
                }
                if (records.size() > 0) {
                    Calendar cal = Calendar.getInstance();
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        if (!inverseUserSelection) {
                            int ix;
                            Object[] s = (Object[])iter.next();
                            ResourceStatImpl c = new ResourceStatImpl();
                            if (columnMap.containsKey(StatsSqlBuilder.C_SITE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_SITE);
                                c.setSiteId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_USER)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_USER);
                                c.setUserId((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_RESOURCE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_RESOURCE);
                                c.setResourceRef((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_RESOURCE_ACTION)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_RESOURCE_ACTION);
                                c.setResourceAction((String)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATE)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATE);
                                c.setDate((Date)s[ix]);
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_DATEMONTH) && columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                int ixY = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int ixM = (Integer)columnMap.get(StatsSqlBuilder.C_DATEMONTH);
                                int yr = 0;
                                int mo = 0;
                                if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                                    yr = Integer.parseInt((String)s[ixY]);
                                    mo = Integer.parseInt((String)s[ixM]) - 1;
                                } else {
                                    yr = (Integer)s[ixY];
                                    mo = (Integer)s[ixM] - 1;
                                }
                                cal.set(1, yr);
                                cal.set(2, mo);
                                c.setDate(cal.getTime());
                            } else if (columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                                int yr = 0;
                                yr = StatsManagerImpl.this.getDbVendor().equals("oracle") ? Integer.parseInt((String)s[ix]) : (Integer)s[ix];
                                cal.set(1, yr);
                                c.setDate(cal.getTime());
                            }
                            if (columnMap.containsKey(StatsSqlBuilder.C_TOTAL)) {
                                ix = (Integer)columnMap.get(StatsSqlBuilder.C_TOTAL);
                                c.setCount(((Long)s[ix]).longValue());
                            }
                            results.add(c);
                            continue;
                        }
                        if (siteUserIds == null) continue;
                        siteUserIds.remove(iter.next());
                    }
                }
                if (inverseUserSelection) {
                    long id = 0L;
                    for (String userId : siteUserIds) {
                        ResourceStatImpl c = new ResourceStatImpl();
                        c.setId(id++);
                        c.setUserId(userId);
                        c.setSiteId(siteId);
                        c.setCount(0L);
                        results.add(c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public int getResourceStatsRowCount(final String siteId, final String resourceAction, final List<String> resourceIds, final Date iDate, final Date fDate, final List<String> userIds, final boolean inverseUserSelection, List<String> totalsBy) {
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 1, totalsBy, siteId, null, null, this.showAnonymousAccessEvents, resourceAction, resourceIds, iDate, fDate, userIds, inverseUserSelection, null, true);
        final String hql = sqlBuilder.getHQL();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (userIds != null && !userIds.isEmpty()) {
                    if (userIds.size() <= 1000) {
                        q.setParameterList("users", (Collection)userIds);
                    } else {
                        int nUsers = userIds.size();
                        int blockId = 0;
                        int startIndex = 0;
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            q.setParameterList("users" + blockId, userIds.subList(startIndex, startIndex + 1000));
                            ++blockId;
                            startIndex += 1000;
                        }
                        q.setParameterList("users" + blockId, userIds.subList(startIndex, nUsers));
                    }
                }
                if (resourceAction != null) {
                    q.setString("action", resourceAction);
                }
                if (resourceIds != null && !resourceIds.isEmpty()) {
                    q.setParameterList("resources", (Collection)resourceIds);
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getEventStatsRowCount(): " + q.getQueryString()));
                Integer rowCount = q.list().size();
                if (!inverseUserSelection) {
                    return rowCount;
                }
                return StatsManagerImpl.this.getSiteUsers(siteId).size() - rowCount;
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getVisitsTotalsStats(final String siteId, final Date iDate, final Date fDate, final PagingPosition page, List<String> totalsBy, String sortBy, boolean sortAscending, final int maxResults) {
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 2, totalsBy, siteId, null, null, this.showAnonymousAccessEvents, null, null, iDate, fDate, null, false, sortBy, sortAscending);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                if (maxResults > 0) {
                    q.setMaxResults(maxResults);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getVisitsTotalsStats(): " + q.getQueryString()));
                List records = q.list();
                ArrayList<SiteVisitsImpl> results = new ArrayList<SiteVisitsImpl>();
                if (records.size() > 0) {
                    Calendar cal = Calendar.getInstance();
                    for (Object[] s : records) {
                        int ix;
                        SiteVisitsImpl c = new SiteVisitsImpl();
                        if (columnMap.containsKey(StatsSqlBuilder.C_SITE)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_SITE);
                            c.setSiteId((String)s[ix]);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_DATE)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATE);
                            c.setDate((Date)s[ix]);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_DATEMONTH) && columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                            int ixY = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                            int ixM = (Integer)columnMap.get(StatsSqlBuilder.C_DATEMONTH);
                            int yr = 0;
                            int mo = 0;
                            if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                                yr = Integer.parseInt((String)s[ixY]);
                                mo = Integer.parseInt((String)s[ixM]) - 1;
                            } else {
                                yr = (Integer)s[ixY];
                                mo = (Integer)s[ixM] - 1;
                            }
                            cal.set(1, yr);
                            cal.set(2, mo);
                            c.setDate(cal.getTime());
                        } else if (columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                            int yr = 0;
                            yr = StatsManagerImpl.this.getDbVendor().equals("oracle") ? Integer.parseInt((String)s[ix]) : (Integer)s[ix];
                            cal.set(1, yr);
                            c.setDate(cal.getTime());
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_VISITS)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_VISITS);
                            try {
                                c.setTotalVisits(((Long)s[ix]).longValue());
                            }
                            catch (ClassCastException cce) {
                                c.setTotalVisits((long)((Integer)s[ix]).intValue());
                            }
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_UNIQUEVISITS)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_UNIQUEVISITS);
                            try {
                                c.setTotalUnique(((Long)s[ix]).longValue());
                            }
                            catch (ClassCastException cce) {
                                c.setTotalUnique((long)((Integer)s[ix]).intValue());
                            }
                        }
                        results.add(c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<Stat> getActivityTotalsStats(final String siteId, final List<String> events, final Date iDate, final Date fDate, final PagingPosition page, List<String> totalsBy, String sortBy, boolean sortAscending, final int maxResults) {
        final List anonymousEvents = this.M_ers.getAnonymousEventIds();
        StatsSqlBuilder sqlBuilder = new StatsSqlBuilder(this.getDbVendor(), 3, totalsBy, siteId, events, anonymousEvents, this.showAnonymousAccessEvents, null, null, iDate, fDate, null, false, sortBy, sortAscending);
        final String hql = sqlBuilder.getHQL();
        final Map<Integer, Integer> columnMap = sqlBuilder.getHQLColumnMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                if (siteId != null) {
                    q.setString("siteid", siteId);
                }
                if (events != null) {
                    if (events.isEmpty()) {
                        events.add("");
                    }
                    q.setParameterList("events", (Collection)events);
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if (columnMap.containsKey(StatsSqlBuilder.C_USER) && anonymousEvents != null && anonymousEvents.size() > 0) {
                    q.setParameterList("anonymousEvents", (Collection)anonymousEvents);
                }
                if (page != null) {
                    q.setFirstResult(page.getFirst() - 1);
                    q.setMaxResults(page.getLast() - page.getFirst() + 1);
                }
                if (maxResults > 0) {
                    q.setMaxResults(maxResults);
                }
                StatsManagerImpl.this.LOG.debug((Object)("getActivityTotalsStats(): " + q.getQueryString()));
                List records = q.list();
                ArrayList<EventStatImpl> results = new ArrayList<EventStatImpl>();
                if (records.size() > 0) {
                    Calendar cal = Calendar.getInstance();
                    Map eventIdToolMap = StatsManagerImpl.this.M_ers.getEventIdToolMap();
                    HashMap<String, Integer> toolIdEventStatIxMap = new HashMap<String, Integer>();
                    boolean groupByTool = columnMap.containsKey(StatsSqlBuilder.C_TOOL) && !columnMap.containsKey(StatsSqlBuilder.C_EVENT);
                    for (Object[] s : records) {
                        ToolInfo ti;
                        int ix;
                        EventStatImpl c = null;
                        int eventStatListIndex = -1;
                        String toolId = null;
                        if (!groupByTool) {
                            c = new EventStatImpl();
                        } else {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_TOOL);
                            ti = (ToolInfo)eventIdToolMap.get((String)s[ix]);
                            toolId = ti != null ? ti.getToolId() : (String)s[ix];
                            Integer esIx = (Integer)toolIdEventStatIxMap.get(toolId);
                            if (esIx == null) {
                                c = new EventStatImpl();
                            } else {
                                eventStatListIndex = esIx;
                                c = (EventStat)results.get(eventStatListIndex);
                            }
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_SITE)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_SITE);
                            c.setSiteId((String)s[ix]);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_EVENT)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_EVENT);
                            c.setEventId((String)s[ix]);
                            ti = (ToolInfo)eventIdToolMap.get((String)s[ix]);
                            toolId = ti != null ? ti.getToolId() : (String)s[ix];
                            c.setToolId(toolId);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_TOOL)) {
                            c.setToolId(toolId);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_DATE)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATE);
                            c.setDate((Date)s[ix]);
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_DATEMONTH) && columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                            int ixY = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                            int ixM = (Integer)columnMap.get(StatsSqlBuilder.C_DATEMONTH);
                            int yr = 0;
                            int mo = 0;
                            if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                                yr = Integer.parseInt((String)s[ixY]);
                                mo = Integer.parseInt((String)s[ixM]) - 1;
                            } else {
                                yr = (Integer)s[ixY];
                                mo = (Integer)s[ixM] - 1;
                            }
                            cal.set(1, yr);
                            cal.set(2, mo);
                            c.setDate(cal.getTime());
                        } else if (columnMap.containsKey(StatsSqlBuilder.C_DATEYEAR)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_DATEYEAR);
                            int yr = 0;
                            yr = StatsManagerImpl.this.getDbVendor().equals("oracle") ? Integer.parseInt((String)s[ix]) : (Integer)s[ix];
                            cal.set(1, yr);
                            c.setDate(cal.getTime());
                        }
                        if (columnMap.containsKey(StatsSqlBuilder.C_TOTAL)) {
                            ix = (Integer)columnMap.get(StatsSqlBuilder.C_TOTAL);
                            c.setCount(c.getCount() + (Long)s[ix]);
                        }
                        if (eventStatListIndex == -1) {
                            results.add(c);
                            toolIdEventStatIxMap.put(toolId, results.size() - 1);
                            continue;
                        }
                        results.set(eventStatListIndex, c);
                    }
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteVisits> getSiteVisits(String siteId) {
        return this.getSiteVisits(siteId, this.getInitialActivityDate(siteId), null);
    }

    public List<SiteVisits> getSiteVisits(final String siteId, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(SiteVisitsImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId));
                if (iDate != null) {
                    c.add((Criterion)Expression.ge((String)"date", (Object)iDate));
                }
                if (fDate != null) {
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(fDate);
                    ca.add(6, 1);
                    Date fDate2 = ca.getTime();
                    c.add((Criterion)Expression.lt((String)"date", (Object)fDate2));
                }
                return c.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteVisits> getSiteVisitsByMonth(final String siteId, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        String usersStr = "";
        if (this.getDbVendor().equals("oracle")) {
            if (iDate != null) {
                iDateStr = "and es.EVENT_DATE >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and es.EVENT_DATE < :fdate ";
            }
            if (!this.showAnonymousAccessEvents) {
                usersStr = "and es.USER_ID != '?' ";
            }
        } else {
            if (iDate != null) {
                iDateStr = "and es.date >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and es.date < :fdate ";
            }
            if (!this.showAnonymousAccessEvents) {
                usersStr = "and es.userId != '?' ";
            }
        }
        final String hql = "select es.siteId, sum(es.count) ,count(distinct es.userId), year(es.date), month(es.date)from EventStatImpl as es where es.siteId = :siteid " + iDateStr + fDateStr + usersStr + "  and es.eventId = '" + "pres.begin" + "' " + "group by es.siteId, year(es.date), month(es.date)";
        final String oracleSql = "select es.SITE_ID as actSiteId, sum(es.EVENT_COUNT) as actVisits, count(distinct es.USER_ID) as actUnique,   to_char(es.EVENT_DATE,'YYYY') as actYear, to_char(es.EVENT_DATE,'MM') as actMonth from SST_EVENTS es where es.SITE_ID = :siteid " + iDateStr + fDateStr + usersStr + "  and es.EVENT_ID = '" + "pres.begin" + "' " + "group by es.SITE_ID,to_char(es.EVENT_DATE,'YYYY'), to_char(es.EVENT_DATE,'MM')";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object q = null;
                q = StatsManagerImpl.this.getDbVendor().equals("oracle") ? session.createSQLQuery(oracleSql).addScalar("actSiteId").addScalar("actVisits").addScalar("actUnique").addScalar("actYear").addScalar("actMonth") : session.createQuery(hql);
                q.setString("siteid", siteId);
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                List records = q.list();
                ArrayList<SiteVisitsImpl> results = new ArrayList<SiteVisitsImpl>();
                Calendar cal = Calendar.getInstance();
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        SiteVisitsImpl c = new SiteVisitsImpl();
                        if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                            c.setSiteId((String)s[0]);
                            c.setTotalVisits(((BigDecimal)s[1]).longValue());
                            c.setTotalUnique(((BigDecimal)s[2]).longValue());
                            cal.set(1, Integer.parseInt((String)s[3]));
                            cal.set(2, Integer.parseInt((String)s[4]) - 1);
                        } else {
                            c.setSiteId((String)s[0]);
                            c.setTotalVisits(((Long)s[1]).longValue());
                            try {
                                c.setTotalUnique((long)((Integer)s[2]).intValue());
                            }
                            catch (ClassCastException e) {
                                c.setTotalUnique((long)((Long)s[2]).intValue());
                            }
                            cal.set(1, (Integer)s[3]);
                            cal.set(2, (Integer)s[4] - 1);
                        }
                        c.setDate(cal.getTime());
                        results.add(c);
                    }
                    return results;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public long getTotalSiteVisits(String siteId) {
        return this.getTotalSiteVisits(siteId, this.getInitialActivityDate(siteId), null);
    }

    public long getTotalSiteVisits(final String siteId, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (iDate != null) {
            iDateStr = "and ss.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and ss.date < :fdate ";
        }
        final String hql = "select sum(ss.totalVisits) from SiteVisitsImpl as ss where ss.siteId = :siteid " + iDateStr + fDateStr + "group by ss.siteId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List res;
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if ((res = q.list()).size() > 0) {
                    return res.get(0);
                }
                return 0L;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hcb);
    }

    public long getTotalSiteUniqueVisits(final String siteId) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String usersStr = "";
        if (!this.showAnonymousAccessEvents) {
            usersStr = "and es.userId != '?' ";
        }
        final String hql = "select count(distinct es.userId) from EventStatImpl as es where es.siteId = :siteid and es.eventId = 'pres.begin' " + usersStr;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                List res = q.list();
                if (res.size() > 0) {
                    return res.get(0);
                }
                return 0;
            }
        };
        try {
            return (Long)this.getHibernateTemplate().execute(hcb);
        }
        catch (ClassCastException e) {
            return ((Integer)this.getHibernateTemplate().execute(hcb)).longValue();
        }
    }

    public long getTotalSiteUniqueVisits(final String siteId, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        String usersStr = "";
        if (iDate != null) {
            iDateStr = "and es.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and es.date < :fdate ";
        }
        if (!this.showAnonymousAccessEvents) {
            usersStr = "and es.userId != '?' ";
        }
        final String hql = "select count(distinct es.userId) from EventStatImpl as es where es.siteId = :siteid and es.eventId = 'pres.begin'" + usersStr + iDateStr + fDateStr;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List res;
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if ((res = q.list()).size() > 0) {
                    return res.get(0);
                }
                return 0L;
            }
        };
        try {
            return (Long)this.getHibernateTemplate().execute(hcb);
        }
        catch (ClassCastException e) {
            return ((Integer)this.getHibernateTemplate().execute(hcb)).longValue();
        }
    }

    public int getTotalSiteUsers(String siteId) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        try {
            return this.M_ss.getSite(siteId).getMembers().size();
        }
        catch (IdUnusedException e) {
            this.LOG.warn((Object)("Unable to get total site users for site id: " + siteId), (Throwable)e);
            return 0;
        }
    }

    public List<SiteActivity> getSiteActivity(String siteId, List<String> events) {
        return this.getSiteActivity(siteId, events, this.getInitialActivityDate(siteId), null);
    }

    public List<SiteActivity> getSiteActivity(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(SiteActivityImpl.class).add((Criterion)Expression.eq((String)"siteId", (Object)siteId)).add(Expression.in((String)"eventId", (Collection)events));
                if (iDate != null) {
                    c.add((Criterion)Expression.ge((String)"date", (Object)iDate));
                }
                if (fDate != null) {
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(fDate);
                    ca.add(6, 1);
                    Date fDate2 = ca.getTime();
                    c.add((Criterion)Expression.lt((String)"date", (Object)fDate2));
                }
                return c.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteActivity> getSiteActivityByDay(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (this.getDbVendor().equals("oracle")) {
            if (iDate != null) {
                iDateStr = "and s.ACTIVITY_DATE >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.ACTIVITY_DATE < :fdate ";
            }
        } else {
            if (iDate != null) {
                iDateStr = "and s.date >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.date < :fdate ";
            }
        }
        final String hql = "select s.siteId, sum(s.count), year(s.date), month(s.date), day(s.date) from SiteActivityImpl as s where s.siteId = :siteid and s.eventId in (:eventlist) " + iDateStr + fDateStr + "group by s.siteId, year(s.date), month(s.date), day(s.date)";
        final String oracleSql = "select s.SITE_ID as actSiteId, sum(s.ACTIVITY_COUNT) as actCount, to_char(s.ACTIVITY_DATE,'YYYY') as actYear, to_char(s.ACTIVITY_DATE,'MM') as actMonth, to_char(s.ACTIVITY_DATE,'DD') as actDay from SST_SITEACTIVITY s where s.SITE_ID = :siteid and s.EVENT_ID in (:eventlist) " + iDateStr + fDateStr + "group by s.SITE_ID, to_char(s.ACTIVITY_DATE,'YYYY'), to_char(s.ACTIVITY_DATE,'MM'), to_char(s.ACTIVITY_DATE,'DD')";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object q = null;
                q = StatsManagerImpl.this.getDbVendor().equals("oracle") ? session.createSQLQuery(oracleSql).addScalar("actSiteId").addScalar("actCount").addScalar("actYear").addScalar("actMonth").addScalar("actDay") : session.createQuery(hql);
                q.setString("siteid", siteId);
                if (events != null && events.size() > 0) {
                    q.setParameterList("eventlist", (Collection)events);
                } else {
                    q.setParameterList("eventlist", (Collection)StatsManagerImpl.this.M_ers.getEventIds());
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                List records = q.list();
                ArrayList<SiteActivityImpl> results = new ArrayList<SiteActivityImpl>();
                Calendar cal = Calendar.getInstance();
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        SiteActivityImpl c = new SiteActivityImpl();
                        if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                            c.setSiteId((String)s[0]);
                            c.setCount(((BigDecimal)s[1]).longValue());
                            cal.set(1, Integer.parseInt((String)s[2]));
                            cal.set(2, Integer.parseInt((String)s[3]) - 1);
                            cal.set(5, Integer.parseInt((String)s[4]));
                        } else {
                            c.setSiteId((String)s[0]);
                            c.setCount(((Long)s[1]).longValue());
                            cal.set(1, (Integer)s[2]);
                            cal.set(2, (Integer)s[3] - 1);
                            cal.set(5, (Integer)s[4]);
                        }
                        c.setDate(cal.getTime());
                        c.setEventId(null);
                        results.add(c);
                    }
                    return results;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteActivity> getSiteActivityByMonth(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (this.getDbVendor().equals("oracle")) {
            if (iDate != null) {
                iDateStr = "and s.ACTIVITY_DATE >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.ACTIVITY_DATE < :fdate ";
            }
        } else {
            if (iDate != null) {
                iDateStr = "and s.date >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.date < :fdate ";
            }
        }
        final String hql = "select s.siteId, sum(s.count), year(s.date), month(s.date) from SiteActivityImpl as s where s.siteId = :siteid and s.eventId in (:eventlist) " + iDateStr + fDateStr + "group by s.siteId, year(s.date), month(s.date)";
        final String oracleSql = "select s.SITE_ID as actSiteId, sum(s.ACTIVITY_COUNT) as actCount, to_char(s.ACTIVITY_DATE,'YYYY') as actYear, to_char(s.ACTIVITY_DATE,'MM') as actMonth from SST_SITEACTIVITY s where s.SITE_ID = :siteid and s.EVENT_ID in (:eventlist) " + iDateStr + fDateStr + "group by s.SITE_ID, to_char(s.ACTIVITY_DATE,'YYYY'), to_char(s.ACTIVITY_DATE,'MM')";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object q = null;
                q = StatsManagerImpl.this.getDbVendor().equals("oracle") ? session.createSQLQuery(oracleSql).addScalar("actSiteId").addScalar("actCount").addScalar("actYear").addScalar("actMonth") : session.createQuery(hql);
                q.setString("siteid", siteId);
                if (events != null && events.size() > 0) {
                    q.setParameterList("eventlist", (Collection)events);
                } else {
                    q.setParameterList("eventlist", (Collection)StatsManagerImpl.this.M_ers.getEventIds());
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                List records = q.list();
                ArrayList<SiteActivityImpl> results = new ArrayList<SiteActivityImpl>();
                Calendar cal = Calendar.getInstance();
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        SiteActivityImpl c = new SiteActivityImpl();
                        if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                            c.setSiteId((String)s[0]);
                            c.setCount(((BigDecimal)s[1]).longValue());
                            cal.set(1, Integer.parseInt((String)s[2]));
                            cal.set(2, Integer.parseInt((String)s[3]) - 1);
                        } else {
                            c.setSiteId((String)s[0]);
                            c.setCount(((Long)s[1]).longValue());
                            cal.set(1, (Integer)s[2]);
                            cal.set(2, (Integer)s[3] - 1);
                        }
                        c.setDate(cal.getTime());
                        c.setEventId(null);
                        results.add(c);
                    }
                    return results;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteActivityByTool> getSiteActivityByTool(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (this.getDbVendor().equals("oracle")) {
            if (iDate != null) {
                iDateStr = "and s.ACTIVITY_DATE >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.ACTIVITY_DATE < :fdate ";
            }
        } else {
            if (iDate != null) {
                iDateStr = "and s.date >= :idate ";
            }
            if (fDate != null) {
                fDateStr = "and s.date < :fdate ";
            }
        }
        final String hql = "select s.siteId, sum(s.count), s.eventId from SiteActivityImpl as s where s.siteId = :siteid and s.eventId in (:eventlist) " + iDateStr + fDateStr + "group by s.siteId, s.eventId";
        final String oracleSql = "select s.SITE_ID as actSiteId, sum(s.ACTIVITY_COUNT) as actCount, s.EVENT_ID as actEventId from SST_SITEACTIVITY s where s.SITE_ID = :siteid and s.EVENT_ID in (:eventlist) " + iDateStr + fDateStr + "group by s.SITE_ID, s.EVENT_ID";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object q = null;
                q = StatsManagerImpl.this.getDbVendor().equals("oracle") ? session.createSQLQuery(oracleSql).addScalar("actSiteId").addScalar("actCount").addScalar("actEventId") : session.createQuery(hql);
                q.setString("siteid", siteId);
                if (events != null && events.size() > 0) {
                    q.setParameterList("eventlist", (Collection)events);
                } else {
                    q.setParameterList("eventlist", (Collection)StatsManagerImpl.this.M_ers.getEventIds());
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                List records = q.list();
                ArrayList results = new ArrayList();
                if (records.size() > 0) {
                    Map eventIdToolMap = StatsManagerImpl.this.M_ers.getEventIdToolMap();
                    HashMap<String, SiteActivityByTool> toolidSABT = new HashMap<String, SiteActivityByTool>();
                    List allTools = StatsManagerImpl.this.M_ers.getEventRegistry();
                    for (Object[] s : records) {
                        ToolInfo toolInfo;
                        SiteActivityByToolImpl c = new SiteActivityByToolImpl();
                        if (StatsManagerImpl.this.getDbVendor().equals("oracle")) {
                            c.setSiteId((String)s[0]);
                            c.setCount(((BigDecimal)s[1]).longValue());
                        } else {
                            c.setSiteId((String)s[0]);
                            c.setCount((Long)s[1]);
                        }
                        if ((toolInfo = (ToolInfo)eventIdToolMap.get((String)s[2])) == null) continue;
                        String toolId = toolInfo.getToolId();
                        SiteActivityByTool existing = (SiteActivityByTool)toolidSABT.get(toolId);
                        if (existing != null) {
                            existing.setCount(existing.getCount() + c.getCount());
                            toolidSABT.put(toolId, existing);
                            continue;
                        }
                        int ix = allTools.indexOf(new ToolInfo(toolId));
                        c.setTool((ToolInfo)allTools.get(ix));
                        toolidSABT.put(toolId, c);
                    }
                    results.addAll(toolidSABT.values());
                    return results;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public List<SiteActivity> getSiteActivityGrpByDate(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (iDate != null) {
            iDateStr = "and s.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and s.date < :fdate ";
        }
        final String hql = "select s.siteId, sum(s.count),s.date from SiteActivityImpl as s where s.siteId = :siteid and s.eventId in (:eventlist) " + iDateStr + fDateStr + "group by s.siteId, s.date";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                if (events != null && events.size() > 0) {
                    q.setParameterList("eventlist", (Collection)events);
                } else {
                    q.setParameterList("eventlist", (Collection)StatsManagerImpl.this.M_ers.getEventIds());
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                List records = q.list();
                ArrayList<SiteActivityImpl> results = new ArrayList<SiteActivityImpl>();
                if (records.size() > 0) {
                    for (Object[] s : records) {
                        SiteActivityImpl c = new SiteActivityImpl();
                        c.setSiteId((String)s[0]);
                        c.setCount(((Long)s[1]).longValue());
                        Date recDate = (Date)s[2];
                        c.setDate(recDate);
                        c.setEventId(null);
                        results.add(c);
                    }
                    return results;
                }
                return results;
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    public long getTotalSiteActivity(String siteId, List<String> events) {
        return this.getTotalSiteActivity(siteId, events, this.getInitialActivityDate(siteId), null);
    }

    public long getTotalSiteActivity(final String siteId, final List<String> events, final Date iDate, final Date fDate) {
        if (siteId == null) {
            throw new IllegalArgumentException("Null siteId");
        }
        String iDateStr = "";
        String fDateStr = "";
        if (iDate != null) {
            iDateStr = "and ss.date >= :idate ";
        }
        if (fDate != null) {
            fDateStr = "and ss.date < :fdate ";
        }
        final String hql = "select sum(ss.count) from SiteActivityImpl as ss where ss.eventId in (:eventlist) and ss.siteId = :siteid " + iDateStr + fDateStr + "group by ss.siteId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List res;
                Query q = session.createQuery(hql);
                q.setString("siteid", siteId);
                if (events != null && events.size() > 0) {
                    q.setParameterList("eventlist", (Collection)events);
                } else {
                    q.setParameterList("eventlist", (Collection)StatsManagerImpl.this.M_ers.getEventIds());
                }
                if (iDate != null) {
                    q.setDate("idate", iDate);
                }
                if (fDate != null) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(fDate);
                    c.add(6, 1);
                    Date fDate2 = c.getTime();
                    q.setDate("fdate", fDate2);
                }
                if ((res = q.list()).size() > 0) {
                    return res.get(0);
                }
                return 0L;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hcb);
    }

    public Date getInitialActivityDate(String siteId) {
        Date date = null;
        try {
            date = new Date(this.M_ss.getSite(siteId).getCreatedTime().getTime());
        }
        catch (Exception e) {
            return new Date(0L);
        }
        return date;
    }

    public boolean isEventContextSupported() {
        return this.isEventContextSupported;
    }

    public void logEvent(Object object, String logAction) {
        this.logEvent(object, logAction, this.M_tm.getCurrentPlacement().getContext(), false);
    }

    public void logEvent(Object object, String logAction, String siteId, boolean oncePerSession) {
        boolean log = true;
        StringBuilder event = new StringBuilder();
        event.append("sitestats");
        StringBuilder ref = new StringBuilder();
        ref.append("/site/");
        ref.append(siteId);
        if (object != null) {
            String className;
            if (object instanceof PrefsData) {
                event.append('.');
                event.append("prefs");
                ref.append('/');
                ref.append("prefs");
            } else if (object instanceof ReportDef) {
                event.append('.');
                event.append("report");
                ref.append('/');
                ref.append("report");
                ref.append('/');
                ref.append(((ReportDef)object).getId());
            } else if (object instanceof String) {
                String str = ((String)object).toLowerCase();
                event.append('.');
                event.append(str);
                ref.append('/');
                ref.append(str);
            } else if (object instanceof Class) {
                className = ((Class)object).getSimpleName().toLowerCase();
                event.append('.');
                event.append(className);
                ref.append('/');
                ref.append(className);
            } else {
                className = object.getClass().getSimpleName().toLowerCase();
                event.append('.');
                event.append(className);
                ref.append('/');
                ref.append(className);
                ref.append('/');
                try {
                    Object id = object.getClass().getMethod("getId", null).invoke(object, (Object[])null);
                    ref.append(id);
                }
                catch (Exception e) {
                    ref.append(object);
                }
            }
        }
        event.append('.');
        event.append(logAction);
        if (oncePerSession) {
            String sessionValue = (String)this.M_sm.getCurrentSession().getAttribute(event.toString() + ref.toString());
            boolean bl = log = sessionValue == null || sessionValue.equals("");
        }
        if (log) {
            boolean modify = "new".equals(logAction) || "edit".equals(logAction) || "delete".equals(logAction);
            Event e = null;
            try {
                Method m = this.M_ets.getClass().getMethod("newEvent", String.class, String.class, String.class, Boolean.TYPE, Integer.TYPE);
                e = (Event)m.invoke((Object)this.M_ets, event.toString(), ref.toString(), siteId, modify, 2);
            }
            catch (Exception ex) {
                e = this.M_ets.newEvent(event.toString(), ref.toString(), modify);
            }
            this.M_ets.post(e);
            if (oncePerSession) {
                this.M_sm.getCurrentSession().setAttribute(event.toString() + ref.toString(), (Object)"true");
            }
        }
    }

    private void checkForEventContextSupport() {
        try {
            Event.class.getMethod("getContext", null);
            this.isEventContextSupported = true;
            this.logger.info((Object)"init(): - Event.getContext() method IS supported.");
        }
        catch (SecurityException e) {
            this.isEventContextSupported = false;
            this.logger.warn((Object)"init(): - security exception while checking for Event.getContext() method.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.isEventContextSupported = false;
            this.logger.info((Object)"init(): - Event.getContext() method is NOT supported.");
        }
        catch (Exception e) {
            this.isEventContextSupported = false;
            this.logger.warn((Object)"init(): - unknown exception while checking for Event.getContext() method.", (Throwable)e);
        }
    }

    private List<String> searchUsers(String searchKey, String siteId) {
        if (searchKey == null || searchKey.trim().equals("")) {
            return null;
        }
        List<String> usersWithStats = this.getUsersWithStats(siteId);
        ArrayList<String> userIdList = new ArrayList<String>();
        for (String userId : usersWithStats) {
            boolean match = false;
            if (userId.toLowerCase().matches("(.*)" + searchKey.toLowerCase() + "(.*)")) {
                match = true;
            } else {
                try {
                    User u = this.M_uds.getUser(userId);
                    if (u.getEid().toLowerCase().matches("(.*)" + searchKey.toLowerCase() + "(.*)") || u.getFirstName().toLowerCase().matches("(.*)" + searchKey.toLowerCase() + "(.*)") || u.getLastName().toLowerCase().matches("(.*)" + searchKey.toLowerCase() + "(.*)")) {
                        match = true;
                    }
                }
                catch (Exception e) {
                    match = false;
                }
            }
            if (!match) continue;
            userIdList.add(userId);
        }
        return userIdList;
    }

    private List<String> getUsersWithStats(final String siteId) {
        String hql = "select distinct(ss.userId) from EventStatImpl as ss where ss.siteId = :siteid ";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select distinct(ss.userId) from EventStatImpl as ss where ss.siteId = :siteid ");
                q.setString("siteid", siteId);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private String getDbVendor() {
        String dialectStr = null;
        dialectStr = this.M_scs.getString("sitestats.db", "internal").equals("internal") ? this.M_scs.getString("hibernate.dialect", "org.hibernate.dialect.HSQLDialect") : this.M_scs.getString("sitestats.externalDb.hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        if (dialectStr.toLowerCase().contains("mysql")) {
            return "mysql";
        }
        if (dialectStr.toLowerCase().contains("oracle")) {
            return "oracle";
        }
        return "hsql";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatsSqlBuilder {
        public static final Integer C_SITE = 0;
        public static final Integer C_USER = 1;
        public static final Integer C_EVENT = 2;
        public static final Integer C_TOOL = 3;
        public static final Integer C_RESOURCE = 4;
        public static final Integer C_RESOURCE_ACTION = 5;
        public static final Integer C_DATE = 6;
        public static final Integer C_DATEYEAR = 7;
        public static final Integer C_DATEMONTH = 8;
        public static final Integer C_TOTAL = 9;
        public static final Integer C_VISITS = 10;
        public static final Integer C_UNIQUEVISITS = 11;
        public static final Integer C_DURATION = 12;
        private Map<Integer, Integer> columnMap = new HashMap<Integer, Integer>();
        private String dbVendor;
        private int queryType;
        private List<String> totalsBy;
        private String siteId;
        private List<String> events;
        private List<String> anonymousEvents;
        private boolean showAnonymousAccessEvents;
        private Date iDate;
        private Date fDate;
        private List<String> userIds;
        private String resourceAction;
        private List<String> resourceIds;
        private boolean inverseUserSelection;
        private String sortBy;
        private boolean sortAscending;

        public StatsSqlBuilder(String dbVendor, int queryType, List<String> totalsBy, String siteId, List<String> events, List<String> anonymousEvents, boolean showAnonymousAccessEvents, String resourceAction, List<String> resourceIds, Date iDate, Date fDate, List<String> userIds, boolean inverseUserSelection, String sortBy, boolean sortAscending) {
            this.dbVendor = dbVendor;
            this.queryType = queryType;
            if (totalsBy == null) {
                if (queryType == 0) {
                    this.totalsBy = StatsManager.TOTALSBY_EVENT_DEFAULT;
                } else if (queryType == 1) {
                    this.totalsBy = StatsManager.TOTALSBY_RESOURCE_DEFAULT;
                } else if (queryType == 2) {
                    this.totalsBy = StatsManager.TOTALSBY_VISITSTOTALS_DEFAULT;
                } else if (queryType == 3) {
                    this.totalsBy = StatsManager.TOTALSBY_ACTIVITYTOTALS_DEFAULT;
                } else if (queryType == 4) {
                    this.totalsBy = StatsManager.TOTALSBY_PRESENCE_DEFAULT;
                }
            } else {
                this.totalsBy = totalsBy;
            }
            this.siteId = siteId;
            this.events = events;
            this.anonymousEvents = anonymousEvents;
            this.showAnonymousAccessEvents = showAnonymousAccessEvents;
            this.resourceAction = resourceAction;
            this.resourceIds = resourceIds;
            this.iDate = iDate;
            this.fDate = fDate;
            this.userIds = userIds;
            this.inverseUserSelection = inverseUserSelection;
            this.sortBy = sortBy;
            this.sortAscending = sortAscending;
        }

        public String getHQL() {
            StringBuilder hql = new StringBuilder();
            hql.append(this.getSelectClause());
            hql.append(this.getFromClause());
            hql.append(this.getWhereClause());
            hql.append(this.getGroupByClause());
            hql.append(this.getSortByClause());
            return hql.toString();
        }

        public Map<Integer, Integer> getHQLColumnMap() {
            return this.columnMap;
        }

        private String getSelectClause() {
            StringBuilder _hql = new StringBuilder();
            ArrayList<String> selectFields = new ArrayList<String>();
            int columnIndex = 0;
            if (!this.inverseUserSelection) {
                if (this.siteId != null || this.totalsBy.contains("site")) {
                    selectFields.add("s.siteId as site");
                    this.columnMap.put(C_SITE, columnIndex++);
                }
                if (this.totalsBy.contains("user")) {
                    if (this.queryType == 0 && this.anonymousEvents != null && this.anonymousEvents.size() > 0) {
                        selectFields.add("(CASE WHEN s.eventId not in (:anonymousEvents) THEN s.userId ELSE '-' END) as user");
                    } else {
                        selectFields.add("s.userId as user");
                    }
                    this.columnMap.put(C_USER, columnIndex++);
                }
                if (this.totalsBy.contains("event")) {
                    selectFields.add("s.eventId as event");
                    this.columnMap.put(C_EVENT, columnIndex++);
                }
                if (this.totalsBy.contains("tool")) {
                    selectFields.add("s.eventId as event");
                    this.columnMap.put(C_TOOL, columnIndex++);
                }
                if (this.totalsBy.contains("resource")) {
                    selectFields.add("s.resourceRef as resourceRef");
                    this.columnMap.put(C_RESOURCE, columnIndex++);
                }
                if (this.totalsBy.contains("resource-action")) {
                    selectFields.add("s.resourceAction as resourceAction");
                    this.columnMap.put(C_RESOURCE_ACTION, columnIndex++);
                }
                if (this.totalsBy.contains("date")) {
                    selectFields.add("s.date as date");
                    this.columnMap.put(C_DATE, columnIndex++);
                } else if (this.totalsBy.contains("last-date")) {
                    selectFields.add("max(s.date) as date");
                    this.columnMap.put(C_DATE, columnIndex++);
                } else if (this.totalsBy.contains("month")) {
                    if (this.dbVendor.equals("oracle")) {
                        selectFields.add("to_char(s.date,'YYYY') as year");
                        selectFields.add("to_char(s.date,'MM') as month");
                    } else {
                        selectFields.add("year(s.date) as year");
                        selectFields.add("month(s.date) as month");
                    }
                    this.columnMap.put(C_DATEYEAR, columnIndex++);
                    this.columnMap.put(C_DATEMONTH, columnIndex++);
                } else if (this.totalsBy.contains("year")) {
                    if (this.dbVendor.equals("oracle")) {
                        selectFields.add("to_char(s.date,'YYYY') as year");
                    } else {
                        selectFields.add("year(s.date) as year");
                    }
                    this.columnMap.put(C_DATEYEAR, columnIndex++);
                }
                if (this.queryType == 0 && !this.totalsBy.contains("visits") && !this.totalsBy.contains("unique-visits") || this.queryType == 1) {
                    selectFields.add("sum(s.count) as total");
                    this.columnMap.put(C_TOTAL, columnIndex++);
                } else if (this.queryType == 3) {
                    selectFields.add("sum(s.count) as total");
                    this.columnMap.put(C_TOTAL, columnIndex++);
                } else if (this.queryType == 4) {
                    selectFields.add("sum(s.duration) as duration");
                    this.columnMap.put(C_DURATION, columnIndex++);
                } else if (this.queryType == 0 || this.totalsBy.contains("month") || this.totalsBy.contains("year")) {
                    selectFields.add("sum(s.count) as totalVisits");
                    this.columnMap.put(C_VISITS, columnIndex++);
                    selectFields.add("count(distinct s.userId) as totalUnique");
                    this.columnMap.put(C_UNIQUEVISITS, columnIndex++);
                } else {
                    selectFields.add("sum(s.totalVisits) as totalVisits");
                    this.columnMap.put(C_VISITS, columnIndex++);
                    selectFields.add("sum(s.totalUnique) as totalUnique");
                    this.columnMap.put(C_UNIQUEVISITS, columnIndex++);
                }
            } else {
                if (this.queryType == 0 && this.anonymousEvents != null && this.anonymousEvents.size() > 0) {
                    selectFields.add("distinct(case when s.eventId not in (:anonymousEvents) then s.userId else '-' end) as user");
                } else {
                    selectFields.add("distinct s.userId as user");
                }
                this.columnMap.put(C_USER, columnIndex++);
            }
            _hql.append("select ");
            for (int i = 0; i < selectFields.size() - 1; ++i) {
                _hql.append((String)selectFields.get(i));
                _hql.append(", ");
            }
            _hql.append((String)selectFields.get(selectFields.size() - 1));
            _hql.append(' ');
            return _hql.toString();
        }

        private String getFromClause() {
            if (this.queryType == 0) {
                return "from EventStatImpl as s ";
            }
            if (this.queryType == 1) {
                return "from ResourceStatImpl as s ";
            }
            if (this.queryType == 2) {
                if (this.totalsBy.contains("month") || this.totalsBy.contains("year")) {
                    return "from EventStatImpl as s ";
                }
                return "from SiteVisitsImpl as s ";
            }
            if (this.queryType == 4) {
                return "from SitePresenceImpl as s ";
            }
            return "from SiteActivityImpl as s ";
        }

        private String getWhereClause() {
            StringBuilder _hql = new StringBuilder();
            ArrayList<String> whereFields = new ArrayList<String>();
            if (this.siteId != null) {
                whereFields.add("s.siteId = :siteid");
            }
            if ((this.queryType == 0 || this.queryType == 3) && this.events != null) {
                whereFields.add("s.eventId in (:events)");
            } else if (this.queryType == 2 && (this.totalsBy.contains("month") || this.totalsBy.contains("year"))) {
                whereFields.add("s.eventId = 'pres.begin'");
            }
            if (this.queryType == 1 && this.resourceAction != null) {
                whereFields.add("s.resourceAction = :action");
            }
            if (this.queryType == 1 && this.resourceIds != null && !this.resourceIds.isEmpty()) {
                int simpleSelectionCount = 0;
                int wildcardSelectionCount = 0;
                for (String rId : this.resourceIds) {
                    if (rId.endsWith("/")) {
                        ++wildcardSelectionCount;
                        continue;
                    }
                    ++simpleSelectionCount;
                }
                if (simpleSelectionCount > 0) {
                    whereFields.add("s.resourceRef in (:resources)");
                }
                for (int i = 0; i < wildcardSelectionCount; ++i) {
                    whereFields.add("s.resourceRef like (:resource" + i + ")");
                }
            }
            if ((this.queryType == 0 || this.queryType == 1 || this.queryType == 4) && this.userIds != null) {
                if (!this.userIds.isEmpty()) {
                    if (this.userIds.size() <= 1000) {
                        whereFields.add("s.userId in (:users)");
                    } else {
                        int nUsers = this.userIds.size();
                        int blockId = 0;
                        StringBuilder buff = new StringBuilder();
                        buff.append("(");
                        int blocks = nUsers / 1000;
                        blocks = blocks * 1000 == nUsers ? blocks : blocks + 1;
                        for (int i = 0; i < blocks - 1; ++i) {
                            buff.append("s.userId in (:users" + blockId + ")");
                            buff.append(" OR ");
                            ++blockId;
                        }
                        buff.append("s.userId in (:users" + blockId + ")");
                        buff.append(")");
                        whereFields.add(buff.toString());
                    }
                } else {
                    whereFields.add("s.userId=''");
                }
            }
            if (this.iDate != null) {
                whereFields.add("s.date >= :idate");
            }
            if (this.fDate != null) {
                whereFields.add("s.date < :fdate");
            }
            if (!(this.queryType != 0 && this.queryType != 1 && this.queryType != 4 || this.showAnonymousAccessEvents)) {
                whereFields.add("s.userId != '?'");
            }
            if (whereFields.size() > 0) {
                _hql.append("where ");
                for (int i = 0; i < whereFields.size() - 1; ++i) {
                    if (((String)whereFields.get(i)).startsWith("s.resourceRef")) {
                        if (i != 0 && !((String)whereFields.get(i - 1)).startsWith("s.resourceRef")) {
                            _hql.append("(");
                        }
                        _hql.append((String)whereFields.get(i));
                        if (((String)whereFields.get(i + 1)).startsWith("s.resourceRef")) {
                            _hql.append(" or ");
                            continue;
                        }
                        _hql.append(") and ");
                        continue;
                    }
                    _hql.append((String)whereFields.get(i));
                    _hql.append(" and ");
                }
                _hql.append((String)whereFields.get(whereFields.size() - 1));
                if (whereFields.size() > 1 && ((String)whereFields.get(whereFields.size() - 2)).startsWith("s.resourceRef")) {
                    _hql.append(')');
                }
            }
            _hql.append(' ');
            return _hql.toString();
        }

        private String getGroupByClause() {
            StringBuilder _hql = new StringBuilder();
            ArrayList<String> groupFields = new ArrayList<String>();
            if (!this.inverseUserSelection && (this.siteId != null || this.totalsBy.contains("site"))) {
                groupFields.add("s.siteId");
            }
            if (this.totalsBy.contains("user")) {
                if (this.queryType == 0 && this.anonymousEvents != null && this.anonymousEvents.size() > 0) {
                    if (this.dbVendor.equals("oracle")) {
                        groupFields.add("s.eventId");
                        groupFields.add("s.userId");
                    } else {
                        groupFields.add("col_" + this.columnMap.get(C_USER) + "_0_");
                    }
                } else {
                    groupFields.add("s.userId");
                }
            }
            if ((this.queryType == 0 || this.queryType == 3) && (this.totalsBy.contains("event") || this.totalsBy.contains("tool"))) {
                groupFields.add("s.eventId");
            }
            if (this.queryType == 1 && this.totalsBy.contains("resource")) {
                groupFields.add("s.resourceRef");
            }
            if (this.queryType == 1 && this.totalsBy.contains("resource-action")) {
                groupFields.add("s.resourceAction");
            }
            if (this.totalsBy.contains("date")) {
                groupFields.add("s.date");
            }
            if (this.totalsBy.contains("last-date") && groupFields.size() == 0) {
                groupFields.add("s.date");
            }
            if (this.totalsBy.contains("month")) {
                if (this.dbVendor.equals("oracle")) {
                    groupFields.add("to_char(s.date,'YYYY')");
                    groupFields.add("to_char(s.date,'MM')");
                } else {
                    groupFields.add("year(s.date)");
                    groupFields.add("month(s.date)");
                }
            }
            if (this.totalsBy.contains("year")) {
                if (this.dbVendor.equals("oracle")) {
                    groupFields.add("to_char(s.date,'YYYY')");
                } else {
                    groupFields.add("year(s.date)");
                }
            }
            if (groupFields.size() > 0) {
                _hql.append("group by ");
                for (int i = 0; i < groupFields.size() - 1; ++i) {
                    _hql.append((String)groupFields.get(i));
                    _hql.append(", ");
                }
                _hql.append((String)groupFields.get(groupFields.size() - 1));
                _hql.append(' ');
            }
            return _hql.toString();
        }

        private String getSortByClause() {
            if (this.sortBy != null) {
                StringBuilder _hql = new StringBuilder();
                String sortField = null;
                if (this.sortBy.equals("site") && this.totalsBy.contains("site")) {
                    sortField = "s.siteId";
                }
                if (this.sortBy.equals("user") && this.totalsBy.contains("user")) {
                    sortField = "s.userId";
                }
                if ((this.queryType == 0 || this.queryType == 3) && (this.sortBy.equals("event") || this.sortBy.equals("tool")) && (this.totalsBy.contains("event") || this.totalsBy.contains("tool"))) {
                    sortField = "s.eventId";
                }
                if (this.queryType == 1 && this.sortBy.equals("resource") && this.totalsBy.contains("resource")) {
                    sortField = "s.resourceRef";
                }
                if (this.queryType == 1 && this.sortBy.equals("resource-action") && this.totalsBy.contains("resource-action")) {
                    sortField = "s.resourceAction";
                }
                if ((this.sortBy.equals("date") || this.sortBy.equals("last-date")) && (this.totalsBy.contains("date") || this.totalsBy.contains("last-date"))) {
                    sortField = "s.date";
                }
                if (this.sortBy.equals("duration")) {
                    sortField = this.dbVendor.equals("oracle") || this.dbVendor.equals("hql") ? "sum(s.duration)" : "col_" + this.columnMap.get(C_DURATION) + "_0_";
                }
                if (this.sortBy.equals("total")) {
                    sortField = this.dbVendor.equals("oracle") || this.dbVendor.equals("hql") ? "sum(s.count)" : "col_" + this.columnMap.get(C_TOTAL) + "_0_";
                }
                if (this.sortBy.equals("visits")) {
                    sortField = this.dbVendor.equals("oracle") || this.dbVendor.equals("hql") ? (this.queryType == 0 || this.totalsBy.contains("month") || this.totalsBy.contains("year") ? "sum(s.count)" : "sum(s.totalVisits)") : "col_" + this.columnMap.get(C_VISITS) + "_0_";
                }
                if (this.sortBy.equals("unique-visits")) {
                    if (this.dbVendor.equals("oracle") || this.dbVendor.equals("hql")) {
                        sortField = "sum(s.totalUnique)";
                        sortField = this.queryType == 0 || this.totalsBy.contains("month") || this.totalsBy.contains("year") ? "count(distinct s.userId)" : "sum(s.totalUnique)";
                    } else {
                        sortField = "col_" + this.columnMap.get(C_UNIQUEVISITS) + "_0_";
                    }
                }
                if (sortField != null) {
                    _hql.append("order by ");
                    _hql.append(sortField);
                    _hql.append(' ');
                    _hql.append(this.sortAscending ? "ASC" : "DESC");
                    _hql.append(' ');
                }
                return _hql.toString();
            }
            return "";
        }
    }
}

