/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.sakaiproject.sitestats.api.SiteVisits;
import org.sakaiproject.sitestats.api.SummaryVisitsChartData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryVisitsChartDataImpl
implements SummaryVisitsChartData {
    private String viewType = null;
    private Date firstDay = null;
    private long[] visits = null;
    private long[] uniqueVisits = null;
    private List<SiteVisits> siteVisits = null;

    public SummaryVisitsChartDataImpl(String viewType) {
        this.viewType = viewType;
    }

    public List<SiteVisits> getSiteVisits() {
        return this.siteVisits;
    }

    public void setSiteVisits(List<SiteVisits> siteVisits) {
        this.siteVisits = siteVisits;
    }

    public long[] getUniqueVisits() {
        if (this.uniqueVisits == null && this.siteVisits.size() > 0) {
            this.fillData();
        }
        return this.uniqueVisits;
    }

    public long[] getVisits() {
        if (this.visits == null && this.siteVisits.size() > 0) {
            this.fillData();
        }
        return this.visits;
    }

    public Date getFirstDay() {
        if (this.firstDay == null && this.siteVisits.size() > 0) {
            this.fillData();
        }
        return this.firstDay;
    }

    private void fillData() {
        if (this.viewType == null || this.siteVisits == null) {
            return;
        }
        int timeSlots = 0;
        if ("week".equals(this.viewType)) {
            timeSlots = 7;
        } else if ("month".equals(this.viewType)) {
            timeSlots = 30;
        } else if ("year".equals(this.viewType)) {
            timeSlots = 12;
        }
        Calendar cal = Calendar.getInstance();
        this.visits = new long[timeSlots];
        this.uniqueVisits = new long[timeSlots];
        for (int i = timeSlots - 1; i >= 0; --i) {
            SiteVisits sv = null;
            sv = "year".equals(this.viewType) ? this.getDataForMonth(cal) : this.getDataForDay(cal);
            if (sv == null) {
                this.visits[i] = 0L;
                this.uniqueVisits[i] = 0L;
            } else {
                this.visits[i] = sv.getTotalVisits();
                this.uniqueVisits[i] = sv.getTotalUnique();
            }
            if (i <= 0) continue;
            if ("week".equals(this.viewType) || "month".equals(this.viewType)) {
                cal.add(5, -1);
                continue;
            }
            if (!"year".equals(this.viewType)) continue;
            cal.add(2, -1);
        }
        this.firstDay = cal.getTime();
    }

    private SiteVisits getDataForDay(Calendar cal_) {
        Calendar cal = (Calendar)cal_.clone();
        int desiredDay = cal.get(6);
        for (int i = this.siteVisits.size() - 1; i >= 0; --i) {
            SiteVisits sv = this.siteVisits.get(i);
            cal.setTime(sv.getDate());
            int thisDay = cal.get(6);
            if (desiredDay != thisDay) continue;
            return sv;
        }
        return null;
    }

    private SiteVisits getDataForMonth(Calendar cal_) {
        Calendar cal = (Calendar)cal_.clone();
        int desiredMonth = cal.get(2);
        for (int i = this.siteVisits.size() - 1; i >= 0; --i) {
            SiteVisits sv = this.siteVisits.get(i);
            cal.setTime(sv.getDate());
            int thisMonth = cal.get(2);
            if (desiredMonth != thisMonth) continue;
            return sv;
        }
        return null;
    }
}

