/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.event.ToolInfo;

public class ConvOldPrefsJobImpl
implements StatefulJob {
    private Log LOG = LogFactory.getLog(ConvOldPrefsJobImpl.class);
    private StatsManager statsManager = null;
    private SqlService sqlService = null;
    private EventRegistryService eventRegistryService = null;

    public void setStatsManager(StatsManager statsManager) {
        this.statsManager = statsManager;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void setEventRegistryService(EventRegistryService eventRegistryService) {
        this.eventRegistryService = eventRegistryService;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.LOG.info((Object)"Old SiteStats Preferences table conversion started...");
        if (this.areBothTablesPresent()) {
            this.convertPrefs();
        }
        this.LOG.info((Object)"Old SiteStats Preferences table conversion finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertPrefs() {
        Connection c = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        List<String> siteIds = this.getSitesInSSTPrefs();
        String sitePrefSql = "select EVENT_ID from SST_PREFS where SITE_ID=? and PAGE=0 ORDER BY EVENT_ID";
        try {
            c = this.sqlService.borrowConnection();
            ps = c.prepareStatement("select EVENT_ID from SST_PREFS where SITE_ID=? and PAGE=0 ORDER BY EVENT_ID");
            for (String siteId : siteIds) {
                try {
                    ArrayList<String> eventIds = new ArrayList<String>();
                    ps.clearParameters();
                    ps.setString(1, siteId);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String eventId = rs.getString(1);
                        eventIds.add(eventId);
                    }
                    rs.close();
                    PrefsData prefs = new PrefsData();
                    prefs.setToolEventsDef(this.eventRegistryService.getEventRegistry());
                    List allTools = prefs.getToolEventsDef();
                    for (ToolInfo ti : allTools) {
                        boolean toolSelected = false;
                        for (EventInfo ei : ti.getEvents()) {
                            if (eventIds.contains(ei.getEventId())) {
                                ei.setSelected(true);
                                toolSelected = true;
                                continue;
                            }
                            ei.setSelected(false);
                        }
                        ti.setSelected(toolSelected);
                    }
                    this.statsManager.setPreferences(siteId, prefs);
                }
                catch (SQLException e) {
                    this.LOG.error((Object)("An SQL error occurred while converting SST_PREFS data for site: " + siteId), (Throwable)e);
                    boolean bl = false;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e3) {
                            // empty catch block
                        }
                    }
                    if (c != null) {
                        this.sqlService.returnConnection(c);
                    }
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)"An SQL error occurred while converting SST_PREFS data to SST_PREFERENCES table.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (c != null) {
                this.sqlService.returnConnection(c);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSitesInSSTPrefs() {
        ArrayList<String> siteIds = new ArrayList<String>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.sqlService.borrowConnection();
            try {
                s = c.createStatement();
                rs = s.executeQuery("select distinct SITE_ID from SST_PREFS");
                while (rs.next()) {
                    siteIds.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Unable to get list of sites from SST_PREFS.", (Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)"An SQL error occurred while getting list of sites from SST_PREFS.", (Throwable)e);
        }
        finally {
            if (c != null) {
                this.sqlService.returnConnection(c);
            }
        }
        return siteIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areBothTablesPresent() {
        boolean present = false;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.sqlService.borrowConnection();
            try {
                s = c.createStatement();
                rs = s.executeQuery("select count(*) from SST_PREFS");
                present = true;
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Table SST_PREFS doesn't exist! Nothing to do, aborting.");
                present = false;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {}
                }
            }
            try {
                s = c.createStatement();
                rs = s.executeQuery("select count(*) from SST_PREFERENCES");
                if (present) {
                    present = true;
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Table SST_PREFERENCES doesn't exist! Create it before running this conversion script.");
                present = false;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)"An SQL error occurred while checking for SST_PREFS and SST_PREFERENCES existence.", (Throwable)e);
        }
        finally {
            if (c != null) {
                this.sqlService.returnConnection(c);
            }
        }
        return present;
    }
}

