/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.impl.report;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Resolvable;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportManager;
import org.sakaiproject.sitestats.impl.parser.DigesterUtil;

public class ReportDefEntityProvider
implements AutoRegisterEntityProvider,
CoreEntityProvider,
Resolvable {
    private Log LOG = LogFactory.getLog(ReportDefEntityProvider.class);
    public static final String PREFIX = "sitestats-report";
    public static final String LABEL = "SiteStatsReport";
    public static final String REFERENCE_ROOT = "/sitestats-report";
    public static final String IMPORTEXPORT_CURRENT_VERSION = "1.0";
    public static final String IMPORTEXPORT_DEFAULT_ENCODING = "UTF-8";
    private ReportManager M_rm;
    private DeveloperHelperService M_dhs;

    public void setReportManager(ReportManager reportManager) {
        this.M_rm = reportManager;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.M_dhs = developerHelperService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public boolean entityExists(String id) {
        long longId = 0L;
        try {
            longId = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return this.M_rm.getReportDefinition(longId) != null;
    }

    public Object getEntity(EntityReference ref) {
        long longId = 0L;
        try {
            longId = Long.valueOf(ref.getId());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.M_rm.getReportDefinition(longId);
    }

    public String[] importData(String reference, InputStream data, String encodingKey, Map<String, Object> params) {
        this.LOG.info((Object)("importData(): reference=" + reference + ", encodingKey=" + encodingKey + ", params=" + params));
        String[] imported = new String[]{};
        if (this.M_dhs.entityExists(reference)) {
            String[] importInfo = encodingKey.split("\\|");
            try {
                byte[] bytes = new byte[data.available()];
                data.read(bytes);
                List<ReportDef> list = DigesterUtil.convertXmlToReportDefs(new String(bytes, importInfo[0]));
                String thisSiteId = this.M_dhs.getCurrentLocationId();
                for (ReportDef rf : list) {
                    rf.setId(0L);
                    rf.setSiteId(thisSiteId);
                    rf.getReportParams().setSiteId(thisSiteId);
                    this.M_rm.saveReportDefinition(rf);
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)"Unable to import SiteStats reports", (Throwable)e);
            }
        }
        return imported;
    }

    public String exportData(String reference, Search search, OutputStream data, boolean destructive, Map<String, Object> params) {
        this.LOG.info((Object)("exportData(): reference=" + reference + ", destructive=" + destructive));
        if (this.M_dhs.entityExists(reference)) {
            String exportInfo = "UTF-8|1.0";
            List list = this.M_rm.getReportDefinitions(this.M_dhs.getCurrentLocationId(), false, true);
            if (list != null && !list.isEmpty()) {
                try {
                    String xml = DigesterUtil.convertReportDefsToXml(list);
                    data.write(xml.getBytes(IMPORTEXPORT_DEFAULT_ENCODING));
                    if (destructive) {
                        for (ReportDef rd : list) {
                            this.M_rm.removeReportDefinition(rd);
                        }
                    }
                    return exportInfo;
                }
                catch (Exception e) {
                    this.LOG.error((Object)"Unable to export SiteStats reports", (Throwable)e);
                }
            }
        }
        return null;
    }
}

