/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.FileSelectorPanel;
import org.sakaiproject.sitestats.tool.wicket.models.CHResourceModel;

public class FileSelectorPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String BASE_DIR = "/";
    private String siteId;
    private String siteTitle;
    private boolean showDefaultBaseFoldersOnly;
    private String currentDir = "/";
    private final AjaxResourcesLoader ajaxResourcesLoader = new AjaxResourcesLoader(this, null);

    public FileSelectorPanel(String id, String siteId, boolean showDefaultBaseFoldersOnly) {
        this(id, siteId, null, showDefaultBaseFoldersOnly);
    }

    public FileSelectorPanel(String id, String siteId, IModel model, boolean showDefaultBaseFoldersOnly) {
        super(id, model);
        this.siteId = siteId;
        try {
            this.siteTitle = Locator.getFacade().getSiteService().getSite(siteId).getTitle();
        }
        catch (IdUnusedException e) {
            this.siteTitle = siteId;
        }
        this.showDefaultBaseFoldersOnly = showDefaultBaseFoldersOnly;
        HiddenField selectedFiles = new HiddenField("selectedFiles", (IModel)new PropertyModel((Object)this, "selectedFiles"));
        this.add(new Component[]{selectedFiles});
        WebMarkupContainer containerHover = new WebMarkupContainer("containerHover");
        if (this.isEnabled()) {
            containerHover.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)"display: block")))});
        } else {
            containerHover.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)"display: none")))});
        }
        this.add(new Component[]{containerHover});
        this.add(new IBehavior[]{this.ajaxResourcesLoader});
    }

    public List<String> getSelectedFilesId() {
        List files = (List)this.getDefaultModelObject();
        if (!this.showDefaultBaseFoldersOnly) {
            ArrayList<String> files2 = new ArrayList<String>();
            for (String f : files) {
                if ("/group/".equals(f) || "/group-user/".equals(f) || "/attachment/".equals(f)) {
                    files2.add(f + this.siteId + BASE_DIR);
                    continue;
                }
                files2.add(f);
            }
            return files2;
        }
        return files;
    }

    public void setSelectedFilesId(List<String> files) {
        this.setDefaultModelObject(files);
    }

    public String getSelectedFiles() {
        List files = (List)this.getDefaultModelObject();
        StringBuilder filesEncoded = new StringBuilder();
        for (String s : files) {
            if (filesEncoded.length() != 0) {
                filesEncoded.append("|||");
            }
            if (!this.showDefaultBaseFoldersOnly && ("/group/".equals(s) || "/group-user/".equals(s) || "/attachment/".equals(s))) {
                filesEncoded.append(s + this.siteId + BASE_DIR);
                continue;
            }
            filesEncoded.append(s);
        }
        return filesEncoded.toString();
    }

    public void setSelectedFiles(String filesEncoded) {
        ArrayList<String> files = new ArrayList<String>();
        if (filesEncoded != null) {
            String[] t = filesEncoded.split("\\|\\|\\|");
            for (int i = 0; i < t.length; ++i) {
                files.add(t[i]);
            }
        }
        this.setDefaultModelObject(files);
    }

    private boolean isSelected(String resourceId) {
        return this.getSelectedFilesId().contains(resourceId);
    }

    private boolean isFolderPartOfSelectedFiles(String collectionId) {
        for (String id : this.getSelectedFilesId()) {
            if (!id.startsWith(collectionId)) continue;
            return true;
        }
        return false;
    }

    public void renderHead(HtmlHeaderContainer container) {
        container.getHeaderResponse().renderJavascriptReference("/library/js/jquery/jquery-1.9.1.min.js");
        container.getHeaderResponse().renderJavascriptReference("/sitestats-tool/html/components/jqueryFileTree/jqueryFileTree.js");
        container.getHeaderResponse().renderCSSReference("/sitestats-tool/html/components/jqueryFileTree/jqueryFileTree.css");
        StringBuilder onDomReady = new StringBuilder();
        onDomReady.append("jQuery('#containerInner').fileTree(");
        onDomReady.append("  {root: '");
        onDomReady.append(BASE_DIR);
        onDomReady.append("', script: '");
        onDomReady.append(this.ajaxResourcesLoader.getCallbackUrl());
        onDomReady.append("', duration: 100},");
        onDomReady.append("  function(file) {return false;}");
        onDomReady.append(");");
        container.getHeaderResponse().renderOnDomReadyJavascript(onDomReady.toString());
        super.renderHead(container);
    }

    private List<CHResourceModel> getResources(String dir) throws IdUnusedException, TypeException, PermissionException {
        ContentCollection collection;
        ArrayList<CHResourceModel> resourcesList = new ArrayList<CHResourceModel>();
        String resourcesCollectionId = null;
        String dropboxCollectionId = null;
        String attachmentsCollectionId = null;
        if (!this.showDefaultBaseFoldersOnly) {
            resourcesCollectionId = Locator.getFacade().getContentHostingService().getSiteCollection(this.siteId);
            dropboxCollectionId = Locator.getFacade().getContentHostingService().getDropboxCollection(this.siteId);
            attachmentsCollectionId = resourcesCollectionId.replaceFirst("/group/", "/attachment/");
        } else {
            resourcesCollectionId = "/group/";
            dropboxCollectionId = "/group-user/";
            attachmentsCollectionId = "/attachment/";
        }
        if (dir.equals(BASE_DIR)) {
            resourcesList.add(new CHResourceModel(resourcesCollectionId, Locator.getFacade().getToolManager().getTool("sakai.resources").getTitle(), true));
            resourcesList.add(new CHResourceModel(dropboxCollectionId, Locator.getFacade().getToolManager().getTool("sakai.dropbox").getTitle(), true));
            resourcesList.add(new CHResourceModel(attachmentsCollectionId, new ResourceModel("report_content_attachments").getObject(), true));
        } else if (!this.showDefaultBaseFoldersOnly && (collection = Locator.getFacade().getContentHostingService().getCollection(dir)) != null) {
            List members = collection.getMemberResources();
            for (ContentEntity ce : members) {
                String dispName = Locator.getFacade().getStatsManager().getResourceName("/content" + ce.getId(), false);
                resourcesList.add(new CHResourceModel(ce.getId(), dispName, ce.isCollection()));
            }
        }
        return resourcesList;
    }

    static /* synthetic */ String access$102(FileSelectorPanel x0, String x1) {
        x0.currentDir = x1;
        return x0.currentDir;
    }

    static /* synthetic */ String access$100(FileSelectorPanel x0) {
        return x0.currentDir;
    }

    static /* synthetic */ List access$200(FileSelectorPanel x0, String x1) throws IdUnusedException, TypeException, PermissionException {
        return x0.getResources(x1);
    }

    static /* synthetic */ boolean access$300(FileSelectorPanel x0, String x1) {
        return x0.isFolderPartOfSelectedFiles(x1);
    }

    static /* synthetic */ boolean access$400(FileSelectorPanel x0, String x1) {
        return x0.isSelected(x1);
    }
}

