/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.AdminMenu;
import org.sakaiproject.sitestats.tool.wicket.components.SakaiDataTable;
import org.sakaiproject.sitestats.tool.wicket.components.SakaiNavigatorSearch;
import org.sakaiproject.sitestats.tool.wicket.pages.AdminPage;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.providers.SortableSearchableDataProvider;
import org.sakaiproject.sitestats.tool.wicket.providers.StatisticableSitesDataProvider;

public class AdminPage
extends BasePage {
    private static final long serialVersionUID = 1L;

    public AdminPage() {
        this(null);
    }

    public AdminPage(PageParameters params) {
        String siteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        boolean allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStatsAdmin(siteId);
        if (allowed) {
            this.renderBody();
            Locator.getFacade().getStatsManager().logEvent((Object)"admin", "view", siteId, true);
        } else {
            this.redirectToInterceptPage((Page)new NotAuthorizedPage());
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
    }

    private void renderBody() {
        StatisticableSitesDataProvider dataProvider = new StatisticableSitesDataProvider();
        this.add(new Component[]{new AdminMenu("menu")});
        this.add(new Component[]{new SakaiNavigatorSearch("search", (SortableSearchableDataProvider)dataProvider)});
        ArrayList<String> choices = new ArrayList<String>();
        choices.add("all");
        List types = Locator.getFacade().getSiteService().getSiteTypes();
        for (String t : types) {
            choices.add(t);
        }
        2 siteTypes = new /* Unavailable Anonymous Inner Class!! */;
        siteTypes.setModel((IModel)new PropertyModel((Object)dataProvider, "siteType"));
        this.add(new Component[]{siteTypes});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new PropertyColumn((IModel)new ResourceModel("th_type"), "type", "type"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{new SakaiDataTable("table", columns, (ISortableDataProvider)dataProvider, true)});
    }
}

