/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.Util;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.CSSFeedbackPanel;
import org.sakaiproject.sitestats.tool.wicket.components.EventRegistryTree;
import org.sakaiproject.sitestats.tool.wicket.components.Menus;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.pages.PreferencesPage;

public class PreferencesPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private String realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
    private String siteId;
    private FeedbackPanel feedback = null;
    private List<String> chartTransparencyChoices = null;
    private EventRegistryTree eventRegistryTree = null;
    private PrefsData prefsdata = null;

    public PreferencesPage() {
        this(null);
    }

    public PreferencesPage(PageParameters pageParameters) {
        boolean allowed;
        if (pageParameters != null) {
            this.siteId = pageParameters.getString("siteId");
        }
        if (this.siteId == null) {
            this.siteId = this.realSiteId;
        }
        if (allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(this.siteId)) {
            this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
            this.renderBody();
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/library/js/jquery/jquery-1.9.1.min.js");
        response.renderOnDomReadyJavascript("toggleCheckboxAll();");
    }

    private void renderBody() {
        this.add(new Component[]{new Menus("menu", this.siteId)});
        Form form = new Form("prefsForm");
        form.setOutputMarkupId(true);
        form.setMarkupId("prefsForm");
        this.add(new Component[]{form});
        this.feedback = new CSSFeedbackPanel("messages");
        form.add(new Component[]{this.feedback});
        CheckBox listToolEventsOnlyAvailableInSite = new CheckBox("listToolEventsOnlyAvailableInSite");
        form.add(new Component[]{listToolEventsOnlyAvailableInSite});
        WebMarkupContainer chartPrefs = new WebMarkupContainer("chartPrefs");
        boolean chartPrefsVisible = Locator.getFacade().getStatsManager().isEnableSiteVisits() || Locator.getFacade().getStatsManager().isEnableSiteActivity();
        chartPrefs.setVisible(chartPrefsVisible);
        form.add(new Component[]{chartPrefs});
        CheckBox itemLabelsVisible = new CheckBox("itemLabelsVisible");
        chartPrefs.add(new Component[]{itemLabelsVisible});
        this.chartTransparencyChoices = new ArrayList();
        for (int i = 100; i >= 10; i -= 10) {
            this.chartTransparencyChoices.add(Integer.toString(i));
        }
        DropDownChoice chartTransparency = new DropDownChoice("chartTransparency", this.chartTransparencyChoices, (IChoiceRenderer)new /* Unavailable Anonymous Inner Class!! */);
        chartPrefs.add(new Component[]{chartTransparency});
        CheckBox useAllTools = new CheckBox("useAllTools");
        useAllTools.add(new IBehavior[]{new SimpleAttributeModifier("onclick", (CharSequence)"toggleCheckboxAll();")});
        useAllTools.setOutputMarkupId(true);
        useAllTools.setMarkupId("useAllTools");
        form.add(new Component[]{useAllTools});
        this.eventRegistryTree = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{this.eventRegistryTree});
        3 update = new /* Unavailable Anonymous Inner Class!! */;
        update.setDefaultFormProcessing(true);
        form.add(new Component[]{update});
        4 cancel = new /* Unavailable Anonymous Inner Class!! */;
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private PrefsData getPrefsdata() {
        if (this.prefsdata == null) {
            this.prefsdata = Locator.getFacade().getStatsManager().getPreferences(this.siteId, true);
        }
        return this.prefsdata;
    }

    private void savePreferences() {
        if (this.isUseAllTools()) {
            this.getPrefsdata().setToolEventsDef(Locator.getFacade().getEventRegistryService().getEventRegistry(this.siteId, this.isListToolEventsOnlyAvailableInSite()));
        } else {
            this.getPrefsdata().setToolEventsDef(this.eventRegistryTree.getEventRegistry());
        }
        boolean opOk = Locator.getFacade().getStatsManager().setPreferences(this.siteId, this.getPrefsdata());
        if (opOk) {
            this.info(new ResourceModel("prefs_updated").getObject());
        } else {
            this.error((Serializable)((Object)new ResourceModel("prefs_not_updated").getObject()));
        }
    }

    public void setListToolEventsOnlyAvailableInSite(boolean listToolEventsOnlyAvailableInSite) {
        this.prefsdata.setListToolEventsOnlyAvailableInSite(listToolEventsOnlyAvailableInSite);
    }

    public boolean isListToolEventsOnlyAvailableInSite() {
        return this.getPrefsdata().isListToolEventsOnlyAvailableInSite();
    }

    public void setChartIn3D(boolean chartIn3D) {
        this.prefsdata.setChartIn3D(chartIn3D);
    }

    public boolean isChartIn3D() {
        return this.getPrefsdata().isChartIn3D();
    }

    public void setUseAllTools(boolean useAllTools) {
        this.prefsdata.setUseAllTools(useAllTools);
    }

    public boolean isUseAllTools() {
        return this.getPrefsdata().isUseAllTools();
    }

    public void setItemLabelsVisible(boolean itemLabelsVisible) {
        this.prefsdata.setItemLabelsVisible(itemLabelsVisible);
    }

    public boolean isItemLabelsVisible() {
        return this.getPrefsdata().isItemLabelsVisible();
    }

    public void setChartTransparency(String value) {
        float converted = (float)Util.round((double)(Double.parseDouble(value) / 100.0), (int)1);
        this.getPrefsdata().setChartTransparency(converted);
    }

    public String getChartTransparency() {
        return Integer.toString((int)Util.round((double)(this.getPrefsdata().getChartTransparency() * 100.0f), (int)0));
    }

    static /* synthetic */ String access$000(PreferencesPage x0) {
        return x0.siteId;
    }

    static /* synthetic */ PrefsData access$100(PreferencesPage x0) {
        return x0.getPrefsdata();
    }

    static /* synthetic */ void access$200(PreferencesPage x0) {
        x0.savePreferences();
    }

    static /* synthetic */ PrefsData access$302(PreferencesPage x0, PrefsData x1) {
        x0.prefsdata = x1;
        return x0.prefsdata;
    }
}

