/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.LastJobRun;
import org.sakaiproject.sitestats.tool.wicket.components.Menus;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.widget.ActivityWidget;
import org.sakaiproject.sitestats.tool.wicket.widget.ResourcesWidget;
import org.sakaiproject.sitestats.tool.wicket.widget.VisitsWidget;

public class OverviewPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private String realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
    private String siteId;

    public OverviewPage() {
        this(null);
    }

    public OverviewPage(PageParameters pageParameters) {
        boolean allowed;
        if (pageParameters != null) {
            this.siteId = pageParameters.getString("siteId");
        }
        if (this.siteId == null) {
            this.siteId = this.realSiteId;
        }
        if (allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(this.siteId)) {
            this.renderBody();
            Locator.getFacade().getStatsManager().logEvent(null, "view", this.siteId, true);
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/library/js/jquery/jquery-1.9.1.min.js");
    }

    private void renderBody() {
        boolean visitsVisible;
        this.setRenderBodyOnly(true);
        this.add(new Component[]{new Menus("menu", this.siteId)});
        StatsManager statsManager = Locator.getFacade().getStatsManager();
        this.add(new Component[]{new LastJobRun("lastJobRun", this.siteId)});
        boolean bl = visitsVisible = statsManager.isEnableSiteVisits() && statsManager.isVisitsInfoAvailable();
        if (visitsVisible) {
            this.add(new Component[]{new VisitsWidget("visitsWidget", this.siteId)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("visitsWidget").setRenderBodyOnly(true)});
        }
        boolean activityVisible = statsManager.isEnableSiteActivity();
        if (activityVisible) {
            this.add(new Component[]{new ActivityWidget("activityWidget", this.siteId)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("activityWidget").setRenderBodyOnly(true)});
        }
        boolean resourcesVisible = false;
        try {
            resourcesVisible = statsManager.isEnableResourceStats() && Locator.getFacade().getSiteService().getSite(this.siteId).getToolForCommonId("sakai.resources") != null;
        }
        catch (Exception e) {
            resourcesVisible = false;
        }
        if (resourcesVisible) {
            this.add(new Component[]{new ResourcesWidget("resourcesWidget", this.siteId)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("resourcesWidget").setRenderBodyOnly(true)});
        }
    }
}

