/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.providers;

import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.model.IModel;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.models.SiteModel;
import org.sakaiproject.sitestats.tool.wicket.providers.SortableSearchableDataProvider;

public class StatisticableSitesDataProvider
extends SortableSearchableDataProvider {
    private static final long serialVersionUID = 1L;
    public static final String COL_TITLE = "title";
    public static final String COL_TYPE = "type";
    public static final String COL_STATUS = "published";
    public static final String SITE_TYPE_ALL = "all";
    private String siteType = "all";

    public StatisticableSitesDataProvider() {
        InjectorHolder.getInjector().inject((Object)this);
        this.setSort(COL_TITLE, true);
    }

    public Iterator iterator(int first, int count) {
        int start = first + 1;
        int end = start + count - 1;
        PagingPosition pp = new PagingPosition(start, end);
        String type = SITE_TYPE_ALL.equals(this.getSiteType()) ? null : this.getSiteType();
        return Locator.getFacade().getSiteService().getSites(SiteService.SelectionType.NON_USER, (Object)type, this.getSearchKeyword(), null, this.getSSSortType(), pp).iterator();
    }

    private SiteService.SortType getSSSortType() {
        SortParam sp = this.getSort();
        if (sp.getProperty().equals(COL_TITLE)) {
            if (sp.isAscending()) {
                return SiteService.SortType.TITLE_ASC;
            }
            return SiteService.SortType.TITLE_DESC;
        }
        if (sp.getProperty().equals(COL_TYPE)) {
            if (sp.isAscending()) {
                return SiteService.SortType.TYPE_ASC;
            }
            return SiteService.SortType.TYPE_DESC;
        }
        if (sp.getProperty().equals(COL_STATUS)) {
            if (sp.isAscending()) {
                return SiteService.SortType.PUBLISHED_ASC;
            }
            return SiteService.SortType.PUBLISHED_DESC;
        }
        return SiteService.SortType.TITLE_ASC;
    }

    public IModel model(Object object) {
        return new SiteModel((Site)object);
    }

    public int size() {
        String type = SITE_TYPE_ALL.equals(this.getSiteType()) ? null : this.getSiteType();
        return Locator.getFacade().getSiteService().countSites(SiteService.SelectionType.NON_USER, (Object)type, this.getSearchKeyword(), null);
    }

    public void setSiteType(String siteType) {
        this.siteType = siteType;
    }

    public String getSiteType() {
        return this.siteType;
    }
}

