/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket;

import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.sitestats.tool.facade.SakaiFacade;
import org.sakaiproject.sitestats.tool.wicket.SiteStatsApplication;
import org.sakaiproject.sitestats.tool.wicket.pages.OverviewPage;

public class SiteStatsApplication
extends WebApplication {
    private boolean debug = false;
    private transient SakaiFacade facade;

    protected void init() {
        super.init();
        this.addComponentInstantiationListener((IComponentInstantiationListener)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getResourceSettings().addStringResourceLoader((IStringResourceLoader)new SiteStatsStringResourceLoader(null));
        this.getResourceSettings().addResourceFolder("html");
        this.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new SiteStatsResourceStreamLocator());
        this.getDebugSettings().setAjaxDebugModeEnabled(this.debug);
        this.mountBookmarkablePage("/home", OverviewPage.class);
        this.mount((IRequestTargetUrlCodingStrategy)new PassThroughUrlCodingStrategy(this, "/home/panel/Main/none"));
        this.getApplicationSettings().setPageExpiredErrorPage(OverviewPage.class);
        this.getApplicationSettings().setAccessDeniedPage(OverviewPage.class);
        this.debug = ServerConfigurationService.getBoolean((String)"sitestats.debug", (boolean)false);
        if (this.debug) {
            this.getDebugSettings().setComponentUseCheck(true);
            this.getDebugSettings().setAjaxDebugModeEnabled(true);
            this.getDebugSettings().setLinePreciseReportingOnAddComponentEnabled(true);
            this.getDebugSettings().setLinePreciseReportingOnNewComponentEnabled(true);
            this.getDebugSettings().setOutputComponentPath(true);
            this.getDebugSettings().setOutputMarkupContainerClassName(true);
            this.getMarkupSettings().setStripWicketTags(false);
            this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_EXCEPTION_PAGE);
        }
    }

    public Class getHomePage() {
        return OverviewPage.class;
    }

    public SakaiFacade getFacade() {
        return this.facade;
    }

    public void setFacade(SakaiFacade facade) {
        this.facade = facade;
    }

    public RequestCycle newRequestCycle(Request request, Response response) {
        if (!this.debug) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return super.newRequestCycle(request, response);
    }
}

