/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.form.select.IOptionRenderer;
import org.apache.wicket.extensions.markup.html.form.select.Select;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.extensions.markup.html.form.select.SelectOptions;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.parser.EventParserTip;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.CSSFeedbackPanel;
import org.sakaiproject.sitestats.tool.wicket.components.FileSelectorPanel;
import org.sakaiproject.sitestats.tool.wicket.components.IStylableOptionRenderer;
import org.sakaiproject.sitestats.tool.wicket.components.IndicatingAjaxDropDownChoice;
import org.sakaiproject.sitestats.tool.wicket.components.LastJobRun;
import org.sakaiproject.sitestats.tool.wicket.components.Menus;
import org.sakaiproject.sitestats.tool.wicket.components.StylableSelectOptions;
import org.sakaiproject.sitestats.tool.wicket.components.StylableSelectOptionsGroup;
import org.sakaiproject.sitestats.tool.wicket.models.EventModel;
import org.sakaiproject.sitestats.tool.wicket.models.ReportDefModel;
import org.sakaiproject.sitestats.tool.wicket.models.ToolModel;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportsEditPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ReportsEditPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(ReportsEditPage.class);
    private static final String REPORT_THISSITE = "this";
    private static final String REPORT_ALLSITES = "all";
    private String realSiteId;
    private String siteId;
    private boolean predefined = false;
    private String reportSiteOpt = "this";
    private boolean visitsEnabled = true;
    private FeedbackPanel feedback = null;
    private boolean visitsVisible = true;
    private boolean activityVisible = true;
    private boolean resourcesVisible = true;
    private boolean presencesVisible = true;
    private ReportDefModel reportDefModel;
    private PrefsData prefsdata = null;
    private WebPage returnPage;
    private final ReentrantLock ajaxUpdateLock = new ReentrantLock();
    private boolean usersLoaded = false;
    private transient Collator collator = Collator.getInstance();

    public ReportsEditPage() {
        this(null, null, null);
    }

    public ReportsEditPage(ReportDefModel reportDef) {
        this(reportDef, null, null);
    }

    public ReportsEditPage(PageParameters pageParameters) {
        this(null, pageParameters, null);
    }

    public ReportsEditPage(ReportDefModel reportDef, PageParameters pageParameters, WebPage returnPage) {
        this.realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        if (pageParameters != null) {
            this.siteId = pageParameters.getString("siteId");
            this.predefined = pageParameters.getBoolean("predefined");
        }
        if (this.siteId == null) {
            this.siteId = this.realSiteId;
        }
        this.reportDefModel = reportDef != null ? reportDef : (this.predefined ? new ReportDefModel(null, null) : new ReportDefModel(this.siteId, this.siteId));
        this.returnPage = returnPage == null ? new ReportsPage(pageParameters) : returnPage;
        boolean allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(this.siteId);
        if (allowed) {
            this.visitsVisible = Locator.getFacade().getStatsManager().isEnableSiteVisits() && Locator.getFacade().getStatsManager().isVisitsInfoAvailable();
            this.activityVisible = Locator.getFacade().getStatsManager().isEnableSiteActivity();
            this.resourcesVisible = false;
            try {
                this.resourcesVisible = Locator.getFacade().getStatsManager().isEnableResourceStats() && Locator.getFacade().getSiteService().getSite(this.siteId).getToolForCommonId("sakai.resources") != null;
            }
            catch (Exception e) {
                this.resourcesVisible = false;
            }
            this.presencesVisible = Locator.getFacade().getStatsManager().isEnableSitePresences();
            this.renderBody();
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/sitestats-tool/script/jquery-1.3.2.min.js");
        response.renderJavascriptReference("/sitestats-tool/script/reports.js");
        response.renderJavascriptReference("/sitestats-tool/script/jquery.ifixpng2.js");
        StringBuilder onDomReady = new StringBuilder();
        onDomReady.append("checkWhatSelection();");
        onDomReady.append("checkWhenSelection();");
        onDomReady.append("checkWhoSelection();");
        onDomReady.append("checkHowSelection();");
        onDomReady.append("checkReportDetails();");
        onDomReady.append("checkHowChartSelection();");
        onDomReady.append("jQuery.ifixpng('/sitestats-toolimages/transparent.gif'); ");
        onDomReady.append("jQuery('img').ifixpng();");
        response.renderOnDomReadyJavascript(onDomReady.toString());
    }

    private void renderBody() {
        StatsManager statsManager = Locator.getFacade().getStatsManager();
        this.add(new Component[]{new Menus("menu", this.siteId)});
        String action = null;
        if (this.getReportDef().isTitleLocalized()) {
            action = this.reportDefModel.isNew() ? new ResourceModel("report_adding").getObject() : new ResourceModel("report_editing").getObject();
            action = action.replaceAll("\\$\\{title\\}", new ResourceModel(this.getReportDef().getTitleBundleKey()).getObject());
        } else {
            action = this.reportDefModel.isNew() ? new StringResourceModel("report_adding", (Component)this, (IModel)this.reportDefModel).getString() : new StringResourceModel("report_editing", (Component)this, (IModel)this.reportDefModel).getString();
        }
        this.add(new Component[]{new Label("reportAction", action)});
        this.visitsEnabled = statsManager.isEnableSiteVisits();
        if (!this.visitsEnabled) {
            this.getReportParams().setWhat("what-events-bytool");
        }
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{new LastJobRun("lastJobRun", this.siteId)});
        Form form = new Form("reportsForm");
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        this.feedback = new CSSFeedbackPanel("messages");
        this.feedback.setOutputMarkupId(true);
        form.add(new Component[]{this.feedback});
        this.renderReportDetailsUI(form);
        this.renderWhatUI(form);
        this.renderWhenUI(form);
        this.renderWhoUI(form);
        this.renderHowUI(form);
        1 generateReport = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{generateReport});
        2 saveReport = new /* Unavailable Anonymous Inner Class!! */;
        saveReport.setVisible(!this.predefined || this.predefined && Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage() && this.realSiteId.equals(this.siteId));
        form.add(new Component[]{saveReport});
        3 back = new /* Unavailable Anonymous Inner Class!! */;
        back.setDefaultFormProcessing(false);
        form.add(new Component[]{back});
    }

    private void renderReportDetailsUI(Form form) {
        WebMarkupContainer reportDetailsTop = new WebMarkupContainer("reportDetailsTop");
        WebMarkupContainer reportDetailsShow = new WebMarkupContainer("reportDetailsShow");
        reportDetailsTop.add(new Component[]{reportDetailsShow});
        form.add(new Component[]{reportDetailsTop});
        WebMarkupContainer fakeReportDetails = new WebMarkupContainer("fakeReportDetails");
        reportDetailsTop.add(new Component[]{fakeReportDetails});
        WebMarkupContainer reportDetails = new WebMarkupContainer("reportDetails");
        form.add(new Component[]{reportDetails});
        TextField title = new TextField("reportDef.title");
        reportDetails.add(new Component[]{title});
        WebMarkupContainer titleLocalizedContainer = new WebMarkupContainer("titleLocalizedContainer");
        titleLocalizedContainer.setOutputMarkupId(true);
        titleLocalizedContainer.setOutputMarkupPlaceholderTag(true);
        titleLocalizedContainer.setVisible(this.getReportDef().isTitleLocalized());
        titleLocalizedContainer.add(new Component[]{new Label("titleLocalized")});
        reportDetails.add(new Component[]{titleLocalizedContainer});
        title.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        TextArea description = new TextArea("reportDef.description");
        reportDetails.add(new Component[]{description});
        WebMarkupContainer descriptionLocalizedContainer = new WebMarkupContainer("descriptionLocalizedContainer");
        descriptionLocalizedContainer.setOutputMarkupId(true);
        descriptionLocalizedContainer.setOutputMarkupPlaceholderTag(true);
        descriptionLocalizedContainer.setVisible(this.getReportDef().isDescriptionLocalized());
        descriptionLocalizedContainer.add(new Component[]{new Label("descriptionLocalized")});
        reportDetails.add(new Component[]{descriptionLocalizedContainer});
        description.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        if (this.predefined) {
            if (Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage() && this.realSiteId.equals(this.siteId)) {
                reportDetailsTop.setVisible(true);
                reportDetailsShow.setVisible(false);
                reportDetails.setVisible(true);
                fakeReportDetails.setVisible(false);
            } else {
                reportDetailsTop.setVisible(false);
                reportDetailsShow.setVisible(false);
                reportDetails.setVisible(false);
            }
        } else {
            reportDetailsTop.setVisible(true);
            reportDetailsShow.setVisible(true);
            reportDetails.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)"display: none")))});
        }
    }

    private void renderWhatUI(Form form) {
        ArrayList<String> whatOptions = new ArrayList<String>();
        if (this.visitsVisible) {
            whatOptions.add("what-visits");
        }
        if (this.activityVisible) {
            whatOptions.add("what-events");
        }
        if (this.resourcesVisible) {
            whatOptions.add("what-resources");
        }
        if (this.presencesVisible) {
            whatOptions.add("what-presences");
        }
        6 whatChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice what = new DropDownChoice("reportParams.what", whatOptions, (IChoiceRenderer)whatChoiceRenderer);
        what.setMarkupId("what");
        what.setOutputMarkupId(true);
        form.add(new Component[]{what});
        List<String> whatEventSelTypeOptions = Arrays.asList("what-events-bytool", "what-events-byevent");
        7 whatEventSelTypeChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice whatEventSelType = new DropDownChoice("reportParams.whatEventSelType", whatEventSelTypeOptions, (IChoiceRenderer)whatEventSelTypeChoiceRenderer);
        whatEventSelType.setEscapeModelStrings(false);
        whatEventSelType.setMarkupId("whatEventSelType");
        whatEventSelType.setOutputMarkupId(true);
        form.add(new Component[]{whatEventSelType});
        Select whatToolIds = new Select("reportParams.whatToolIds");
        RepeatingView selectOptionsRV1 = new RepeatingView("selectOptionsRV1");
        whatToolIds.add(new Component[]{selectOptionsRV1});
        whatToolIds.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("report_multiple_sel_instruction"))});
        this.addTools(selectOptionsRV1);
        form.add(new Component[]{whatToolIds});
        Select whatEventIds = new Select("reportParams.whatEventIds");
        RepeatingView selectOptionsRV2 = new RepeatingView("selectOptionsRV2");
        whatEventIds.add(new Component[]{selectOptionsRV2});
        whatEventIds.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("report_multiple_sel_instruction"))});
        this.addEvents(selectOptionsRV2);
        form.add(new Component[]{whatEventIds});
        boolean isSiteStatsAdminTool = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage();
        boolean showDefaultBaseFoldersOnly = isSiteStatsAdminTool && this.predefined && this.realSiteId.equals(this.siteId);
        CheckBox whatLimitedAction = new CheckBox("reportParams.whatLimitedAction");
        whatLimitedAction.setMarkupId("whatLimitedAction");
        whatLimitedAction.setOutputMarkupId(true);
        form.add(new Component[]{whatLimitedAction});
        CheckBox whatLimitedResourceIds = new CheckBox("reportParams.whatLimitedResourceIds");
        whatLimitedResourceIds.setMarkupId("whatLimitedResourceIds");
        whatLimitedResourceIds.setOutputMarkupId(true);
        form.add(new Component[]{whatLimitedResourceIds});
        FileSelectorPanel whatResourceIds = new FileSelectorPanel("reportParams.whatResourceIds", this.siteId, showDefaultBaseFoldersOnly);
        whatResourceIds.setMarkupId("whatResourceIds");
        whatResourceIds.setOutputMarkupId(true);
        form.add(new Component[]{whatResourceIds});
        whatResourceIds.setEnabled(true);
        ArrayList<String> resourceActions = new ArrayList<String>();
        resourceActions.add("new");
        resourceActions.add("read");
        resourceActions.add("revise");
        resourceActions.add("delete");
        9 whatResourceAction = new /* Unavailable Anonymous Inner Class!! */;
        whatResourceAction.setMarkupId("whatResourceAction");
        whatResourceAction.setOutputMarkupId(true);
        form.add(new Component[]{whatResourceAction});
    }

    private void renderWhenUI(Form form) {
        List<String> whenOptions = Arrays.asList("when-all", "when-last7days", "when-last30days", "when-last365days", "when-custom");
        10 whenChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice when = new DropDownChoice("reportParams.when", whenOptions, (IChoiceRenderer)whenChoiceRenderer);
        when.setMarkupId("when");
        when.setOutputMarkupId(true);
        form.add(new Component[]{when});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void renderWhoUI(Form form) {
        List groups = this.getGroups();
        RepeatingView selectOptionsRV = new RepeatingView("selectOptionsRV");
        MultipleSelect whoUserIds = new MultipleSelect("reportParams.whoUserIds");
        ArrayList<String> whoOptions = new ArrayList<String>();
        whoOptions.add("who-all");
        whoOptions.add("who-role");
        whoOptions.add("who-custom");
        whoOptions.add("who-none");
        if (groups.size() > 0) {
            whoOptions.add(2, "who-groups");
        }
        13 whoChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        IndicatingAjaxDropDownChoice who = new IndicatingAjaxDropDownChoice("reportParams.who", whoOptions, (IChoiceRenderer)whoChoiceRenderer);
        who.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        who.setMarkupId("who");
        who.setOutputMarkupId(true);
        form.add(new Component[]{who});
        selectOptionsRV.setRenderBodyOnly(true);
        selectOptionsRV.setEscapeModelStrings(true);
        whoUserIds.add(new Component[]{selectOptionsRV});
        whoUserIds.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("report_multiple_sel_instruction"))});
        whoUserIds.setOutputMarkupId(true);
        whoUserIds.setOutputMarkupPlaceholderTag(true);
        whoUserIds.setEscapeModelStrings(true);
        form.add(new Component[]{whoUserIds});
        boolean preloadData = "who-custom".equals(this.getReportParams().getWho());
        if (preloadData) {
            this.addUsers(selectOptionsRV);
        }
        List roles = this.getRoles();
        15 rolesRenderer = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(roles, ReportsEditPage.getChoiceRendererComparator((Collator)this.collator, (IChoiceRenderer)rolesRenderer));
        DropDownChoice whoRoleId = new DropDownChoice("reportParams.whoRoleId", roles, (IChoiceRenderer)rolesRenderer);
        whoRoleId.setEnabled(roles.size() > 0);
        if (this.getReportParams().getWhoRoleId() == null) {
            if (roles.size() > 0) {
                this.getReportParams().setWhoRoleId((String)roles.get(0));
            } else {
                this.getReportParams().setWhoRoleId("");
            }
        }
        form.add(new Component[]{whoRoleId});
        WebMarkupContainer whoGroupTr = new WebMarkupContainer("who-groups-tr");
        form.add(new Component[]{whoGroupTr});
        16 groupsRenderer = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(groups, ReportsEditPage.getChoiceRendererComparator((Collator)this.collator, (IChoiceRenderer)groupsRenderer));
        DropDownChoice whoGroupId = new DropDownChoice("reportParams.whoGroupId", groups, (IChoiceRenderer)groupsRenderer);
        if (groups.size() == 0) {
            whoGroupTr.setVisible(false);
        } else if (this.getReportParams().getWhoGroupId() == null) {
            if (groups.size() > 0) {
                this.getReportParams().setWhoGroupId((String)groups.get(0));
            } else {
                this.getReportParams().setWhoGroupId("");
            }
        }
        whoGroupTr.add(new Component[]{whoGroupId});
    }

    private void renderHowUI(Form form) {
        boolean isSiteStatsAdminTool = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage();
        boolean renderSiteSelectOption = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage() && !this.predefined && this.realSiteId.equals(this.siteId);
        boolean renderSiteSortOption = isSiteStatsAdminTool && !this.predefined && this.realSiteId.equals(this.siteId);
        boolean renderSortAscendingOption = isSiteStatsAdminTool && this.predefined && this.realSiteId.equals(this.siteId);
        17 allColumnsChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        WebMarkupContainer siteContainer = new WebMarkupContainer("siteContainer");
        siteContainer.setVisible(renderSiteSelectOption);
        form.add(new Component[]{siteContainer});
        List<String> reportSiteOptions = Arrays.asList("this", "all");
        18 reportSiteRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice reportSite = new DropDownChoice("reportSite", (IModel)new PropertyModel((Object)this, "reportSite"), reportSiteOptions, (IChoiceRenderer)reportSiteRenderer);
        reportSite.setMarkupId("reportSite");
        reportSite.setOutputMarkupId(true);
        siteContainer.add(new Component[]{reportSite});
        this.reportSiteOpt = this.getReportParams().getSiteId() == null ? "all" : "this";
        Select howTotalsBy = new Select("reportParams.howTotalsBy");
        howTotalsBy.setRequired(true);
        howTotalsBy.setMarkupId("howTotalsBy");
        howTotalsBy.setOutputMarkupId(true);
        form.add(new Component[]{howTotalsBy});
        RepeatingView howTotalsByOptions = new RepeatingView("howTotalsByOptions");
        howTotalsBy.add(new Component[]{howTotalsByOptions});
        this.addGroupOptions(howTotalsByOptions);
        WebMarkupContainer trSortBy = new WebMarkupContainer("trSortBy");
        trSortBy.setVisible(renderSortAscendingOption);
        form.add(new Component[]{trSortBy});
        CheckBox howSortCheck = new CheckBox("reportParams.howSort");
        howSortCheck.setMarkupId("howSortCheck");
        howSortCheck.setOutputMarkupId(true);
        trSortBy.add(new Component[]{howSortCheck});
        List<String> sortOptions = null;
        sortOptions = renderSiteSortOption ? Arrays.asList("event", "resource", "resource-action", "date", "total", "site") : Arrays.asList("event", "resource", "resource-action", "date", "total");
        DropDownChoice howSortBy = new DropDownChoice("reportParams.howSortBy", sortOptions, (IChoiceRenderer)allColumnsChoiceRenderer);
        howSortBy.setMarkupId("howSortBy");
        howSortBy.setOutputMarkupId(true);
        trSortBy.add(new Component[]{howSortBy});
        CheckBox howSortAscending = new CheckBox("reportParams.howSortAscending");
        howSortAscending.setMarkupId("howSortAscending");
        howSortAscending.setOutputMarkupId(true);
        trSortBy.add(new Component[]{howSortAscending});
        CheckBox howMaxResultsCheck = new CheckBox("reportParams.howLimitedMaxResults");
        howMaxResultsCheck.setMarkupId("howMaxResultsCheck");
        howMaxResultsCheck.setOutputMarkupId(true);
        form.add(new Component[]{howMaxResultsCheck});
        19 howMaxResults = new /* Unavailable Anonymous Inner Class!! */;
        howMaxResults.setMarkupId("howMaxResults");
        howMaxResults.setOutputMarkupId(true);
        form.add(new Component[]{howMaxResults});
        List<String> howPresentationOptions = Arrays.asList("how-presentation-table", "how-presentation-chart", "how-presentation-both");
        20 howPresentationChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice howPresentation = new DropDownChoice("reportParams.howPresentationMode", howPresentationOptions, (IChoiceRenderer)howPresentationChoiceRenderer);
        howPresentation.setMarkupId("howPresentation");
        howPresentation.setOutputMarkupId(true);
        form.add(new Component[]{howPresentation});
        List<String> howChartTypeOptions = Arrays.asList("bar", "pie", "timeseries", "timeseriesbar");
        21 howChartTypeChoiceRenderer = new /* Unavailable Anonymous Inner Class!! */;
        DropDownChoice howChartType = new DropDownChoice("reportParams.howChartType", howChartTypeOptions, (IChoiceRenderer)howChartTypeChoiceRenderer);
        howChartType.setMarkupId("howChartType");
        howChartType.setOutputMarkupId(true);
        form.add(new Component[]{howChartType});
        List<String> howChartSourceOptions = null;
        List<String> howChartCategorySourceOptions = null;
        List<String> howChartSeriesSourceOptions = null;
        if (renderSiteSortOption) {
            howChartSourceOptions = Arrays.asList("site", "user", "tool", "event", "resource", "resource-action", "date");
            howChartCategorySourceOptions = Arrays.asList("none", "site", "user", "tool", "event", "resource", "resource-action", "date");
            howChartSeriesSourceOptions = Arrays.asList("site", "user", "tool", "event", "resource", "resource-action", "total");
        } else {
            howChartSourceOptions = Arrays.asList("user", "tool", "event", "resource", "resource-action", "date");
            howChartCategorySourceOptions = Arrays.asList("none", "tool", "user", "event", "resource", "resource-action", "date");
            howChartSeriesSourceOptions = Arrays.asList("user", "tool", "event", "resource", "resource-action", "total");
        }
        DropDownChoice howChartSource = new DropDownChoice("reportParams.howChartSource", howChartSourceOptions, (IChoiceRenderer)allColumnsChoiceRenderer);
        howChartSource.setMarkupId("howChartSource");
        howChartSource.setOutputMarkupId(true);
        form.add(new Component[]{howChartSource});
        DropDownChoice howChartCategorySource = new DropDownChoice("reportParams.howChartCategorySource", howChartCategorySourceOptions, (IChoiceRenderer)allColumnsChoiceRenderer);
        howChartCategorySource.setMarkupId("howChartCategorySource");
        howChartCategorySource.setOutputMarkupId(true);
        form.add(new Component[]{howChartCategorySource});
        DropDownChoice howChartSeriesSource = new DropDownChoice("reportParams.howChartSeriesSource", howChartSeriesSourceOptions, (IChoiceRenderer)allColumnsChoiceRenderer);
        howChartSeriesSource.setMarkupId("howChartSeriesSource");
        howChartSeriesSource.setOutputMarkupId(true);
        form.add(new Component[]{howChartSeriesSource});
    }

    private void addTools(RepeatingView rv) {
        ArrayList<SelectOption> tools = new ArrayList<SelectOption>();
        List siteTools = Locator.getFacade().getEventRegistryService().getEventRegistry(this.siteId, this.getPrefsdata().isListToolEventsOnlyAvailableInSite());
        for (ToolInfo toolInfo : siteTools) {
            if (!this.isToolSuported(toolInfo)) continue;
            tools.add(new SelectOption("option", (IModel)new ToolModel(toolInfo)));
        }
        WebMarkupContainer optgroupItem = new WebMarkupContainer(rv.newChildId());
        optgroupItem.setRenderBodyOnly(true);
        rv.add(new Component[]{optgroupItem});
        22 optionRenderer = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(tools, ReportsEditPage.getOptionRendererComparator((Collator)this.collator, (IOptionRenderer)optionRenderer));
        tools.add(0, new SelectOption("option", (IModel)new ToolModel("all", "all")));
        StylableSelectOptions selectOptions = new StylableSelectOptions("selectOptions", tools, (IStylableOptionRenderer)optionRenderer);
        selectOptions.setRenderBodyOnly(true);
        optgroupItem.add(new Component[]{selectOptions});
    }

    private void addEvents(RepeatingView rv) {
        List siteTools = Locator.getFacade().getEventRegistryService().getEventRegistry(this.siteId, this.getPrefsdata().isListToolEventsOnlyAvailableInSite());
        Collections.sort(siteTools, ReportsEditPage.getToolInfoComparator((Collator)this.collator));
        for (ToolInfo toolInfo : siteTools) {
            if (!this.isToolSuported(toolInfo)) continue;
            List eventInfos = toolInfo.getEvents();
            ArrayList<SelectOption> events = new ArrayList<SelectOption>();
            for (EventInfo e : eventInfos) {
                SelectOption opt = new SelectOption("option", (IModel)new EventModel(e));
                events.add(opt);
            }
            WebMarkupContainer optgroupItem = new WebMarkupContainer(rv.newChildId());
            optgroupItem.setRenderBodyOnly(true);
            rv.add(new Component[]{optgroupItem});
            String toolIconPath = "background-image: url(" + Locator.getFacade().getEventRegistryService().getToolIcon(toolInfo.getToolId()) + ");";
            String style = "background-position:left top; background-repeat:no-repeat; margin-left:3px; padding-left:20px; " + toolIconPath;
            String toolName = Locator.getFacade().getEventRegistryService().getToolName(toolInfo.getToolId());
            StylableSelectOptionsGroup group = new StylableSelectOptionsGroup("group", (IModel)new Model((Serializable)((Object)toolName)), (IModel)new Model((Serializable)((Object)style)));
            optgroupItem.add(new Component[]{group});
            SelectOptions selectOptions = new SelectOptions("selectOptions", events, (IOptionRenderer)new /* Unavailable Anonymous Inner Class!! */);
            selectOptions.setRenderBodyOnly(true);
            group.add(new Component[]{selectOptions});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUsers(RepeatingView rv) {
        if (this.usersLoaded) {
            return;
        }
        this.ajaxUpdateLock.lock();
        try {
            ArrayList<SelectOption> users = new ArrayList<SelectOption>();
            if (Locator.getFacade().getStatsManager().isShowAnonymousAccessEvents()) {
                SelectOption anon = new SelectOption("option", (IModel)new Model((Serializable)((Object)"?")));
                users.add(anon);
            }
            HashSet siteUsers = null;
            try {
                siteUsers = Locator.getFacade().getSiteService().getSite(this.siteId).getUsers();
            }
            catch (IdUnusedException e) {
                LOG.warn((Object)("Site does not exist: " + this.siteId));
                siteUsers = new HashSet();
            }
            for (String userId : siteUsers) {
                if (userId == null) continue;
                SelectOption opt = new SelectOption("option", (IModel)new Model((Serializable)((Object)userId)));
                opt.setEscapeModelStrings(true);
                users.add(opt);
            }
            WebMarkupContainer optgroupItem = new WebMarkupContainer(rv.newChildId());
            optgroupItem.setRenderBodyOnly(true);
            rv.add(new Component[]{optgroupItem});
            24 optionRenderer = new /* Unavailable Anonymous Inner Class!! */;
            Collections.sort(users, ReportsEditPage.getOptionRendererComparator((Collator)this.collator, (IOptionRenderer)optionRenderer));
            SelectOptions selectOptions = new SelectOptions("selectOptions", users, (IOptionRenderer)optionRenderer);
            selectOptions.setRenderBodyOnly(true);
            optgroupItem.add(new Component[]{selectOptions});
            this.usersLoaded = true;
        }
        finally {
            this.ajaxUpdateLock.unlock();
        }
    }

    private void addGroupOptions(RepeatingView rv) {
        boolean isSiteStatsAdminTool = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage();
        boolean renderAdminOptions = isSiteStatsAdminTool && !this.predefined && this.realSiteId.equals(this.siteId);
        ArrayList<String> totalsOptions = new ArrayList<String>();
        totalsOptions.add("user");
        totalsOptions.add("tool");
        totalsOptions.add("event");
        totalsOptions.add("resource");
        totalsOptions.add("resource-action");
        totalsOptions.add("date");
        if (renderAdminOptions) {
            totalsOptions.add("site");
        }
        ArrayList<SelectOption> selectOptionList = new ArrayList<SelectOption>();
        for (String totalOpt : totalsOptions) {
            SelectOption so = new SelectOption("option", (IModel)new Model((Serializable)((Object)totalOpt)));
            so.setEscapeModelStrings(false);
            selectOptionList.add(so);
        }
        WebMarkupContainer optgroupItem = new WebMarkupContainer(rv.newChildId());
        optgroupItem.setRenderBodyOnly(true);
        rv.add(new Component[]{optgroupItem});
        25 optionRenderer = new /* Unavailable Anonymous Inner Class!! */;
        SelectOptions selectOptions = new SelectOptions("selectOptions", selectOptionList, (IOptionRenderer)optionRenderer);
        selectOptions.setRenderBodyOnly(true);
        selectOptions.setEscapeModelStrings(false);
        optgroupItem.add(new Component[]{selectOptions});
    }

    private List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            Collection groupCollection = Locator.getFacade().getSiteService().getSite(this.siteId).getGroups();
            for (Group g : groupCollection) {
                groups.add(g.getId());
            }
        }
        catch (IdUnusedException e) {
            LOG.warn((Object)("Site does not exist: " + this.siteId));
        }
        return groups;
    }

    private List<String> getRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            Set roleSet = Locator.getFacade().getSiteService().getSite(this.siteId).getRoles();
            for (Role r : roleSet) {
                roles.add(r.getId());
            }
        }
        catch (IdUnusedException e) {
            LOG.warn((Object)("Site does not exist: " + this.siteId));
        }
        return roles;
    }

    private boolean isToolSuported(ToolInfo toolInfo) {
        if (Locator.getFacade().getStatsManager().isEventContextSupported()) {
            return true;
        }
        List siteTools = Locator.getFacade().getEventRegistryService().getEventRegistry(this.siteId, this.getPrefsdata().isListToolEventsOnlyAvailableInSite());
        for (ToolInfo t : siteTools) {
            EventParserTip parserTip;
            if (!t.getToolId().equals(toolInfo.getToolId()) || (parserTip = t.getEventParserTip()) == null || !parserTip.getFor().equals("contextId")) continue;
            return true;
        }
        return false;
    }

    public static final Comparator<String> getStringComparator(Collator collator) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final Comparator<ToolInfo> getToolInfoComparator(Collator collator) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final Comparator<Object> getOptionRendererComparator(Collator collator, IOptionRenderer renderer) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static final Comparator<Object> getChoiceRendererComparator(Collator collator, IChoiceRenderer renderer) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private PrefsData getPrefsdata() {
        if (this.prefsdata == null) {
            this.prefsdata = Locator.getFacade().getStatsManager().getPreferences(this.siteId, true);
        }
        return this.prefsdata;
    }

    private boolean validReportParameters() {
        Site site = null;
        try {
            site = Locator.getFacade().getSiteService().getSite(this.siteId);
        }
        catch (IdUnusedException e) {
            LOG.error((Object)("No site with id: " + this.siteId));
        }
        if (this.getReportParams().getWhat().equals("what-events") && this.getReportParams().getWhatEventSelType().equals("what-events-bytool") && (this.getReportParams().getWhatToolIds() == null || this.getReportParams().getWhatToolIds().size() == 0)) {
            this.error((Serializable)((Object)new ResourceModel("report_err_notools").getObject()));
        }
        if (this.getReportParams().getWhat().equals("what-events") && this.getReportParams().getWhatEventSelType().equals("what-events-byevent") && (this.getReportParams().getWhatEventIds() == null || this.getReportParams().getWhatEventIds().size() == 0)) {
            this.error((Serializable)((Object)new ResourceModel("report_err_noevents").getObject()));
        }
        if (this.getReportParams().getWhat().equals("what-resources") && this.getReportParams().isWhatLimitedResourceIds() && (this.getReportParams().getWhatResourceIds() == null || this.getReportParams().getWhatResourceIds().size() == 0)) {
            this.error((Serializable)((Object)new ResourceModel("report_err_noresources").getObject()));
        }
        if (this.getReportParams().getWhen().equals("when-custom") && (this.getReportParams().getWhenFrom() == null || this.getReportParams().getWhenTo() == null)) {
            this.error((Serializable)((Object)new ResourceModel("report_err_nocustomdates").getObject()));
        }
        if (this.getReportParams().getWho().equals("who-role")) {
            if (site.getUsersHasRole(this.getReportParams().getWhoRoleId()).isEmpty()) {
                this.error((Serializable)((Object)new ResourceModel("report_err_emptyrole").getObject()));
            }
        } else if (this.getReportParams().getWho().equals("who-groups")) {
            if (this.getReportParams().getWhoGroupId() == null || this.getReportParams().getWhoGroupId().equals("")) {
                this.error((Serializable)((Object)new ResourceModel("report_err_nogroup").getObject()));
            } else if (site.getGroup(this.getReportParams().getWhoGroupId()).getUsers().isEmpty()) {
                this.error((Serializable)((Object)new ResourceModel("report_err_emptygroup").getObject()));
            }
        } else if (this.getReportParams().getWho().equals("who-custom") && (this.getReportParams().getWhoUserIds() == null || this.getReportParams().getWhoUserIds().size() == 0)) {
            this.error((Serializable)((Object)new ResourceModel("report_err_nousers").getObject()));
        }
        if (this.getReportParams().getHowTotalsBy() != null) {
            if (this.getReportParams().getHowSortBy().length() == 0) {
                this.error((Serializable)((Object)new ResourceModel("report_err_totalsbynone").getObject()));
            }
            if (this.getReportParams().getWhat().equals("what-events") && (this.getReportParams().getHowTotalsBy().contains("resource") || this.getReportParams().getHowTotalsBy().contains("resource-action"))) {
                this.error((Serializable)((Object)new ResourceModel("report_err_totalsbyevent").getObject()));
            } else if (this.getReportParams().getWhat().equals("what-resources") && this.getReportParams().getHowTotalsBy().contains("event")) {
                this.error((Serializable)((Object)new ResourceModel("report_err_totalsbyresource").getObject()));
            }
        }
        if (this.getReportParams().isHowSort() && this.getReportParams().getHowSortBy() != null && !this.getReportParams().getHowSortBy().equals("default") && !"total".equals(this.getReportParams().getHowSortBy()) && !this.getReportParams().getHowTotalsBy().contains(this.getReportParams().getHowSortBy())) {
            this.getReportParams().setHowSort(false);
            this.getReportParams().setHowSortBy(null);
        }
        return !this.hasErrorMessage();
    }

    public String getReportSite() {
        return this.reportSiteOpt;
    }

    public void setReportSite(String reportSiteOpt) {
        this.reportSiteOpt = reportSiteOpt;
        if ("this".equals(reportSiteOpt)) {
            this.getReportParams().setSiteId(this.siteId);
        } else if ("all".equals(reportSiteOpt)) {
            this.getReportParams().setSiteId(null);
        }
    }

    public String getTitleLocalized() {
        return new ResourceModel(this.getReportDef().getTitleBundleKey()).getObject();
    }

    public String getDescriptionLocalized() {
        return new ResourceModel(this.getReportDef().getDescriptionBundleKey()).getObject();
    }

    public ReportDef getReportDef() {
        return (ReportDef)this.reportDefModel.getObject();
    }

    public void setReportParams(ReportParams reportParams) {
        this.getReportDef().setReportParams(reportParams);
    }

    public ReportParams getReportParams() {
        return this.getReportDef().getReportParams();
    }

    static /* synthetic */ boolean access$000(ReportsEditPage x0) {
        return x0.validReportParameters();
    }

    static /* synthetic */ boolean access$100(ReportsEditPage x0) {
        return x0.predefined;
    }

    static /* synthetic */ String access$200(ReportsEditPage x0) {
        return x0.siteId;
    }

    static /* synthetic */ ReportDefModel access$300(ReportsEditPage x0) {
        return x0.reportDefModel;
    }

    static /* synthetic */ WebPage access$400(ReportsEditPage x0) {
        return x0.returnPage;
    }

    static /* synthetic */ void access$500(ReportsEditPage x0, RepeatingView x1) {
        x0.addUsers(x1);
    }
}

