/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.AdminMenu;
import org.sakaiproject.sitestats.tool.wicket.components.AjaxLazyLoadImage;
import org.sakaiproject.sitestats.tool.wicket.models.ServerWideModel;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ServerWidePage;

public class ServerWidePage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private Label reportTitle = null;
    private Label reportDescription = null;
    private AjaxLazyLoadImage reportChart = null;
    private Label reportNotes = null;
    private WebMarkupContainer selectors = null;
    private ServerWideModel report = null;
    private String siteId = null;
    private int selectedWidth = 0;
    private int selectedHeight = 0;
    private List<Component> links = new ArrayList();
    private Map<Component, Component> labels = new HashMap();

    public ServerWidePage() {
        this(null);
    }

    public ServerWidePage(PageParameters params) {
        this.siteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        boolean allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStatsAdmin(this.siteId);
        if (allowed) {
            this.renderBody();
        } else {
            this.redirectToInterceptPage((Page)new NotAuthorizedPage());
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/sitestats-tool/script/jquery-1.3.2.min.js");
    }

    private void renderBody() {
        this.add(new Component[]{new AdminMenu("menu")});
        this.report = new ServerWideModel();
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        Form form = new Form("serverWideReportForm");
        this.add(new Component[]{form});
        this.reportTitle = new Label("report.reportTitle");
        this.reportTitle.setOutputMarkupId(true);
        form.add(new Component[]{this.reportTitle});
        this.reportDescription = new Label("report.reportDescription");
        this.reportDescription.setOutputMarkupId(true);
        form.add(new Component[]{this.reportDescription});
        this.reportNotes = new Label("report.reportNotes");
        this.reportNotes.setOutputMarkupId(true);
        form.add(new Component[]{this.reportNotes});
        this.reportChart = new /* Unavailable Anonymous Inner Class!! */;
        this.reportChart.setOutputMarkupId(true);
        this.reportChart.setAutoDetermineChartSizeByAjax(".chartContainer");
        form.add(new Component[]{this.reportChart});
        this.selectors = new WebMarkupContainer("selectors");
        this.selectors.setOutputMarkupId(true);
        form.add(new Component[]{this.selectors});
        this.makeSelectorLink("reportMonthlyLogin", "monthlyLogin");
        this.makeSelectorLink("reportWeeklyLogin", "weeklyLogin");
        this.makeSelectorLink("reportDailyLogin", "dailyLogin");
        this.makeSelectorLink("reportRegularUsers", "regularUsers");
        this.makeSelectorLink("reportHourlyUsage", "hourlyUsage");
        this.makeSelectorLink("reportTopActivities", "topActivities");
        this.makeSelectorLink("reportTool", "toolReport");
    }

    public void setReport(ServerWideModel report) {
        this.report = report;
    }

    public ServerWideModel getReport() {
        return this.report;
    }

    private byte[] getChartImage(int width, int height) {
        int _width = width <= 0 ? 350 : width;
        int _height = height <= 0 ? 200 : height;
        return Locator.getFacade().getServerWideReportManager().generateReportChart(this.report.getSelectedView(), _width, _height);
    }

    private void makeSelectorLink(String id, String view) {
        2 link = new /* Unavailable Anonymous Inner Class!! */;
        link.setVisible(true);
        this.links.add(link);
        this.selectors.add(new Component[]{link});
        this.makeSelectorLabel((Component)link, id + "Lbl");
    }

    private void makeSelectorLabel(Component link, String id) {
        WebMarkupContainer label = new WebMarkupContainer(id);
        label.setVisible(false);
        this.labels.put(link, label);
        this.selectors.add(new Component[]{label});
    }

    static /* synthetic */ int access$000(ServerWidePage x0) {
        return x0.selectedWidth;
    }

    static /* synthetic */ int access$100(ServerWidePage x0) {
        return x0.selectedHeight;
    }

    static /* synthetic */ byte[] access$200(ServerWidePage x0, int x1, int x2) {
        return x0.getChartImage(x1, x2);
    }

    static /* synthetic */ ServerWideModel access$300(ServerWidePage x0) {
        return x0.report;
    }

    static /* synthetic */ Label access$400(ServerWidePage x0) {
        return x0.reportTitle;
    }

    static /* synthetic */ Label access$500(ServerWidePage x0) {
        return x0.reportDescription;
    }

    static /* synthetic */ Label access$600(ServerWidePage x0) {
        return x0.reportNotes;
    }

    static /* synthetic */ AjaxLazyLoadImage access$700(ServerWidePage x0) {
        return x0.reportChart;
    }

    static /* synthetic */ Map access$800(ServerWidePage x0) {
        return x0.labels;
    }

    static /* synthetic */ List access$900(ServerWidePage x0) {
        return x0.links;
    }

    static /* synthetic */ WebMarkupContainer access$1000(ServerWidePage x0) {
        return x0.selectors;
    }
}

