/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.providers;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.Stat;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.event.EventRegistryService;
import org.sakaiproject.sitestats.api.report.Report;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.providers.SortableSearchableDataProvider;
import org.sakaiproject.user.api.UserDirectoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportsDataProvider
extends SortableSearchableDataProvider {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(ReportsDataProvider.class);
    public static final String COL_SITE = "site";
    public static final String COL_USERID = "user";
    public static final String COL_USERNAME = "userName";
    public static final String COL_EVENT = "event";
    public static final String COL_TOOL = "tool";
    public static final String COL_RESOURCE = "resource";
    public static final String COL_ACTION = "resource-action";
    public static final String COL_DATE = "date";
    public static final String COL_TOTAL = "total";
    public static final String COL_VISITS = "visits";
    public static final String COL_UNIQUEVISITS = "unique-visits";
    public static final String COL_DURATION = "duration";
    private boolean log = true;
    private PrefsData prefsData;
    private ReportDef reportDef;
    private Report report;
    private int reportRowCount = -1;

    public ReportsDataProvider(PrefsData prefsData, ReportDef reportDef) {
        this(prefsData, reportDef, true);
    }

    public ReportsDataProvider(PrefsData prefsData, ReportDef reportDef, boolean log) {
        InjectorHolder.getInjector().inject((Object)this);
        this.prefsData = prefsData;
        this.setReportDef(reportDef);
        this.log = log;
        if (!reportDef.getReportParams().isHowSort() || reportDef.getReportParams().getHowSortBy() == null) {
            this.setSort(COL_USERNAME, true);
        } else {
            this.setSort(reportDef.getReportParams().getHowSortBy(), reportDef.getReportParams().getHowSortAscending());
        }
    }

    public void setReportDef(ReportDef reportDef) {
        this.report = null;
        this.reportRowCount = -1;
        this.reportDef = reportDef;
    }

    public ReportDef getReportDef() {
        return this.reportDef;
    }

    public Iterator iterator(int first, int count) {
        int end = first + count;
        end = end < this.size() ? this.size() : end;
        end = end < 0 ? this.getReport().getReportData().size() : end;
        return this.getReport().getReportData().subList(first, end).iterator();
    }

    public Report getReport() {
        if (this.report == null) {
            this.report = Locator.getFacade().getReportManager().getReport(this.getReportDef(), this.prefsData.isListToolEventsOnlyAvailableInSite(), null, this.log);
            if (this.log && this.report != null) {
                LOG.info((Object)("Site statistics report generated: " + this.report.getReportDefinition().toString(false)));
            }
        }
        if (this.report != null) {
            this.sortReport();
        }
        return this.report;
    }

    public IModel model(Object object) {
        return new Model((Serializable)object);
    }

    public int size() {
        if (this.reportRowCount == -1) {
            this.reportRowCount = this.getReport().getReportData().size();
        }
        return this.reportRowCount;
    }

    public void sortReport() {
        Collections.sort(this.report.getReportData(), this.getReportDataComparator(this.getSort().getProperty(), this.getSort().isAscending(), Locator.getFacade().getStatsManager(), Locator.getFacade().getEventRegistryService(), Locator.getFacade().getUserDirectoryService()));
    }

    public final Comparator<Stat> getReportDataComparator(String fieldName, boolean sortAscending, StatsManager SST_sm, EventRegistryService SST_ers, UserDirectoryService M_uds) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

