/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.MenuItem;
import org.sakaiproject.sitestats.tool.wicket.pages.AdminPage;
import org.sakaiproject.sitestats.tool.wicket.pages.OverviewPage;
import org.sakaiproject.sitestats.tool.wicket.pages.PreferencesPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportsPage;

public class Menu
extends Panel {
    private static final long serialVersionUID = 1L;

    public Menu(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.renderBody();
    }

    public Menu(String id, String siteId) {
        super(id);
        this.setRenderBodyOnly(true);
        this.renderBody(siteId);
    }

    private void renderBody() {
        this.renderBody(Locator.getFacade().getToolManager().getCurrentPlacement().getContext());
    }

    private void renderBody(String siteId) {
        Class currentPageClass = this.getRequestCycle().getResponsePageClass();
        PageParameters pageParameters = new PageParameters();
        if (siteId != null) {
            pageParameters.put("siteId", (Object)siteId);
        }
        String realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        boolean isSiteStatsAdminPage = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage();
        boolean isBrowsingThisSite = siteId != null && siteId.equals(realSiteId);
        String siteTitle = null;
        try {
            siteTitle = Locator.getFacade().getSiteService().getSite(siteId).getTitle();
        }
        catch (IdUnusedException e) {
            siteTitle = siteId;
        }
        Label siteDisplay = new Label("siteDisplay", siteTitle);
        boolean siteDisplayVisible = isSiteStatsAdminPage && !isBrowsingThisSite;
        siteDisplay.setVisible(siteDisplayVisible);
        this.add(new Component[]{siteDisplay});
        boolean overviewVisible = !AdminPage.class.equals((Object)currentPageClass) && (Locator.getFacade().getStatsManager().isEnableSiteVisits() || Locator.getFacade().getStatsManager().isEnableSiteActivity());
        MenuItem overview = new MenuItem("overview", (IModel)new ResourceModel("menu_overview"), OverviewPage.class, pageParameters, !siteDisplayVisible);
        overview.setVisible(overviewVisible);
        this.add(new Component[]{overview});
        MenuItem reports = new MenuItem("reports", (IModel)new ResourceModel("menu_reports"), ReportsPage.class, pageParameters, false);
        if (!overviewVisible) {
            reports.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"firstToolBarItem")))});
        }
        this.add(new Component[]{reports});
        MenuItem preferences = new MenuItem("preferences", (IModel)new ResourceModel("menu_prefs"), PreferencesPage.class, pageParameters, false);
        this.add(new Component[]{preferences});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "menu");
    }
}

