/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.models;

import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.tool.facade.Locator;

public class EventModel
implements IModel {
    private static final long serialVersionUID = 1L;
    private String eventId = "";
    private String eventName = "";

    public EventModel(String eventId, String eventName) {
        this.eventId = eventId;
        this.eventName = eventName;
    }

    public EventModel(EventInfo e) {
        this.eventId = e.getEventId();
        this.eventName = Locator.getFacade().getEventRegistryService().getEventName(this.eventId);
    }

    public Object getObject() {
        return this.getEventId() + " + " + this.getEventName();
    }

    public void setObject(Object object) {
        if (object instanceof String) {
            String[] str = ((String)object).split(" \\+ ");
            this.eventId = str[0];
            this.eventName = str[1];
        }
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventName() {
        if ("all".equals(this.eventName)) {
            return new ResourceModel("all").getObject();
        }
        return this.eventName;
    }

    public void detach() {
        this.eventId = null;
        this.eventName = null;
    }
}

