/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.CSSFeedbackPanel;
import org.sakaiproject.sitestats.tool.wicket.components.LastJobRun;
import org.sakaiproject.sitestats.tool.wicket.components.Menus;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportsPage;
import org.sakaiproject.sitestats.tool.wicket.providers.ReportDefsProvider;

public class ReportsPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(ReportsPage.class);
    private String realSiteId;
    private String siteId;

    public ReportsPage() {
    }

    public ReportsPage(PageParameters pageParameters) {
        boolean allowed;
        this.realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        if (pageParameters != null) {
            this.siteId = pageParameters.getString("siteId");
        }
        if (this.siteId == null) {
            this.siteId = this.realSiteId;
        }
        if (allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(this.siteId)) {
            this.renderBody();
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/sitestats-tool/script/jquery-1.3.2.min.js");
        response.renderJavascriptReference("/sitestats-tool/script/jquery.ifixpng2.js");
        StringBuilder onDomReady = new StringBuilder();
        onDomReady.append("jQuery.ifixpng('/sitestats-tool/images/transparent.gif');");
        onDomReady.append("jQuery('img').ifixpng();");
        response.renderOnDomReadyJavascript(onDomReady.toString());
    }

    private void renderBody() {
        boolean isSiteStatsAdminPage = Locator.getFacade().getStatsAuthz().isSiteStatsAdminPage();
        boolean isAdministering = isSiteStatsAdminPage && this.realSiteId.equals(this.siteId);
        boolean isFilteringReportsWithToolsInSite = !isAdministering;
        this.add(new Component[]{new Menus("menu", this.siteId)});
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{new Label("pageTitle")});
        this.add(new Component[]{new LastJobRun("lastJobRun", this.siteId)});
        Form form = new Form("reportsForm");
        this.add(new Component[]{form});
        form.add(new Component[]{new CSSFeedbackPanel("messages")});
        WebMarkupContainer myReportsContainer = new WebMarkupContainer("myReportsContainer");
        1 lnkNewReport = new /* Unavailable Anonymous Inner Class!! */;
        myReportsContainer.add(new Component[]{lnkNewReport});
        WebMarkupContainer noReports = new WebMarkupContainer("noReports");
        myReportsContainer.add(new Component[]{noReports});
        ReportDefsProvider myReportsProvider = new ReportDefsProvider(this.siteId, 0, true, false);
        2 myReports = new /* Unavailable Anonymous Inner Class!! */;
        myReportsContainer.add(new Component[]{myReports});
        form.add(new Component[]{myReportsContainer});
        WebMarkupContainer predefinedReportsContainer = new WebMarkupContainer("predefinedReportsContainer");
        WebMarkupContainer noPredefReports = new WebMarkupContainer("noReports");
        predefinedReportsContainer.add(new Component[]{noPredefReports});
        WebMarkupContainer adminAddContainer = new WebMarkupContainer("adminAddContainer");
        adminAddContainer.setVisible(isAdministering);
        predefinedReportsContainer.add(new Component[]{adminAddContainer});
        3 lnkPDNewReport = new /* Unavailable Anonymous Inner Class!! */;
        adminAddContainer.add(new Component[]{lnkPDNewReport});
        ReportDefsProvider predefinedReportsProvider = new ReportDefsProvider(this.siteId, 1, isFilteringReportsWithToolsInSite, isAdministering);
        4 predefinedReports = new /* Unavailable Anonymous Inner Class!! */;
        predefinedReportsContainer.add(new Component[]{predefinedReports});
        predefinedReportsContainer.setVisible(isSiteStatsAdminPage || predefinedReportsProvider.size() != 0);
        form.add(new Component[]{predefinedReportsContainer});
    }

    public String getPageTitle() {
        return new ResourceModel("menu_reports").getObject();
    }

    static /* synthetic */ String access$000(ReportsPage x0) {
        return x0.siteId;
    }

    static /* synthetic */ String access$100(ReportsPage x0) {
        return x0.realSiteId;
    }
}

