/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.models.ReportDefModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDefsProvider
implements IDataProvider {
    private static final long serialVersionUID = 1L;
    public static final int MODE_MYREPORTS = 0;
    public static final int MODE_PREDEFINED_REPORTS = 1;
    public static final int MODE_MY_AND_PREDEFINED_REPORTS = 2;
    private String siteId;
    private int mode;
    private boolean filterWithToolsInSite;
    private boolean includeHidden;
    private List<ReportDef> data;

    public ReportDefsProvider(String siteId, int mode, boolean filterWithToolsInSite, boolean includeHidden) {
        InjectorHolder.getInjector().inject((Object)this);
        this.siteId = siteId;
        this.mode = mode;
        this.filterWithToolsInSite = filterWithToolsInSite;
        this.includeHidden = includeHidden;
    }

    public Iterator iterator(int first, int count) {
        return this.getReportDefs().iterator();
    }

    public List<ReportDef> getReportDefs() {
        if (this.data == null) {
            switch (this.mode) {
                case 0: {
                    this.data = Locator.getFacade().getReportManager().getReportDefinitions(this.siteId, false, this.includeHidden);
                    break;
                }
                case 1: {
                    this.data = Locator.getFacade().getReportManager().getReportDefinitions(null, false, this.includeHidden);
                    break;
                }
                case 2: {
                    this.data = Locator.getFacade().getReportManager().getReportDefinitions(this.siteId, true, this.includeHidden);
                }
            }
            if (this.filterWithToolsInSite) {
                this.data = this.filterWithToolsInSite(this.data);
            }
            this.data = this.fixReportParamsSiteIdForPredefinedReports(this.data);
            Collections.sort(this.data, this.getReportDefComparator());
        }
        return this.data;
    }

    public IModel model(Object object) {
        return new ReportDefModel((ReportDef)object);
    }

    public int size() {
        return this.getReportDefs().size();
    }

    public void detach() {
        this.data = null;
    }

    private List<ReportDef> fixReportParamsSiteIdForPredefinedReports(List<ReportDef> list) {
        ArrayList<ReportDef> fixed = new ArrayList<ReportDef>();
        for (ReportDef rd : list) {
            if (rd.getSiteId() == null) {
                rd.getReportParams().setSiteId(this.siteId);
                fixed.add(rd);
                continue;
            }
            fixed.add(rd);
        }
        return fixed;
    }

    private List<ReportDef> filterWithToolsInSite(List<ReportDef> list) {
        List<ReportDef> filtered = new ArrayList<ReportDef>();
        if (list != null) {
            try {
                Site site = Locator.getFacade().getSiteService().getSite(this.siteId);
                for (ReportDef rd : list) {
                    if (!this.canIncludeReport(rd, site)) continue;
                    filtered.add(rd);
                }
            }
            catch (Exception e) {
                filtered = list;
            }
        }
        return filtered;
    }

    private boolean canIncludeReport(ReportDef reportDef, Site site) {
        block9: {
            ArrayList siteTools;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            siteTools = new ArrayList();
                            for (SitePage page : site.getPages()) {
                                siteTools.addAll(page.getTools());
                            }
                            if (!"what-visits".equals(reportDef.getReportParams().getWhat())) break block8;
                            if (Locator.getFacade().getStatsManager().isEnableSiteVisits()) {
                                return true;
                            }
                            break block9;
                        }
                        if (!"what-resources".equals(reportDef.getReportParams().getWhat())) break block10;
                        for (ToolConfiguration tc : siteTools) {
                            if (!tc.getToolId().equals("sakai.resources")) continue;
                            return true;
                        }
                        break block9;
                    }
                    if (!"what-presences".equals(reportDef.getReportParams().getWhat())) break block11;
                    if (Locator.getFacade().getStatsManager().isEnableSitePresences()) {
                        return true;
                    }
                    break block9;
                }
                if (!"what-events-byevent".equals(reportDef.getReportParams().getWhatEventSelType())) break block12;
                for (ToolConfiguration tc : siteTools) {
                    Map map = Locator.getFacade().getEventRegistryService().getEventIdToolMap();
                    for (String eventId : reportDef.getReportParams().getWhatEventIds()) {
                        if (!tc.getToolId().equals(((ToolInfo)map.get(eventId)).getToolId())) continue;
                        return true;
                    }
                }
                break block9;
            }
            if (!"what-events-bytool".equals(reportDef.getReportParams().getWhatEventSelType())) break block9;
            if (reportDef.getReportParams().getWhatToolIds().contains("all")) {
                return true;
            }
            for (ToolConfiguration tc : siteTools) {
                if (!reportDef.getReportParams().getWhatToolIds().contains(tc.getToolId())) continue;
                return true;
            }
        }
        return false;
    }

    public final Comparator<ReportDef> getReportDefComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

