/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.MenuItem;
import org.sakaiproject.sitestats.tool.wicket.pages.AdminPage;
import org.sakaiproject.sitestats.tool.wicket.pages.AdminReportsPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ServerWidePage;

public class AdminMenu
extends Panel {
    private static final long serialVersionUID = 1L;

    public AdminMenu(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.renderBody();
    }

    private void renderBody() {
        String siteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        PageParameters pageParameters = new PageParameters("siteId=" + siteId);
        boolean adminPageVisible = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStatsAdmin(siteId);
        MenuItem adminPage = new MenuItem("adminPage", (IModel)new ResourceModel("menu_sitelist"), AdminPage.class, pageParameters, true);
        adminPage.setVisible(adminPageVisible);
        this.add(new Component[]{adminPage});
        boolean reportsPageVisible = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStatsAdmin(siteId);
        MenuItem reportsPage = new MenuItem("reportsPage", (IModel)new ResourceModel("menu_adminreports"), AdminReportsPage.class, pageParameters, false);
        reportsPage.setVisible(reportsPageVisible);
        this.add(new Component[]{reportsPage});
        boolean serverWidePageVisible = Locator.getFacade().getStatsManager().isServerWideStatsEnabled();
        MenuItem serverWidePage = new MenuItem("serverWidePage", (IModel)new ResourceModel("menu_serverwide"), ServerWidePage.class, pageParameters, false);
        serverWidePage.setVisible(serverWidePageVisible);
        this.add(new Component[]{serverWidePage});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "menu");
    }
}

