/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.version.undo.Change;
import org.sakaiproject.sitestats.tool.wicket.components.AjaxLazyLoadImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxLazyLoadImage
extends Panel {
    private static final long serialVersionUID = 1L;
    private SubmitLink link = null;
    private Page returnPage = null;
    private Class<?> returnClass = null;
    private AbstractDefaultAjaxBehavior chartRenderAjaxBehavior = null;
    private Form form = null;
    private boolean autoDetermineChartSizeByAjax = false;
    private int selectedWidth = 400;
    private int selectedHeight = 200;
    private int maxWidth = 800;
    private int maxHeight = 600;
    private static Log LOG = LogFactory.getLog(AjaxLazyLoadImage.class);
    private byte state = 0;

    public AjaxLazyLoadImage(String id, Class<?> returnClass) {
        super(id);
        this.returnClass = returnClass;
        this.init();
    }

    public AjaxLazyLoadImage(String id, Page returnPage) {
        super(id);
        this.returnPage = returnPage;
        this.init();
    }

    private void init() {
        this.setOutputMarkupId(true);
        this.chartRenderAjaxBehavior = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new IBehavior[]{this.chartRenderAjaxBehavior});
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.form = new Form("chartForm");
        this.form.add(new Component[]{new HiddenField("maxWidth")});
        this.form.add(new Component[]{new HiddenField("maxHeight")});
        this.add(new Component[]{this.form});
    }

    protected void onBeforeRender() {
        if (this.state == 0) {
            Component loadingComponent = this.getLoadingComponent("content");
            this.link = this.createMaximizedLink("link");
            this.link.setOutputMarkupId(true);
            this.link.setEnabled(false);
            this.link.add(new Component[]{loadingComponent.setRenderBodyOnly(true)});
            this.add(new Component[]{this.link});
            this.setState((byte)1);
        } else if (this.state == 2) {
            Component loadingComponent = this.getLoadingComponent("content");
            this.link.setEnabled(false);
            this.link.removeAll();
            this.link.add(new Component[]{loadingComponent.setRenderBodyOnly(true)});
            this.add(new Component[]{this.link});
            this.setState((byte)1);
        }
        super.onBeforeRender();
    }

    public CharSequence getCallbackUrl() {
        return this.chartRenderAjaxBehavior.getCallbackUrl(false);
    }

    public Image renderImage(AjaxRequestTarget target, boolean fullRender) {
        if (this.returnPage != null || this.returnClass != null) {
            this.link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("click_to_max"))});
            this.link.setEnabled(true);
        }
        this.link.removeAll();
        Image img = null;
        img = !this.autoDetermineChartSizeByAjax ? this.createImage("content", this.getImageData()) : this.createImage("content", this.getImageData(this.selectedWidth, this.selectedHeight));
        img.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)"display: none; margin: 0 auto;")});
        this.link.add(new Component[]{img});
        this.setState((byte)1);
        if (fullRender) {
            if (target != null) {
                target.addComponent((Component)this.link);
                target.appendJavascript("jQuery('#" + img.getMarkupId() + "').fadeIn();");
            }
            this.setState((byte)2);
        }
        return img;
    }

    public Component getLoadingComponent(String markupId) {
        Label indicator = new Label(markupId, "<img src=\"" + RequestCycle.get().urlFor(AbstractDefaultAjaxBehavior.INDICATOR) + "\"/>");
        indicator.setEscapeModelStrings(false);
        indicator.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)"...")))});
        return indicator;
    }

    public abstract byte[] getImageData();

    public abstract byte[] getImageData(int var1, int var2);

    private SubmitLink createMaximizedLink(String id) {
        2 link = new /* Unavailable Anonymous Inner Class!! */;
        link.setOutputMarkupId(true);
        return link;
    }

    private Image createImage(String id, byte[] imageData) {
        3 chartImage = new /* Unavailable Anonymous Inner Class!! */;
        chartImage.setOutputMarkupId(true);
        chartImage.setOutputMarkupPlaceholderTag(true);
        return chartImage;
    }

    public void setAutoDetermineChartSizeByAjax(String jquerySelectorForContainer) {
        this.autoDetermineChartSizeByAjax = true;
        4 determineChartSizeBehavior = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new IBehavior[]{determineChartSizeBehavior});
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    private void setState(byte state) {
        if (this.state != state) {
            this.addStateChange((Change)new StateChange(this, this.state));
        }
        this.state = state;
    }

    static /* synthetic */ byte access$000(AjaxLazyLoadImage x0) {
        return x0.state;
    }

    static /* synthetic */ Page access$100(AjaxLazyLoadImage x0) {
        return x0.returnPage;
    }

    static /* synthetic */ Class access$200(AjaxLazyLoadImage x0) {
        return x0.returnClass;
    }

    static /* synthetic */ int access$300(AjaxLazyLoadImage x0) {
        return x0.maxWidth;
    }

    static /* synthetic */ int access$402(AjaxLazyLoadImage x0, int x1) {
        x0.selectedWidth = x1;
        return x0.selectedWidth;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }

    static /* synthetic */ int access$602(AjaxLazyLoadImage x0, int x1) {
        x0.selectedHeight = x1;
        return x0.selectedHeight;
    }

    static /* synthetic */ int access$600(AjaxLazyLoadImage x0) {
        return x0.selectedHeight;
    }

    static /* synthetic */ byte access$002(AjaxLazyLoadImage x0, byte x1) {
        x0.state = x1;
        return x0.state;
    }
}

