/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.models;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.model.LoadableDetachableModel;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.sitestats.tool.facade.Locator;

public class SiteModel
extends LoadableDetachableModel {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(SiteModel.class);
    private String id;

    public SiteModel(Site site) {
        this(site.getId());
    }

    public SiteModel(String id) {
        this.id = id;
    }

    protected Object load() {
        try {
            return Locator.getFacade().getSiteService().getSite(this.id);
        }
        catch (IdUnusedException e) {
            LOG.warn((Object)("SiteModel: no site with id " + this.id));
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SiteModel) {
            SiteModel other = (SiteModel)obj;
            return this.id != null && this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

