/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.models;

import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.tool.facade.Locator;

public class ToolModel
implements IModel {
    private static final long serialVersionUID = 1L;
    private String toolId = "";
    private String toolName = "";

    public ToolModel(String toolId, String toolName) {
        this.toolId = toolId;
        this.toolName = toolName;
    }

    public ToolModel(ToolInfo e) {
        this.toolId = e.getToolId();
        this.toolName = Locator.getFacade().getEventRegistryService().getToolName(this.toolId);
    }

    public Object getObject() {
        return this.getToolId() + " + " + this.getToolName();
    }

    public void setObject(Object object) {
        if (object instanceof String) {
            String[] str = ((String)object).split(" \\+ ");
            this.toolId = str[0];
            this.toolName = str[1];
        }
    }

    public String getToolId() {
        return this.toolId;
    }

    public String getToolName() {
        if ("all".equals(this.toolName)) {
            return new ResourceModel("all").getObject();
        }
        return this.toolName;
    }

    public void detach() {
        this.toolId = null;
        this.toolName = null;
    }
}

