/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.widget;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.ResourceModel;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.widget.VisitsWidget;
import org.sakaiproject.sitestats.tool.wicket.widget.Widget;
import org.sakaiproject.sitestats.tool.wicket.widget.WidgetMiniStat;
import org.sakaiproject.sitestats.tool.wicket.widget.WidgetTabTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitsWidget
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(VisitsWidget.class);
    private String siteId = null;
    private Set<String> siteUsers = null;
    private Set<String> usersWithVisits = null;

    public VisitsWidget(String id, String siteId) {
        super(id);
        this.siteId = siteId;
        this.setRenderBodyOnly(true);
        this.setOutputMarkupId(true);
        ArrayList<WidgetMiniStat> widgetMiniStats = new ArrayList<WidgetMiniStat>();
        widgetMiniStats.add(this.getMiniStatVisits());
        widgetMiniStats.add(this.getMiniStatUniqueVisits());
        widgetMiniStats.add(this.getMiniStatEnrolledUsers());
        widgetMiniStats.add(this.getMiniStatEnrolledUsersWithVisits());
        widgetMiniStats.add(this.getMiniStatEnrolledUsersWithoutVisits());
        if (Locator.getFacade().getStatsManager().isEnableSitePresences()) {
            widgetMiniStats.add(this.getMiniStatAveragePresenceTime());
        }
        ArrayList<Object> tabs = new ArrayList<Object>();
        tabs.add(new /* Unavailable Anonymous Inner Class!! */);
        tabs.add(new /* Unavailable Anonymous Inner Class!! */);
        String icon = "/library/image/silk/user_gray.png";
        String title = new ResourceModel("overview_title_visits").getObject();
        Widget widget = new Widget("widget", icon, title, widgetMiniStats, tabs);
        this.add(new Component[]{widget});
    }

    private WidgetMiniStat getMiniStatVisits() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private WidgetMiniStat getMiniStatUniqueVisits() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private WidgetMiniStat getMiniStatEnrolledUsers() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private WidgetMiniStat getMiniStatEnrolledUsersWithVisits() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private WidgetMiniStat getMiniStatEnrolledUsersWithoutVisits() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private WidgetMiniStat getMiniStatAveragePresenceTime() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected WidgetTabTemplate getWidgetTabByDate(String panelId) {
        9 wTab = new /* Unavailable Anonymous Inner Class!! */;
        return wTab;
    }

    protected WidgetTabTemplate getWidgetTabByUser(String panelId) {
        10 wTab = new /* Unavailable Anonymous Inner Class!! */;
        return wTab;
    }

    private Set<String> getSiteUsers() {
        if (this.siteUsers == null) {
            this.siteUsers = Locator.getFacade().getStatsManager().getSiteUsers(this.siteId);
            if (this.siteUsers == null) {
                this.siteUsers = new HashSet();
            }
        }
        return this.siteUsers;
    }

    private Set<String> getUsersWithVisits() {
        if (this.usersWithVisits == null) {
            this.usersWithVisits = Locator.getFacade().getStatsManager().getUsersWithVisits(this.siteId);
            if (this.usersWithVisits == null) {
                this.usersWithVisits = new HashSet();
            }
        }
        return this.usersWithVisits;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ String access$100(VisitsWidget x0) {
        return x0.siteId;
    }

    static /* synthetic */ Set access$200(VisitsWidget x0) {
        return x0.getSiteUsers();
    }

    static /* synthetic */ Set access$300(VisitsWidget x0) {
        return x0.getUsersWithVisits();
    }
}

