/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.sakaiproject.sitestats.api.StatsManager;
import org.sakaiproject.sitestats.api.StatsUpdateManager;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;

public class LastJobRun
extends Panel {
    private static final long serialVersionUID = 1L;
    private String realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
    private String siteId;
    private String siteTitle;

    public LastJobRun(String id) {
        this(id, null);
    }

    public LastJobRun(String id, String siteId) {
        super(id);
        boolean allowed;
        if (siteId == null) {
            siteId = this.realSiteId;
        }
        if (allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(siteId)) {
            this.renderBody();
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    private void renderBody() {
        StatsManager statsManager = Locator.getFacade().getStatsManager();
        StatsUpdateManager statsUpdateManager = Locator.getFacade().getStatsUpdateManager();
        this.setRenderBodyOnly(true);
        WebMarkupContainer lastJobRun = new WebMarkupContainer("lastJobRun");
        boolean lastJobRunVisible = !statsUpdateManager.isCollectThreadEnabled() && statsManager.isLastJobRunDateVisible();
        lastJobRun.setVisible(lastJobRunVisible);
        this.add(new Component[]{lastJobRun});
        Label lastJobRunDate = new Label("lastJobRunDate");
        if (lastJobRunVisible) {
            try {
                Date d = statsUpdateManager.getEventDateFromLatestJobRun();
                String dStr = Locator.getFacade().getTimeService().newTime(d.getTime()).toStringLocalFull();
                lastJobRunDate.setDefaultModel((IModel)new Model((Serializable)((Object)dStr)));
            }
            catch (RuntimeException e) {
                lastJobRunDate.setDefaultModel((IModel)new Model());
            }
            catch (Exception e) {
                lastJobRunDate.setDefaultModel((IModel)new Model());
            }
        }
        lastJobRun.add(new Component[]{lastJobRunDate});
    }
}

