/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.models;

import org.apache.wicket.model.LoadableDetachableModel;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.tool.facade.Locator;

public class ReportDefModel
extends LoadableDetachableModel {
    private static final long serialVersionUID = 1L;
    private long id;
    private String siteId;
    private String reportSiteId;

    public ReportDefModel(String siteId, String reportSiteId) {
        this.id = 0L;
        this.siteId = siteId;
        this.reportSiteId = reportSiteId;
    }

    public ReportDefModel(ReportDef reportDef) {
        super((Object)reportDef);
        this.id = reportDef.getId();
        this.siteId = reportDef.getSiteId();
        this.reportSiteId = reportDef.getReportParams().getSiteId();
    }

    public ReportDefModel(long id) {
        this.id = id;
    }

    public boolean isNew() {
        return this.id == 0L;
    }

    protected Object load() {
        ReportDef reportDef = null;
        if (this.id == 0L) {
            reportDef = new ReportDef();
            reportDef.setSiteId(this.getSiteId());
            reportDef.setReportParams(new ReportParams(this.reportSiteId));
        } else {
            reportDef = Locator.getFacade().getReportManager().getReportDefinition(this.id);
            if (reportDef.getSiteId() == null && reportDef.getReportParams().getSiteId() == null) {
                reportDef.getReportParams().setSiteId(this.getSiteId());
            }
        }
        return reportDef;
    }

    private String getSiteId() {
        if (this.siteId == null) {
            this.siteId = this.reportSiteId;
        }
        return this.siteId;
    }
}

