/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.select.SelectOption;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.sakaiproject.sitestats.tool.wicket.components.IStylableOptionRenderer;
import org.sakaiproject.sitestats.tool.wicket.components.StylableSelectOptions;

public class StylableSelectOptions
extends RepeatingView {
    private static final long serialVersionUID = 1L;
    private boolean recreateChoices = false;
    private final IStylableOptionRenderer renderer;

    public StylableSelectOptions(String id, IModel model, IStylableOptionRenderer renderer) {
        super(id, model);
        this.renderer = renderer;
        this.setRenderBodyOnly(true);
    }

    public StylableSelectOptions(String id, Collection elements, IStylableOptionRenderer renderer) {
        this(id, (IModel)new Model((Serializable)((Object)elements)), renderer);
    }

    public StylableSelectOptions setRecreateChoices(boolean refresh) {
        this.recreateChoices = refresh;
        return this;
    }

    protected final void onPopulate() {
        if (this.size() == 0 || this.recreateChoices) {
            this.removeAll();
            Object modelObject = this.getDefaultModelObject();
            if (modelObject != null) {
                if (!(modelObject instanceof Collection)) {
                    throw new WicketRuntimeException("Model object " + modelObject + " not a collection");
                }
                Iterator it = ((Collection)modelObject).iterator();
                while (it.hasNext()) {
                    WebMarkupContainer row = new WebMarkupContainer(this.newChildId());
                    row.setRenderBodyOnly(true);
                    this.add(new Component[]{row});
                    Object value = it.next();
                    String text = this.renderer.getDisplayValue(value);
                    IModel model = this.renderer.getModel(value);
                    String style = this.renderer.getStyle(value);
                    row.add(new Component[]{this.newOption(text, model, style)});
                }
            }
        }
    }

    protected SelectOption newOption(String text, IModel model, String style) {
        return new StylableSelectOption("option", model, text, style);
    }
}

