/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.pages;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.target.basic.EmptyRequestTarget;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.report.Report;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.AjaxLazyLoadImage;
import org.sakaiproject.sitestats.tool.wicket.components.LastJobRun;
import org.sakaiproject.sitestats.tool.wicket.components.Menus;
import org.sakaiproject.sitestats.tool.wicket.components.SakaiDataTable;
import org.sakaiproject.sitestats.tool.wicket.models.ReportDefModel;
import org.sakaiproject.sitestats.tool.wicket.pages.BasePage;
import org.sakaiproject.sitestats.tool.wicket.pages.NotAuthorizedPage;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportsPage;
import org.sakaiproject.sitestats.tool.wicket.providers.ReportsDataProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportDataPage
extends BasePage {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(ReportDataPage.class);
    private String realSiteId;
    private String siteId;
    private boolean inPrintVersion;
    private ReportDefModel reportDefModel;
    private Report report;
    private PrefsData prefsdata;
    private WebPage returnPage;
    private AjaxLazyLoadImage reportChart = null;
    private byte[] chartImage = null;
    private int selectedWidth = 0;
    private int selectedHeight = 0;

    public ReportDataPage(ReportDefModel reportDef) {
        this(reportDef, null, null);
    }

    public ReportDataPage(ReportDefModel reportDef, PageParameters pageParameters) {
        this(reportDef, pageParameters, null);
    }

    public ReportDataPage(ReportDefModel reportDef, PageParameters pageParameters, WebPage returnPage) {
        this.reportDefModel = reportDef;
        this.realSiteId = Locator.getFacade().getToolManager().getCurrentPlacement().getContext();
        if (pageParameters != null) {
            this.siteId = pageParameters.getString("siteId");
            this.inPrintVersion = pageParameters.getBoolean("printVersion");
        }
        if (this.siteId == null) {
            this.siteId = this.realSiteId;
        }
        this.returnPage = returnPage == null ? new ReportsPage(pageParameters) : returnPage;
        boolean allowed = Locator.getFacade().getStatsAuthz().isUserAbleToViewSiteStats(this.siteId);
        if (allowed) {
            if (reportDef != null && this.getReportDef() != null && this.getReportDef().getReportParams() != null) {
                this.renderBody();
            } else {
                this.setResponsePage(ReportsPage.class);
            }
        } else {
            this.setResponsePage(NotAuthorizedPage.class);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference("/sitestats-tool/script/jquery-1.3.2.min.js");
    }

    private void renderBody() {
        if (this.getReportDef().getTitle() != null && this.getReportDef().getTitle().trim().length() != 0) {
            String titleStr = null;
            if (this.getReportDef().isTitleLocalized()) {
                titleStr = new ResourceModel("reportres_title_detailed").getObject();
                titleStr = titleStr.replaceAll("\\$\\{title\\}", new ResourceModel(this.getReportDef().getTitleBundleKey()).getObject());
            } else {
                titleStr = new StringResourceModel("reportres_title_detailed", (Component)this, (IModel)this.reportDefModel).getString();
            }
            this.add(new Component[]{new Label("reportAction", titleStr)});
        } else {
            this.add(new Component[]{new Label("reportAction", (IModel)new ResourceModel("reportres_title"))});
        }
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.add(new Component[]{new Menus("menu", this.siteId).setVisible(!this.inPrintVersion)});
        this.add(new Component[]{new LastJobRun("lastJobRun", this.siteId)});
        WebMarkupContainer toPrintVersion = new WebMarkupContainer("toPrintVersion");
        toPrintVersion.setVisible(!this.inPrintVersion);
        toPrintVersion.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{toPrintVersion});
        this.add(new Component[]{new WebMarkupContainer("inPrintVersion").setVisible(this.inPrintVersion)});
        ReportsDataProvider dataProvider = new ReportsDataProvider(this.getPrefsdata(), this.getReportDef());
        this.report = dataProvider.getReport();
        this.reportChart = new /* Unavailable Anonymous Inner Class!! */;
        this.reportChart.setOutputMarkupId(true);
        this.add(new Component[]{this.reportChart});
        if ("how-presentation-chart".equals(this.report.getReportDefinition().getReportParams().getHowPresentationMode()) || "how-presentation-both".equals(this.report.getReportDefinition().getReportParams().getHowPresentationMode())) {
            this.reportChart.setVisible(true);
            this.reportChart.setAutoDetermineChartSizeByAjax(".chartContainer");
        } else {
            this.reportChart.setVisible(false);
        }
        SakaiDataTable reportTable = new SakaiDataTable("table", ReportDataPage.getTableColumns((ReportParams)this.getReportParams(), (boolean)true), (ISortableDataProvider)dataProvider, !this.inPrintVersion);
        if (this.inPrintVersion) {
            reportTable.setRowsPerPage(Integer.MAX_VALUE);
        }
        reportTable.setVisible("how-presentation-table".equals(this.report.getReportDefinition().getReportParams().getHowPresentationMode()) || "how-presentation-both".equals(this.report.getReportDefinition().getReportParams().getHowPresentationMode()));
        form.add(new Component[]{reportTable});
        WebMarkupContainer trDescription = new WebMarkupContainer("trDescription");
        trDescription.setVisible(this.getReportDescription() != null);
        trDescription.add(new Component[]{new Label("reportDescription")});
        this.add(new Component[]{trDescription});
        this.add(new Component[]{new Label("reportSite")});
        this.add(new Component[]{new Label("reportActivityBasedOn")});
        WebMarkupContainer trResourceAction = new WebMarkupContainer("trResourceAction");
        trResourceAction.setVisible(this.getReportResourceAction() != null);
        trResourceAction.add(new Component[]{new Label("reportResourceActionTitle")});
        trResourceAction.add(new Component[]{new Label("reportResourceAction")});
        this.add(new Component[]{trResourceAction});
        WebMarkupContainer trActivitySelection = new WebMarkupContainer("trActivitySelection");
        trActivitySelection.setVisible(this.getReportActivitySelection() != null);
        trActivitySelection.add(new Component[]{new Label("reportActivitySelectionTitle")});
        trActivitySelection.add(new Component[]{new Label("reportActivitySelection")});
        this.add(new Component[]{trActivitySelection});
        this.add(new Component[]{new Label("reportTimePeriod")});
        this.add(new Component[]{new Label("reportUserSelectionType")});
        WebMarkupContainer trReportUserSelection = new WebMarkupContainer("trReportUserSelection");
        trReportUserSelection.setVisible(this.getReportUserSelectionTitle() != null);
        trReportUserSelection.add(new Component[]{new Label("reportUserSelectionTitle")});
        trReportUserSelection.add(new Component[]{new Label("reportUserSelection")});
        this.add(new Component[]{trReportUserSelection});
        this.add(new Component[]{new Label("report.localizedReportGenerationDate")});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.setVisible(!this.inPrintVersion)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.setDefaultFormProcessing(false).setVisible(Locator.getFacade().getStatsManager().isEnableReportExport() && !this.inPrintVersion)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public static List<IColumn> getTableColumns(ReportParams reportParams, boolean columnsSortable) {
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        Map eventIdToolMap = Locator.getFacade().getEventRegistryService().getEventIdToolMap();
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "site")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "user")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "tool")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "event")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "resource")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "resource-action")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "date")) {
            columns.add((IColumn)new PropertyColumn((IModel)new ResourceModel("th_date"), columnsSortable ? "date" : null, "date"));
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "month")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "year")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "last-date")) {
            columns.add((IColumn)new PropertyColumn((IModel)new ResourceModel("th_lastdate"), columnsSortable ? "date" : null, "date"));
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "total")) {
            columns.add((IColumn)new PropertyColumn((IModel)new ResourceModel("th_total"), columnsSortable ? "total" : null, "count"));
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "visits")) {
            columns.add((IColumn)new PropertyColumn((IModel)new ResourceModel("th_visits"), columnsSortable ? "visits" : null, "totalVisits"));
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "unique-visits")) {
            columns.add((IColumn)new PropertyColumn((IModel)new ResourceModel("th_uniquevisitors"), columnsSortable ? "unique-visits" : null, "totalUnique"));
        }
        if (Locator.getFacade().getReportManager().isReportColumnAvailable(reportParams, "duration")) {
            columns.add((IColumn)new /* Unavailable Anonymous Inner Class!! */);
        }
        return columns;
    }

    private byte[] getChartImage() {
        if (this.chartImage == null) {
            this.chartImage = this.getChartImage(this.selectedWidth, this.selectedHeight);
        }
        return this.chartImage;
    }

    private byte[] getChartImage(int width, int height) {
        PrefsData prefsData = Locator.getFacade().getStatsManager().getPreferences(this.siteId, false);
        int _width = width <= 0 ? 350 : width;
        int _height = height <= 0 ? 200 : height;
        return Locator.getFacade().getChartService().generateChart(this.report, _width, _height, prefsData.isChartIn3D(), prefsData.getChartTransparency(), prefsData.isItemLabelsVisible());
    }

    protected String getExportFileName() {
        StringBuilder exportFileName = new StringBuilder();
        if (this.getReportDef().getTitle() != null && this.getReportDef().getTitle().trim().length() != 0) {
            String titleStr = null;
            titleStr = this.getReportDef().isTitleLocalized() ? new ResourceModel(this.getReportDef().getTitleBundleKey()).getObject() : this.getReportDef().getTitle();
            exportFileName.append(new ResourceModel("reportres_title").getObject());
            exportFileName.append(" (");
            exportFileName.append(titleStr);
            exportFileName.append(')');
        } else if (this.report.getReportDefinition().getReportParams().getWhat().equals("what-visits")) {
            exportFileName.append(new ResourceModel("report_what_visits").getObject());
        } else if (this.report.getReportDefinition().getReportParams().getWhat().equals("what-events")) {
            exportFileName.append(new ResourceModel("report_what_events").getObject());
        } else if (this.report.getReportDefinition().getReportParams().getWhat().equals("what-presences")) {
            exportFileName.append(new ResourceModel("report_what_presences").getObject());
        } else {
            exportFileName.append(new ResourceModel("report_what_resources").getObject());
        }
        exportFileName.append(" (");
        try {
            exportFileName.append(Locator.getFacade().getSiteService().getSite(this.siteId).getTitle());
        }
        catch (IdUnusedException e) {
            exportFileName.append(this.siteId);
        }
        exportFileName.append(')');
        return exportFileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportXls() {
        String fileName = this.getExportFileName();
        byte[] hssfWorkbookBytes = Locator.getFacade().getReportManager().getReportAsExcel(this.report, fileName);
        RequestCycle.get().setRequestTarget((IRequestTarget)EmptyRequestTarget.getInstance());
        WebResponse response = (WebResponse)this.getResponse();
        response.setContentType("application/vnd.ms-excel");
        response.setAttachmentHeader(fileName + ".xls");
        response.setHeader("Cache-Control", "max-age=0");
        response.setContentLength((long)hssfWorkbookBytes.length);
        OutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(hssfWorkbookBytes);
            out.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportCsv() {
        String fileName = this.getExportFileName();
        String csvString = Locator.getFacade().getReportManager().getReportAsCsv(this.report);
        RequestCycle.get().setRequestTarget((IRequestTarget)EmptyRequestTarget.getInstance());
        WebResponse response = (WebResponse)this.getResponse();
        response.setContentType("text/comma-separated-values");
        response.setAttachmentHeader(fileName + ".csv");
        response.setHeader("Cache-Control", "max-age=0");
        response.setContentLength((long)csvString.length());
        OutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(csvString.getBytes());
            out.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportPdf() {
        String fileName = this.getExportFileName();
        byte[] pdf = Locator.getFacade().getReportManager().getReportAsPDF(this.report);
        RequestCycle.get().setRequestTarget((IRequestTarget)EmptyRequestTarget.getInstance());
        WebResponse response = (WebResponse)this.getResponse();
        response.setContentType("application/pdf");
        response.setAttachmentHeader(fileName + ".pdf");
        response.setHeader("Cache-Control", "max-age=0");
        response.setContentLength((long)pdf.length);
        OutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(pdf);
            out.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                e.printStackTrace();
            }
        }
    }

    private PrefsData getPrefsdata() {
        if (this.prefsdata == null) {
            this.prefsdata = Locator.getFacade().getStatsManager().getPreferences(this.siteId, true);
        }
        return this.prefsdata;
    }

    public void setReportDef(ReportDef reportDef) {
        this.reportDefModel.setObject((Object)reportDef);
    }

    public ReportDef getReportDef() {
        return (ReportDef)this.reportDefModel.getObject();
    }

    public void setReportParams(ReportParams reportParams) {
        this.getReportDef().setReportParams(reportParams);
    }

    public ReportParams getReportParams() {
        return this.getReportDef().getReportParams();
    }

    public String getReportDescription() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportDescription(this.report);
    }

    public String getReportSite() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportSite(this.report);
    }

    public String getReportGenerationDate() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportGenerationDate(this.report);
    }

    public String getReportActivityBasedOn() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportActivityBasedOn(this.report);
    }

    public String getReportActivitySelectionTitle() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportActivitySelectionTitle(this.report);
    }

    public String getReportActivitySelection() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportActivitySelection(this.report);
    }

    public String getReportResourceActionTitle() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportResourceActionTitle(this.report);
    }

    public String getReportResourceAction() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportResourceAction(this.report);
    }

    public String getReportTimePeriod() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportTimePeriod(this.report);
    }

    public String getReportUserSelectionType() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportUserSelectionType(this.report);
    }

    public String getReportUserSelectionTitle() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportUserSelectionTitle(this.report);
    }

    public String getReportUserSelection() {
        return Locator.getFacade().getReportManager().getReportFormattedParams().getReportUserSelection(this.report);
    }

    static /* synthetic */ ReportDefModel access$000(ReportDataPage x0) {
        return x0.reportDefModel;
    }

    static /* synthetic */ String access$100(ReportDataPage x0) {
        return x0.siteId;
    }

    static /* synthetic */ byte[] access$200(ReportDataPage x0) {
        return x0.getChartImage();
    }

    static /* synthetic */ byte[] access$300(ReportDataPage x0, int x1, int x2) {
        return x0.getChartImage(x1, x2);
    }

    static /* synthetic */ WebPage access$400(ReportDataPage x0) {
        return x0.returnPage;
    }
}

