/**
 * $URL: https://source.sakaiproject.org/svn/sitestats/tags/sitestats-2.3.2/sitestats-tool/src/java/org/sakaiproject/sitestats/tool/wicket/components/IndicatingAjaxDropDownChoice.java $
 * $Id: IndicatingAjaxDropDownChoice.java 72172 2009-09-23 00:48:53Z arwhyte@umich.edu $
 *
 * Copyright (c) 2006-2009 The Sakai Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *             http://www.osedu.org/licenses/ECL-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sakaiproject.sitestats.tool.wicket.components;

import java.util.List;

import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.extensions.ajax.markup.html.WicketAjaxIndicatorAppender;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;


public class IndicatingAjaxDropDownChoice extends DropDownChoice implements IAjaxIndicatorAware {
	private static final long					serialVersionUID	= 1L;
	private final WicketAjaxIndicatorAppender	indicatorAppender	= new WicketAjaxIndicatorAppender();
	
	public IndicatingAjaxDropDownChoice(String id, List data, IChoiceRenderer renderer) {
		super(id, data, renderer);
		add(indicatorAppender);
	}	

	public String getAjaxIndicatorMarkupId() {
		return indicatorAppender.getMarkupId();
	}
}
