/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.sitestats.tool.wicket.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.sitestats.api.PrefsData;
import org.sakaiproject.sitestats.api.event.EventInfo;
import org.sakaiproject.sitestats.api.event.ToolInfo;
import org.sakaiproject.sitestats.api.parser.EventParserTip;
import org.sakaiproject.sitestats.api.report.ReportDef;
import org.sakaiproject.sitestats.api.report.ReportParams;
import org.sakaiproject.sitestats.tool.facade.Locator;
import org.sakaiproject.sitestats.tool.wicket.components.AjaxLazyLoadImage;
import org.sakaiproject.sitestats.tool.wicket.components.IndicatingAjaxDropDownChoice;
import org.sakaiproject.sitestats.tool.wicket.components.SakaiDataTable;
import org.sakaiproject.sitestats.tool.wicket.pages.ReportDataPage;
import org.sakaiproject.sitestats.tool.wicket.providers.ReportsDataProvider;
import org.sakaiproject.sitestats.tool.wicket.widget.WidgetTabTemplate;

public abstract class WidgetTabTemplate
extends Panel {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(WidgetTabTemplate.class);
    public static final int MAX_TABLE_ROWS = 5;
    public static final Integer FILTER_DATE = 0;
    public static final Integer FILTER_ROLE = 1;
    public static final Integer FILTER_USER = 2;
    public static final Integer FILTER_TOOL = 3;
    public static final Integer FILTER_RESOURCE_ACTION = 4;
    private AjaxLazyLoadImage chart = null;
    private WebMarkupContainer tableTd = null;
    private SakaiDataTable table = null;
    private Link tableLink = null;
    private WebMarkupContainer tableJs = null;
    private ReportsDataProvider chartDataProvider = null;
    private ReportsDataProvider tableDataProvider = null;
    private PrefsData prefsdata = null;
    private int chartWidth = 0;
    private String siteId = null;
    private boolean renderChart = false;
    private boolean renderTable = false;
    private boolean tabTemplateRendered = false;
    private transient Set<Role> roles = null;
    private String dateFilter = "when-last7days";
    private String roleFilter = "who-all";
    private String toolFilter = "all";
    private String resactionFilter = null;

    public WidgetTabTemplate(String id, String siteId) {
        super(id);
        this.siteId = siteId;
    }

    public abstract ReportDef getChartReportDefinition();

    public abstract ReportDef getTableReportDefinition();

    public abstract boolean useChartReportDefinitionForTable();

    public abstract List<Integer> getFilters();

    protected void onBeforeRender() {
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.removeAll();
        ReportDef chartRD = this.getChartReportDefinition();
        ReportDef tableRD = this.getTableReportDefinition();
        if (chartRD != null) {
            this.renderChart = true;
            this.chartDataProvider = new ReportsDataProvider(this.getPrefsdata(), chartRD, false);
        }
        if (tableRD != null) {
            this.renderTable = true;
            if (!this.useChartReportDefinitionForTable()) {
                this.tableDataProvider = new ReportsDataProvider(this.getPrefsdata(), tableRD, false);
            }
        }
        this.renderFilters();
        this.renderChart();
        this.renderTable();
        this.tabTemplateRendered = true;
        super.onBeforeRender();
    }

    private void renderChart() {
        WebMarkupContainer chartTd = new WebMarkupContainer("chartTd");
        chartTd.setOutputMarkupId(true);
        this.chart = new /* Unavailable Anonymous Inner Class!! */;
        this.chart.setAutoDetermineChartSizeByAjax("#" + chartTd.getMarkupId());
        this.chart.setOutputMarkupId(true);
        chartTd.add(new Component[]{this.chart});
        if (!this.renderChart) {
            chartTd.setVisible(false);
        } else if (this.renderChart && !this.renderTable) {
            chartTd.add(new IBehavior[]{new SimpleAttributeModifier("colspan", (CharSequence)"2")});
        }
        this.add(new Component[]{chartTd});
    }

    private void renderTable() {
        this.tableTd = new WebMarkupContainer("tableTd");
        this.createTable();
        if (!this.renderTable) {
            this.tableTd.setVisible(false);
        } else if (this.renderTable && !this.renderChart) {
            this.tableTd.add(new IBehavior[]{new SimpleAttributeModifier("colspan", (CharSequence)"2")});
        }
        this.tableLink = new /* Unavailable Anonymous Inner Class!! */;
        this.tableLink.setOutputMarkupId(true);
        this.tableTd.add(new Component[]{this.tableLink});
        this.tableJs = new /* Unavailable Anonymous Inner Class!! */;
        this.tableJs.setOutputMarkupId(true);
        this.tableTd.add(new Component[]{this.tableJs});
        this.tableTd.setOutputMarkupId(true);
        this.add(new Component[]{this.tableTd});
    }

    private void createTable() {
        this.table = this.useChartReportDefinitionForTable() ? new SakaiDataTable("table", ReportDataPage.getTableColumns((ReportParams)this.getChartReportDefinition().getReportParams(), (boolean)false), (ISortableDataProvider)this.chartDataProvider, false) : new SakaiDataTable("table", ReportDataPage.getTableColumns((ReportParams)this.getTableReportDefinition().getReportParams(), (boolean)false), (ISortableDataProvider)this.tableDataProvider, false);
        this.table.setRowsPerPage(5);
        this.table.setOutputMarkupId(true);
        this.tableTd.add(new Component[]{this.table});
    }

    private void renderFilters() {
        List filters = this.getFilters();
        List<String> dateFilterOptions = Arrays.asList("when-all", "when-last365days", "when-last30days", "when-last7days");
        4 dateFilterRenderer = new /* Unavailable Anonymous Inner Class!! */;
        IndicatingAjaxDropDownChoice dateFilter = new IndicatingAjaxDropDownChoice("dateFilter", dateFilterOptions, (IChoiceRenderer)dateFilterRenderer);
        dateFilter.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        dateFilter.setOutputMarkupId(true);
        this.add(new Component[]{dateFilter});
        dateFilter.setVisible(filters.contains(FILTER_DATE));
        ArrayList<String> roleFilterOptions = new ArrayList<String>();
        roleFilterOptions.add("who-all");
        try {
            Site site = Locator.getFacade().getSiteService().getSite(this.siteId);
            this.roles = site.getRoles();
            for (Role r : this.roles) {
                roleFilterOptions.add(r.getId());
            }
        }
        catch (IdUnusedException e) {
            LOG.warn((Object)("Site does not exist: " + this.siteId));
        }
        6 roleFilterRenderer = new /* Unavailable Anonymous Inner Class!! */;
        IndicatingAjaxDropDownChoice roleFilter = new IndicatingAjaxDropDownChoice("roleFilter", roleFilterOptions, (IChoiceRenderer)roleFilterRenderer);
        roleFilter.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        roleFilter.setOutputMarkupId(true);
        this.add(new Component[]{roleFilter});
        roleFilter.setVisible(filters.contains(FILTER_ROLE));
        ArrayList<String> toolFilterOptions = new ArrayList<String>();
        toolFilterOptions.add("all");
        toolFilterOptions.addAll(this.getToolIds());
        8 toolFilterRenderer = new /* Unavailable Anonymous Inner Class!! */;
        IndicatingAjaxDropDownChoice toolFilter = new IndicatingAjaxDropDownChoice("toolFilter", toolFilterOptions, (IChoiceRenderer)toolFilterRenderer);
        toolFilter.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        toolFilter.setOutputMarkupId(true);
        this.add(new Component[]{toolFilter});
        toolFilter.setVisible(filters.contains(FILTER_TOOL));
        List<String> resactionFilterOptions = Arrays.asList(null, "new", "read", "revise", "delete");
        10 resactionFilterRenderer = new /* Unavailable Anonymous Inner Class!! */;
        11 resactionFilter = new /* Unavailable Anonymous Inner Class!! */;
        resactionFilter.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        resactionFilter.setOutputMarkupId(true);
        this.add(new Component[]{resactionFilter});
        resactionFilter.setVisible(filters.contains(FILTER_RESOURCE_ACTION));
    }

    private void updateData(AjaxRequestTarget target) {
        if (this.renderChart) {
            this.chartDataProvider.setReportDef(this.getChartReportDefinition());
            target.addComponent((Component)this.chart);
        }
        if (this.renderTable) {
            if (this.useChartReportDefinitionForTable()) {
                this.chartDataProvider.setReportDef(this.getChartReportDefinition());
            } else {
                this.tableDataProvider.setReportDef(this.getTableReportDefinition());
            }
            this.tableTd.remove((Component)this.table);
            this.createTable();
            target.addComponent((Component)this.tableTd);
        }
        target.appendJavascript("setMainFrameHeightNoScroll(window.name, 0, 300);");
    }

    private List<String> getToolIds() {
        ArrayList<String> toolIds = new ArrayList<String>();
        for (ToolInfo ti : this.getPrefsdata().getToolEventsDef()) {
            if (!this.isToolSuported(ti) || !ti.isSelected()) continue;
            toolIds.add(ti.getToolId());
        }
        return toolIds;
    }

    private boolean isToolSuported(ToolInfo toolInfo) {
        if (Locator.getFacade().getStatsManager().isEventContextSupported()) {
            return true;
        }
        List siteTools = Locator.getFacade().getEventRegistryService().getEventRegistry(this.siteId, this.getPrefsdata().isListToolEventsOnlyAvailableInSite());
        for (ToolInfo t : siteTools) {
            EventParserTip parserTip;
            if (!t.getToolId().equals(toolInfo.getToolId()) || (parserTip = t.getEventParserTip()) == null || !parserTip.getFor().equals("contextId")) continue;
            return true;
        }
        return false;
    }

    public boolean isRole(String role) {
        for (Role r : this.roles) {
            if (!r.getId().equals(role)) continue;
            return true;
        }
        return false;
    }

    private PrefsData getPrefsdata() {
        if (this.prefsdata == null) {
            this.prefsdata = Locator.getFacade().getStatsManager().getPreferences(this.siteId, false);
        }
        return this.prefsdata;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setRoleFilter(String roleFilter) {
        this.roleFilter = roleFilter;
    }

    public String getRoleFilter() {
        return this.roleFilter;
    }

    public void setToolFilter(String toolFilter) {
        this.toolFilter = toolFilter;
    }

    public String getToolFilter() {
        return this.toolFilter;
    }

    public List<String> getToolEventsFilter() {
        if ("all".equals(this.toolFilter)) {
            return this.getPrefsdata().getToolEventsStringList();
        }
        ArrayList<String> eventIds = new ArrayList<String>();
        for (ToolInfo ti : this.getPrefsdata().getToolEventsDef()) {
            if (!this.isToolSuported(ti) || !ti.isSelected() || !ti.getToolId().equals(this.toolFilter)) continue;
            for (EventInfo ei : ti.getEvents()) {
                if (!ei.isSelected()) continue;
                eventIds.add(ei.getEventId());
            }
        }
        return eventIds;
    }

    public void setResactionFilter(String resactionFilter) {
        this.resactionFilter = "".equals(resactionFilter) ? null : resactionFilter;
    }

    public String getResactionFilter() {
        return this.resactionFilter;
    }

    static /* synthetic */ int access$000(WidgetTabTemplate x0) {
        return x0.chartWidth;
    }

    static /* synthetic */ String access$100(WidgetTabTemplate x0) {
        return x0.siteId;
    }

    static /* synthetic */ ReportsDataProvider access$200(WidgetTabTemplate x0) {
        return x0.chartDataProvider;
    }

    static /* synthetic */ SakaiDataTable access$300(WidgetTabTemplate x0) {
        return x0.table;
    }

    static /* synthetic */ Link access$400(WidgetTabTemplate x0) {
        return x0.tableLink;
    }

    static /* synthetic */ void access$500(WidgetTabTemplate x0, AjaxRequestTarget x1) {
        x0.updateData(x1);
    }
}

