/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.userauditservice.tool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.jsf.util.LocaleUtil;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.userauditservice.api.UserAuditRegistration;
import org.sakaiproject.userauditservice.api.UserAuditService;
import org.sakaiproject.userauditservice.tool.UserAuditEventLog;

public class UserAuditEventLog {
    private static final Log log = LogFactory.getLog(UserAuditEventLog.class);
    protected List<EventLog> eventLog = new ArrayList();
    public static final Comparator<EventLog> displayNameComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<EventLog> userIdComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<EventLog> roleNameComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<EventLog> auditStampComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<EventLog> actionTextComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    public static final Comparator<EventLog> sourceTextComparatorEL = new /* Unavailable Anonymous Inner Class!! */;
    protected String sortColumn;
    protected boolean sortAscending;
    private int totalItems = -1;
    private int firstItem = 0;
    private int pageSize = 0;
    private Map<String, User> userMap = new HashMap();
    private transient SqlService sqlService = (SqlService)ComponentManager.get((String)SqlService.class.getName());
    private transient UserAuditRegistration userAuditRegistration = (UserAuditRegistration)ComponentManager.get((String)UserAuditRegistration.class.getName());
    private transient UserAuditService userAuditService = (UserAuditService)ComponentManager.get((String)UserAuditService.class.getName());
    private transient SiteService siteService = (SiteService)ComponentManager.get((String)SiteService.class.getName());
    private transient ToolManager toolManager = (ToolManager)ComponentManager.get((String)ToolManager.class.getName());
    private transient UserDirectoryService userDirectoryService = (UserDirectoryService)ComponentManager.get((String)UserDirectoryService.class.getName());

    protected Comparator<EventLog> getComparatorEL() {
        String sortColumn = this.getSortColumn();
        Comparator comparator = "userDisplayName".equals(sortColumn) ? displayNameComparatorEL : ("userId".equals(sortColumn) ? userIdComparatorEL : ("roleName".equals(sortColumn) ? roleNameComparatorEL : ("auditStamp".equals(sortColumn) ? auditStampComparatorEL : ("actionText".equals(sortColumn) ? actionTextComparatorEL : ("sourceText".equals(sortColumn) ? sourceTextComparatorEL : auditStampComparatorEL)))));
        return comparator;
    }

    public List<EventLog> getEventLog() {
        return this.eventLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEvents() {
        if (this.eventLog == null || this.eventLog.isEmpty()) {
            this.eventLog = new ArrayList();
            Connection conn = null;
            Statement statement = null;
            ResultSet result = null;
            String sql = "";
            String siteId = this.toolManager.getCurrentPlacement().getContext();
            try {
                conn = this.sqlService.borrowConnection();
                statement = conn.createStatement();
                sql = "select user_id, role_name, action_taken, audit_stamp, source, action_user_id from user_audits_log where site_id = '" + siteId + "' order by audit_stamp desc";
                result = statement.executeQuery(sql);
                while (result.next()) {
                    User cachedUser;
                    String userId = result.getString("user_id");
                    String roleName = result.getString("role_name");
                    String actionTaken = result.getString("action_taken");
                    Timestamp auditStamp = result.getTimestamp("audit_stamp");
                    String source = result.getString("source");
                    String actionUserId = result.getString("action_user_id");
                    if (this.userMap.containsKey(userId)) {
                        cachedUser = (User)this.userMap.get(userId);
                    } else {
                        cachedUser = this.userDirectoryService.getUserByEid(userId);
                        this.userMap.put(userId, cachedUser);
                    }
                    if (actionUserId != null && !"".equals(actionUserId)) {
                        User cachedActionUser;
                        if (this.userMap.containsKey(actionUserId)) {
                            cachedActionUser = (User)this.userMap.get(actionUserId);
                        } else {
                            cachedActionUser = this.userDirectoryService.getUserByEid(actionUserId);
                            this.userMap.put(actionUserId, cachedActionUser);
                        }
                        this.eventLog.add(new EventLog(this, cachedUser, roleName, actionTaken, (Date)auditStamp, source, cachedActionUser));
                        continue;
                    }
                    this.eventLog.add(new EventLog(this, cachedUser, roleName, actionTaken, (Date)auditStamp, source, null));
                }
            }
            catch (UserNotDefinedException e) {
                log.warn((Object)"ERROR getting the user audit logs!", (Throwable)e);
            }
            catch (SQLException e) {
                log.warn((Object)"ERROR getting the user audit logs!", (Throwable)e);
            }
            finally {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)"Error trying to close the result set in the Roster Event Log!", (Throwable)e);
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)"Error trying to close the statement in the Roster Event Log!", (Throwable)e);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)"Error trying to close the database connection in the Roster Event Log!", (Throwable)e);
                }
            }
        }
        this.totalItems = this.eventLog.size();
    }

    public String getInitValues() {
        this.getEvents();
        if (this.eventLog != null && this.eventLog.size() >= 1) {
            Collections.sort(this.eventLog, this.getComparatorEL());
            if (!this.isSortAscending()) {
                Collections.reverse(this.eventLog);
            }
        }
        return "";
    }

    public String getPageTitle() {
        return LocaleUtil.getLocalizedString((FacesContext)FacesContext.getCurrentInstance(), (String)"UserAuditMessages", (String)"title_event_log");
    }

    public String getSortColumn() {
        if (this.sortColumn == null) {
            this.sortColumn = "auditStamp";
        }
        return this.sortColumn;
    }

    public boolean isExportablePage() {
        return false;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setEventLog(List<EventLog> eventLog) {
        this.eventLog = eventLog;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public int getRowsNumber() {
        if (this.totalItems <= this.pageSize) {
            return this.totalItems;
        }
        return this.pageSize;
    }

    public int getFirstItem() {
        return this.firstItem;
    }

    public void setFirstItem(int firstItem) {
        this.firstItem = firstItem;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    static /* synthetic */ UserAuditService access$000(UserAuditEventLog x0) {
        return x0.userAuditService;
    }
}

