/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PortletConfig;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.api.MenuItem;
import org.sakaiproject.cheftool.menu.MenuDivider;
import org.sakaiproject.cheftool.menu.MenuEntry;
import org.sakaiproject.cheftool.menu.MenuField;
import org.sakaiproject.courier.api.ObservingCourier;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.StringUtil;

public abstract class PagedResourceActionII
extends VelocityPortletPaneledAction {
    protected static ResourceLoader rb_praII = new ResourceLoader("velocity-tool");
    protected static final int DEFAULT_PAGE_SIZE = 20;
    protected static final String PARAM_PAGESIZE = "pagesize";
    protected static final String STATE_VIEW_ID = "view-id";
    protected static final String STATE_TOP_PAGE_MESSAGE = "msg-top";
    protected static final String STATE_PAGESIZE = "page-size";
    protected static final String STATE_NUM_MESSAGES = "num-messages";
    protected static final String STATE_NEXT_PAGE_EXISTS = "msg-next-page";
    protected static final String STATE_PREV_PAGE_EXISTS = "msg-prev-page";
    protected static final String STATE_FIRST_PAGE_EXISTS = "msg-first-page";
    protected static final String STATE_LAST_PAGE_EXISTS = "msg-last-page";
    protected static final String STATE_GO_NEXT_PAGE = "msg-go-next-page";
    protected static final String STATE_GO_PREV_PAGE = "msg-go-prev-page";
    protected static final String STATE_GO_NEXT = "msg-go-next";
    protected static final String STATE_GO_PREV = "msg-go-prev";
    protected static final String STATE_NEXT_EXISTS = "msg-next";
    protected static final String STATE_PREV_EXISTS = "msg-prev";
    protected static final String STATE_GO_FIRST_PAGE = "msg-go-first-page";
    protected static final String STATE_GO_LAST_PAGE = "msg-go-last-page";
    protected static final String STATE_SEARCH = "search";
    protected static final String STATE_MANUAL_REFRESH = "manual";
    protected static final String FORM_SEARCH = "search";
    protected static final String STATE_TOTAL_PAGENUMBER = "total_page_number";
    protected static final String STATE_CURRENT_PAGE = "current-page";
    protected static final String FORM_PAGE_NUMBER = "page_number";
    protected static final String STATE_GOTO_PAGE = "goto-page";
    protected static final int[] PAGESIZES = new int[]{5, 10, 20, 50, 100, 200};

    protected abstract List readResourcesPage(SessionState var1, int var2, int var3);

    protected abstract int sizeResources(SessionState var1);

    protected int totalPageNumber(SessionState state) {
        return state.getAttribute(STATE_TOTAL_PAGENUMBER) != null ? (Integer)state.getAttribute(STATE_TOTAL_PAGENUMBER) : 1;
    }

    @Override
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        HttpServletRequest req = rundata.getRequest();
        if (this.getVmReference("is_wireless_device", req) == null) {
            Session session = SessionManager.getCurrentSession();
            Object c = session.getAttribute("is_wireless_device");
            this.setVmReference("is_wireless_device", c, req);
        }
        if (state.getAttribute(STATE_PAGESIZE) == null) {
            state.setAttribute(STATE_PAGESIZE, (Object)new Integer(20));
            PortletConfig config = portlet.getPortletConfig();
            try {
                Integer size = new Integer(config.getInitParameter(PARAM_PAGESIZE));
                if (size <= 0) {
                    size = new Integer(20);
                    if (this.Log.getLogger("chef").isDebugEnabled()) {
                        this.Log.debug("chef", (Object)((Object)this) + ".initState: size parameter invalid: " + config.getInitParameter(PARAM_PAGESIZE));
                    }
                }
                state.setAttribute(STATE_PAGESIZE, (Object)size);
            }
            catch (Exception any) {
                if (this.Log.getLogger("chef").isDebugEnabled()) {
                    this.Log.debug("chef", (Object)((Object)this) + ".initState: size parameter invalid: " + any.toString());
                }
                state.setAttribute(STATE_PAGESIZE, (Object)new Integer(20));
            }
        }
        if (state.getAttribute(STATE_CURRENT_PAGE) == null) {
            state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
        }
        if (state.getAttribute(STATE_TOTAL_PAGENUMBER) == null) {
            state.setAttribute(STATE_TOTAL_PAGENUMBER, (Object)new Integer(1));
        }
    }

    protected void addViewPagingMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("viepag.prev"), state.getAttribute(STATE_PREV_EXISTS) != null, "doView_prev"));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("viepag.next"), state.getAttribute(STATE_NEXT_EXISTS) != null, "doView_next"));
    }

    protected void addListPagingMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("lispag.first"), state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_first"));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("lispag.prev"), state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_prev"));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("lispag.next"), state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_next"));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("lispag.last"), state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_last"));
    }

    protected void addSearchMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuDivider());
        bar.add((MenuItem)new MenuField("search", "toolbar", "doSearch", (String)state.getAttribute("search")));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("sea.sea"), null, true, 0, "doSearch", "toolbar"));
        if (state.getAttribute("search") != null) {
            bar.add((MenuItem)new MenuEntry(rb_praII.getString("sea.cleasea"), "doSearch_clear"));
        }
    }

    protected void addSearchMenus(Menu bar, SessionState state, String accessibilityLabel) {
        bar.add((MenuItem)new MenuDivider());
        bar.add((MenuItem)new MenuField("search", "toolbar", "doSearch", (String)state.getAttribute("search"), accessibilityLabel));
        bar.add((MenuItem)new MenuEntry(rb_praII.getString("sea.sea"), null, true, 0, "doSearch", "toolbar"));
        if (state.getAttribute("search") != null) {
            bar.add((MenuItem)new MenuEntry(rb_praII.getString("sea.cleasea"), "doSearch_clear"));
        }
    }

    protected void addRefreshMenus(Menu bar, SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer == null) {
            return;
        }
        bar.add((MenuItem)new MenuDivider());
        bar.add((MenuItem)new MenuEntry(observer.getEnabled() ? rb_praII.getString("ref.manref") : rb_praII.getString("ref.autoref"), "doAuto"));
        if (!observer.getEnabled()) {
            bar.add((MenuItem)new MenuEntry(rb_praII.getString("ref.refresh"), "doRefresh"));
        }
    }

    protected List prepPage(SessionState state) {
        int posEnd;
        int pageSize = state.getAttribute(STATE_PAGESIZE) != null ? (Integer)state.getAttribute(STATE_PAGESIZE) : 20;
        state.removeAttribute(STATE_NUM_MESSAGES);
        boolean goNextPage = state.getAttribute(STATE_GO_NEXT_PAGE) != null;
        boolean goPrevPage = state.getAttribute(STATE_GO_PREV_PAGE) != null;
        boolean goFirstPage = state.getAttribute(STATE_GO_FIRST_PAGE) != null;
        boolean goLastPage = state.getAttribute(STATE_GO_LAST_PAGE) != null;
        state.removeAttribute(STATE_GO_NEXT_PAGE);
        state.removeAttribute(STATE_GO_PREV_PAGE);
        state.removeAttribute(STATE_GO_FIRST_PAGE);
        state.removeAttribute(STATE_GO_LAST_PAGE);
        boolean goNext = state.getAttribute(STATE_GO_NEXT) != null;
        boolean goPrev = state.getAttribute(STATE_GO_PREV) != null;
        state.removeAttribute(STATE_GO_NEXT);
        state.removeAttribute(STATE_GO_PREV);
        boolean goViewPage = state.getAttribute(STATE_GOTO_PAGE) != null;
        boolean pinToTop = state.getAttribute(STATE_TOP_PAGE_MESSAGE) != null && state.getAttribute(STATE_PREV_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage && !goViewPage;
        int numMessages = this.sizeResources(state);
        if (numMessages == 0) {
            return new Vector();
        }
        int totalPageNumber = 1;
        totalPageNumber = numMessages % pageSize > 0 ? numMessages / pageSize + 1 : numMessages / pageSize;
        state.setAttribute(STATE_TOTAL_PAGENUMBER, (Object)new Integer(totalPageNumber));
        state.setAttribute(STATE_NUM_MESSAGES, (Object)new Integer(numMessages));
        int posStart = 0;
        Integer topPageMessage = (Integer)state.getAttribute(STATE_TOP_PAGE_MESSAGE);
        if (topPageMessage != null) {
            posStart = topPageMessage;
        }
        if (state.getAttribute(STATE_GOTO_PAGE) != null) {
            int gotoPage = (Integer)state.getAttribute(STATE_GOTO_PAGE);
            int currentPage = state.getAttribute(STATE_CURRENT_PAGE) != null ? (Integer)state.getAttribute(STATE_CURRENT_PAGE) : 0;
            posStart += pageSize * (gotoPage - currentPage);
        } else if (goNextPage) {
            posStart += pageSize;
        } else if (goPrevPage) {
            if ((posStart -= pageSize) < 0) {
                posStart = 0;
            }
        } else if (goFirstPage) {
            posStart = 0;
        } else if (goLastPage && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if (pinToTop) {
            posStart = 0;
        }
        if ((posEnd = posStart + (pageSize - 1)) >= numMessages) {
            posEnd = numMessages - 1;
        }
        List messagePage = this.readResourcesPage(state, posStart + 1, posEnd + 1);
        state.setAttribute(STATE_TOP_PAGE_MESSAGE, (Object)new Integer(posStart));
        int next = posStart + pageSize;
        if (next < numMessages) {
            state.setAttribute(STATE_NEXT_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
        }
        int prev = posStart - 1;
        if (prev >= 0) {
            state.setAttribute(STATE_PREV_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_PREV_PAGE_EXISTS);
        }
        state.removeAttribute(STATE_FIRST_PAGE_EXISTS);
        state.removeAttribute(STATE_LAST_PAGE_EXISTS);
        if (totalPageNumber != 1) {
            if (posStart > 0) {
                state.setAttribute(STATE_FIRST_PAGE_EXISTS, (Object)"");
            }
            if (posStart + pageSize < numMessages) {
                state.setAttribute(STATE_LAST_PAGE_EXISTS, (Object)"");
            }
        }
        if (state.getAttribute(STATE_VIEW_ID) != null) {
            int viewPos = (Integer)state.getAttribute(STATE_VIEW_ID);
            if (goNext && ++viewPos >= numMessages) {
                viewPos = numMessages - 1;
            }
            if (goPrev && --viewPos < 0) {
                viewPos = 0;
            }
            state.setAttribute(STATE_VIEW_ID, (Object)new Integer(viewPos));
            if (viewPos < posStart) {
                state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
            } else if (viewPos > posEnd) {
                state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
            }
            if (viewPos > 0) {
                state.setAttribute(STATE_PREV_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_PREV_EXISTS);
            }
            if (viewPos < numMessages - 1) {
                state.setAttribute(STATE_NEXT_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_NEXT_EXISTS);
            }
        }
        if (state.getAttribute(STATE_GOTO_PAGE) != null) {
            state.setAttribute(STATE_CURRENT_PAGE, state.getAttribute(STATE_GOTO_PAGE));
            state.removeAttribute(STATE_GOTO_PAGE);
        }
        return messagePage;
    }

    public void doChange_pagesize(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String newPageSize = data.getParameters().getString("selectPageSize");
        if (newPageSize == null) {
            state.setAttribute(STATE_PAGESIZE, (Object)new Integer(20));
            state.setAttribute("inter_size", (Object)new Integer(20));
        } else {
            state.setAttribute(STATE_PAGESIZE, (Object)Integer.valueOf(newPageSize));
            state.setAttribute("inter_size", (Object)Integer.valueOf(newPageSize));
        }
    }

    public void pagingInfoToContext(SessionState state, Context context) {
        if (state.getAttribute(STATE_NUM_MESSAGES) != null) {
            context.put("allMsgNumber", state.getAttribute(STATE_NUM_MESSAGES).toString());
            context.put("allMsgNumberInt", state.getAttribute(STATE_NUM_MESSAGES));
        }
        if (state.getAttribute(STATE_TOP_PAGE_MESSAGE) != null && state.getAttribute(STATE_PAGESIZE) != null) {
            int allMsgNumber;
            int topMsgPos = (Integer)state.getAttribute(STATE_TOP_PAGE_MESSAGE) + 1;
            context.put("topMsgPos", Integer.toString(topMsgPos));
            context.put("topMsgPosInt", new Integer(topMsgPos));
            int btmMsgPos = topMsgPos + (Integer)state.getAttribute(STATE_PAGESIZE) - 1;
            if (state.getAttribute(STATE_NUM_MESSAGES) != null && btmMsgPos > (allMsgNumber = ((Integer)state.getAttribute(STATE_NUM_MESSAGES)).intValue())) {
                btmMsgPos = allMsgNumber;
            }
            context.put("btmMsgPos", Integer.toString(btmMsgPos));
            context.put("btmMsgPosInt", new Integer(btmMsgPos));
        }
        boolean goPPButton = state.getAttribute(STATE_PREV_PAGE_EXISTS) != null;
        context.put("goPPButton", Boolean.toString(goPPButton));
        boolean goNPButton = state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null;
        context.put("goNPButton", Boolean.toString(goNPButton));
        boolean goFPButton = state.getAttribute(STATE_FIRST_PAGE_EXISTS) != null;
        context.put("goFPButton", Boolean.toString(goFPButton));
        boolean goLPButton = state.getAttribute(STATE_LAST_PAGE_EXISTS) != null;
        context.put("goLPButton", Boolean.toString(goLPButton));
        context.put(PARAM_PAGESIZE, state.getAttribute(STATE_PAGESIZE));
        context.put("pagesizes", PAGESIZES);
    }

    public void cleanStatePaging(SessionState state) {
        state.removeAttribute("inter_size");
        state.removeAttribute(STATE_NUM_MESSAGES);
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE);
        state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
        state.removeAttribute(STATE_PREV_PAGE_EXISTS);
    }

    public void doView_page(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String page = runData.getParameters().getString(FORM_PAGE_NUMBER);
        state.setAttribute(STATE_GOTO_PAGE, (Object)new Integer(page));
    }

    public void doView_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT, (Object)"");
        int page = state.getAttribute(STATE_CURRENT_PAGE) != null ? (Integer)state.getAttribute(STATE_CURRENT_PAGE) : 1;
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page + 1));
    }

    public void doList_first(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_FIRST_PAGE, (Object)"");
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
    }

    public void doList_last(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_LAST_PAGE, (Object)"");
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(this.totalPageNumber(state)));
    }

    public void doList_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
        int page = state.getAttribute(STATE_CURRENT_PAGE) != null ? (Integer)state.getAttribute(STATE_CURRENT_PAGE) : 1;
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page + 1));
    }

    public void doView_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV, (Object)"");
        int page = state.getAttribute(STATE_CURRENT_PAGE) != null ? (Integer)state.getAttribute(STATE_CURRENT_PAGE) : 2;
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page - 1));
    }

    public void doList_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
        int page = state.getAttribute(STATE_CURRENT_PAGE) != null ? (Integer)state.getAttribute(STATE_CURRENT_PAGE) : 2;
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page - 1));
    }

    public void doSearch(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String search = StringUtil.trimToNull((String)runData.getParameters().getString("search"));
        if (search == null) {
            state.removeAttribute("search");
        } else {
            state.setAttribute("search", (Object)search);
        }
        this.resetPaging(state);
        if (search != null) {
            ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
            if (observer != null) {
                observer.disable();
            }
        } else {
            this.enableObserver(state);
        }
    }

    public void doSearch_clear(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute("search");
        this.resetPaging(state);
        this.enableObserver(state);
    }

    protected void resetPaging(SessionState state) {
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
    }

    public void doAuto(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            boolean enabled = observer.getEnabled();
            if (enabled) {
                observer.disable();
                state.setAttribute(STATE_MANUAL_REFRESH, (Object)STATE_MANUAL_REFRESH);
            } else {
                observer.enable();
                state.removeAttribute(STATE_MANUAL_REFRESH);
            }
        }
    }

    public void doRefresh(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
    }

    public void enableObserver(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            if (state.getAttribute("search") != null || state.getAttribute(STATE_MANUAL_REFRESH) != null) {
                observer.disable();
            } else {
                observer.enable();
            }
        }
    }
}

