/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FileItem {
    protected static final int STREAM_BUFFER_SIZE = 102400;
    protected ByteArrayOutputStream m_body = new ByteArrayOutputStream();
    protected byte[] m_bodyBytes = null;
    protected String m_name = null;
    protected String m_type = null;
    protected InputStream m_inputStream;

    public FileItem(String fileName, String fileType) {
        if (fileName != null) {
            this.m_name = fileName.trim();
        }
        if (fileType != null) {
            this.m_type = fileType.trim();
        }
        this.m_body = null;
        this.m_bodyBytes = null;
        this.m_inputStream = null;
    }

    public FileItem(String fileName, String fileType, byte[] body) {
        if (fileName != null) {
            this.m_name = fileName.trim();
        }
        if (fileType != null) {
            this.m_type = fileType.trim();
        }
        this.m_body = null;
        this.m_bodyBytes = body;
        this.m_inputStream = null;
    }

    public FileItem(String fileName, String fileType, InputStream stream) {
        if (fileName != null) {
            this.m_name = fileName.trim();
        }
        if (fileType != null) {
            this.m_type = fileType.trim();
        }
        this.m_body = null;
        this.m_bodyBytes = null;
        this.m_inputStream = stream;
    }

    public String getFileName() {
        return this.m_name;
    }

    public String getContentType() {
        return this.m_type;
    }

    public String getString() {
        String rv = null;
        if (this.m_body == null && this.m_bodyBytes == null && this.m_inputStream != null) {
            this.stream2bodyBytes();
        }
        try {
            rv = this.m_body != null ? this.m_body.toString("ISO8859_1") : new String(this.m_bodyBytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.m_body = null;
        this.m_bodyBytes = null;
        return rv;
    }

    public byte[] get() {
        if (this.m_body == null && this.m_bodyBytes == null && this.m_inputStream != null) {
            this.stream2bodyBytes();
        }
        if (this.m_body != null) {
            byte[] content = this.m_body.toByteArray();
            this.m_body = null;
            return content;
        }
        byte[] content = this.m_bodyBytes;
        this.m_bodyBytes = null;
        return content;
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    OutputStream getOutputStream() {
        return this.m_body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stream2bodyBytes() {
        if (this.m_inputStream != null) {
            this.m_body = new ByteArrayOutputStream();
            byte[] chunk = new byte[102400];
            try {
                int lenRead;
                while ((lenRead = this.m_inputStream.read(chunk)) != -1) {
                    this.m_body.write(chunk, 0, lenRead);
                }
            }
            catch (IOException ignoree) {
            }
            finally {
                if (this.m_inputStream != null) {
                    try {
                        this.m_inputStream.close();
                        this.m_inputStream = null;
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

