/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.util.EnumerationIterator;
import org.sakaiproject.util.FileItem;

public class ParameterParser {
    protected HttpServletRequest m_req = null;

    public ParameterParser(HttpServletRequest req) {
        this.m_req = req;
    }

    public Properties getProperties() {
        Properties retval = new Properties();
        Iterator names = this.getNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            retval.setProperty(name, this.getString(name));
        }
        return retval;
    }

    public Iterator getNames() {
        return new EnumerationIterator(this.m_req.getParameterNames());
    }

    public String get(String name) {
        return this.m_req.getParameter(name);
    }

    public String getString(String name) {
        return this.get(name);
    }

    public String[] getStrings(String name) {
        return this.m_req.getParameterValues(name);
    }

    public boolean getBoolean(String name) {
        return "true".equalsIgnoreCase(this.get(name));
    }

    public int getInt(String name, int deflt) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (Throwable t) {
            return deflt;
        }
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public String getCleanString(String name) {
        String value = this.getString(name);
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder();
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            int next = 0;
            if (i + 1 < len) {
                next = value.charAt(i + 1);
            }
            switch (c) {
                case '\r': {
                    if (next == 10) {
                        buf.append('\n');
                        ++i;
                        continue block3;
                    }
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.charAt(buf.length() - 1) == '\n') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public String getPath() {
        return this.m_req.getPathInfo();
    }

    public FileItem getFileItem(String name) {
        Object o = this.m_req.getAttribute(name);
        if (o != null && o instanceof org.apache.commons.fileupload.FileItem) {
            org.apache.commons.fileupload.FileItem item = (org.apache.commons.fileupload.FileItem)o;
            try {
                return new FileItem(Normalizer.normalize(item.getName(), Normalizer.Form.NFC), item.getContentType(), item.getInputStream());
            }
            catch (IOException e) {
                return new FileItem(Normalizer.normalize(item.getName(), Normalizer.Form.NFC), item.getContentType(), item.get());
            }
        }
        return null;
    }
}

