/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.vm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.view.servlet.VelocityViewServlet;

public class VelocityServlet
extends VelocityViewServlet {
    protected ExtendedProperties loadConfiguration(ServletConfig config) throws IOException, FileNotFoundException {
        ExtendedProperties p;
        String configPath = config.getInitParameter("properties");
        if (configPath != null && configPath.length() > 0) {
            p = new ExtendedProperties();
            if (!configPath.startsWith("/")) {
                configPath = "/" + configPath;
            }
            p.load(this.getServletContext().getResourceAsStream(configPath));
        } else {
            p = super.loadConfiguration(config);
        }
        String path = config.getServletContext().getRealPath("/");
        if (path == null) {
            System.out.println(" SampleServlet.loadConfiguration() : unable to get the current webapp root.  Using '/'. Please fix.");
            path = "/";
        }
        p.setProperty("file.resource.loader.path", (Object)path);
        p.setProperty("runtime.log", (Object)(path + p.getProperty("runtime.log")));
        return p;
    }

    public Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) {
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String vName = this.escapeVmName(name);
            Object value = request.getAttribute(name);
            ctx.put(vName, value);
        }
        String templatePath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (templatePath == null) {
            templatePath = (String)request.getAttribute("sakai.vm.path");
        }
        if (templatePath == null) {
            templatePath = request.getServletPath();
        }
        Template template = null;
        try {
            template = this.getTemplate(templatePath);
        }
        catch (ParseErrorException ex) {
            this.log("Exception reading vm template: " + templatePath + " " + (Object)((Object)ex));
        }
        catch (ResourceNotFoundException ex) {
            this.log("Exception reading vm template: " + templatePath + " " + (Object)((Object)ex));
        }
        catch (Exception ex) {
            this.log("Exception reading vm template: " + templatePath + " " + ex);
        }
        return template;
    }

    protected String escapeVmName(String name) {
        char[] chars = name.toCharArray();
        if (!Character.isLetter(chars[0])) {
            chars[0] = 88;
        }
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            chars[i] = 95;
        }
        return new String(chars);
    }
}

