/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.cheftool.AlertImpl;
import org.sakaiproject.cheftool.VmServlet;
import org.sakaiproject.cheftool.api.Alert;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.menu.MenuImpl;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ParameterParser;
import org.sakaiproject.util.Web;

public abstract class ToolServlet
extends VmServlet {
    private static final long serialVersionUID = 1L;
    private static Log M_log = LogFactory.getLog(ToolServlet.class);
    protected static final String HELPER_ID = "sakai.tool.helper.id";
    private static final String HELPER_EXT = ".helper";
    protected final String TOOL_MODE_DEFAULT = "Default";
    protected final String TOOL_MODE_ATTR = "sakai.toolMode";
    protected final String TITLE_PANEL = "Title";
    protected final String MAIN_PANEL = "Main";
    protected static final String PARAM_ACTION_COMBO = "sakai_action_";
    protected static final String PARAM_ACTION = "sakai_action";
    protected static final String ALERT_STATE_INITED = "sakai.inited";
    protected static final String ALERT_ATTR = "sakai.alert";
    protected static final String MENU_ATTR = "sakai.menu";

    @Override
    protected void setVmStdRef(HttpServletRequest request, HttpServletResponse response) {
        super.setVmStdRef(request, response);
        this.setVmReference("sakai_toolMode", this.getToolMode(request), request);
        this.setVmReference("sakai_alert", this.getAlert(request), request);
        this.setVmReference("sakai_menu", this.getMenu(request), request);
    }

    protected void setToolMode(String toolMode, HttpServletRequest req) {
        this.getState(req).setAttribute("sakai.toolMode", (Object)toolMode);
    }

    protected String getToolMode(HttpServletRequest req) {
        String toolMode = (String)this.getState(req).getAttribute("sakai.toolMode");
        if (toolMode == null) {
            toolMode = "Default";
        }
        return toolMode;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        this.doGet(req, res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String panel = ((ParameterParser)req.getAttribute("sakai.wrapper.params")).getString("panel");
        panel = panel == null || panel.equals("") || panel.equals("null") ? "Main" : panel.replaceAll("[\r\n]", "");
        String helperId = HELPER_ID + panel;
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        String helper = ((ParameterParser)req.getAttribute("sakai.wrapper.params")).getString(helperId);
        if (helper != null) {
            toolSession.removeAttribute(helperId);
            String newUrl = req.getContextPath() + req.getServletPath() + (req.getPathInfo() == null ? "" : req.getPathInfo()) + "?" + "panel" + "=" + panel;
            try {
                res.sendRedirect(newUrl);
            }
            catch (IOException e) {
                M_log.warn((Object)("redirecting after helper done detection  to: " + newUrl + " : " + e.toString()));
            }
            return;
        }
        helper = (String)toolSession.getAttribute(helperId);
        Tool me = ToolManager.getCurrentTool();
        if (helper != null && !helper.equals(me.getId())) {
            toolSession.removeAttribute(helperId);
            String newUrl = req.getContextPath() + req.getServletPath() + (req.getPathInfo() == null ? "" : req.getPathInfo()) + "/" + helper + HELPER_EXT;
            try {
                res.sendRedirect(newUrl);
            }
            catch (IOException e) {
                M_log.warn((Object)("redirecting to helper to: " + newUrl + " : " + e.toString()));
            }
            return;
        }
        if (this.sendToHelper(req, res, req.getPathInfo())) {
            return;
        }
        this.prepState(req, res);
        this.processAction(req, res);
        if (!res.isCommitted()) {
            this.toolModeDispatch("doView", this.getToolMode(req), req, res);
        }
    }

    protected void startHelper(HttpServletRequest req, String helperId, String panel) {
        if (panel == null) {
            panel = "Main";
        }
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        toolSession.setAttribute(HELPER_ID + panel, (Object)helperId);
        String doneUrl = req.getContextPath() + req.getServletPath() + (req.getPathInfo() == null ? "" : req.getPathInfo()) + "?" + HELPER_ID + panel + "=done" + "&" + "panel" + "=" + panel;
        toolSession.setAttribute(helperId + "sakai.tool.helper.done.url", (Object)doneUrl);
    }

    protected void startHelper(HttpServletRequest req, String helperId) {
        this.startHelper(req, helperId, "Main");
    }

    protected void toolModeDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res) throws ToolException {
        String methodName = null;
        try {
            Class[] signature = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
            methodName = methodBase + methodExt;
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, signature);
            Object[] args = new Object[]{req, res};
            method.invoke((Object)this, args);
        }
        catch (NoSuchMethodException e) {
            throw new ToolException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ToolException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ToolException((Throwable)e);
        }
    }

    protected void processAction(HttpServletRequest req, HttpServletResponse res) {
        String action = ((ParameterParser)req.getAttribute("sakai.wrapper.params")).getString(PARAM_ACTION);
        if (action == null) {
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(PARAM_ACTION_COMBO)) continue;
                action = name.substring(PARAM_ACTION_COMBO.length());
                break;
            }
        }
        if (action != null) {
            this.actionDispatch("processAction", action, req, res);
        }
    }

    protected void actionDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res) {
        String methodName = null;
        try {
            Class[] signature = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
            methodName = methodBase + methodExt;
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, signature);
            Object[] args = new Object[]{req, res};
            method.invoke((Object)this, args);
        }
        catch (NoSuchMethodException e) {
            this.getServletContext().log("Exception calling method " + methodName + " " + e);
        }
        catch (IllegalAccessException e) {
            this.getServletContext().log("Exception calling method " + methodName + " " + e);
        }
        catch (InvocationTargetException e) {
            String xtra = "";
            if (e.getCause() != null) {
                xtra = " (Caused by " + e.getCause() + ")";
            }
            this.getServletContext().log("Exception calling method " + methodName + " " + e + xtra);
        }
    }

    protected String getPid(HttpServletRequest req) {
        String pid = (String)req.getAttribute("sakai.tool.placement.id");
        return pid;
    }

    protected SessionState getState(HttpServletRequest req) {
        SessionState rv;
        String key = this.getPid(req);
        if (key == null) {
            key = ((Object)((Object)this)).toString() + ".";
            M_log.warn((Object)("getState(): using servlet key: " + key));
        }
        if ((rv = UsageSessionService.getSessionState((String)key)) == null) {
            M_log.warn((Object)("getState(): no state found for key: " + key + " " + req.getPathInfo() + " " + req.getQueryString() + " " + req.getRequestURI()));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepState(HttpServletRequest req, HttpServletResponse res) {
        Session session;
        SessionState state = this.getState(req);
        Session session2 = session = SessionManager.getCurrentSession();
        synchronized (session2) {
            if (state.getAttribute(ALERT_STATE_INITED) == null) {
                this.initState(state, req, res);
                state.setAttribute(ALERT_STATE_INITED, (Object)new Boolean(true));
            } else {
                this.updateState(state, req, res);
            }
        }
    }

    protected void initState(SessionState state, HttpServletRequest req, HttpServletResponse res) {
    }

    protected void updateState(SessionState state, HttpServletRequest req, HttpServletResponse res) {
    }

    protected Alert getAlert(HttpServletRequest req) {
        SessionState state = this.getState(req);
        Alert alert = null;
        try {
            alert = (Alert)state.getAttribute(ALERT_ATTR);
        }
        catch (Exception e) {
            alert = null;
        }
        if (alert == null) {
            alert = new AlertImpl();
            state.setAttribute(ALERT_ATTR, (Object)alert);
        }
        return alert;
    }

    protected Alert getAlert(SessionState state) {
        Alert alert = (Alert)state.getAttribute(ALERT_ATTR);
        if (alert == null) {
            alert = new AlertImpl();
            state.setAttribute(ALERT_ATTR, (Object)alert);
        }
        return alert;
    }

    protected Menu getMenu(HttpServletRequest req) {
        SessionState state = this.getState(req);
        Menu menu = null;
        try {
            menu = (Menu)state.getAttribute(MENU_ATTR);
        }
        catch (Exception e) {
            menu = null;
        }
        if (menu == null) {
            menu = new MenuImpl();
            state.setAttribute(MENU_ATTR, (Object)menu);
        }
        return menu;
    }

    protected boolean sendToHelper(HttpServletRequest req, HttpServletResponse res, String target) throws ToolException {
        String[] parts;
        String path = req.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if ((parts = path.split("/")).length < 2) {
            return false;
        }
        if (!parts[1].endsWith(HELPER_EXT)) {
            return false;
        }
        int posEnd = parts[1].lastIndexOf(".");
        String helperId = target.substring(1, posEnd + 1);
        ActiveTool helperTool = ActiveToolManager.getActiveTool((String)helperId);
        String context = req.getContextPath() + req.getServletPath() + Web.makePath((String[])parts, (int)1, (int)2);
        String toolPath = Web.makePath((String[])parts, (int)2, (int)parts.length);
        helperTool.help(req, res, context, toolPath);
        return true;
    }
}

