/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.ControllerState;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.event.api.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VelocityPortletStateAction
extends VelocityPortletPaneledAction {
    private static final Logger log = LoggerFactory.getLogger(VelocityPortletStateAction.class);

    protected ControllerState getState(Context context, RunData rundata, Class stateClass) {
        return this.getState(((JetspeedRunData)rundata).getJs_peid(), rundata, stateClass);
    }

    protected ControllerState getState(VelocityPortlet portlet, RunData rundata, Class stateClass) {
        if (portlet == null) {
            log.warn("portlet null");
            return null;
        }
        return this.getState(portlet.getID(), rundata, stateClass);
    }

    protected ControllerState getState(String peid, RunData rundata, Class stateClass) {
        if (peid == null) {
            log.warn("peid null");
            return null;
        }
        try {
            SessionState ss = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            ControllerState state = (ControllerState)ss.getAttribute("state");
            if (state != null) {
                return state;
            }
            state = (ControllerState)stateClass.newInstance();
            state.setId(peid);
            ss.setAttribute("state", (Object)state);
            return state;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void releaseState(Context context, RunData rundata) {
        this.releaseState(((JetspeedRunData)rundata).getJs_peid(), rundata);
    }

    protected void releaseState(VelocityPortlet portlet, RunData rundata) {
        this.releaseState(portlet.getID(), rundata);
    }

    protected void releaseState(String peid, RunData rundata) {
        try {
            SessionState ss = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            ControllerState state = (ControllerState)ss.getAttribute("state");
            state.recycle();
            ss.removeAttribute("state");
            ss.clear();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

