/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool.menu;

import java.util.List;
import java.util.Vector;
import org.sakaiproject.cheftool.api.MenuItem;

public class MenuEntry
implements MenuItem {
    protected String m_title = null;
    protected String m_icon = null;
    protected boolean m_enabled = true;
    protected String m_action = null;
    protected String m_url = null;
    protected String m_form = null;
    protected int m_checked = 0;
    protected String m_accessibilitylabel = null;

    public MenuEntry(String title, String accessibilityLabel, String icon, boolean enabled, int checked, String action, String form) {
        this.m_title = title;
        this.m_accessibilitylabel = accessibilityLabel;
        this.m_icon = icon;
        this.m_enabled = enabled;
        this.m_checked = checked;
        this.m_action = action;
        this.m_form = form;
    }

    public MenuEntry(String title, String icon, boolean enabled, int checked, String action) {
        this(title, null, icon, enabled, checked, action, null);
    }

    public MenuEntry(String title, boolean enabled, String action) {
        this(title, null, null, enabled, 0, action, null);
    }

    public MenuEntry(String title, String action) {
        this(title, null, null, true, 0, action, null);
    }

    public MenuEntry(String title, String accessibilityLabel, String icon, boolean enabled, int checked, String action) {
        this(title, accessibilityLabel, icon, enabled, checked, action, null);
    }

    public MenuEntry(String title, String accessibilityLabel, String action) {
        this(title, accessibilityLabel, null, true, 0, action, null);
    }

    public MenuEntry(String title, String accessibilityLabel, boolean enabled, String action) {
        this(title, accessibilityLabel, null, enabled, 0, action, null);
    }

    public MenuEntry(String title, String icon, boolean enabled, int checked, String action, String form) {
        this(title, null, icon, enabled, checked, action, form);
    }

    public MenuEntry setUrl(String url) {
        this.m_url = url;
        return this;
    }

    public boolean getIsContainer() {
        return false;
    }

    public boolean getIsDivider() {
        return false;
    }

    public String getTitle() {
        return this.m_title == null ? "" : this.m_title;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public boolean getIsEnabled() {
        return this.m_enabled;
    }

    public String getAction() {
        return this.m_action == null || !this.m_enabled ? "" : this.m_action;
    }

    public String getUrl() {
        return this.m_url == null || !this.m_enabled ? "" : this.m_url;
    }

    public String getForm() {
        return this.m_form;
    }

    public List getItems() {
        return new Vector();
    }

    public MenuItem getItem(int index) {
        return null;
    }

    public int getChecked() {
        return this.m_checked;
    }

    public boolean getIschecked() {
        return this.m_checked == 2;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean getIsField() {
        return false;
    }

    public String getAccessibilityLabel() {
        return this.m_accessibilitylabel == null ? this.m_title : this.m_accessibilitylabel;
    }
}

