/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PortletConfig;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.api.MenuItem;
import org.sakaiproject.cheftool.menu.MenuDivider;
import org.sakaiproject.cheftool.menu.MenuEntry;
import org.sakaiproject.cheftool.menu.MenuField;
import org.sakaiproject.courier.api.ObservingCourier;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.util.ParameterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PagedResourceHelperAction
extends VelocityPortletPaneledAction {
    private static final Logger log = LoggerFactory.getLogger(PagedResourceHelperAction.class);
    private static final long serialVersionUID = 1L;
    protected static ResourceBundle rb = ResourceBundle.getBundle("velocity-tool");
    protected static final int DEFAULT_PAGE_SIZE = 10;
    protected static final String PARAM_PAGESIZE = "pagesize";
    protected static final String STATE_VIEW_ID = "prha.view-id";
    protected static final String STATE_TOP_PAGE_MESSAGE_ID = "prha.msg-top-id";
    protected static final String STATE_PAGESIZE = "prha.page-size";
    protected static final String STATE_NUM_MESSAGES = "prha.num-messages";
    protected static final String STATE_NEXT_PAGE_EXISTS = "prha.msg-next-page";
    protected static final String STATE_PREV_PAGE_EXISTS = "prha.msg-prev-page";
    protected static final String STATE_GO_NEXT_PAGE = "prha.msg-go-next-page";
    protected static final String STATE_GO_PREV_PAGE = "prha.msg-go-prev-page";
    protected static final String STATE_GO_NEXT = "prha.msg-go-next";
    protected static final String STATE_GO_PREV = "prha.msg-go-prev";
    protected static final String STATE_NEXT_EXISTS = "prha.msg-next";
    protected static final String STATE_PREV_EXISTS = "prha.msg-prev";
    protected static final String STATE_GO_FIRST_PAGE = "prha.msg-go-first-page";
    protected static final String STATE_GO_LAST_PAGE = "prha.msg-go-last-page";
    protected static final String STATE_SEARCH = "prha.search";
    protected static final String STATE_MANUAL_REFRESH = "prha.manual";
    protected static final String FORM_SEARCH = "search";

    protected List readAllResources(SessionState state) {
        Vector allResources = new Vector();
        return allResources;
    }

    @Override
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute(STATE_PAGESIZE) == null) {
            state.setAttribute(STATE_PAGESIZE, (Object)new Integer(10));
            PortletConfig config = portlet.getPortletConfig();
            try {
                Integer size = new Integer(config.getInitParameter(PARAM_PAGESIZE));
                if (size <= 0) {
                    size = new Integer(10);
                    log.debug("size parameter invalid: {}", (Object)config.getInitParameter(PARAM_PAGESIZE));
                }
                state.setAttribute(STATE_PAGESIZE, (Object)size);
            }
            catch (Exception any) {
                log.debug("size parameter invalid: {}", (Object)any.toString());
                state.setAttribute(STATE_PAGESIZE, (Object)new Integer(10));
            }
        }
    }

    protected void addViewPagingMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuEntry(rb.getString("viepag.prev"), state.getAttribute(STATE_PREV_EXISTS) != null, "doView_prev"));
        bar.add((MenuItem)new MenuEntry(rb.getString("viepag.next"), state.getAttribute(STATE_NEXT_EXISTS) != null, "doView_next"));
    }

    protected void addListPagingMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuEntry("First Page", state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_first"));
        bar.add((MenuItem)new MenuEntry("Previous Page", state.getAttribute(STATE_PREV_PAGE_EXISTS) != null, "doList_prev"));
        bar.add((MenuItem)new MenuEntry("Next Page", state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_next"));
        bar.add((MenuItem)new MenuEntry("Last Page", state.getAttribute(STATE_NEXT_PAGE_EXISTS) != null, "doList_last"));
    }

    protected void addSearchMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuDivider());
        bar.add((MenuItem)new MenuField(FORM_SEARCH, "toolbar", "doSearch", (String)state.getAttribute(STATE_SEARCH)));
        bar.add((MenuItem)new MenuEntry(rb.getString("sea.sea"), null, true, 0, "doSearch", "toolbar"));
        if (state.getAttribute(STATE_SEARCH) != null) {
            bar.add((MenuItem)new MenuEntry(rb.getString("sea.cleasea"), "doSearch_clear"));
        }
    }

    protected void addRefreshMenus(Menu bar, SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer == null) {
            return;
        }
        bar.add((MenuItem)new MenuDivider());
        bar.add((MenuItem)new MenuEntry(observer.getEnabled() ? rb.getString("ref.manref") : rb.getString("ref.autoref"), "doAuto"));
        if (!observer.getEnabled()) {
            bar.add((MenuItem)new MenuEntry(rb.getString("ref.refresh"), "doRefresh"));
        }
    }

    protected List prepPage(SessionState state) {
        int posEnd;
        Vector rv = new Vector();
        int pageSize = (Integer)state.getAttribute(STATE_PAGESIZE);
        state.removeAttribute(STATE_NUM_MESSAGES);
        boolean goNextPage = state.getAttribute(STATE_GO_NEXT_PAGE) != null;
        boolean goPrevPage = state.getAttribute(STATE_GO_PREV_PAGE) != null;
        boolean goFirstPage = state.getAttribute(STATE_GO_FIRST_PAGE) != null;
        boolean goLastPage = state.getAttribute(STATE_GO_LAST_PAGE) != null;
        state.removeAttribute(STATE_GO_NEXT_PAGE);
        state.removeAttribute(STATE_GO_PREV_PAGE);
        state.removeAttribute(STATE_GO_FIRST_PAGE);
        state.removeAttribute(STATE_GO_LAST_PAGE);
        boolean goNext = state.getAttribute(STATE_GO_NEXT) != null;
        boolean goPrev = state.getAttribute(STATE_GO_PREV) != null;
        state.removeAttribute(STATE_GO_NEXT);
        state.removeAttribute(STATE_GO_PREV);
        List allMessages = this.readAllResources(state);
        if (allMessages == null) {
            return rv;
        }
        boolean pinToTop = state.getAttribute(STATE_TOP_PAGE_MESSAGE_ID) != null && state.getAttribute(STATE_PREV_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage;
        boolean pinToBottom = state.getAttribute(STATE_TOP_PAGE_MESSAGE_ID) != null && state.getAttribute(STATE_NEXT_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage;
        int numMessages = allMessages.size();
        if (numMessages == 0) {
            return rv;
        }
        state.setAttribute(STATE_NUM_MESSAGES, (Object)new Integer(numMessages));
        int posStart = 0;
        String messageIdAtTheTopOfThePage = (String)state.getAttribute(STATE_TOP_PAGE_MESSAGE_ID);
        if (messageIdAtTheTopOfThePage != null && (posStart = this.findResourceInList(allMessages, messageIdAtTheTopOfThePage)) == -1) {
            posStart = 0;
        }
        if (goNextPage) {
            posStart += pageSize;
        } else if (goPrevPage) {
            if ((posStart -= pageSize) < 0) {
                posStart = 0;
            }
        } else if (goFirstPage) {
            posStart = 0;
        } else if (goLastPage && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if (pinToTop) {
            posStart = 0;
        } else if (pinToBottom && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if (posStart + pageSize > numMessages && (posStart = numMessages - pageSize) < 0) {
            posStart = 0;
        }
        if ((posEnd = posStart + (pageSize - 1)) >= numMessages) {
            posEnd = numMessages - 1;
        }
        int numMessagesOnThisPage = posEnd - posStart + 1;
        for (int i = posStart; i <= posEnd; ++i) {
            rv.add(allMessages.get(i));
        }
        Entity messageAtTheTopOfThePage = (Entity)allMessages.get(posStart);
        state.setAttribute(STATE_TOP_PAGE_MESSAGE_ID, (Object)messageAtTheTopOfThePage.getId());
        int next = posStart + pageSize;
        if (next < numMessages) {
            state.setAttribute(STATE_NEXT_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
        }
        int prev = posStart - 1;
        if (prev >= 0) {
            state.setAttribute(STATE_PREV_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_PREV_PAGE_EXISTS);
        }
        if (state.getAttribute(STATE_VIEW_ID) != null) {
            int viewPos = this.findResourceInList(allMessages, (String)state.getAttribute(STATE_VIEW_ID));
            if (goNext && ++viewPos >= numMessages) {
                viewPos = numMessages - 1;
            }
            if (goPrev && --viewPos < 0) {
                viewPos = 0;
            }
            state.setAttribute(STATE_VIEW_ID, (Object)((Entity)allMessages.get(viewPos)).getId());
            if (viewPos < posStart) {
                state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
            } else if (viewPos > posEnd) {
                state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
            }
            if (viewPos > 0) {
                state.setAttribute(STATE_PREV_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_PREV_EXISTS);
            }
            if (viewPos < numMessages - 1) {
                state.setAttribute(STATE_NEXT_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_NEXT_EXISTS);
            }
        }
        return rv;
    }

    public void doView_next(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT, (Object)"");
    }

    public void doList_first(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_FIRST_PAGE, (Object)"");
    }

    public void doList_last(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_LAST_PAGE, (Object)"");
    }

    public void doList_next(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
    }

    public void doChange_pagesize(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        ParameterParser params = runData.getParameters();
        String pagesize = params.getString("selectPageSize");
        Integer size = Integer.valueOf(pagesize);
        state.setAttribute(STATE_PAGESIZE, (Object)size);
    }

    public void doView_prev(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV, (Object)"");
    }

    public void doList_prev(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
    }

    public void doSearch(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String search = StringUtils.trimToNull((String)runData.getParameters().getString(FORM_SEARCH));
        if (search == null) {
            state.removeAttribute(STATE_SEARCH);
        } else {
            state.setAttribute(STATE_SEARCH, (Object)search);
        }
        this.resetPaging(state);
        if (search != null) {
            ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
            if (observer != null) {
                observer.disable();
            }
        } else {
            this.enableObserver(state);
        }
    }

    public void doSearch_clear(RunData runData) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute(STATE_SEARCH);
        this.resetPaging(state);
        this.enableObserver(state);
    }

    protected void resetPaging(SessionState state) {
        state.removeAttribute(STATE_TOP_PAGE_MESSAGE_ID);
    }

    protected int findResourceInList(List resources, String id) {
        for (int i = 0; i < resources.size(); ++i) {
            if (!((Entity)resources.get(i)).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public void doAuto(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            boolean enabled = observer.getEnabled();
            if (enabled) {
                observer.disable();
                state.setAttribute(STATE_MANUAL_REFRESH, (Object)"manual");
            } else {
                observer.enable();
                state.removeAttribute(STATE_MANUAL_REFRESH);
            }
        }
    }

    public void doRefresh(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
    }

    public void enableObserver(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            if (state.getAttribute(STATE_SEARCH) != null || state.getAttribute(STATE_MANUAL_REFRESH) != null) {
                observer.disable();
            } else {
                observer.enable();
            }
        }
    }
}

