/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PortletConfig;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.api.MenuItem;
import org.sakaiproject.cheftool.menu.MenuEntry;
import org.sakaiproject.cheftool.menu.MenuField;
import org.sakaiproject.courier.api.ObservingCourier;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.event.api.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewPagedResourceAction
extends VelocityPortletPaneledAction {
    private static final Logger log = LoggerFactory.getLogger(NewPagedResourceAction.class);
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_PAGE_SIZE = 15;
    protected static final String PARAM_PAGESIZE = "pagesize";
    protected static final String STATE_VIEW_ID = "view-id";
    protected static final String STATE_TOP_PAGE_ITEM = "item-top";
    protected static final String STATE_PAGESIZE = "page-size";
    protected static final String STATE_TOTAL_PAGENUMBER = "total_page_number";
    protected static final String STATE_NUM_ITEMS = "num-items";
    protected static final String STATE_NEXT_PAGE_EXISTS = "item-next-page";
    protected static final String STATE_PREV_PAGE_EXISTS = "item-prev-page";
    protected static final String STATE_GO_NEXT_PAGE = "item-go-next-page";
    protected static final String STATE_GO_PREV_PAGE = "item-go-prev-page";
    protected static final String STATE_GO_NEXT = "item-go-next";
    protected static final String STATE_GO_PREV = "item-go-prev";
    protected static final String STATE_NEXT_EXISTS = "item-next";
    protected static final String STATE_PREV_EXISTS = "item-prev";
    protected static final String STATE_GO_FIRST_PAGE = "item-go-first-page";
    protected static final String STATE_GO_LAST_PAGE = "item-go-last-page";
    protected static final String STATE_SEARCH = "search";
    protected static final String STATE_MANUAL_REFRESH = "manual";
    protected static final String STATE_GOTO_PAGE = "goto-page";
    protected static final String STATE_CURRENT_PAGE = "current-page";
    protected static final String STATE_SELECTED_VIEW = "selected_view";
    protected static final String STATE_PAGING = "paging";
    protected static final String FORM_SEARCH = "search";
    protected static final String FORM_PAGE_NUMBER = "page_number";

    protected abstract List readAllResources(SessionState var1);

    protected int totalPageNumber(SessionState state) {
        return (Integer)state.getAttribute(STATE_TOTAL_PAGENUMBER);
    }

    protected void addSearchMenus(Menu bar, SessionState state) {
        bar.add((MenuItem)new MenuField("search", "2ndToolbarForm", "doSearch", (String)state.getAttribute("search")));
        bar.add((MenuItem)new MenuEntry("Search", null, true, 0, "doSearch", "2ndToolbarForm"));
        if (state.getAttribute("search") != null) {
            bar.add((MenuItem)new MenuEntry("Clear Search", "doSearch_clear"));
        }
    }

    @Override
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute(STATE_PAGESIZE) == null) {
            PortletConfig config = portlet.getPortletConfig();
            try {
                Integer size = new Integer(config.getInitParameter(PARAM_PAGESIZE));
                if (size <= 0) {
                    size = new Integer(15);
                    log.debug("size parameter invalid 1: {}", (Object)config.getInitParameter(PARAM_PAGESIZE));
                }
                state.setAttribute(STATE_PAGESIZE, (Object)size);
            }
            catch (Exception any) {
                log.debug("size parameter invalid 2: {}", (Object)any.toString());
                state.setAttribute(STATE_PAGESIZE, (Object)new Integer(15));
            }
        }
        if (state.getAttribute(STATE_CURRENT_PAGE) == null) {
            state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
        }
        if (state.getAttribute(STATE_PAGING) == null) {
            state.setAttribute(STATE_PAGING, (Object)Boolean.FALSE);
        }
        if (state.getAttribute(STATE_TOTAL_PAGENUMBER) == null) {
            state.setAttribute(STATE_TOTAL_PAGENUMBER, (Object)new Integer(1));
        }
    }

    protected List prepPage(SessionState state) {
        Vector rv = new Vector();
        List allItems = this.readAllResources(state);
        if (allItems == null) {
            return rv;
        }
        int pageSize = (Integer)state.getAttribute(STATE_PAGESIZE);
        int totalPageNumber = 1;
        int listSize = allItems.size();
        totalPageNumber = listSize % pageSize > 0 ? listSize / pageSize + 1 : listSize / pageSize;
        state.setAttribute(STATE_TOTAL_PAGENUMBER, (Object)new Integer(totalPageNumber));
        boolean paged = (Boolean)state.getAttribute(STATE_PAGING);
        if (!paged) {
            if (totalPageNumber > 1) {
                state.setAttribute(STATE_NEXT_PAGE_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
            }
            state.removeAttribute(STATE_PREV_PAGE_EXISTS);
            return allItems;
        }
        state.removeAttribute(STATE_NUM_ITEMS);
        boolean goNextPage = state.getAttribute(STATE_GO_NEXT_PAGE) != null;
        boolean goPrevPage = state.getAttribute(STATE_GO_PREV_PAGE) != null;
        boolean goFirstPage = state.getAttribute(STATE_GO_FIRST_PAGE) != null;
        boolean goLastPage = state.getAttribute(STATE_GO_LAST_PAGE) != null;
        state.removeAttribute(STATE_GO_NEXT_PAGE);
        state.removeAttribute(STATE_GO_PREV_PAGE);
        state.removeAttribute(STATE_GO_FIRST_PAGE);
        state.removeAttribute(STATE_GO_LAST_PAGE);
        boolean goNext = state.getAttribute(STATE_GO_NEXT) != null;
        boolean goPrev = state.getAttribute(STATE_GO_PREV) != null;
        state.removeAttribute(STATE_GO_NEXT);
        state.removeAttribute(STATE_GO_PREV);
        boolean goViewPage = state.getAttribute(STATE_GOTO_PAGE) != null;
        boolean pinToTop = state.getAttribute(STATE_TOP_PAGE_ITEM) != null && state.getAttribute(STATE_PREV_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage && !goViewPage;
        boolean pinToBottom = state.getAttribute(STATE_TOP_PAGE_ITEM) != null && state.getAttribute(STATE_NEXT_PAGE_EXISTS) == null && !goNextPage && !goPrevPage && !goNext && !goPrev && !goFirstPage && !goLastPage && !goViewPage;
        int numItems = allItems.size();
        if (numItems == 0) {
            return rv;
        }
        state.setAttribute(STATE_NUM_ITEMS, (Object)new Integer(numItems));
        int posStart = 0;
        String itemIdAtTheTopOfThePage = (String)state.getAttribute(STATE_TOP_PAGE_ITEM);
        if (itemIdAtTheTopOfThePage != null && (posStart = this.findResourceInList(allItems, itemIdAtTheTopOfThePage)) == -1) {
            posStart = 0;
        }
        if (state.getAttribute(STATE_GOTO_PAGE) != null) {
            int gotoPage = (Integer)state.getAttribute(STATE_GOTO_PAGE);
            int currentPage = (Integer)state.getAttribute(STATE_CURRENT_PAGE);
            posStart += pageSize * (gotoPage - currentPage);
        } else if (goNextPage) {
            posStart += pageSize;
        } else if (goPrevPage) {
            if ((posStart -= pageSize) < 0) {
                posStart = 0;
            }
        } else if (goFirstPage) {
            posStart = 0;
        } else if (goLastPage && (posStart = numItems - pageSize) < 0) {
            posStart = 0;
        }
        if (pinToTop) {
            posStart = 0;
        } else if (pinToBottom && (posStart = numItems - pageSize) < 0) {
            posStart = 0;
        }
        int posEnd = posStart + (pageSize - 1);
        if (posEnd >= numItems) {
            posEnd = numItems - 1;
        }
        int numItemsOnThisPage = posEnd - posStart + 1;
        for (int i = posStart; i <= posEnd; ++i) {
            rv.add(allItems.get(i));
        }
        Entity itemAtTheTopOfThePage = (Entity)allItems.get(posStart);
        state.setAttribute(STATE_TOP_PAGE_ITEM, (Object)itemAtTheTopOfThePage.getId());
        int next = posStart + pageSize;
        if (next < numItems) {
            state.setAttribute(STATE_NEXT_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_NEXT_PAGE_EXISTS);
        }
        int prev = posStart - 1;
        if (prev >= 0) {
            state.setAttribute(STATE_PREV_PAGE_EXISTS, (Object)"");
        } else {
            state.removeAttribute(STATE_PREV_PAGE_EXISTS);
        }
        if (state.getAttribute(STATE_VIEW_ID) != null) {
            int viewPos = this.findResourceInList(allItems, (String)state.getAttribute(STATE_VIEW_ID));
            if (goNext && ++viewPos >= numItems) {
                viewPos = numItems - 1;
            }
            if (goPrev && --viewPos < 0) {
                viewPos = 0;
            }
            state.setAttribute(STATE_VIEW_ID, (Object)((Entity)allItems.get(viewPos)).getId());
            if (viewPos < posStart) {
                state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
            } else if (viewPos > posEnd) {
                state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
            }
            if (viewPos > 0) {
                state.setAttribute(STATE_PREV_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_PREV_EXISTS);
            }
            if (viewPos < numItems - 1) {
                state.setAttribute(STATE_NEXT_EXISTS, (Object)"");
            } else {
                state.removeAttribute(STATE_NEXT_EXISTS);
            }
        }
        if (state.getAttribute(STATE_GOTO_PAGE) != null) {
            state.setAttribute(STATE_CURRENT_PAGE, state.getAttribute(STATE_GOTO_PAGE));
            state.removeAttribute(STATE_GOTO_PAGE);
        }
        return rv;
    }

    public void doView_page(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String page = runData.getParameters().getString(FORM_PAGE_NUMBER);
        state.setAttribute(STATE_GOTO_PAGE, (Object)new Integer(page));
    }

    public void doView_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT, (Object)"");
        int page = (Integer)state.getAttribute(STATE_CURRENT_PAGE);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page + 1));
    }

    public void doList_first(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_FIRST_PAGE, (Object)"");
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
    }

    public void doList_last(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_LAST_PAGE, (Object)"");
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(this.totalPageNumber(state)));
    }

    public void doList_next(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_NEXT_PAGE, (Object)"");
        int page = (Integer)state.getAttribute(STATE_CURRENT_PAGE);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page + 1));
    }

    public void doView_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV, (Object)"");
        int page = (Integer)state.getAttribute(STATE_CURRENT_PAGE);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page - 1));
    }

    public void doList_prev(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setAttribute(STATE_GO_PREV_PAGE, (Object)"");
        int page = (Integer)state.getAttribute(STATE_CURRENT_PAGE);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(page - 1));
    }

    public void doSearch(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String search = StringUtils.trimToNull((String)runData.getParameters().getString("search"));
        if (search == null) {
            state.removeAttribute("search");
        } else {
            state.setAttribute("search", (Object)search);
        }
        this.resetPaging(state);
        if (search != null) {
            ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
            if (observer != null) {
                observer.disable();
            }
        } else {
            this.enableObserver(state);
        }
    }

    public void doSearch_clear(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.removeAttribute("search");
        this.resetPaging(state);
        this.enableObserver(state);
    }

    protected void resetPaging(SessionState state) {
        state.removeAttribute(STATE_TOP_PAGE_ITEM);
        state.setAttribute(STATE_CURRENT_PAGE, (Object)new Integer(1));
    }

    protected int findResourceInList(List resources, String id) {
        for (int i = 0; i < resources.size(); ++i) {
            if (!((Entity)resources.get(i)).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public void doAuto(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            boolean enabled = observer.getEnabled();
            if (enabled) {
                observer.disable();
                state.setAttribute(STATE_MANUAL_REFRESH, (Object)STATE_MANUAL_REFRESH);
            } else {
                observer.enable();
                state.removeAttribute(STATE_MANUAL_REFRESH);
            }
        }
    }

    public void doRefresh(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
    }

    public void enableObserver(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute("obsever");
        if (observer != null) {
            if (state.getAttribute("search") != null || state.getAttribute(STATE_MANUAL_REFRESH) != null) {
                observer.disable();
            } else {
                observer.enable();
            }
        }
    }

    public void doToggle_paging(RunData data, Context context) {
        SessionState state;
        String peid = ((JetspeedRunData)data).getJs_peid();
        Boolean paging_status = (Boolean)(state = ((JetspeedRunData)data).getPortletSessionState(peid)).getAttribute(STATE_PAGING);
        state.setAttribute(STATE_PAGING, (Object)new Boolean(paging_status == false));
        if (((Boolean)state.getAttribute(STATE_PAGING)).booleanValue()) {
            this.resetPaging(state);
        }
    }
}

