/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PortletConfig;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.ToolServlet;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.api.Alert;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.api.MenuItem;
import org.sakaiproject.cheftool.menu.MenuEntry;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.courier.api.ObservingCourier;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.portal.util.PortalUtils;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.EditorConfiguration;
import org.sakaiproject.util.ParameterParser;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;
import org.sakaiproject.util.Web;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VelocityPortletPaneledAction
extends ToolServlet {
    private static final Logger log = LoggerFactory.getLogger(VelocityPortletPaneledAction.class);
    private static final long serialVersionUID = 1L;
    private static ResourceLoader rb = new ResourceLoader("velocity-tool");
    protected static final String BUTTON = "eventSubmit_";
    public static final String STATE_HELPER = "vppa.helper";
    protected static final String STATE_MODE = "mode";
    protected static final String STATE_OBSERVER = "obsever";
    protected static final String STATE_ACTION = "action";
    protected static final String STATE_NEW_PANEL = "state:new_panel";
    protected static final String CONTEXT_SITE_COLLECTION_ID = "vppa_site_collection_id";
    protected static final String CONTEXT_SITE_COLLECTION_URL = "vppa_site_collection_url";
    protected static final String LAYOUT_MAIN = "Main";
    protected static final String SAKAI_CSRF_TOKEN = "sakai_csrf_token";
    protected static final String HELPER_LINK_MODE = "link_mode";
    protected static final String HELPER_MODE_DONE = "helper.done";
    private ContentHostingService contentHostingService = (ContentHostingService)ComponentManager.get((String)ContentHostingService.class.getName());
    public static final String STATE_OBSERVER2 = "obsever2";
    public static final String STATE_PRESENCE_OBSERVER = "presence_observer";
    public static final String STATE_FLOAT = "float";
    public static final String STATE_TOOL = "tool";
    public static final String STATE_MESSAGE = "message";
    public static final String STATE_NOTIF = "notification";
    public static final String MODE_OPTIONS = "options";
    protected static final String ATTR_CONTEXT = "sakai.wrapper.context";
    protected static final String ATTR_CONFIG = "sakai.wrapper.config";
    protected static final String ATTR_PORTLET = "sakai.wrapper.portlet";
    protected static final String ATTR_RUNDATA = "sakai.wrapper.rundata";
    public static final String ATTR_FRAME_REFRESH = "sakai.vppa.frame.refresh";
    public static final String ATTR_TOP_REFRESH = "sakai.vppa.top.refresh";
    public static final String ATTR_FRAME_FOCUS = "sakai.vppa.frame.focus";
    private static String[] DEFAULT_FORMAT_ARRAY = new String[]{"m", "d", "y"};
    private static final String[] DEFAULT_TIME_FORMAT_ARRAY = new String[]{"h", "m", "a"};

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        HttpServletRequest req = rundata.getRequest();
        Session session = SessionManager.getCurrentSession();
        if (this.getVmReference("is_wireless_device", req) == null) {
            Object c = session.getAttribute("is_wireless_device");
            this.setVmReference("is_wireless_device", c, req);
        }
        if (this.getVmReference(SAKAI_CSRF_TOKEN, req) == null) {
            Object csrfToken = session.getAttribute(UsageSessionService.SAKAI_CSRF_SESSION_ATTRIBUTE);
            this.setVmReference(SAKAI_CSRF_TOKEN, csrfToken, req);
        }
    }

    protected String clientWindowId(SessionState state, String toolId) {
        Session session = SessionManager.getCurrentSession();
        Placement placement = ToolManager.getCurrentPlacement();
        String deliveryId = session.getId() + placement.getId();
        return deliveryId;
    }

    public static String mainPanelUpdateId(String toolId) {
        return Validator.escapeJavascript((String)(LAYOUT_MAIN + toolId));
    }

    public static String titlePanelUpdateId(String toolId) {
        return Validator.escapeJavascript((String)("Title" + toolId));
    }

    public static void addAlert(SessionState state, String message) {
        String soFar = (String)state.getAttribute(STATE_MESSAGE);
        soFar = soFar != null ? soFar + "\n\n" + message : message;
        state.setAttribute(STATE_MESSAGE, (Object)soFar);
    }

    public static void addFlashNotif(SessionState state, String message) {
        String soFar = (String)state.getAttribute(STATE_NOTIF);
        soFar = soFar != null ? soFar + "\n\n" + message : message;
        state.setAttribute(STATE_NOTIF, (Object)soFar);
    }

    public static void switchPanel(SessionState state, String newPanel) {
        state.setAttribute(STATE_NEW_PANEL, (Object)newPanel);
    }

    @Override
    protected void initState(SessionState state, HttpServletRequest req, HttpServletResponse res) {
        super.initState(state, req, res);
        VelocityPortlet portlet = (VelocityPortlet)req.getAttribute(ATTR_PORTLET);
        JetspeedRunData rundata = (JetspeedRunData)req.getAttribute(ATTR_RUNDATA);
        this.initState(state, portlet, rundata);
    }

    @Override
    protected void updateState(SessionState state, HttpServletRequest req, HttpServletResponse res) {
        super.updateState(state, req, res);
        VelocityPortlet portlet = (VelocityPortlet)req.getAttribute(ATTR_PORTLET);
        JetspeedRunData rundata = (JetspeedRunData)req.getAttribute(ATTR_RUNDATA);
        this.initState(state, portlet, rundata);
    }

    @Override
    protected void toolModeDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res) throws ToolException {
        Context context = (Context)req.getAttribute(ATTR_CONTEXT);
        VelocityPortlet portlet = (VelocityPortlet)req.getAttribute(ATTR_PORTLET);
        JetspeedRunData rundata = (JetspeedRunData)req.getAttribute(ATTR_RUNDATA);
        context.put("param_panel", "panel");
        context.put(STATE_ACTION, this.getState(req).getAttribute(STATE_ACTION));
        context.put("param_pid", "pid");
        context.put("pid", this.getPid(req));
        String collectionId = this.contentHostingService.getSiteCollection(ToolManager.getCurrentPlacement().getContext());
        context.put(CONTEXT_SITE_COLLECTION_ID, collectionId);
        String editor = EditorConfiguration.getWysiwigEditor();
        context.put("sakai_editor", editor);
        context.put("editorConfig", new EditorConfiguration());
        UsageSession session = UsageSessionService.getSession();
        if (session != null) {
            String userId = session.getUserId();
            ResourceLoader rl = new ResourceLoader(userId);
            Locale locale = rl.getLocale();
            String languageCode = locale.getLanguage();
            String countryCode = locale.getCountry();
            if (countryCode != null && countryCode.length() > 0) {
                languageCode = languageCode + "-" + countryCode;
            }
            context.put("language", languageCode);
            context.put("dir", rl.getOrientation(locale));
            String browserId = session.getBrowserId();
            if ("Win-InternetExplorer".equals(browserId) || "Win-Mozilla".equals(browserId) || "Win-NetscapeNavigator".equals(browserId) || "Mac-Mozilla".equals(browserId) || "Mac-NetscapeNavigator".equals(browserId)) {
                context.put("wysiwyg", "true");
            }
        }
        try {
            String panel = ((ParameterParser)req.getAttribute("sakai.wrapper.params")).getString("panel");
            panel = panel == null || "".equals(panel) || "null".equals(panel) ? LAYOUT_MAIN : panel.replaceAll("[\r\n]", "");
            context.put("panel", panel);
            Class[] types = new Class[]{VelocityPortlet.class, Context.class, RunData.class, SessionState.class};
            String methodName = this.panelMethodName(panel);
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, types);
            Object[] args = new Object[]{portlet, context, rundata, this.getState(req)};
            String template = (String)method.invoke((Object)this, args);
            if (!res.isCommitted()) {
                Alert alert;
                if (template == null) {
                    template = this.getContext(rundata).get("template") + "-" + panel;
                }
                template = "/vm/" + template + ".vm";
                StringBuilder buf = new StringBuilder();
                String msg = (String)this.getState(req).getAttribute(STATE_MESSAGE);
                if (msg != null) {
                    buf.append(msg);
                    this.getState(req).removeAttribute(STATE_MESSAGE);
                }
                if (!(alert = this.getAlert(req)).isEmpty()) {
                    buf.append(alert.peekAlert());
                    this.setVmReference("sakai.alert", alert, req);
                }
                if (buf.length() > 0) {
                    this.setVmReference("alertMessage", buf.toString(), req);
                }
                StringBuilder sbNotif = new StringBuilder();
                String sNotif = (String)this.getState(req).getAttribute(STATE_NOTIF);
                if (sNotif != null) {
                    sbNotif.append(sNotif);
                    this.getState(req).removeAttribute(STATE_NOTIF);
                }
                if (sbNotif.length() > 0) {
                    this.setVmReference("flashNotif", sbNotif.toString(), req);
                    this.setVmReference("flashNotifCloseTitle", rb.getString("flashNotifCloseTitle"), req);
                }
                this.setVmReference("validator", this.m_validator, req);
                this.setNoCacheHeaders(res);
                this.includeVm("chef_header.vm", req, res);
                this.includeVm(template, req, res);
                this.includeVm("chef_footer.vm", req, res);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                res.sendError(400, "NoSuchMethodException for panel name");
            }
            catch (IOException iOException) {}
        }
        catch (IllegalAccessException e) {
            throw new ToolException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ToolException((Throwable)e);
        }
        catch (ServletException e) {
            throw new ToolException((Throwable)e);
        }
    }

    protected String panelMethodName(String panel) {
        return "build" + panel + "PanelContext";
    }

    @Override
    public void processAction(HttpServletRequest req, HttpServletResponse res) {
        String[] actions;
        JetspeedRunData rundata = (JetspeedRunData)req.getAttribute(ATTR_RUNDATA);
        ParameterParser params = rundata.getParameters();
        String action = params.get("sakai_action");
        if (action == null) {
            Iterator<String> names = params.getNames();
            while (names.hasNext()) {
                String name = names.next();
                if (!name.startsWith(BUTTON)) continue;
                action = name.substring(BUTTON.length());
                break;
            }
        } else if ("".equals(action) && (actions = params.getStrings("sakai_action")) != null) {
            for (int i = 0; i < actions.length; ++i) {
                if ("".equals(actions[i])) continue;
                action = actions[i];
                break;
            }
        }
        if (action != null) {
            if (!this.checkCSRFToken(req, rundata, action)) {
                return;
            }
            String helperClass = (String)this.getState(req).getAttribute(STATE_HELPER);
            if (helperClass != null) {
                this.helperActionDispatch("", action, req, res, helperClass);
            } else {
                this.actionDispatch("", action, req, res);
            }
            ToolSession toolSession = SessionManager.getCurrentToolSession();
            if (HELPER_MODE_DONE.equals(toolSession.getAttribute(HELPER_LINK_MODE))) {
                Tool tool = ToolManager.getCurrentTool();
                String url = (String)toolSession.getAttribute(tool.getId() + "sakai.tool.helper.done.url");
                toolSession.removeAttribute(tool.getId() + "sakai.tool.helper.done.url");
                toolSession.removeAttribute(HELPER_LINK_MODE);
                if (url != null) {
                    try {
                        res.sendRedirect(url);
                        return;
                    }
                    catch (IOException e) {
                        log.warn("IOException: ", (Throwable)e);
                    }
                }
            }
            String url = Web.returnUrl((HttpServletRequest)req, null);
            String panel = ((ParameterParser)req.getAttribute("sakai.wrapper.params")).getString("panel");
            String newPanel = (String)this.getState(req).getAttribute(STATE_NEW_PANEL);
            this.getState(req).removeAttribute(STATE_NEW_PANEL);
            if (newPanel != null) {
                panel = newPanel;
            }
            panel = panel == null || panel.equals("") || panel.equals("null") ? LAYOUT_MAIN : panel.replaceAll("[\r\n]", "");
            String redirect = url + "?" + "panel" + "=" + panel;
            try {
                res.sendRedirect(redirect);
            }
            catch (IOException iOException) {}
        } else {
            log.debug("processAction: no action");
        }
    }

    public boolean checkCSRFToken(HttpServletRequest request, RunData rundata, String action) {
        ParameterParser params = rundata.getParameters();
        if ("POST".equals(rundata.getRequest().getMethod())) {
            Session session;
            boolean loggedIn;
            Placement placement = ToolManager.getCurrentPlacement();
            String toolId = null;
            if (placement != null) {
                toolId = placement.getToolId();
            }
            boolean skipCSRFCheck = false;
            String[] insecureTools = ServerConfigurationService.getStrings((String)"velocity.csrf.insecure.tools");
            if (toolId != null && insecureTools != null) {
                for (int i = 0; i < insecureTools.length; ++i) {
                    if (!StringUtils.equalsIgnoreCase((String)toolId, (String)insecureTools[i])) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Will skip all CSRF checks on toolId=" + toolId);
                    }
                    skipCSRFCheck = true;
                    break;
                }
            }
            boolean bl = loggedIn = (session = SessionManager.getCurrentSession()).getUserId() != null;
            if (loggedIn && !skipCSRFCheck) {
                Object sessionAttr = SessionManager.getCurrentSession().getAttribute(UsageSessionService.SAKAI_CSRF_SESSION_ATTRIBUTE);
                if (sessionAttr == null) {
                    log.warn("Missing CSRF Token session attribute: " + action + "; toolId=" + toolId);
                    return false;
                }
                String csrfToken = params.getString(SAKAI_CSRF_TOKEN);
                String sessionToken = sessionAttr.toString();
                if (csrfToken == null || sessionToken == null || !StringUtils.equals((String)csrfToken, (String)sessionToken)) {
                    log.warn("CSRF Token mismatched or missing on velocity action: " + action + "; toolId=" + toolId);
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug("CSRF token (" + csrfToken + ") matches on action: " + action + "; toolId=" + toolId);
                }
            }
        }
        return true;
    }

    @Override
    protected void actionDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res) {
        String methodName = null;
        try {
            Class[] signature = new Class[]{RunData.class, Context.class};
            methodName = methodBase + methodExt;
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, signature);
            Object[] args = new Object[]{(JetspeedRunData)req.getAttribute(ATTR_RUNDATA), null};
            method.invoke((Object)this, args);
        }
        catch (NoSuchMethodException e) {
            try {
                Class[] signature = new Class[]{RunData.class};
                methodName = methodBase + methodExt;
                Method method = ((Object)((Object)this)).getClass().getMethod(methodName, signature);
                Object[] args = new Object[]{(JetspeedRunData)req.getAttribute(ATTR_RUNDATA)};
                method.invoke((Object)this, args);
            }
            catch (NoSuchMethodException e2) {
                log.warn("Exception calling method " + methodName + " " + e2);
            }
            catch (IllegalAccessException e2) {
                log.warn("Exception calling method " + methodName + " " + e2);
            }
            catch (InvocationTargetException e2) {
                String xtra = "";
                if (e2.getCause() != null) {
                    xtra = " (Caused by " + e2.getCause() + ")";
                }
                log.warn("Exception calling method " + methodName + " " + e2 + xtra, (Throwable)e2);
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Exception calling method " + methodName + " " + e);
        }
        catch (InvocationTargetException e) {
            String xtra = "";
            if (e.getCause() != null) {
                xtra = " (Caused by " + e.getCause() + ")";
            }
            log.warn("Exception calling method " + methodName + " " + e + xtra, (Throwable)e);
        }
    }

    protected void helperActionDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res, String className) {
        String methodName = null;
        try {
            Class[] signature = new Class[]{RunData.class};
            methodName = methodBase + methodExt;
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod(methodName, signature);
            Object[] args = new Object[]{(JetspeedRunData)req.getAttribute(ATTR_RUNDATA)};
            method.invoke((Object)this, args);
        }
        catch (ClassNotFoundException e) {
            log.warn("Exception helper class not found " + e);
        }
        catch (NoSuchMethodException e) {
            log.warn("Exception calling method " + methodName + " " + e);
        }
        catch (IllegalAccessException e) {
            log.warn("Exception calling method " + methodName + " " + e);
        }
        catch (InvocationTargetException e) {
            String xtra = "";
            if (e.getCause() != null) {
                xtra = " (Caused by " + e.getCause() + ")";
            }
            log.warn("Exception calling method " + methodName + " " + e + xtra);
        }
    }

    protected Map<String, String> getContext(RunData data) {
        String template = this.getServletConfig().getInitParameter("template");
        HashMap<String, String> rv = new HashMap<String, String>();
        rv.put("template", template);
        return rv;
    }

    public void doOptions(RunData runData, Context context) {
        if (!this.allowedToOptions()) {
            return;
        }
        Placement placement = ToolManager.getCurrentPlacement();
        String pid = null;
        if (placement != null) {
            pid = placement.getId();
        }
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(pid);
        state.setAttribute(STATE_MODE, (Object)MODE_OPTIONS);
        VelocityPortletPaneledAction.disableObservers(state);
        String currentPanelId = runData.getParameters().getString("panel");
        if (!LAYOUT_MAIN.equals(currentPanelId)) {
            String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(pid);
            this.schedulePeerFrameRefresh(mainPanelId);
        }
    }

    protected void saveOptions() {
        Placement placement = ToolManager.getCurrentPlacement();
        if (placement != null) {
            placement.save();
        }
    }

    protected void cancelOptions() {
    }

    protected void addOptionsMenu(Menu bar, JetspeedRunData data) {
        if (this.allowedToOptions()) {
            bar.add((MenuItem)new MenuEntry(rb.getString(MODE_OPTIONS), "doOptions"));
        }
    }

    protected boolean allowedToOptions() {
        Placement placement = ToolManager.getCurrentPlacement();
        String context = null;
        if (placement != null) {
            context = placement.getContext();
        }
        return SecurityService.unlock((String)"site.upd", (String)("/site/" + context));
    }

    public static void disableObservers(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer != null) {
            observer.disable();
        }
        if ((observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER2)) != null) {
            observer.disable();
        }
    }

    public static void enableObservers(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer != null) {
            observer.enable();
        }
        if ((observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER2)) != null) {
            observer.enable();
        }
    }

    public static void justDelivered(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer != null) {
            observer.justDelivered();
        }
    }

    public void doReset(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        this.resetTool(state);
        String main = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        this.schedulePeerFrameRefresh(main);
    }

    protected void resetTool(SessionState state) {
        state.clear();
    }

    @Override
    protected void setVmStdRef(HttpServletRequest request, HttpServletResponse response) {
        Tool tool;
        super.setVmStdRef(request, response);
        this.setVmReference("config", ServerConfigurationService.getInstance(), request);
        this.setVmReference("pid", this.getPid(request), request);
        String query = PortalUtils.getCDNQuery();
        this.setVmReference("portalCdnQuery", query, request);
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session != null) {
            String focusPath;
            Set ids;
            if (session.getAttribute(ATTR_TOP_REFRESH) != null) {
                this.setVmReference("topRefresh", Boolean.TRUE, request);
                session.removeAttribute(ATTR_TOP_REFRESH);
            }
            if ((ids = (Set)session.getAttribute(ATTR_FRAME_REFRESH)) != null) {
                this.setVmReference("frameRefresh", ids, request);
                session.removeAttribute(ATTR_FRAME_REFRESH);
            }
            if ((focusPath = (String)session.getAttribute(ATTR_FRAME_FOCUS)) != null) {
                this.setVmReference("focusChange", focusPath, request);
                session.removeAttribute(ATTR_FRAME_FOCUS);
            }
        }
        if ((tool = ToolManager.getCurrentTool()) != null) {
            this.setVmReference("toolTitle", tool.getTitle(), request);
        }
    }

    protected void setVmCourier(HttpServletRequest request, int refresh) {
        Placement placement = ToolManager.getCurrentPlacement();
        if (placement != null) {
            String userId = SessionManager.getCurrentSessionUserId();
            StringBuilder url = new StringBuilder(Web.serverUrl((HttpServletRequest)request));
            url.append("/courier/");
            url.append(placement.getId());
            url.append("?userId=");
            url.append(userId);
            this.setVmReference("courier", url.toString(), request);
            this.setVmReference("courierTimeout", Integer.toString(refresh), request);
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ParameterParser params = (ParameterParser)req.getAttribute("sakai.wrapper.params");
        Context context = new Context(this, req);
        Placement placement = ToolManager.getCurrentPlacement();
        PortletConfig config = new PortletConfig(this.getServletConfig(), placement.getPlacementConfig(), placement.getTool().getRegisteredConfig(), placement);
        VelocityPortlet portlet = new VelocityPortlet(this.getPid(req), config);
        JetspeedRunData rundata = new JetspeedRunData(req, this.getState(req), this.getPid(req), params);
        req.setAttribute(ATTR_CONTEXT, (Object)context);
        req.setAttribute(ATTR_CONFIG, (Object)config);
        req.setAttribute(ATTR_PORTLET, (Object)portlet);
        req.setAttribute(ATTR_RUNDATA, (Object)rundata);
        super.doGet(req, res);
    }

    protected void checkRunData(HttpServletRequest req) {
        if (req.getAttribute(ATTR_RUNDATA) != null) {
            return;
        }
        ParameterParser params = (ParameterParser)req.getAttribute("sakai.wrapper.params");
        JetspeedRunData rundata = new JetspeedRunData(req, this.getState(req), this.getPid(req), params);
        req.setAttribute(ATTR_RUNDATA, (Object)rundata);
    }

    protected void scheduleTopRefresh() {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute(ATTR_TOP_REFRESH) == null) {
            session.setAttribute(ATTR_TOP_REFRESH, (Object)Boolean.TRUE);
        }
    }

    protected void schedulePeerFrameRefresh(String id) {
        ToolSession session = SessionManager.getCurrentToolSession();
        HashSet<String> soFar = (HashSet<String>)session.getAttribute(ATTR_FRAME_REFRESH);
        if (soFar == null) {
            soFar = new HashSet<String>();
            session.setAttribute(ATTR_FRAME_REFRESH, soFar);
        }
        soFar.add(id);
    }

    protected void scheduleFocusRefresh(String[] path) {
        ToolSession session = SessionManager.getCurrentToolSession();
        String jsArray = "[";
        for (int i = 0; i < path.length; ++i) {
            if (i > 0) {
                jsArray = jsArray + ",";
            }
            jsArray = jsArray + " \"" + path[i] + "\"";
        }
        jsArray = jsArray + " ]";
        session.setAttribute(ATTR_FRAME_FOCUS, (Object)jsArray);
    }

    public String[] getDateFormatString() {
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance(3, rb.getLocale());
        String[] formatArray = sdf.toPattern().split("[/\\-\\.]");
        for (int i = 0; i < formatArray.length; ++i) {
            formatArray[i] = formatArray[i].trim().substring(0, 1).toLowerCase();
        }
        if (formatArray.length != DEFAULT_FORMAT_ARRAY.length) {
            log.warn("Unknown date format string (using default): " + sdf.toPattern());
            return DEFAULT_FORMAT_ARRAY;
        }
        return formatArray;
    }

    public String[] getTimeFormatString() {
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getTimeInstance(3, rb.getLocale());
        String format = sdf.toPattern();
        LinkedHashSet<String> formatSet = new LinkedHashSet<String>();
        char lastChar = '\u0000';
        for (int i = 0; i < format.length(); ++i) {
            char curChar = format.charAt(i);
            if (curChar != 'h' && curChar != 'm' && curChar != 'a' && curChar != 'H' || curChar == lastChar) continue;
            formatSet.add(String.valueOf(curChar));
            lastChar = curChar;
        }
        String[] formatArray = formatSet.toArray(new String[formatSet.size()]);
        if (formatArray.length != DEFAULT_TIME_FORMAT_ARRAY.length && formatArray.length != DEFAULT_TIME_FORMAT_ARRAY.length - 1) {
            log.warn("Unknown time format string (using default): " + format);
            return (String[])DEFAULT_TIME_FORMAT_ARRAY.clone();
        }
        return formatArray;
    }
}

