/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.cheftool;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import org.sakaiproject.tool.api.Placement;

public class PortletConfig
implements Map {
    private ServletConfig m_servletCofig;
    private Properties m_toolConfig;
    private Properties m_toolReg;
    private Placement m_placement;
    private Map m_map = null;

    PortletConfig(ServletConfig config, Properties toolConfig, Properties reg, Placement p) {
        this.m_servletCofig = config;
        this.m_toolConfig = toolConfig;
        this.m_toolReg = reg;
        this.m_placement = p;
    }

    public String getInitParameter(String name, String dflt) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = dflt;
        }
        return value;
    }

    public String getInitParameter(String name) {
        String value = null;
        if (this.m_toolConfig != null) {
            value = this.m_toolConfig.getProperty(name);
        }
        if (value == null && this.m_toolReg != null) {
            value = this.m_toolReg.getProperty(name);
        }
        if (value == null) {
            value = this.m_servletCofig.getInitParameter(name);
        }
        return value;
    }

    public Map getInitParameters() {
        return this.getMap();
    }

    private synchronized Map getMap() {
        String name;
        if (this.m_map != null) {
            return this.m_map;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = this.m_servletCofig.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            map.put(name, this.m_servletCofig.getInitParameter(name));
        }
        if (this.m_toolReg != null) {
            e = this.m_toolReg.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                map.put(name, this.m_toolReg.getProperty(name));
            }
        }
        if (this.m_toolConfig != null) {
            Enumeration<?> i = this.m_toolConfig.propertyNames();
            while (i.hasMoreElements()) {
                String name2 = (String)i.nextElement();
                map.put(name2, this.m_toolConfig.getProperty(name2));
            }
        }
        this.m_map = Collections.unmodifiableMap(map);
        return this.m_map;
    }

    public String getTitle() {
        if (this.m_placement != null) {
            return this.m_placement.getTitle();
        }
        return "";
    }

    public String[] get3InitParameter(String name) {
        String[] value = new String[3];
        if (this.m_toolConfig != null) {
            value[2] = this.m_toolConfig.getProperty(name);
        }
        if (this.m_toolReg != null) {
            value[1] = this.m_toolReg.getProperty(name);
        }
        value[0] = this.m_servletCofig.getInitParameter(name);
        return value;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    public Set entrySet() {
        return this.getMap().entrySet();
    }

    public Object get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    public Collection values() {
        return this.getMap().values();
    }
}

