/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.vm;

import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.api.ToolURL;
import org.sakaiproject.tool.api.ToolURLManager;
import org.sakaiproject.util.api.FormattedText;

public class ActionURL {
    public static final String PARAM_PID = "pid";
    public static final String PARAM_SITE = "site";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PANEL = "panel";
    protected String m_base = null;
    protected Map m_parameters = new Hashtable();
    protected String m_pid = null;
    protected String m_panel = null;
    protected String m_site = null;
    protected String m_page = null;
    protected boolean m_isAction = false;
    protected String m_resourcePath = null;
    protected String m_QueryString = "";
    protected HttpServletRequest m_request;

    public ActionURL(String base, HttpServletRequest request) {
        this.m_base = base;
        this.m_request = request;
    }

    public ActionURL reset() {
        this.m_parameters = new Hashtable();
        this.m_isAction = false;
        this.m_resourcePath = null;
        this.m_QueryString = "";
        return this;
    }

    public ActionURL setParameter(String name, String value) {
        if (value == null) {
            this.m_parameters.remove(name);
        } else {
            this.m_parameters.put(name, value);
        }
        return this;
    }

    public ActionURL setAction() {
        this.m_isAction = true;
        return this;
    }

    public ActionURL setPid(String pid) {
        this.m_pid = pid;
        return this;
    }

    public ActionURL setSite(String site) {
        this.m_site = site;
        return this;
    }

    public ActionURL setPage(String page) {
        this.m_page = page;
        return this;
    }

    public ActionURL setPanel(String panel) {
        this.m_panel = panel;
        return this;
    }

    public String toString() {
        String toolURL = this.getToolURL();
        if (toolURL != null) {
            return ((FormattedText)ComponentManager.get(FormattedText.class)).sanitizeHrefURL(toolURL);
        }
        String rv = this.m_base;
        int c = 63;
        if (this.m_parameters.size() > 0) {
            for (Map.Entry entry : this.m_parameters.entrySet()) {
                rv = rv + (char)c + entry.getKey() + "=" + entry.getValue();
                c = 38;
            }
        }
        if (this.m_QueryString != null && this.m_QueryString.length() > 0) {
            rv = rv + (char)c + this.m_QueryString;
            c = 38;
        }
        if (this.m_pid != null && !this.m_parameters.containsKey(PARAM_PID)) {
            rv = rv + (char)c + PARAM_PID + "=" + this.m_pid;
            c = 38;
        }
        if (this.m_site != null && !this.m_parameters.containsKey(PARAM_SITE)) {
            rv = rv + (char)c + PARAM_SITE + "=" + this.m_site;
            c = 38;
        }
        if (this.m_page != null && !this.m_parameters.containsKey(PARAM_PAGE)) {
            rv = rv + (char)c + PARAM_PAGE + "=" + this.m_page;
            c = 38;
        }
        if (this.m_panel != null && !this.m_parameters.containsKey(PARAM_PANEL)) {
            rv = rv + (char)c + PARAM_PANEL + "=" + this.m_panel;
            c = 38;
        }
        this.reset();
        return ((FormattedText)ComponentManager.get(FormattedText.class)).sanitizeHrefURL(rv);
    }

    private String getToolURL() {
        ToolURLManager urlManager = this.getToolURLManager();
        if (urlManager == null) {
            return null;
        }
        ToolURL url = null;
        String path = this.m_base;
        if (this.m_isAction) {
            url = urlManager.createActionURL();
        } else if (this.m_resourcePath != null) {
            url = urlManager.createResourceURL();
            path = this.m_resourcePath;
        } else {
            url = urlManager.createRenderURL();
        }
        if (url != null) {
            if (this.m_QueryString != null && this.m_QueryString.length() > 0) {
                path = path.indexOf(63) == -1 ? path + '?' + this.m_QueryString : path + '&' + this.m_QueryString;
            }
            url.setPath(path);
            if (this.m_pid != null && !this.m_parameters.containsKey(PARAM_PID)) {
                this.m_parameters.put(PARAM_PID, this.m_pid);
            }
            if (this.m_site != null && !this.m_parameters.containsKey(PARAM_SITE)) {
                this.m_parameters.put(PARAM_SITE, this.m_site);
            }
            if (this.m_page != null && !this.m_parameters.containsKey(PARAM_PAGE)) {
                this.m_parameters.put(PARAM_PAGE, this.m_page);
            }
            if (this.m_panel != null && !this.m_parameters.containsKey(PARAM_PANEL)) {
                this.m_parameters.put(PARAM_PANEL, this.m_panel);
            }
            url.setParameters(this.m_parameters);
            this.reset();
            return url.toString();
        }
        return null;
    }

    private ToolURLManager getToolURLManager() {
        HttpServletRequest request = this.m_request;
        if (request == null) {
            request = (HttpServletRequest)ThreadLocalManager.get((String)"org.sakaiproject.util.RequestFilter.http_request");
        }
        if (request != null) {
            return (ToolURLManager)request.getAttribute("tool.url.manager");
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && obj instanceof ActionURL) {
            equals = ((ActionURL)obj).toString().equals(this.toString());
        }
        return equals;
    }

    public ActionURL setResourcePath(String path) {
        this.m_resourcePath = path;
        return this;
    }

    public ActionURL setQueryString(String queryString) {
        this.m_QueryString = queryString;
        return this;
    }
}

